$(document).ready(async function () {

  // variável responsável por definir se a foto está sendo inclusa por ordem ou não
  // var incluiMedidaOrdem = false;

  // autocompleta, pesquisa e limpa campos dos modais
  $('#txtProdutoDuplicaMedidas').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnPesquisaProdutoDuplicaMedidas').pesquisa('#txtProdutoDuplicaMedidas', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PRODUTO","camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
  $('#btnLimpaProdutoDuplicaMedidas').on('click', async function () { $('#txtProdutoDuplicaMedidas').val('') });

  $('#txtProdutoImportaMedidas').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnPesquisaProdutoImportaMedidas').pesquisa('#txtProdutoImportaMedidas', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PRODUTO","camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
  $('#btnLimpaProdutoImportaMedidas').on('click', async function () { $('#txtProdutoImportaMedidas').val('') });
  $('#btnLimpaFotoMedidas').on('click', async function () {
    $('#txtFotoMedidas').val('');
    //  sMedidaOrdem == true ? await buscaFotoOrdemMedida() : 
    await buscaFotoMedida();
  });

  // limpa a tabela de medidas quando o modal é fechado
  $("#modal-medidas").on('hide.bs.modal', async function () {
    $('#tabelaMedidas').DataTable().destroy();
    $('#tabelaMedidas').empty();
    mostraBotaoEdicao();
  });

  // limpa os campos e o tipo de medida quando o modal de importação de medidas é fechado
  $('#modal-importa-medidas').on('hide.bs.modal', async function () {
    $('#txtProdutoImportaMedidas').val('');
    $('#rImportaTipoMedidaFinal').prop('checked', false);
    $('#rImportaTipoMedidaInicial').prop('checked', false);
    $('#rImportaTipoMedidaCorte').prop('checked', false);
    $('#rImportaTipoMedidaPosCorte').prop('checked', false);
  });

  // atualiza a variável de controle de inclusão (se a foto está sendo inclusa por ordem ou não) como falso e limpa o campo do nome da imagem
  $('#modal-foto-medidas').on('hide.bs.modal', async function () {
    // incluiMedidaOrdem = false;
    $('#txtFotoMedidas').val('');
  });

  // variáveis responsáveis por definir se a largura, largura2 e comprimento serão atualizados ao gravar as informações
  let alteraLargura = false;
  let alteraLargura2 = false;
  let alteraComprimento = false;

  // botão invisível responsável por buscar as medidas do produto
  $('#btnBuscaMedidas').on('click', async function () {
    $('#opcoesTipoMedida').val('F');
    let data = $('#txtTitulo').html().split(' ');
    let medida = $('#opcoesTipoMedida').val();
    const valoresInputsLargura = await buscaLargura();
    $('#inputLarguraMedidas').val(0);
    $('#inputLargura2Medidas').val(0);
    $('#inputComprimentoMedidas').val(0);
    if (valoresInputsLargura.length > 0) {
      for (i in valoresInputsLargura[0]) {
        if (valoresInputsLargura[0][i] != null) {
          $('#inputLarguraMedidas').val(valoresInputsLargura[0].LARGURA);
          $('#inputLargura2Medidas').val(valoresInputsLargura[0].LARGURA2);
          $('#inputComprimentoMedidas').val(valoresInputsLargura[0].COMPRIMENTO);
        };
      };
    };
    await buscaMedidas(data[0], medida);
  });

  // desabilita o modo de edição e deixa somente como visualização
  async function mostraBotaoEdicao() {
    alteraLargura = false;
    alteraLargura2 = false;
    alteraComprimento = false;
    $('#btnEdicaoMedidas').removeClass('d-none');
    $('#btnGravarMedidas').addClass('d-none');
    $('#btnCancelarMedidas').addClass('d-none');
    $('#btnImportarMedidas').addClass('d-none');
    $('#btnExcluirMedidas').removeClass('d-none');
    $('.inputedit').attr('readonly', true);
    $('#opcoesTipoMedida').attr('disabled', false);
    $('#checkTodosLargura').attr('disabled', true);
    $('#btnAdicionarMedidas').attr('disabled', true);
    $('#btnFotoMedidas').addClass('d-none');
    $('#btnDuplicarMedidas').removeClass('d-none');
    $('#btnImprimirMedidas').removeClass('d-none');
    $('.btnOpcoesOrdem').attr('disabled', true);
    $('.btnFecharMedidas').removeClass('d-none');
    $('#botaoTodosLargura').attr('disabled', true);
    $('#botaoTodosLargura2').attr('disabled', true);
    $('#botaoTodosComprimento').attr('disabled', true);
    $('#inputLarguraMedidas').attr('disabled', true);
    $('#inputLargura2Medidas').attr('disabled', true);
    $('#inputComprimentoMedidas').attr('disabled', true);
    $('.btnPesquisaAbrev').attr('disabled', true);
  };

  // habilita o modo de edição
  async function mostraBotaoGravar() {
    $('#btnEdicaoMedidas').addClass('d-none');
    $('#btnGravarMedidas').removeClass('d-none');
    $('#btnImportarMedidas').removeClass('d-none');
    $('#btnExcluirMedidas').addClass('d-none');
    $('#btnCancelarMedidas').removeClass('d-none');
    $('.inputedit').attr('readonly', false);
    $('#opcoesTipoMedida').attr('disabled', true);
    $('#btnAdicionarMedidas').attr('disabled', false);
    $('#checkTodosLargura').attr('disabled', false);
    $('#btnFotoMedidas').removeClass('d-none');
    $('#btnDuplicarMedidas').addClass('d-none');
    $('#btnImprimirMedidas').addClass('d-none');
    $('.btnOpcoesOrdem').attr('disabled', false);
    $('.btnFecharMedidas').addClass('d-none');
    $('#botaoTodosLargura').attr('disabled', false);
    $('#botaoTodosLargura2').attr('disabled', false);
    $('#botaoTodosComprimento').attr('disabled', false);
    $('#inputLarguraMedidas').attr('disabled', false);
    $('#inputLargura2Medidas').attr('disabled', false);
    $('#inputComprimentoMedidas').attr('disabled', false);
    $('.btnPesquisaAbrev').attr('disabled', false);
  };

  // atualizam as variáveis como true para que as informações de largura, largura2 ou comprimento sejam atualizadas ao gravar as informações
  $('#botaoTodosLargura').on('click', async function () {
    msgAlerta('Você realmente deseja gravar esta largura para este tipo de medida?', async () => {
      alteraLargura = true;
    })
  });

  $('#botaoTodosLargura2').on('click', async function () {
    msgAlerta('Você realmente deseja gravar esta largura2 para este tipo de medida?', async () => {
      alteraLargura2 = true;
    })
  });

  $('#botaoTodosComprimento').on('click', async function () {
    msgAlerta('Você realmente deseja gravar este comprimento para este tipo de medida?', async () => {
      alteraComprimento = true;
    })
  });

  // habilita o modo de edição ao ser clicado
  $('#btnEdicaoMedidas').on('click', async function () {
    await mostraBotaoGravar();
  });

  // abre o modal e inicia o processo de duplicar medidas do produto
  $('#btnDuplicarMedidas').on('click', async function () {
    let data = $('#txtTitulo').html().split('-');
    const pesquisaPOrig = {
      tabela: "PCP_MEDIDAS",
      camposSelect: ["ORDEM"],
      where: [`CODIGO = '${data[0].trim()}'`]
    }

    const verificaMedidasOrig = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaPOrig));

    if (!verificaMedidasOrig) {
      return;
    }

    if (verificaMedidasOrig.length == 0) {
      msgAlerta('O produto selecionado não possui medidas a serem duplicadas!')
      return;
    }

    await abreModalDuplicaMedidasProduto(data[0], data[1]);
  });

  // retorna os filtros de consulta para a próxima função
  async function retornaFiltros() {
    const produto = ($('#txtTitulo').html().split(' '))[0];
    const medida = $('#opcoesTipoMedida').val();

    return `CODIGO=${produto}` +
      `&TIPO_MEDIDA=${medida}`
  }

  // abre uma nova aba apresentando as informações das medidas no relatório
  $('#btnImprimirMedidas').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = `/sisplan/impressao/v1/imprimirmedidasprod?`;
        const filtros = await retornaFiltros()
        const bImprimeAutomatico = await verificaImprimirAutomatico('relMedidasProd');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, "GET", 100000, false, 'relMedidasProd');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  // passa mensagem de confirmação e chama a função de exclusão de medidas do produto
  $('#btnExcluirMedidas').on('click', async function () {
    msgAlerta('Você realmente deseja excluir todos os registros?', async () => {
      const data = $('#txtTitulo').html().split(' ');
      const tMedida = $('#opcoesTipoMedida').val();
      await excluiTodosRegistros(data[0], tMedida);
    });
  });

  // passa mensagem de confirmação e chama função para gravar os dados
  $('#btnGravarMedidas').on('click', async function () {
    const data = $('#tabelaMedidas').DataTable().data();
    if (data.length == 0) {
      msgAlertaSemConfirmacao('Favor adicionar um registro para gravar!')
      return;
    }
    msgAlerta('Você realmente deseja gravar as informações?', async () => {
      await gravaDados();
    })
  });

  // abre modal de foto de medidas do produto
  $('#btnFotoMedidas').on('click', async function () {
    window.event.preventDefault();
    let data = $('#txtTitulo').html().split('-');
    // incluiMedidaOrdem = false;
    await abreModalFotoMedidasProduto(data[0], data[1], false);
  });

  // abre modal de importação de medidas do produto
  $('#btnImportarMedidas').on('click', async function () {
    let data = $('#txtTitulo').html().split('-');
    await abreModalImportaMedidasProduto(data[0], data[1]);
  });

  // desabilita o modo de alteração e busca novamente as medidas do banco de dados
  $('#btnCancelarMedidas').on('click', async function () {
    mostraBotaoEdicao();
    $('#btnBuscaMedidas').trigger('click');
  });

  // fecha o modal de importação de medidas do produto
  $('#btnCancelarImportaMedidasProduto').on('click', async function () {
    $('#modal-importa-medidas').modal('hide');
  });

  // abre o modal de duplicar medidas e preenche o título da tela
  async function abreModalDuplicaMedidasProduto(sChave, sDescricao) {
    $('#modal-duplica-medidas').modal('show');
    $('#txtTituloDuplicaMedidas').html(`${sChave} - ${sDescricao}`);
  };

  // abre o modal de importar medidas e preenche o título da tela
  async function abreModalImportaMedidasProduto(sChave, sDescricao) {
    $('#modal-importa-medidas').modal('show');
    $('#txtTituloImportaMedidas').html(`${sChave} - ${sDescricao}`);
  };

  // abre o modal de foto de medidas do produto
  async function abreModalFotoMedidasProduto(sChave, sDescricao, sMedidaOrdem) {
    $('#txtTituloFotoMedidas').html(`${sChave} - ${sDescricao}`);
    // if (sMedidaOrdem == true) {
    //   await buscaFotoOrdemMedida();
    // }
    // if (sMedidaOrdem == false) {
    await buscaFotoMedida();
    // }
    $('#modal-foto-medidas').modal('show');
  };

  // busca largura, largura2 e comprimento
  async function buscaLargura() {
    let data = $('#txtTitulo').html().split(' ');
    let medida = await $('#opcoesTipoMedida').val();
    const dados = await requisicao("GET", "/Sisplan/medidas/v1/buscalargura?", `CODIGO=${data[0]}&TIPO_MEDIDA=${medida}`);
    if (!dados || dados.status != 200) {
      return;
    };

    const jsonLargura = await dados.json();

    return jsonLargura;
  };

  // busca as medidas do produto
  async function buscaMedidas(sChave, sTipoMedida) {
    const dados = await requisicao("GET", "/Sisplan/medidas/v1/buscamedidas?", `CODIGO=${sChave}&TIPO_MEDIDA=${sTipoMedida}`, null);
    const dadosColunas = await requisicao("GET", "/Sisplan/medidas/v1/buscacampos?", `CODIGO=${sChave}`, null);

    if (!dados || !dadosColunas) {
      return;
    };

    const jsonColunas = await dadosColunas.json();

    const jsonStr = await dados.json();

    let Cols = [{}];
    for (i in jsonColunas[0]) {
      let nomeColuna = jsonColunas[0][i];
      Cols[0][nomeColuna] = jsonColunas[0][i];
    }

    let Data = [];
    if (jsonStr.length > 0) {
      for (i in jsonStr) {
        Data.push({});
        delete jsonStr[i]['CODIGO'];
        for (j in jsonStr[i]) {
          let nomeColuna = jsonColunas[0][j];
          Data[i][nomeColuna] = jsonStr[i][j];
        };
      };
    };
    await criaTabelaMedidas(Cols, Data, false);
  };

  // renderiza as opções do botão ordem
  function retornaOpcoes(sChave) {
    let retorno = '<div style="width: 1px; text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesOrdem" disabled data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' + sChave +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      // '       <button class="dropdown-item" id="btn-foto-ordem-medida">Anexar Foto Ordem</button>' +
      '       <button class="dropdown-item" id="btn-excluir-ordem">Excluir item</button>' +
      '       <button class="dropdown-item" id="btn-inserir-registro-acima">Adicionar Registro Acima</button>' +
      '    </div>';

    return retorno;
  };

  // consulta as medidas quando o tipo é alterado
  $('#opcoesTipoMedida').change(async function () {
    let data = $('#txtTitulo').html().split(' ');
    let medida = await $('#opcoesTipoMedida').val();
    await buscaMedidas(data[0], medida);
    const valoresInputsLargura = await buscaLargura();
    $('#inputLarguraMedidas').val(0);
    $('#inputLargura2Medidas').val(0);
    $('#inputComprimentoMedidas').val(0);
    if (valoresInputsLargura.length > 0) {
      for (i in valoresInputsLargura[0]) {
        if (valoresInputsLargura[0][i] != null) {
          $('#inputLarguraMedidas').val(valoresInputsLargura[0].LARGURA);
          $('#inputLargura2Medidas').val(valoresInputsLargura[0].LARGURA2);
          $('#inputComprimentoMedidas').val(valoresInputsLargura[0].COMPRIMENTO);
        };
      };
    };
  });

  // chama função para adicionar uma nova linha na tabela
  $('#btnAdicionarMedidas').on('click', async function () {
    let data = $('#txtTitulo').html().split(' ');
    const ordem = await retornaProximaOrdem();
    await adicionaLinhaTabela(ordem, data[0]);
    await mostraBotaoGravar();
  });

  // retorna a próxima ordem a ser inserida na nova linha da tabela
  async function retornaProximaOrdem() {
    if ($('#tabelaMedidas').DataTable().rows().data().length > 0) {
      const ultimaLinha = ($('#tabelaMedidas').DataTable().rows().data().length);
      const data = $('#tabelaMedidas').DataTable().row(ultimaLinha - 1).data();
      return data.ORDEM + 1;
    } else {
      return 1;
    }
  }

  // adiciona um novo registro no final da tabela
  async function adicionaLinhaTabela(sOrdem, sChave) {
    const dadosColunas = await requisicao("GET", "/Sisplan/medidas/v1/buscacampos?", `CODIGO=${sChave}`, null);

    if (!dadosColunas) {
      return
    };

    const jsonColunas = await dadosColunas.json();

    let Cols = [{}];
    for (i in jsonColunas[0]) {
      let nomeColuna = jsonColunas[0][i];
      Cols[0][nomeColuna] = jsonColunas[0][i];
    };

    const keys = Object.keys(Cols[0]);

    colunasLinha = [{}];
    for (i in keys) {
      colunasLinha[0][keys[i]] = '';
    };

    colunasLinha[0].ORDEM = sOrdem;
    let novaLinha = await carregaInputsTabela(colunasLinha);
    novaLinha[0].ABREV = `
    <div class="input-group-append">
      <input style="width: 5em;" readonly type="text" id="txtAbrev${$('#tabelaMedidas').DataTable().rows().data().length}" class="check-todos-medidas inputedit input-default focus form-control" value="">
        <button class="btnPesquisaAbrev btn bg-danger" disabled id="btnPesquisaAbrev${$('#tabelaMedidas').DataTable().rows().data().length}" data-button="absolute" type="button">
          <i class="m-0 p-0 fas fa-search"></i>
        </button>
    </div>
    `

    novaLinha[0].DESCRICAO = `
    <input style="width: 25em;" readonly type="text" id="txtAbrevDescricao${$('#tabelaMedidas').DataTable().rows().data().length}" class="check-todos-medidas inputedit input-default focus form-control" value="">
    `

    novaLinha[0].ORIENTACAO = `
      <input style="width: 30em;" readonly type="text" id="txtAbrevOrientacao${$('#tabelaMedidas').DataTable().rows().data().length}" class="check-todos-medidas inputedit input-default focus form-control" value="">
      `

    $('#tabelaMedidas').DataTable().row.add(
      novaLinha[0]
    );

    $('#tabelaMedidas').DataTable().columns.adjust().draw(false)
    let scrollBody = $($('#tabelaMedidas').DataTable().table().node()).parent();
    await scrollBody.scrollTop(scrollBody.get(0).scrollHeight);
    await carregaPesquisaAbrev();
  };

  // adiciona os inputs da tabela com os seus respectivos valores consultados do banco
  async function carregaInputsTabela(sDadosTabela) {

    for (i in sDadosTabela) {
      delete sDadosTabela[i]['CODIGO'];
      for (j in sDadosTabela[i]) {
        if (j == 'ORDEM' || j == 'ORIENTACAO') {
          null;
        } else if (j == 'ABREV') {
          sDadosTabela[i][j] = `
          <div class="input-group-append">
            <input style="width: 5em;" readonly type="text" id="txtAbrev${i}" class="check-todos-medidas inputedit input-default focus form-control" value="${sDadosTabela[i][j]}">
              <button class="btnPesquisaAbrev btn bg-danger" disabled id="btnPesquisaAbrev${i}" data-button="absolute" type="button">
                <i class="m-0 p-0 fas fa-search"></i>
            </button>
          </div>`
        } else if (j == 'DESCRICAO') {
          sDadosTabela[i][j] = `
          <input style="width: 25em;" readonly type="text" id="txtAbrevDescricao${i}" class="check-todos-medidas inputedit input-default focus form-control" value="${sDadosTabela[i][j]}">
          `
        } else if (j == 'TOLERANCIA' || j == 'TOLER_MIN' || j == 'TOLER_MAX') {
          sDadosTabela[i][j] = `
          <input style="width: 6em;" readonly type="number" class="check-todos-medidas inputedit input-default focus form-control" value="${sDadosTabela[i][j]}">
          `
        } else {
          sDadosTabela[i][j] = `
          <input style="width: 5em;" readonly type="number" step="any" class="check-todos-medidas inputedit input-default focus form-control" value="${sDadosTabela[i][j]}">
          `
        }
        if (j == 'ORIENTACAO') {
          sDadosTabela[i][j] = `
          <input style="width: 30em;" readonly type="text" id="txtAbrevOrientacao${i}" class="check-todos-medidas inputedit input-default focus form-control" value="${sDadosTabela[i][j]}">
          `
        }
      }
    };

    return sDadosTabela;
  };

  // retorna a altura em px da tela para definir a altura da tabela
  async function retornaTamanhoTela() {
    if (window.screen.height == 768) {
      return '340px';
    } else if (window.screen.height == 900) {
      return '460px';
    } else if (window.screen.height == 960) {
      return '520px';
    } else if (window.screen.height == 1024) {
      return '585px';
    } else if (window.screen.height == 1050) {
      return '605px';
    } else {
      return '620px';
    }
  };

  // grava as informações no banco de dados conforme o que está informado na tabela e nos campos largura, largura2 e comprimento
  async function gravaDados() {

    const data = $('#txtTitulo').html().split(' ');
    const chave = data[0];
    const dadosColunas = await requisicao("GET", "/Sisplan/medidas/v1/buscacampos?", `CODIGO=${chave}`, null);

    let largura = 0;
    let largura2 = 0;
    let comprimento = 0;

    const valoresInputsLargura = await buscaLargura();
    if (valoresInputsLargura.length > 0) {
      largura = valoresInputsLargura[0].LARGURA;
      largura2 = valoresInputsLargura[0].LARGURA2;
      comprimento = valoresInputsLargura[0].COMPRIMENTO;
    };

    if (alteraLargura == true) {
      largura = $('#inputLarguraMedidas').val();
    };

    if (alteraLargura2 == true) {
      largura2 = $('#inputLargura2Medidas').val();
    };

    if (alteraComprimento == true) {
      comprimento = $('#inputComprimentoMedidas').val();
    };

    if (!dadosColunas) {
      return;
    };

    const campos = await dadosColunas.json();
    let jsonColunas = [{}];
    for (i in campos[0]) {
      let nomeColuna = campos[0][i];
      jsonColunas[0][nomeColuna] = campos[0][i];
    }
    let keys = Object.keys(jsonColunas[0]);

    const jsonStr = $('#tabelaMedidas').DataTable().data();
    delete keys[6];

    let row = 1;
    let cols = keys.length;
    const posColuna = cols - 1;
    const colunasSemTamanhos = cols - 7;
    const colunasPosicaoInicial = cols - colunasSemTamanhos;
    for (i in jsonStr) {
      let listaTamanhos = [];
      delete jsonStr[i]['ORIENTACAO'];
      for (j in jsonStr[i]) {
        if (j == 'ORDEM') {
          null;
        } else if (j == 'ABREV') {
          jsonStr[i][j] = $('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(1) input[type='text']").val();
        } else if (j == 'DESCRICAO') {
          jsonStr[i][j] = $('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(2) input[type='text']").val();
        } else if (j == 'TOLERANCIA') {
          jsonStr[i][j] = parseFloat($('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(3) input[type='number']").val());
        } else if (j == 'TOLER_MIN') {
          jsonStr[i][j] = parseFloat($('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(4) input[type='number']").val());
        } else if (j == 'TOLER_MAX') {
          jsonStr[i][j] = parseFloat($('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(5) input[type='number']").val());
        } else {
          if (cols > 0) {
            for (let k = colunasPosicaoInicial; k < cols; k++) {
              if (j == keys[k]) {
                let nomeTamanho = keys[k].substring(4, keys[k].length);
                const controle = k - 1;
                listaTamanhos.push(
                  {
                    'DESCTAM': nomeTamanho,
                    'TAM': parseFloat($('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(" + controle + ") input[type='number']").val())
                  })
              }
            }
          } else {
            null;
          }
          null;
        }
        jsonStr[i]['LISTATAM'] = listaTamanhos;
        keys[6] = '';
      }
      row += 1;
    };

    keys[keys.length] = 'ORIENTACAO';

    row = 1
    for (i in jsonStr) {
      jsonStr[i]['ORIENTACAO'] = $('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(" + posColuna + ") input[type='text']").val();
      row += 1;
    }

    let infoMedidas = jsonStr;

    for (i in infoMedidas) {
      infoMedidas[i]['ORDEM'] = parseInt(i) + 1;
      if (!isNaN(i)) {
        infoMedidas[i] = { CODIGO: data[0], TIPO_MEDIDA: $('#opcoesTipoMedida').val(), ...infoMedidas[i] };
        for (j in infoMedidas[i]) {
          if (j.substr(0, 3) == 'TAM') {
            delete infoMedidas[i][j];
          }
        }
      }
    };

    let body = {
      Medidas: infoMedidas.toArray()
    }

    const tipoMedida = $('#opcoesTipoMedida').val();

    const response = await requisicao("POST", "/Sisplan/medidas/v1/gravamedidas?", '', `JSON=${JSON.stringify(body)}&CODIGO=${chave}&TIPO_MEDIDA=${tipoMedida}&LARGURA=${largura}&LARGURA2=${largura2}&COMPRIMENTO=${comprimento}`, null);

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    if (response.status != 200) {
      $.LoadingOverlay('hide');
      return;
    }
    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "success",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() {
        mostraBotaoEdicao();
        $('#btnBuscaMedidas').trigger('click');
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });

  };

  // exclui todos os registros e a foto anexada (caso exista) do tipo da medida excluída
  async function excluiTodosRegistros(sChave, sTipoMedida) {
    try {
      $.LoadingOverlay("show");
      try {
        const produto = ($('#txtTitulo').html().split(' '))[0];
        const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

        if (!caminhoFoto) {
          msgAlerta('Não foi possível encontrar o caminho das fotos! Por favor verifique.')
        };

        if (caminhoFoto.status != 200) {
          msgAlerta('Não foi possível encontrar o caminho das fotos! Por favor verifique.')
        };

        const jsonCaminhoFoto = await caminhoFoto.json();
        const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
        const pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';

        let response = await requisicao("DELETE", "/Sisplan/medidas/v1/excluitodos?", `CODIGO=${sChave}&TIPO_MEDIDA=${sTipoMedida}`)

        if (!response) {
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        const responseFoto = await requisicao('DELETE', '/sisplan/funcoes/v1/fotomedida?', `DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null)

        if (!responseFoto) {
          msgAlerta('´Não foi possível excluir a foto anexada a esta medida! Por favor verifique.')
        }

        if (responseFoto.status != 200) {
          msgAlerta('´Não foi possível excluir a foto anexada a esta medida! Por favor verifique.')
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#tabelaMedidas').DataTable().rows().remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }

    const valoresInputsLargura = await buscaLargura();
    $('#inputLarguraMedidas').val(0);
    $('#inputLargura2Medidas').val(0);
    $('#inputComprimentoMedidas').val(0);
    if (valoresInputsLargura.length > 0) {
      for (i in valoresInputsLargura[0]) {
        if (valoresInputsLargura[0][i] != null) {
          $('#inputLarguraMedidas').val(valoresInputsLargura[0].LARGURA);
          $('#inputLargura2Medidas').val(valoresInputsLargura[0].LARGURA2);
          $('#inputComprimentoMedidas').val(valoresInputsLargura[0].COMPRIMENTO);
        };
      };
    };
  };

  // exclui o registro selecionado
  async function excluiRegistroOrdem(sData) {

    const produto = ($('#txtTitulo').html().split(' '))[0];
    const ordem = sData.data().ORDEM;

    sData.remove().draw(false);

    const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

    if (!caminhoFoto) {
      msgAlerta('Não foi possível encontrar o caminho das fotos! Por favor verifique.')
    };

    if (caminhoFoto.status != 200) {
      msgAlerta('Não foi possível encontrar o caminho das fotos! Por favor verifique.')
    };

    const jsonCaminhoFoto = await caminhoFoto.json();
    const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
    const pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';

    const responseFoto = await requisicao('DELETE', '/sisplan/funcoes/v1/fotomedida?', `DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}${ordem}.jpg`, null)

    if (!responseFoto) {
      msgAlerta('´Não foi possível excluir a foto anexada a esta medida! Por favor verifique.')
    }

    if (responseFoto.status != 200) {
      msgAlerta('´Não foi possível excluir a foto anexada a esta medida! Por favor verifique.')
    }

  };

  // abre modal de foto, porém a foto anexada é por ordem
  // $('#tabelaMedidas').on('click', '#btn-foto-ordem-medida', async function () {
  //   let data = $('#txtTitulo').html().split('-');
  //   window.event.preventDefault();
  //   const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
  //   $('#txtTipoMedidaFoto').val(medida);
  //   const ordem = $("#tabelaMedidas").DataTable().row($(this).parents("tr")).data().ORDEM;
  //   $('#txtOrdemFoto').val(ordem);
  //   // incluiMedidaOrdem = true;
  //   await abreModalFotoMedidasProduto(data[0], data[1], true);
  // });

  // passa mensagem de confirmação e chama a função de exclusão do registro selecionado (por ordem)
  $('#tabelaMedidas').on('click', '#btn-excluir-ordem', async function () {
    msgAlerta('Você realmente deseja excluir esse registro?', async () => {
      const row = $("#tabelaMedidas").DataTable().row($(this).parents("tr"));
      await excluiRegistroOrdem(row);
    });
  });

  // consulta as informações da tabela para chamar a função de adicionar um registro acima do que foi selecionado
  $('#tabelaMedidas').on('click', '#btn-inserir-registro-acima', async function () {
    let data = $('#txtTitulo').html().split(' ');
    const posicao = $('#tabelaMedidas').DataTable().row($(this).parents('tr'))[0][0];
    const ordem = $('#tabelaMedidas').DataTable().row($(this).parents('tr')).data().ORDEM;
    await insereRegistroAcima(data[0], ordem, posicao);
    await mostraBotaoGravar();
  });

  // função responsável por adicionar um novo registro acima do que foi selecionado
  async function insereRegistroAcima(sChave, sOrdem, sPosicao) {
    const dadosColunas = await requisicao("GET", "/Sisplan/medidas/v1/buscacampos?", `CODIGO=${sChave}`, null)

    if (!dadosColunas) {
      return
    };

    const jsonColunas = await dadosColunas.json();

    let Cols = [{}];
    for (i in jsonColunas[0]) {
      let nomeColuna = jsonColunas[0][i];
      Cols[0][nomeColuna] = jsonColunas[0][i];
    };

    const keys = Object.keys(Cols[0]);

    colunasLinha = [{}];
    for (i in keys) {
      colunasLinha[0][keys[i]] = '';
    }

    let row = 1;
    const jsonStr = $('#tabelaMedidas').DataTable().data();
    const cols = keys.length;
    const posColuna = cols - 1;
    const colunasSemTamanhos = cols - 7;
    const colunasPosicaoInicial = cols - colunasSemTamanhos;
    for (i in jsonStr) {
      for (j in jsonStr[i]) {
        if (j == 'ORDEM') {
          null;
        } else if (j == 'ABREV') {
          jsonStr[i][j] =
            `
          <div class="input-group-append">
            <input style="width: 5em;" readonly type="text" id="txtAbrev${i}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(1) input[type='text']").val()}">
              <button class="btnPesquisaAbrev btn bg-danger" disabled id="btnPesquisaAbrev${i}" data-button="absolute" type="button">
                <i class="m-0 p-0 fas fa-search"></i>
              </button>
          </div>`
        } else if (j == 'DESCRICAO') {
          jsonStr[i][j] = `
          <input style="width: 25em;" readonly type="text" id="txtAbrevDescricao${i}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(2) input[type='text']").val()}">
          `
        } else if (j == 'TOLERANCIA') {
          jsonStr[i][j] = `
          <input style="width: 6em;" readonly type="number" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(3) input[type='number']").val()}">
          `
        } else if (j == 'TOLER_MIN') {
          jsonStr[i][j] = `
          <input style="width: 6em;" readonly type="number" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(4) input[type='number']").val()}">
          `
        } else if (j == 'TOLER_MAX') {
          jsonStr[i][j] = `
          <input style="width: 6em;" readonly type="number" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(5) input[type='number']").val()}">
          `
        } else if (j == 'ORIENTACAO') {
          if (i < sPosicao) {
            jsonStr[i][j] = `
          <input style="width: 30em;" readonly type="text" id="txtAbrevOrientacao${i}" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(" + posColuna + ") input[type='text']").val()}">
          `
          }
        } else {
          if (cols > 0) {
            for (let k = colunasPosicaoInicial; k < cols; k++) {
              const controle = k - 1;
              if (j == keys[k]) {
                jsonStr[i][j] = `
          <input style="width: 5em;" readonly type="number" step="any" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + row + ") td:eq(" + controle + ") input[type='number']").val()}">
          `
              }
            }
          } else {
            null;
          }
        }
      }
      row += 1;
    };

    for (i in jsonStr) {
      if (jsonStr[i]['ORDEM'] >= sOrdem) {
        jsonStr[i]['ORDEM'] = jsonStr[i]['ORDEM'] + 1
      }
    };

    colunasLinha[0].ORDEM = sOrdem;
    jsonStr.splice(sPosicao, 0, colunasLinha[0]);
    for (j in jsonStr[sPosicao]) {
      if (j == 'ORDEM') {
        null;
      } else if (j == 'ABREV') {
        jsonStr[sPosicao][j] = `
        <div class="input-group-append">
          <input style="width: 5em;" readonly type="text" id="txtAbrev${sPosicao}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${jsonStr[sPosicao][j]}">
            <button class="btnPesquisaAbrev btn bg-danger" disabled id="btnPesquisaAbrev${sPosicao}" data-button="absolute" type="button">
              <i class="m-0 p-0 fas fa-search"></i>
            </button>
        </div>`
      } else if (j == 'DESCRICAO') {
        jsonStr[sPosicao][j] = `
          <input style="width: 25em;" readonly type="text" id="txtAbrevDescricao${sPosicao}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${jsonStr[sPosicao][j]}">
          `
      } else if (j == 'TOLERANCIA' || j == 'TOLER_MIN' || j == 'TOLER_MAX') {
        jsonStr[sPosicao][j] = `
          <input style="width: 6em;" readonly type="number" class="check-todos-medidas inputedit input-default focus form-control" value="${jsonStr[sPosicao][j]}">
          `
      } else {
        jsonStr[sPosicao][j] = `
          <input style="width: 5em;" readonly type="number" step="any" class="check-todos-medidas inputedit input-default focus form-control" value="${jsonStr[sPosicao][j]}">
          `
      }
      if (j == 'ORIENTACAO') {
        jsonStr[sPosicao][j] = '';
        jsonStr[sPosicao][j] = `
        <input style="width: 30em;" readonly type="text" id="txtAbrevOrientacao${sPosicao}" class="check-todos-medidas inputedit input-default focus form-control" value="${jsonStr[sPosicao][j]}">
        `
      }
    }

    for (let i = sPosicao + 1; i <= $('#tabelaMedidas').DataTable().rows().data().length; i++) {
      for (j in jsonStr[i]) {
        if (j == 'ABREV') {
          jsonStr[i][j] = '';
          jsonStr[i][j] = `<div class="input-group-append">
        <input style="width: 5em;" readonly type="text" id="txtAbrev${i}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${$('#tabelaMedidas').find("tr:eq(" + i + ") td:eq(1) input[type='text']").val()}">
          <button class="btnPesquisaAbrev btn bg-danger" disabled id="btnPesquisaAbrev${i}" data-button="absolute" type="button">
            <i class="m-0 p-0 fas fa-search"></i>
          </button>
      </div>`
        }
        if (j == 'DESCRICAO') {
          jsonStr[i][j] = '';
          jsonStr[i][j] = `<input style="width: 25em;" readonly type="text" id="txtAbrevDescricao${i}" class="check-todos-medidas inputedit input-default focus form-control btnPesquisaAbrev" value="${$('#tabelaMedidas').find("tr:eq(" + i + ") td:eq(2) input[type='text']").val()}">`
        }
        if (j == 'ORIENTACAO') {
          jsonStr[i][j] = '';
          jsonStr[i][j] = `<input style="width: 30em;" readonly type="text" id="txtAbrevOrientacao${i}" class="check-todos-medidas inputedit input-default focus form-control" value="${$('#tabelaMedidas').find("tr:eq(" + i + ") td:eq(" + posColuna + ") input[type='text']").val()}">`
        }
        else {
          null;
        }
      }
    }

    await criaTabelaMedidas(Cols, jsonStr, true);
    mostraBotaoGravar();
    const focoTabela = (sPosicao * 60) + 15;
    let scrollBody = $($('#tabelaMedidas').DataTable().table().node()).parent();
    await scrollBody.scrollTop(focoTabela);
  };


  let cliquesDisparados = false;

// Função para criar a tabela de medidas
async function criaTabelaMedidas(colunasTabela, dadosTabela, sNovaLinha) {
    $('#tabelaMedidas').empty();

    let dataCols = [];
    let keysDataCols = Object.keys(colunasTabela[0]);
    delete keysDataCols[6];
    keysDataCols[keysDataCols.length] = 'ORIENTACAO';

    for (var i in keysDataCols) {
      dataCols.push(
        {
          'title': keysDataCols[i],
          'data': keysDataCols[i]
        }
      )
    };

    let tableData = [];
    const screenSize = await retornaTamanhoTela();
    if (sNovaLinha == false) {
      tableData = await carregaInputsTabela(dadosTabela);
    } else {
      tableData = dadosTabela;
    }

    $("#tabelaMedidas").DataTable({
      ordering: false,
      bPaginate: false,
      destroy: true,
      order: false,
      search: false,
      filter: false,
      lengthChange: false,
      serverside: false,
      scrollX: '500px',
      scrollY: screenSize,
      orderable: false,
      autoWidth: true,
      data: tableData,
      columns: dataCols,
      columnDefs: [
        {
          targets: [0],
          render: function (data) {
            return retornaOpcoes(data);
          }
        }
      ],
    });

    if (!cliquesDisparados) {
      $('#btnEdicaoMedidas').click();
      $('#btnCancelarMedidas').click();  
      cliquesDisparados = true;
    }
    await carregaPesquisaAbrev();
};

  $('#modal-medidas').on('hidden.bs.modal', function () {
    cliquesDisparados = false;
  });

  // adiciona a lupa de pesquisa do campo abrev na tabela
  async function carregaPesquisaAbrev() {
    for (let i = 0; i < $('#tabelaMedidas').DataTable().rows().data().length; i++) {
      $(`#btnPesquisaAbrev${i}`).pesquisa_serverside([`#txtAbrev${i}`, `#txtAbrevDescricao${i}`, `#txtAbrevOrientacao${i}`], ['CODIGO', 'DESCRICAO', 'ORIENTACAO'], ['DESCRICAO', 'DESCRICAO', 'ORIENTACAO'], '{"tabela":"medidas", "camposSelect":[ "CODIGO", "DESCRICAO", "ORIENTACAO"], "where": null}', 'Pesquisa de Medidas', '', [true, true, true]);
    }
  };

  // inicia o processo de duplicar medidas do produto e chama a função responsável por fazê-lo
  $('#btnConfirmarDuplicaMedidasProduto').on('click', async function () {
    const data = $('#txtTitulo').html().split(' ');
    const novoProduto = pegaChave('#txtProdutoDuplicaMedidas');

    if (novoProduto == '') {
      msgAlerta('Favor informar um produto para duplicar as medidas!');
      return;
    };

    const pesquisaPDest = {
      tabela: "PCP_MEDIDAS",
      camposSelect: ["ORDEM"],
      where: [`CODIGO = '${novoProduto}'`]
    }

    const verificaMedidasDestino = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaPDest));

    if (!verificaMedidasDestino) {
      return;
    }

    if (data[0] == novoProduto) {
      msgAlerta('O código original e de destino não podem ser iguais.');
      return;
    };

    if (verificaMedidasDestino.length > 0) {
      msgAlerta('Este produto possui medidas cadastradas, deseja substituí-las?', async () => {
        await duplicaMedidasProduto(data[0], novoProduto);
      });
    } else {
      await duplicaMedidasProduto(data[0], novoProduto);
    }

  });

  // função responsável por duplicar as medidas do produto
  async function duplicaMedidasProduto(sCodigoOrig, sCodigoDest) {
    try {
      $.LoadingOverlay("show");
      try {

        const response = await requisicao("POST", "/Sisplan/medidas/v1/duplicamedidas?", `CODIGO_ORIG=${sCodigoOrig}&CODIGO_DEST=${sCodigoDest}`, 90000);

        if (!response) {
          msgAlerta('Não foi possível duplicar as medidas, por favor verifique.');
          return;
        };

        if (response.status != 200) {
          msgAlerta('Não foi possível duplicar as medidas, por favor verifique.');
          return;
        };

        const pesquisa = {
          tabela: "PCP_MEDIDAS",
          camposSelect: ["ORDEM"],
          where: [`CODIGO = '${sCodigoDest}'`]
        }

        const verificaDuplicaMedidas = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (verificaDuplicaMedidas.length == 0) {
          msgAlerta('Nenhum dado foi duplicado pois os tamanhos dos produtos são divergentes, por favor verifique.')
          return;
        };

        $('#modal-duplica-medidas').modal('hide');

        toastr.success("Medidas duplicadas com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#txtProdutoDuplicaMedidas').val('');
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }

  };

  // retorna o tipo de medida selecionado na tela de importar medidas
  async function retornaTipoMedidaImporta() {
    let tipoMedida = '';
    if ($('#rImportaTipoMedidaFinal').is(':checked') == true) {
      tipoMedida = ['F', 'final'];
    }
    if ($('#rImportaTipoMedidaInicial').is(':checked') == true) {
      tipoMedida = ['I', 'inicial'];
    }
    if ($('#rImportaTipoMedidaCorte').is(':checked') == true) {
      tipoMedida = ['C', 'corte'];
    }
    if ($('#rImportaTipoMedidaPosCorte').is(':checked') == true) {
      tipoMedida = ['P', 'pós-corte'];
    }

    return tipoMedida;
  };

  // inicia processo de importar medidas e chama a função responsável por fazê-lo
  $('#btnConfirmarImportaMedidasProduto').on('click', async function () {
    if ($('#rImportaTipoMedidaFinal').is(':checked') == false && ($('#rImportaTipoMedidaInicial').is(':checked') == false) &&
      ($('#rImportaTipoMedidaCorte').is(':checked') == false) && ($('#rImportaTipoMedidaPosCorte').is(':checked') == false)) {
      msgAlerta('Favor selecionar um tipo de medida para realizar a importação!')
      return;
    };

    const data = $('#txtTitulo').html().split(' ');
    const produtoOrig = pegaChave('#txtProdutoImportaMedidas');

    if (produtoOrig == '') {
      msgAlerta('Favor informar um produto para realizar a importação!');
      return;
    };

    const tipoMedida = await retornaTipoMedidaImporta();

    const pesquisaPOrig = {
      tabela: "PCP_MEDIDAS",
      camposSelect: ["ORDEM"],
      where: [`CODIGO = '${produtoOrig}'`, `TIPO_MEDIDA = '${tipoMedida[0]}'`]
    }

    const verificaMedidasOrig = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaPOrig));

    if (!verificaMedidasOrig) {
      return;
    }

    if (verificaMedidasOrig.length == 0) {
      msgAlerta(`Não foram encontradas medidas do tipo ${tipoMedida[1]} a serem importadas!`)
      return;
    }

    const pesquisaPDest = {
      tabela: "PCP_MEDIDAS",
      camposSelect: ["ORDEM"],
      where: [`CODIGO = '${data[0]}'`, `TIPO_MEDIDA = '${tipoMedida[0]}'`]
    }


    const verificaMedidasDestino = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaPDest));

    if (!verificaMedidasDestino) {
      return;
    }

    if (verificaMedidasDestino.length > 0) {
      msgAlerta('Este produto possui medidas cadastradas, deseja substituí-las?', async () => {
        await importaMedidasProduto(produtoOrig, data[0], tipoMedida[0]);
      });
    } else {
      await importaMedidasProduto(produtoOrig, data[0], tipoMedida[0]);
    }

  });

  // função responsável por importar as medidas de um produto
  async function importaMedidasProduto(sCodigoOrig, sCodigoDest, sTipoMedida) {
    try {
      $.LoadingOverlay("show");
      try {

        const response = await requisicao("POST", "/Sisplan/medidas/v1/importamedidas?", `CODIGO_ORIG=${sCodigoOrig}&CODIGO_DEST=${sCodigoDest}&TIPO_MEDIDA=${sTipoMedida}`, 90000);

        if (!response) {
          msgAlerta('Não foi possível realizar a importação das medidas, por favor verifique.');
          return;
        };

        if (response.status != 200) {
          msgAlerta('Não foi possível realizar a importação das medidas, por favor verifique.');
          return;
        };

        const pesquisa = {
          tabela: "PCP_MEDIDAS",
          camposSelect: ["ORDEM"],
          where: [`CODIGO = '${sCodigoDest}'`, `TIPO_MEDIDA = '${sTipoMedida}'`]
        }

        const verificaImportaMedidas = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (verificaImportaMedidas.length == 0) {
          msgAlerta('Nenhum dado foi importado pois os tamanhos dos produtos são divergentes, por favor verifique.')
          return;
        };

        $('#modal-importa-medidas').modal('hide');

        toastr.success("Medidas importadas com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#txtProdutoImportaMedidas').val('');
            $('#btnCancelarMedidas').trigger('click');
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  // abre tela para selecionar a foto a ser anexada na medida
  $(async function () {
    var modalUpload = $("#mdModalUpload");
    var Arquivo = $('#txtFotoMedidas');
    var Botao = $("#btnConsultaFotoMedidas");
    Botao.click(function () {
      modalUpload.click();
    });
    modalUpload.change(async function () {
      var NomeArquivo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
      Arquivo.val(NomeArquivo);

      let file = document.querySelector('input[type=file]').files[0];
      let reader = new FileReader();
      let baseString;
      reader.onloadend = function () {
        baseString = reader.result;
        $("#imgMedidas").attr('src', baseString);
      };
      await reader.readAsDataURL(file);
    });

  });

  // confirma alteração da foto da medida
  $('#btnAddFotoMedidas').on('click', async function () {

    if ($('#txtFotoMedidas').val() == '') {
      msgAlerta('Nenhum arquivo foi selecionado! Por favor verifique.');
      return;
    }

    let existeImagem = false;
    const produto = ($('#txtTitulo').html().split(' '))[0];
    const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
    const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!caminhoFoto) {
      return;
    };

    if (caminhoFoto.status != 200) {
      return;
    }

    let response = '';
    // let ordem = $('#txtOrdemFoto').val();
    // let tipoMedida = $('#txtTipoMedidaFoto').val();

    const jsonCaminhoFoto = await caminhoFoto.json();
    const pastaFoto = (jsonCaminhoFoto.mensagem) + '\\MEDIDA\\';
    // if (incluiMedidaOrdem == true) {
    //   response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${tipoMedida}${ordem}.jpg`, null);
    // } else {
    response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null);
    // }

    if (!response) {
      existeImagem = false;
    }

    if (response.status != 200) {
      existeImagem = false;
    }

    const jsonStr = await response.json();
    if (jsonStr.codigo != 200) {
      existeImagem = false;
    } else {
      existeImagem = true;
    };

    // if (incluiMedidaOrdem == true) {
    //   if (existeImagem == true) {
    //     msgAlerta('Já existe uma imagem anexada à esta medida. Deseja substituí-la?', async () => {
    //       await gravaFotoOrdemMedida();
    //     })

    //   } else {
    //     await gravaFotoOrdemMedida();
    //   }
    // } else {
    if (existeImagem == true) {
      msgAlerta('Já existe uma imagem anexada à esta medida. Deseja substituí-la?', async () => {
        await gravaFotoMedida();
      })
    } else {
      await gravaFotoMedida();
    }
    // }
  });

  // define se a foto está sendo excluída por ordem ou não e chama a função de exclusão de foto da medida
  $('#btnExcluiFotoMedidas').on('click', async function () {
    // if (incluiMedidaOrdem == true) {
    //   await excluiFotoOrdemMedida();
    // }
    // if (incluiMedidaOrdem == false) {
    await excluiFotoMedida();
    // }
  });

  // define se a foto que está sendo impressa por ordem ou não e chama a função de impressão de foto da medida
  $('#btnImprimeFotoMedidas').on('click', async function () {
    // if (incluiMedidaOrdem == true) {
    //   await imprimeFotoOrdemMedida();
    // }
    // if (incluiMedidaOrdem == false) {
    await imprimeFotoMedida();
    // }
  });

  // grava foto por produto e tipo de medida
  async function gravaFotoMedida() {
    $.LoadingOverlay('show');
    try {
      try {
        const produto = ($('#txtTitulo').html().split(' '))[0];

        let file = document.querySelector('input[type=file]').files[0];
        let reader = new FileReader();
        let baseString;
        reader.onloadend = function () {
          baseString = reader.result
        };
        await reader.readAsDataURL(file);
        const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
        if (!caminhoFoto) {
          return;
        };

        if (caminhoFoto.status != 200) {
          return;
        };

        jsonStr = await caminhoFoto.json();
        const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
        let pastaFoto = jsonStr.mensagem;
        const response = await requisicao('POST', '/sisplan/funcoes/v1/fotomedida?',
          `DIRETORIO=${pastaFoto + '\\MEDIDA\\'}&ARQUIVO=${produto}MED${medida}.jpg`, `SBASE64=${encodeURIComponent(baseString)}&FILETYPE=${file.type}`);
        if (!response) {
          msgAlerta('Não foi possível gravar imagem! Tente novamente.')
          return;
        };
        if (response.status != 200) {
          msgAlerta('Não foi possível gravar imagem! Tente novamente.')
          return;
        };

        toastr.success("Imagem gravada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#txtArquivoFoto').val('');
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        await buscaFotoMedida();

      } catch (error) {
        console.error(error);
      }

    } catch (error) {
      console.error(error);
      msgAlerta(`Não foi possivel gravar a imagem`);

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  // busca a foto anexada por produto e tipo de medida
  async function buscaFotoMedida() {
    const produto = ($('#txtTitulo').html().split(' '))[0];
    const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
    const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!caminhoFoto) {
      return;
    };

    if (caminhoFoto.status != 200) {
      return;
    }

    const jsonCaminhoFoto = await caminhoFoto.json();
    const pastaFoto = (jsonCaminhoFoto.mensagem) + '\\MEDIDA\\';
    const response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null);

    if (!response) {
      $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
      return;
    }

    if (response.status != 200) {
      $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
      return;
    }

    const jsonStr = await response.json();
    if (jsonStr.codigo != 200) {
      $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    } else {
      $("#imgMedidas").attr('src', `data:image/png;base64,${jsonStr.mensagem}`);
    };
  };

  // grava foto por produto, tipo de medida e ordem
  // async function gravaFotoOrdemMedida() {
  //   $.LoadingOverlay('show');
  //   try {
  //     if ($('#txtFotoMedidas').val() == '') {
  //       msgAlerta('Nenhum arquivo foi selecionado! Por favor verifique.');
  //       return;
  //     }

  //     try {
  //       const ordem = $('#txtOrdemFoto').val();
  //       const medida = $('#txtTipoMedidaFoto').val();
  //       const produto = ($('#txtTitulo').html().split(' '))[0];

  //       let file = document.querySelector('input[type=file]').files[0];
  //       let reader = new FileReader();
  //       let baseString;
  //       reader.onloadend = function () {
  //         baseString = reader.result
  //       };
  //       await reader.readAsDataURL(file);
  //       const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
  //       if (!caminhoFoto) {
  //         return;
  //       };

  //       if (caminhoFoto.status != 200) {
  //         return;
  //       };

  //       jsonStr = await caminhoFoto.json();
  //       let pastaFoto = jsonStr.mensagem;
  //       const medidaOrdem = medida + ordem
  //       const response = await requisicao('POST', '/sisplan/funcoes/v1/fotomedida?',
  //         `DIRETORIO=${pastaFoto + '\\MEDIDA\\'}&ARQUIVO=${produto}MED${medidaOrdem}.jpg`, `SBASE64=${encodeURIComponent(baseString)}&FILETYPE=${file.type}`);
  //       if (!response) {
  //         msgAlerta('Não foi possível gravar imagem! Tente novamente.')
  //         return;
  //       };
  //       if (response.status != 200) {
  //         msgAlerta('Não foi possível gravar imagem! Tente novamente.')
  //         return;
  //       };

  //       toastr.success("Imagem gravada com sucesso!", "Confirmação", {
  //         toastClass: "success",
  //         iconClasses: {
  //           error: "alert-error",
  //           info: "alert-info",
  //           success: "alert-success",
  //           warning: "alert-warning",
  //         },
  //         positionClass: "toast-top-center",
  //         progressBar: true,
  //         timeOut: 3000,
  //         fadeOut: 1000,
  //         onHidden() {
  //           $('#txtArquivoFoto').val('');
  //         },
  //       }).css({
  //         "margin-top": "20%",
  //         width: "500px",
  //         "max-width": "500px",
  //       });

  //       await buscaFotoOrdemMedida();

  //     } catch (error) {
  //       console.error(error);
  //     }

  //   } catch (error) {
  //     console.error(error);
  //     msgAlerta(`Não foi possivel gravar a imagem`);

  //   } finally {
  //     $.LoadingOverlay("hide");
  //   };
  // };

  // busca foto por produto, tipo de medida e ordem
  // async function buscaFotoOrdemMedida() {
  //   const ordem = $('#txtOrdemFoto').val();
  //   const medida = $('#txtTipoMedidaFoto').val();
  //   const produto = ($('#txtTitulo').html().split(' '))[0];
  //   const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

  //   if (!caminhoFoto) {
  //     $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  //     return;
  //   };

  //   if (caminhoFoto.status != 200) {
  //     $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  //     return;
  //   }

  //   const jsonCaminhoFoto = await caminhoFoto.json();
  //   const medidaOrdem = medida + ordem
  //   const pastaFoto = (jsonCaminhoFoto.mensagem) + '\\MEDIDA\\';
  //   const response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medidaOrdem}.jpg`, null);

  //   if (!response) {
  //     $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  //     return;
  //   }

  //   if (response.status != 200) {
  //     $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  //     return;
  //   }

  //   const jsonStr = await response.json();
  //   if (jsonStr.codigo != 200) {
  //     $("#imgMedidas").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  //   } else {
  //     $("#imgMedidas").attr('src', `data:image/png;base64,${jsonStr.mensagem}`);
  //   };
  // };

  // exclui foto por produto e tipo de medida
  async function excluiFotoMedida() {
    $.LoadingOverlay('show');
    try {
      const produto = ($('#txtTitulo').html().split(' '))[0];
      const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

      if (!caminhoFoto) {
        return;
      };

      if (caminhoFoto.status != 200) {
        return;
      };

      const jsonCaminhoFoto = await caminhoFoto.json();
      const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
      const pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';
      const response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null);

      if (!response) {
        msgErro('Não existe nenhuma imagem anexada a esta medida.');
      } else if (response.status != 200) {
        msgErro('Não existe nenhuma imagem anexada a esta medida.');
      } else {
        msgAlerta('Você realmente deseja excluir a imagem?', async () => {
          const exclusao = await requisicao('DELETE', '/sisplan/funcoes/v1/fotomedida?', `DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null)
          if (!exclusao) {
            msgAlerta('Não foi possível excluir a imagem! Por favor verifique.')
            return;
          };
          if (exclusao.status != 200) {
            msgAlerta('Não foi possível excluir a imagem! Por favor verifique.')
            return;
          };
          toastr.success("Imagem excluída com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              $('#txtArquivoFoto').val('');
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });

          await buscaFotoMedida();
        })
      }
    } catch (error) {
      console.error(error);
      msgAlerta(`Não foi possivel excluir a imagem`);

    } finally {
      $.LoadingOverlay("hide");
    };
  };

  // exclui foto por produto, tipo de medida e ordem
  // async function excluiFotoOrdemMedida() {
  //   const ordem = $('#txtOrdemFoto').val();
  //   const medida = $('#txtTipoMedidaFoto').val();
  //   const produto = ($('#txtTitulo').html().split(' '))[0];
  //   const caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

  //   if (!caminhoFoto) {
  //     return;
  //   };

  //   if (caminhoFoto.status != 200) {
  //     return;
  //   };

  //   const jsonCaminhoFoto = await caminhoFoto.json();
  //   const medidaOrdem = medida + ordem
  //   const pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';
  //   const response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medidaOrdem}.jpg`, null);

  //   if (!response) {
  //     msgErro('Não existe nenhuma imagem anexada a esta medida.');
  //   } else if (response.status != 200) {
  //     msgErro('Não existe nenhuma imagem anexada a esta medida.');
  //   } else {
  //     msgAlerta('Você realmente deseja excluir a imagem?', async () => {
  //       const exclusao = await requisicao('DELETE', '/sisplan/funcoes/v1/fotomedida?', `DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medidaOrdem}.jpg`, null)
  //       if (!exclusao) {
  //         msgAlerta('Não foi possível excluir a imagem! Por favor verifique.')
  //         return;
  //       };
  //       if (exclusao.status != 200) {
  //         msgAlerta('Não foi possível excluir a imagem! Por favor verifique.')
  //         return;
  //       };
  //       toastr.success("Imagem excluída com sucesso!", "Confirmação", {
  //         toastClass: "success",
  //         iconClasses: {
  //           error: "alert-error",
  //           info: "alert-info",
  //           success: "alert-success",
  //           warning: "alert-warning",
  //         },
  //         positionClass: "toast-top-center",
  //         progressBar: true,
  //         timeOut: 3000,
  //         fadeOut: 1000,
  //         onHidden() {
  //           $('#txtArquivoFoto').val('');
  //         },
  //       }).css({
  //         "margin-top": "20%",
  //         width: "500px",
  //         "max-width": "500px",
  //       });

  //       await buscaFotoOrdemMedida();
  //     })
  //   };
  // };

  // imprime foto por produto e tipo de medida
  async function imprimeFotoMedida() {
    const produto = ($('#txtTitulo').html().split(' '))[0];
    let caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

    if (!caminhoFoto) {
      return;
    };

    if (caminhoFoto.status != 200) {
      return;
    };

    jsonCaminhoFoto = await caminhoFoto.json();
    const medida = await retornaTipoMedidaGravaFoto($('#opcoesTipoMedida').val());
    let pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';
    let response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medida}.jpg`, null);

    if (!response) {
      msgErro('Não existe nenhuma imagem anexada a esta medida.');
      return;
    } else if (response.status != 200) {
      msgErro('Não existe nenhuma imagem anexada a esta medida.');
      return;
    } else {
      var frame1 = document.createElement('iframe');
      frame1.name = "frame1";
      frame1.style.position = "absolute";
      frame1.style.top = "-1000000px";
      const src = $('#imgMedidas')[0].src;
      document.body.appendChild(frame1);
      var frameDoc = (frame1.contentWindow) ? frame1.contentWindow : (frame1.contentDocument.document) ? frame1.contentDocument.document : frame1.contentDocument;
      frameDoc.document.open();
      frameDoc.document.write(`<image src='${src}' style='width: 700; height:450;' alt='foto'/>`);
      frameDoc.document.close();
      setTimeout(function () {
        window.frames["frame1"].focus();
        window.frames["frame1"].print();
        document.body.removeChild(frame1);
      }, 500);
    }
  };

  // imprime foto por produto, tipo de medida e ordem
  // async function imprimeFotoOrdemMedida() {
  //   const ordem = $('#txtOrdemFoto').val();
  //   const medida = $('#txtTipoMedidaFoto').val();
  //   const produto = ($('#txtTitulo').html().split(' '))[0];
  //   let caminhoFoto = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);

  //   if (!caminhoFoto) {
  //     return;
  //   };

  //   if (caminhoFoto.status != 200) {
  //     return;
  //   };

  //   jsonCaminhoFoto = await caminhoFoto.json();
  //   const medidaOrdem = medida + ordem
  //   let pastaFoto = jsonCaminhoFoto.mensagem + '\\MEDIDA\\';
  //   let response = await requisicao('GET', '/sisplan/funcoes/v1/fotomedida?', `CODIGO=${produto}&DIRETORIO=${pastaFoto}&ARQUIVO=${produto}MED${medidaOrdem}.jpg`, null);

  //   if (!response) {
  //     msgErro('Não existe nenhuma imagem anexada a esta medida.');
  //     return;
  //   } else if (response.status != 200) {
  //     msgErro('Não existe nenhuma imagem anexada a esta medida.');
  //     return;
  //   } else {
  //     var frame1 = document.createElement('iframe');
  //     frame1.name = "frame1";
  //     frame1.style.position = "absolute";
  //     frame1.style.top = "-1000000px";
  //     const src = $('#imgMedidas')[0].src;
  //     document.body.appendChild(frame1);
  //     var frameDoc = (frame1.contentWindow) ? frame1.contentWindow : (frame1.contentDocument.document) ? frame1.contentDocument.document : frame1.contentDocument;
  //     frameDoc.document.open();
  //     frameDoc.document.write(`<image src='${src}' style='width: 700; height:450;' alt='foto'/>`);
  //     frameDoc.document.close();
  //     setTimeout(function () {
  //       window.frames["frame1"].focus();
  //       window.frames["frame1"].print();
  //       document.body.removeChild(frame1);
  //     }, 500);
  //   }
  // };

  // retorna o tipo de medida que se encontrará no nome da foto gravada na pasta - código do produto+tipo de medida+ordem(opcional) ex: 01005FI1.jpg
  async function retornaTipoMedidaGravaFoto(sTipoMedida) {
    let mGravaFoto = '';
    if (sTipoMedida == 'F') {
      mGravaFoto = 'FI';
    }
    if (sTipoMedida == 'I') {
      mGravaFoto = 'IN';
    }
    if (sTipoMedida == 'C') {
      mGravaFoto = 'CT';
    }
    if (sTipoMedida == 'P') {
      mGravaFoto = 'PC';
    }
    if (sTipoMedida == 'O') {
      mGravaFoto = 'CP'
    }

    return mGravaFoto;
  };

});