<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Histórico</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.255.29.2">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.255.29.2">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.255.29.2" />
    <link href='../dist/css/bootstrap.min.css?versao=3.255.29.2'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.255.29.2">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.255.29.2">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.255.29.2">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.255.29.2">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.255.29.2">
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.255.29.2">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.255.29.2" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.255.29.2">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        .labelGeral {
            margin-top: 7px;
            margin-bottom: 3px;
        }

        .radioTop {
            margin-left: 2%;
            margin-top: 2%;
        }

        .radiosStyle {
            margin-top: 2%;
            padding: 1%;
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            margin-left: 0%;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--white-dark) !important;
            /* padding: 0 1.0em 1.0em 1.0em !important; */
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
        }

        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 100%;
            float: left;
            position: relative
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0.5em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px !important;
        }
        .icheck-primary, .form-row{
            margin-bottom: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        ;
        ?>

        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="content">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 flex">
                            </div>
                            <div class="col-sm-6">
                                <!-- <ol class="breadcrumb float-sm-right">
                                    
                                    <li class="breadcrumb-item"><a href="../cadhistorico">Acesso Histórico</a></li>
                                    <li class="breadcrumb-item active">Cadastro de Histórico</li>
                                </ol> -->
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center mt-0">
                        <div class="col-10 text-center p-0 mt-3 mb-2">
                            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                    <h2>Cadastro de Histórico
                                        <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </h2>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mx-0 mb-3">
                                        <form id="msform">
                                            <ul id="progressbar">
                                                <li class="active" id="account"><strong>Geral</strong></li>
                                            </ul>
                                            <p>Preencha os dados e clique em gravar para realizar o cadastro ou alteração do Histórico.</p>
                                            <fieldset class="row justify-content-center mt-5">
                                                <div class="form-card" id="formcard1">
                                                    <div>
                                                        <div class="row">
                                                            <div class="col-12 col-md-auto" id="tutorialSituacao" style="padding-left: 8px;">
                                                                <fieldset class="form border-Field p-0">
                                                                    <legend class="textoBorda pb-0 mb-0">Situação</legend>
                                                                    <div class="form-row" style="margin-bottom: 0px !important;">
                                                                        <div class="icheck-primary" style="margin-bottom: 0px !important;">
                                                                            <input type="radio" checked="checked" id="radioPendente" name="radio">
                                                                            <label class="labelCheck" for="radioPendente">Pendente</label>
                                                                        </div>
                                                                        <div class="icheck-primary" style="margin-bottom: 0px !important;">
                                                                            <input type="radio" id="radioBaixado" name="radio">
                                                                            <label class="labelCheck ml-3" for="radioBaixado">Baixado</label>
                                                                        </div>
                                                                    </div>
                                                                </fieldset>
                                                            </div>
                                                            <div class="col-md-auto col-12" id="tutorialOpcoes" style="padding-left: 8px;">
                                                                <fieldset class="form border-Field p-0">
                                                                    <legend class="textoBorda pb-0 mb-0">Opções</legend>
                                                                    <div class="form-row" style="margin-bottom: 0px !important;">
                                                                        <div class="icheck-primary" style="margin-bottom: 0px !important;">
                                                                            <input type="checkbox" class="configCheck" id="cbCreditoGrupo">
                                                                            <label class="labelCheck" for="cbCreditoGrupo">Utiliza Crédito Grupo</label>
                                                                        </div>
                                                                        <div class="icheck-primary" style="margin-left: 6px;">
                                                                            <input type="checkbox" class="configCheck" id="cbLimiteCredito">
                                                                            <label class="labelCheck" for="cbLimiteCredito">Utiliza no Limite Crédito</label>
                                                                        </div>
                                                                    </div>
                                                                </fieldset>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12 col-md-6 col-sm-12 form-group" id="tutorialHistorico">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtHistorico">Histórico *</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control validate" minlength="2" maxlength="3" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                                                            </div>
                                                        </div>
                                                        <div class="col-12 col-md-6 col-sm-12" id="tutorialTipo">
                                                            <div class="row">
                                                                <div class="col-lg-12  col-12 form-group">
                                                                    <label>Tipo</label>
                                                                    <select id="rgTipo" class="input-default focus custom-select ">
                                                                        <option value="Normal">Normal</option>
                                                                        <option value="Desconto">Desconto</option>
                                                                        <option value="Valor Pago">Valor Pago</option>
                                                                        <option value="Devolução">Devolução</option>
                                                                        <option value="Impostos">Impostos</option>
                                                                        <option value="Despesas">Despesas</option>
                                                                        <option value="Materia Pr">Materia Prima</option>
                                                                        <option value="Loja">Loja</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12  col-12 form-group" id="tutorialDescricao">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição *</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Descrição">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group col-12" id="ObservacaoInfoTour">
                                                            <label data-error="wrong" data-success="right" for="txtObservacao">Observação</label>
                                                            <div class="input-group">
                                                                <textarea style="resize: none" id="txtObservacao" maxlength="1000" placeholder="Observação" class="input-default focus form-control" rows="6"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <input type="button" name="gravar" id="gravar" class="btn-sisp action-button" value="Gravar" />
                                            <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    </div>

    <?php
    include_once('../../../modais.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
    </div>

    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.255.29.2"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.255.29.2"></script>
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.255.29.2"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.255.29.2"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/requisicoes.js?versao=3.255.29.2"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.255.29.2"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.255.29.2"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/sisplan.js?versao=3.255.29.2"></script>
    <script src="../utils/funcoes.js?versao=3.255.29.2"></script>
    <script src="../utils/cookies.js?versao=3.255.29.2"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/driver.min.js?versao=3.255.29.2"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="../config.js?versao=3.255.29.2"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('CADHISTORICO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("CADHISTORICO");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/cadhistorico`
                });
                return;
            }

            //código para liberar registro ao sair da tela clicando no menu, breadcrumb
            const queryString = window.location.href;
            const parametros = queryString.split('/');
            const historico = parametros[parametros.length - 1];

            $(window).on("beforeunload", function(e) {
                // e.preventDefault();
                e.stopPropagation();
                deletaRegistro('CADHISTORICO', getCookie('usuario'), historico);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/cadhistorico/cadastro_cadhistorico/cadhistorico.js?versao=3.255.29.2`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>