$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("CADREGESTADO");

    montaPesquisas();

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#btnLimpaRegEstado').trigger('click');
        $('#btnLimpaLinha').trigger('click');
        $('#btnLimpaMarca').trigger('click');
    });

    function montaPesquisas() {
        componenteFiltro('regEstado', true);
        componenteFiltro('linha', true);
        componenteFiltro('marca', true);
    };

    $('#btnConsultar').on('click', async function () {
        await consultaRegEstado(true);
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    async function consultaRegEstado(bBotao = false) {
        try {
            let response;
            $.LoadingOverlay("show");
            const listaRegEstado = await formataListas($('#txtRegEstado').val().toString());
            const listaLinha = await formataListas($('#txtLinha').val().toString());
            const listaMarca = await formataListas($('#txtMarca').val().toString());
            const regEstado = listaRegEstado.length > 0 ? ` AND CODIGO IN (${listaRegEstado})` : "";
            const linha = listaLinha.length > 0 ? ` AND LINHA IN (${listaLinha})` : "";
            const marca = listaMarca.length > 0 ? ` AND MARCA IN (${listaMarca})` : "";
            if (bBotao) {
                response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/V1/pesquisa?",
                    `JSON={"tabela":"REG_ESTADO", "camposSelect":[ "CODIGO", "DESCRICAO", "COTA", "CODIGO2", "OBS", "TIPO"], "where": ["1=1 ${regEstado} ${linha} ${marca}"]}`,
                    null
                );
            } else {
                response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/V1/pesquisa?",
                    'JSON={ "tabela":"REG_ESTADO", "camposSelect":[ "CODIGO", "DESCRICAO", "COTA", "CODIGO2", "OBS", "TIPO"], "where": null}',
                    null
                );
            };

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();

            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            };

            $('#modal-filtros').modal('hide');

            $("#tabelaAcessoRegEstado").DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                autoWidth: true,
                data: jsonStr.RESULT[0].length > 0 ? jsonStr.RESULT[0] : '',
                columns: [
                    {
                        data: "CODIGO",
                    },
                    {
                        data: "DESCRICAO",
                    },
                    {
                        data: "CODIGO2",
                    },
                    {
                        data: "TIPO",
                    },
                    {
                        data: "COTA",
                    },
                    {
                        data: "OBS",
                    },
                ],
                columnDefs: [
                    {
                        targets: [0], 
                        render: function (data) {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                ],
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        };
    };

    $("#btnIncluir").on("click", function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadregestado/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        };
    });

    $("#tabelaAcessoRegEstado").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $("#tabelaAcessoRegEstado").DataTable().row($(this).parents("tr")).data();
            let registroLiberado = await verificarRegistro("CADREGESTADO", data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadregestado/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        };
    });

    $("#tabelaAcessoRegEstado").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $("#tabelaAcessoRegEstado").DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro("CADREGESTADO", data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadregestado/${data.CODIGO}`;
            };
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        };
    });

    $('#tabelaAcessoRegEstado').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaAcessoRegEstado").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
                window.location.reload();
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        };
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadregestado?", `CODIGOREGESTADO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        };
    };

    await consultaRegEstado();
});