<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Entrada NF</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.255.29.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.255.29.2">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.255.29.2">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.255.29.2">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.255.29.2" />
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.255.29.2" />
  <link rel="stylesheet" href="../dist/css/select.bootstrap.min.css?versao=3.255.29.2" />
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.255.29.2">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.255.29.2">
  <style>
    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
      padding: 1.50rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: #343a40;
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #fretes>.card,
    #proodutoMaterial>.card {
      background: #f7f7f7;
    }

    .linhaBotao {
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .action-button {
      width: 80px;
      background: var(--primary-color);
      font-weight: bold;
      color: white;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 0px 10px 5px;
      float: right;
    }

    .action-button:hover,
    .action-button:focus {
      background-color: rgb(133, 0, 40)
    }

    .FormCenter {
      display: flex !important;
      align-items: center !important;
      justify-content: center !important;
    }

    .tipoItem {
      display: flex;
      align-items: center;
      justify-content: center;
      min-width: 45px;
      margin-left: 15px;
      text-align: center;
      background-color: #dc3545;
      max-width: 35px;
      width: 45px;
      max-height: 35px;
      font-size: 12px;
      padding-top: 5px;
      height: 35px;
      font-weight: bold;
      color: white;
      border-radius: 5px;
    }

    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative;
    }

    fieldset {
      padding: 2.5rem;
    }

    #tabelaFinanceiro {
      margin: 15px;
    }

    #tabelaFinanceiro th,
    #tabelaFinanceiro td {
      border: none;
    }

    #msform {
      text-align: left;
    }

    #msform fieldset .form-card {
      /* background: white; */
      border: 0 none;
      width: 100%;
      height: 100%;
      margin: 0px !important;
      padding: 0px !important;
      position: relative;
    }

    .menuEntrada {
      width: 100%;
      background-color: var(--colorMenuEntrada) !important;
    }

    .submenuEntrada {
      width: 100%;
      height: 400px;
    }

    .submenu {
      height: 25%;
      background-color: var(--colorMenuEntrada);
      display: flex;
      font-size: 15px;
      align-items: center;
      text-align: left;
      padding: 1.5rem !important;
      cursor: pointer;
      color: var(--fontColorMenuEntrada) !important;
    }

    .submenu p,
    .submenu i {
      margin-bottom: 0rem !important;
      margin-right: 5px;
    }

    .submenu i {
      font-size: 25px !important;
    }

    .submenuAtivo {
      background-color: var(--colorActiveMenuEntrada) !important;
      color: var(--fontColorMenuEntrada) !important;
    }

    #tabelaNotasNR.dataTable tbody td,
    #tabelaNotasNR.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }


    .submenu:hover {
      transition: 0.5s;
      font-size: 16px;
      background-color: var(--colorHoverMenuEntrada) !important;
    }

    @media screen and (max-width: 1200px) {
      div.menuEntrada {
        height: 100%;
        width: 100%;
        background-color: var(--colorMenuEntrada) !important;
      }

      div.submenuEntrada {
        display: flex;
        width: 100%;
        height: 100px;
      }

      div.submenu {
        padding: 0rem;
        height: 100%;
        width: 100%;
        background-color: var(--colorMenuEntrada);
        margin-bottom: 5px;
        padding: 0rem !important;
        font-size: 45px;
        align-items: center;
        justify-content: center;
      }

      .submenu:hover {
        transition: 0.4s;
        font-size: 50px;
        background-color: var(--colorHoverMenuEntrada) !important;
      }

      .ajusteTipo {
        height: 1px;
      }

      .ajusteItem {
        height: 1px;
      }

      div.submenu p {
        display: none;
      }
    }

    fieldset {
      padding: 0rem;
    }

    .addProdutoFocus:read-only {
      border: solid red 2px !important;
    }

    .bNaoValidado:read-only {
      border: solid red 2px !important;
    }

    .bValidado:read-only {
      border: solid green 2px !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 4px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

  <div class="wrapper">

    <div class="content-wrapper">

      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <!-- <ol class="breadcrumb float-sm-right">

                  <li class="breadcrumb-item"><a href="../entrada_nf">Acesso Entrada NF</a></li>
                  <li class="breadcrumb-item active">Entrada NF</li>
                </ol> -->
              </div><!-- /.col -->
            </div><!-- /.row -->
            <div class="row">
              <div class="col-12">
                <div class="card" style="height:auto;">
                  <div class="card-header bg-dark">
                    <div class="row flex">
                      <h4 class="text-white">Entrada de Nota Fiscal </h4>
                      <button title="Tutorial" class="btn btn-info btn-sm ml-2" id="tutorial">
                        <i class="fas fa-question-circle"></i>
                      </button>
                    </div>
                  </div>
                  <div class="card-body" style="padding-left: 0.5rem !important; padding-top: 0px!important;padding-bottom: 0px!important; padding-right: 0.5rem !important;">
                    <div class="row">
                      <div class="col-12 col-xl-2" style="padding:0;">
                        <div class="menuEntrada">
                          <div class="submenuEntrada">
                            <div class="submenu" id="dadosGeraisMenu" title="Dados Gerais">
                              <i class="fas fa-book"></i>
                              <p> Dados Gerais</p>
                            </div>
                            <div class="submenu" id="itensNF" title="Itens">
                              <i class="fas fa-cart-arrow-down"></i>
                              <p> Itens</p>
                            </div>
                            <div class="submenu" id="basesMenu" title="Bases">
                              <i class="fas fa-percent"></i>
                              <p> Bases</p>
                            </div>
                            <div class="submenu d-none" id="financeiroMenu" title="Financeiro">
                              <i class="fas fa-money-check-alt"></i>
                              <p>Financeiro</p>
                            </div>
                            <div class="submenu d-none" id="luzMenu" title="Energia/Telefonia">
                              <i class="far fa-lightbulb"></i>
                              <p>Energia/Telefonia </p>
                            </div>
                            <div class="submenu" id="notasRef" title="Notas Referenciadas" style="padding-right: 0!important">
                              <i class="fas fa-copy"></i>
                              <p>Notas Referenciadas</p>
                            </div>
                            <div class="submenu" id="dadosAddMenu" title="Dados Adicionais">
                              <i class="fas fa-plus"></i>
                              <p>Dados Adicionais</p>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-12 col-xl-10" style="min-height: 570px; padding:0;">
                        <fieldset>
                          <form action="" id="msform" class="m-0">
                            <div class="card" id="dadosGerais">
                              <div class="form-card">
                                <div class="card card-header" role="tab" id="geral">
                                  <a style="width:100%;" data-toggle="collapse--" data-parent="#DadosGerais" aria-expanded="true" aria-controls="collapseOne1--">
                                    <div class="row">
                                      <div class="col-11">
                                        <h4 class="title-page">
                                          Dados Gerais   

                                          <label for="fileXml" class="btn btn-secondary" id="botaoImportarXml" style="font-weight: 400; font-size: 60%"><i class="fas fa-file-upload"></i>
                                            Importar XML</label>
                                          <input type="file" id="fileXml" accept="text/xml" style="display: none;">

                                          <label for="btnImportarNota" class="btn btn-primary" id="botaoImportarNotaLabel" style="font-weight: 400; font-size: 60%">
                                            <i class="fas fa-file-upload"></i>
                                            Importar Nota
                                          </label>
                                          <input type="button" id="btnImportarNota" style="display: none;">

                                          <label for="fileXmlCTe" class="btn btn-secondary" id="botaoImportarCTe" style="font-weight: 400; font-size: 60%"><i class="fas fa-file-upload"></i>
                                            Importar CT-e</label>
                                          <input type="file" id="fileXmlCTe" accept="text/xml" style="display: none;">
                                        </h4>
                                      </div>
                                    </div>
                                  </a>
                                </div>
                                <div class="collapse show" id="DadosGerais">
                                  <div class="card-body" style="min-height: 553px;">
                                    <div class="row" style="margin-top: 5px;">
                                      <div class="form-group group-default col-md-2 col-12" id="NotaFiscalInfoTour">
                                        <label>Nota Fiscal *</label>
                                        <div class="relative">
                                          <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNotaFiscal" name="txtNotaFiscal" placeholder="NF">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-md-2 col-12" id="NotaFiscalInfoTour">
                                        <label>Série *</label>
                                        <div class="relative">
                                          <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtSerie" name="txtSerie" placeholder="Série">
                                        </div>
                                      </div>
                                      <div class="form-group col-md-2 col-12">
                                        <label for="txtLancamento">Lançamento</label>
                                        <div class="relative">
                                          <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtLancamento" name="txtLancamento" disabled>
                                        </div>
                                      </div>
                                      <div class="form-group col-md-6 col-12" id="TipoDocInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtTpDoc">Tipo Documento
                                          *</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" required="required" id="txtTpDoc" name="txtTpDoc" class="form-control" placeholder="Tipo Documento">
                                          <div class=" input-group-append">
                                            <button class="btn bg-danger" id="btn-TpDoc" name="btn-TpDoc" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-TpDoc" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="row">
                                      <div class="form-group group-default col-md-6 col-12" id="NotaFiscalInfoTour">
                                        <label>Data Emissão </label>
                                        <div class="relative">
                                          <input type="date" max="2500-12-31" autocomplete="off" value="" class="input-default focus form-control" required="required" pattern="[0-9]+$" id="txtDtEmissao" name="txtDtEmissao">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-md-6 col-12" id="NotaFiscalInfoTour">
                                        <label>Data Entrada </label>
                                        <div class="relative">
                                          <input type="date" max="2500-12-31" autocomplete="off" value="" class="input-default focus form-control" required="required" pattern="[0-9]+$" id="txtDtEntrada" name="txtDtEntrada">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="row">
                                      <div class="form-group col-12 col-md-6" id="FornecInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor
                                          *</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" required="required" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-Fornecedor" name="btn-Fornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-Fornecedor" name="btn-limpa-Fornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-12 col-md-6" id="NaturezaServInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtFornecedor">Operação</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtOperacao" name="txtOperacao" class="form-control" placeholder="Operação">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-Operacao" name="btn-Operacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-Operacao" name="btn-limpa-Operacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="row">
                                      <div class="form-group col-12 col-md-6" id="NaturezaInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtNatureza">Natureza
                                          *</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtNatureza" name="txtNatureza" class="form-control" placeholder="Natureza">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-Natureza" name="btn-Natureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-Natureza" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-3 col-md-3" id="NaturezaServInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtNaturezaServ">Natureza
                                          Serv. </label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNaturezaServ" name="txtNaturezaServ" class="form-control" placeholder="Natureza serv.">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-NaturezaServ" name="btn-NaturezaServ" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-NaturezaServ" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-3 col-md-3" id="SitDocInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtSitDoc">Sit. Doc.</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSitDoc" name="txtSitDoc" class="form-control" placeholder="Sit. Doc.">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-SitDoc" name="btn-SitDoc" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-SitDoc" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="form-group group-default col-md-3 col-12 d-none" id="nsuEntrada">
                                        <label>NR DANFE: </label>
                                        <div class="relative">
                                          <input type="text" autocomplete="off" value="" class="input-default focus form-control" pattern="[0-9]+$" id="txtNSU" name="txtNSU" placeholder="NR DANFE">
                                        </div>
                                      </div>

                                      <div class="form-group group-default col-md-6 col-12" id="txtDocumentoDiv">
                                        <label>Documento: </label>
                                        <div class="relative">
                                          <input type="text" autocomplete="off" value="" class="input-default focus form-control" pattern="[0-9]+$" id="txtDocumento" name="txtDocumento" placeholder="Documento">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-md-6 col-12">
                                        <label for="">Tipo Frete *</label>
                                        <div class="relative">
                                          <select name="txtTipoFrete" id="txtTipoFrete" class="input-default focus form-control validate" required="required">
                                            <option value="">Selecione o tipo de Frete</option>
                                            <option value="1"> 0 - Contratação do Frete por conta do Remetente (CIF)</option>
                                            <option value="2"> 1 - Contratação do Frete por conta do Destinatário (FOB)</option>
                                            <option value="3"> 2 - Contratação do Frete por conta de Terceiros</option>
                                            <option value="5"> 3 - Transporte Próprio por conta do Remetente</option>
                                            <option value="6"> 4 - Transporte Próprio por conta do Destinatário</option>
                                            <option value="7"> 8 - Por Conta Destinatário na NF</option>
                                            <option value="4"> 9 - Sem Frete</option>
                                          </select>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="form-group col-12 col-md-6" id="tpMovimentacaoInfoTour">
                                        <label data-error="wrong" data-success="right" for="txttpMovimentacao">Tipo
                                          Movimentação *</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" required="required" id="txttpMovimentacao" name="txttpMovimentacao" class="form-control" placeholder="Tipo Movimentacao">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-tpMovimentacao" name="btn-tpMovimentacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-tpMovimentacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>

                                      <div class="form-group col-12 col-md-6" id="DepositoInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtDeposito">Depósito *</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito" oninvalid="this.setCustomValidity('Informe um depósito.')">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-Deposito" name="btn-tpMovimentacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>

                                    </div>
                                    <div class="row">
                                      <div class="form-group col-12 col-md-6 d-none">
                                        <label data-error="wrong" data-success="right" for="selectTipoCteGeral">Tipo CT-e</label>
                                        <select class="drilldown-item form-control focus input-default" id="selectTipoCteGeral" data-dropdown-css-class="select2-danger">
                                          <option class="drilldown-item" value="0">CT-e normal</option>
                                          <option class="drilldown-item" value="1">CT-e de complemento de valores</option>
                                          <option class="drilldown-item" value="2">CT-e emitido em hipótese de anulação de débito</option>
                                          <option class="drilldown-item" value="3">CT-e substituto do CT-e anulado</option>
                                        </select>
                                      </div>
                                      <div class="form-group col-12 col-md-6 d-none" id="cteReferenciadaInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtAliqServ">Alíquota Serviço</label>
                                        <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtAliqServ" name="txtAliqServ" class="form-control" placeholder="CT-e">
                                      </div>
                                      <div class="form-group col-12 col-md-4 d-none" id="naturezaFreteInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtNaturezaFrete">Natureza Frete</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtNaturezaFrete" name="txtNaturezaFrete" class="form-control" placeholder="Natureza">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnNaturezaFrete" name="btnNaturezaFrete" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaNaturezaFrete" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="form-group col-12 col-md-4 d-none" id="cidadeOrigInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtCidadeOrig">Cidade Original</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtCidadeOrig" name="txtCidadeOrig" class="form-control" placeholder="Cidade">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCidadeOrig" name="btnCidadeOrig" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCidadeOrig" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="form-group col-12 col-md-4 d-none" id="cidadeDestInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtCidadeDest">Cidade Destino</label>
                                        <div class="input-group">
                                          <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtCidadeDest" name="txtCidadeDest" class="form-control" placeholder="Cidade">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCidadeDest" name="btnCidadeDest" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCidadeDest" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </form>
                          <!-- itens -->

                          <div class="card d-none" id="itensCard">
                            <div class="card card-header" role="tab" id="geral">
                              <nav class="col-lg-12">
                                <div class="nav nav-tabs d-flex flex-nowrap" id="nav-tab" role="tablist" style="text-decoration: none; max-width: none!important; white-space: nowrap!important; overflow-x: auto!important; overflow-y: hidden">
                                  <a class="nav-link abaLink active" id="tabItens" data-toggle="tab" href="#navItens" role="tab" aria-controls="navItens" aria-selected="true">Itens</a>
                                  <a class="nav-link abaLink" id="tabItensReferenciados" data-toggle="tab" href="#navReferenciados" role="tab" aria-controls="navReferenciados" aria-selected="false">Itens Referenciados</a>
                                </div>
                              </nav>
                            </div>
                            <div class="card-body pb-1" style="min-height: 553px; padding: 0!important">
                              <div class="tab-content col-lg-12 px-0" id="nav-tabContent">
                                <div id="navItens" class="tab-pane fade show active" role="tabpanel" aria-labelledby="tabItens">
                                  <div id="itens">
                                    <div class="form-card">
                                      <div class="collapse show" id="produto">
                                        <div class="card">
                                          <div class="card-body">
                                            <div id="barra" class="row col-12">
                                              <div class="form-group col-lg-2 col-12">
                                                <label class="labelGeral" for="txtBarra">Barra:</label>
                                                <input type="text" class="input-default focus form-control" id="txtBarra" aria-describedby="codError" name="txtBarra" class="form-control" placeholder="Barra">
                                              </div>
                                              <div class="form-group col-lg-2 col-12">
                                                <label class="labelGeral" for="selectTipo">Tipo barra:</label>
                                                <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="selectTipo" style="border-color: #a9a9a9">
                                                  <option class="drilldown-item" value="P" selected>Produto</option>
                                                  <option class="drilldown-item" value="M">Material</option>
                                                </select>
                                              </div>
                                              <div class="form-group col-lg-3 col-12 form-check icheck-primary d-flex align-items-center">
                                                <input type="checkbox" class="form-check-input" id="cbConferencia">
                                                <label class="form-check-label pr-2" for="cbConferencia" id="labelConferencia">Conferência</label>
                                                <button type="button" class="btn btn-icon-normal btn-danger divRFIDItens d-none" style="border-radius: 4px!important; text-align: center; margin-left: 1px;" id="btn-iniciar-epc-itens" name="btn-iniciar-epc-itens" data-button="absolute" title="Iniciar RFID, Atalho (Alt + 1)">
                                                  <i class="fas fa-play"></i>
                                                </button>
                                                <button type="button" class="btn btn-icon-normal btn-danger divRFIDItens ml-1 d-none" style="border-radius: 4px!important;" id="btn-parar-epc-itens" name="btn-parar-epc-itens" data-button="absolute" title="Parar RFID, Atalho (Alt + 2)">
                                                  <i class="fas fa-pause"></i>
                                                </button>
                                              </div>
                                              <div id="divReferenciado" class="form-group col-lg-5 col-12">
                                                <fieldset class="form border-Field mb-0 pb-0">
                                                  <legend class="textoBorda mb-0 pb-0">Legenda</legend>
                                                  <div class="form-row d-flex justify-content-around">
                                                    <div class="ml-1 d-flex flex-row align-items-center pt-1">
                                                      <div style="height: 25px; width:25px; background-color: rgb(220,53,69); border: 1px solid white"></div>
                                                      <label class="form-check-label px-2">Não referenciado</label>
                                                    </div>
                                                    <div class="ml-1 d-flex flex-row align-items-center pt-1">
                                                      <div style="height: 25px; width:25px; background-color: rgb(65,193,57); border: 1px solid white"></div>
                                                      <label class="form-check-label px-2">Referenciado</label>
                                                    </div>
                                                  </div>
                                                </fieldset>
                                              </div>
                                              <div id="divConferido" class="form-group col-lg-5 col-12 d-none">
                                                <fieldset class="form border-Field mb-0 pb-0">
                                                  <legend class="textoBorda mb-0 pb-0">Legenda</legend>
                                                  <div class="form-row d-flex justify-content-around">
                                                    <div class="ml-1 d-flex flex-row align-items-center pt-1">
                                                      <div style="height: 25px; width:25px; background-color: rgb(220,53,69); border: 1px solid white"></div>
                                                      <label class="form-check-label px-1">Não conferido</label>
                                                    </div>
                                                    <div class="ml-1 d-flex flex-row align-items-center pt-1">
                                                      <div style="height: 25px; width:25px; background-color: rgb(0, 0, 255); border: 1px solid white"></div>
                                                      <label class="form-check-label px-1">Parcialment conf.</label>
                                                    </div>
                                                    <div class="ml-1 d-flex flex-row align-items-center pt-1">
                                                      <div style="height: 25px; width:25px; background-color: rgb(65,193,57); border: 1px solid white"></div>
                                                      <label class="form-check-label px-1">Conferido</label>
                                                    </div>
                                                  </div>
                                                </fieldset>
                                              </div>
                                            </div>
                                            <div id="itens">
                                              <div class="table-responsive">
                                                <table id="tabelaAddProduto" class="addItensSequencia" width="100%" style="width: 100%;">
                                                  <thead>
                                                    <th>Número</th>
                                                    <th>Item</th>
                                                    <th>Qtde</th>
                                                    <th id="txtPrecoMask">Preço</th>
                                                    <th>CFOP</th>
                                                    <th>IPI %</th>
                                                    <th>ICMS %</th>
                                                    <th>NCM</th>
                                                    <th>Ações</th>
                                                    <th>AdicionarLinha</th>
                                                    <th>CODIGO2</th>
                                                    <th>COD_REGRA</th>
                                                    <th>TIPO_VENDA</th>
                                                    <th>ALIQ_COFINS</th>
                                                    <th>ALIQ_PIS</th>
                                                    <th>ALIQ_SIMPLES</th>
                                                    <th>ALIQ_DIF</th>
                                                    <th>BASE_COFINS</th>
                                                    <th>BASE_PIS</th>
                                                    <th>BASE_IPI</th>
                                                    <th>BASE_ICMS_ST</th>
                                                    <th>BASE_ICMSST_ENT</th>
                                                    <th>BASE_ICMS</th>
                                                    <th>ISENTA_IPI</th>
                                                    <th>IPI</th>
                                                    <th>ISENTA_ICMS</th>
                                                    <th>LOTE</th>
                                                    <th>OUTRAS_ICMS</th>
                                                    <th>OUTRAS_IPI</th>
                                                    <th>TIPO</th>
                                                    <th>VALOR</th>
                                                    <th>VALOR_ICMS</th>
                                                    <th>VALOR_ICMSST_ENT</th>
                                                    <th>VAL_CRED_SIMPLES</th>
                                                    <th>VAL_ICMS_DIF</th>
                                                    <th>VLR_ICMS_ST</th>
                                                    <th>VLR_IPI</th>
                                                    <th>VAL_PIS</th>
                                                    <th>VAL_COFINS</th>
                                                    <th>CODIPI</th>
                                                    <th>CODFIS</th>
                                                    <th>CODTRIB</th>
                                                    <th>COD_REGRA:</th>
                                                    <th>COMPRI</th>
                                                    <th>DEPOSITO</th>
                                                    <th>DESCNCM</th>
                                                    <th>DESCRICAO</th>
                                                    <th>ESTOQUE</th>
                                                    <th>IPI:</th>
                                                    <th>LARGURA</th>
                                                    <th>LOCAL</th>
                                                    <th>TIPO_VENDA:</th>
                                                    <th>TP_BAIXA</th>
                                                    <th>TRIBUTACAO</th>
                                                    <th>UNIDADE</th>
                                                    <th>CODIGO</th>
                                                    <th>CODCRE</th>
                                                    <th>CLA_PIS</th>
                                                    <th>CLA_COFINS</th>
                                                    <th>CODIPI</th>
                                                    <th>COR</th>
                                                    <th>CSOSN</th>
                                                    <th>DEPOSITO</th>
                                                    <th>DESCRICAO</th>
                                                    <th>ESTOQUE</th>
                                                    <th>PERC_II</th>
                                                    <th>PERC_ICMS_REDUZ</th>
                                                    <th>TOTAL</th>
                                                    <th>TAM</th>
                                                    <th>NOTAFISCAL</th>
                                                    <th>CLATRIB</th>
                                                    <th>FCI</th>
                                                    <th>INFADPROD</th>
                                                    <th>PERCCREDSN</th>
                                                    <th>PERCCST20</th>
                                                    <th>CSTICMS</th>
                                                    <th>PERCIPIABA</th>
                                                    <th>DTFAB</th>
                                                    <th>DTVENC</th>
                                                    <th>MANTERDIGITADO</th>
                                                    <th>CONFERIDO</th>
                                                    <th>UNIDADE_COMPRA</th>
                                                  </thead>
                                                </table>
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <input class="d-none" type="button" id="testarFuncao" value=" TESTAR JSON ITENS ">
                                    <input class="d-none" type="button" id="chamaLoop" value=" CHAMA LOOP ">
                                  </div>
                                  <div class="info-box" style="background-color: var(--blue-color)!important;">
                                    <div class="row text-white col-md-6 col-12">
                                      <div class="col-md-6 col-12" style="border-right: 1px solid white">
                                        <div class="flex" style="padding-top:10px;">
                                          <span class="info-box-icon"><i class="fas fa-box" style="font-size: 25px;"></i></span>
                                          <div class="info-box-content">
                                            <span class="info-box-text" style="font-size:15px">QUANTIDADE</span>
                                            <span id="txtQtdeTot" class="info-box-number" style="font-size:17px">0</span>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-md-6 col-12">
                                        <div class="flex" style="padding-top:10px;">
                                          <span class="info-box-icon"><i class="fas fa-dollar-sign" style="font-size: 25px;"></i></span>
                                          <div class="info-box-content pl-0" style="margin-left: -12px;">
                                            <span class="info-box-text" style="font-size:15px">PREÇO</span>
                                            <span id="txtPrecoTot" class="info-box-number" style="font-size:17px">R$&nbsp;0,00</span>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div id="navReferenciados" class="tab-pane fade" role="tabpanel" aria-labelledby="tabItensReferenciados">
                                  <div class="row col-12 m-0 p-0">
                                    <div class="col-lg-12 table-responsive card-body p-1" style="max-height: 500px">
                                      <table id="tabelaItensReferenciados" class="table table-sm table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <!-- financeiro -->
                          <div class="card d-none" id="financeiro">
                            <div class="form-card">
                              <div class="card card-header" role="tab" id="observacao">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#financeiroCol" href="#financeiroCol" aria-expanded="true" aria-controls="collapseOne1">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto;" class="col-1">
                                      <i class="fas fa-angle-down"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page">
                                        Financeiro
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse show" id="financeiroCol">
                                <div class="card-body" style="min-height: 553px;">
                                  <div class="row">
                                    <div class="form-default group-default col-12 col-md-12 col-lg-6 d-none">
                                      <label for="">Número de Parcelas</label>
                                      <div class="relative">
                                        <input type="number" class="input-default focus form-control validate" required id="txtParcela" placeholder="Número de Parcelas">
                                      </div>
                                    </div>

                                    <div class="col-12 col-md-12 col-lg-12">
                                      <label for="vencimentosDuplicatas">Vencimentos</label>
                                      <div class="flex" id="vencimentosDuplicatas">
                                        <input type="number" class="input-default focus form-control" id="txtParcela1" val="0" placeholder="1">
                                        <input type="number" class="input-default focus form-control" id="txtParcela2" val="0" placeholder="2">
                                        <input type="number" class="input-default focus form-control" id="txtParcela3" val="0" placeholder="3">
                                        <input type="number" class="input-default focus form-control" id="txtParcela4" val="0" placeholder="4">
                                        <input type="number" class="input-default focus form-control" id="txtParcela5" val="0" placeholder="5">
                                        <input type="number" class="input-default focus form-control" id="txtParcela6" val="0" placeholder="6">
                                        <input type="number" class="input-default focus form-control" id="txtParcela7" val="0" placeholder="7">
                                        <input type="number" class="input-default focus form-control" id="txtParcela8" val="0" placeholder="8">
                                        <input type="number" class="input-default focus form-control" id="txtParcela9" val="0" placeholder="9">
                                        <input type="number" class="input-default focus form-control" id="txtParcela10" val="0" placeholder="10">
                                        <input type="number" class="input-default focus form-control" id="txtParcela11" val="0" placeholder="11">
                                        <input type="number" class="input-default focus form-control" id="txtParcela12" val="0" placeholder="12">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row" style="margin-top: 15px;">
                                    <div class="col-md-6 col-12" id="HistoricoInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtHistorico">Histórico</label>
                                      <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control validate" required id="txtHistorico" name="txtHistorico" placeholder="Historico">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-md-6 col-12" id="SituacaoInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtSituacao">Situação</label>
                                      <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" placeholder="Situação">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row" style="margin-top: 15px;">
                                    <div class="col-md-6 col-12" id="ContaInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtConta">Conta</label>
                                      <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" placeholder="Conta">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-md-6 col-12" id="BancoInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtBanco">Banco</label>
                                      <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtBanco" name="txtBanco" placeholder="Banco">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row" style="margin-top: 15px;">
                                    <div class="col-md-12 col-12" id="ClasseGerInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtClasseGer">Classe
                                        Gerencial</label>
                                      <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" placeholder="Classe Gerencial">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="form-default group-default col-12 col-md-12">
                                      <label for="">Observação</label>
                                      <div class="relative">
                                        <input type="text" class="input-default focus form-control validate" required id="txtObsPagar" name="txtObsPagar" placeholder="Observação">
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-12 mb-2">
                                    <input id="btnGerarDuplicata" type="button" style="font-size:14px;" class="btn btn-danger btn-sisp action-button" value="Gerar Duplicatas">
                                  </div>
                                  <div class="col-sm-12 table-responsive card-body">
                                    <table id="tabelaFinanceiro" class="table table-sm table-select table-hover" width="100%">
                                      <thead>
                                        <th>NOTAFISCAL</th>
                                        <th>VALOR</th>
                                        <th>AP</th>
                                        <th>LANCAMENTO</th>
                                        <th>DATA_VENCIMENTO</th>
                                        <th>DUPLI</th>
                                      </thead>
                                      <tbody>
                                      </tbody>
                                    </table>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>

                          <!-- EnergiaTelefonia -->
                          <div class="card d-none" id="EnergiaTelefonia">
                            <div class="form-card">
                              <div class="card card-header" role="tab" id="geral">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#energiaTelefonia" href="#energiaTelefonia" aria-expanded="true" aria-controls="collapseOne1">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-down"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page">
                                        Energia Telefonia
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>

                              <div class="collapse show" id="energiaTelefonia">
                                <div class="card-body">
                                  <div class="row">
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Nr. Conta:</label>
                                      <div class="relative">
                                        <input type="text" class="input-default" id="txtNrContaTelefone" placeholder="Número da conta">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Data Consumo Inicial:</label>
                                      <div class="relative">
                                        <input type="date" max="2500-12-31" value="" class="input-default" id="txtDtConsumoInicial">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Data Consumo Final</label>
                                      <div class="relative">
                                        <input type="date" max="2500-12-31" value="" class="input-default" id="txtDtConsumoFinal">
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Período de Prestação:</label>
                                      <div class="relative">
                                        <input type="text" class="input-default" id="txtPeriodoPrestacao" placeholder="Período de prestação">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Data Apresentação:</label>
                                      <div class="relative">
                                        <input type="date" max="2500-12-31" value="" class="input-default" id="txtDtApresentacao">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Data Vencimento:</label>
                                      <input type="date" max="2500-12-31" value="" class="input-default" id="txtDtVencimento">
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Tipo Identificador:</label>
                                      <div class="relative">
                                        <select name="" id="txtTipoIdentificador" class="input-default">
                                          <option value="">Informe o Tipo Identificador</option>
                                          <option value="0">Nenhum</option>
                                          <option value="1">Inscrição Estadual - IE</option>
                                          <option value="2">CNPJ</option>
                                          <option value="3">CPF</option>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Condição Participante:</label>
                                      <div class="relative">
                                        <select name="" id="txtCondParticipante" class="input-default">
                                          <option value="">Informe a Condição Participanete</option>
                                          <option value="01">Emitente</option>
                                          <option value="02">Destinatário</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Consumo Faturado:</label>
                                      <div class="relative">
                                        <input type="text" value="0.00" class="input-default" id="txtConsumoFaturado">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Valor do Consumo:</label>
                                      <div class="relative">
                                        <input type="text" value="0.00" class="input-default valorMask" id="txtValorConsumoFaturado">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-4 col-12">
                                      <label for="">Outras Despesas:</label>
                                      <div class="relative">
                                        <input type="text" value="0.00" class="input-default" id="txtOutrasDespesas">
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Valor Terceiros:</label>
                                      <div class="relative">
                                        <input type="text" value="0.00" class="input-default valorMask" id="txtValorTerceiros">
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Código da Tarifa:</label>
                                      <div class="relative">
                                        <input type="text" class="input-default" id="txtCodigoTarifa" placeholder="Código da tarifa">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Classe Consumo(Energia/Gás/Água):</label>
                                      <div class="relative">
                                        <select name="" id="txtClasseConsumo" class="input-default">
                                          <option value="">Informe a Classe de consumo(Energia/Gás/Água)</option>
                                          <option value="00">Não Informado</option>
                                          <option value="01">Comercial</option>
                                          <option value="02">Consumo Próprio</option>
                                          <option value="03">Iluminação Pública</option>
                                          <option value="04">Industrial</option>
                                          <option value="05">Poder Público</option>
                                          <option value="06">Residencial</option>
                                          <option value="07">Rural</option>
                                          <option value="08">Serviço Público</option>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Tipo de Ligação (Energia):</label>
                                      <div class="relative">
                                        <select name="" id="txtTipoLigacao" class="input-default">
                                          <option value="">Informe o Tipo de Ligação</option>
                                          <option value="1">Não Informado</option>
                                          <option value="2">Monofásico</option>
                                          <option value="3">Bifásico</option>
                                          <option value="4">Trifásico</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Tipo Assinante (Telefone):</label>
                                      <div class="relative">
                                        <select name="" id="TipoAssinante" class="input-default">
                                          <option value="">Informe o Tipo de Assinante</option>
                                          <option value="1">Não Informado</option>
                                          <option value="2">Comercial/Industrial</option>
                                          <option value="3">Poder Público</option>
                                          <option value="4">Residencial/Pessoa física</option>
                                          <option value="5">Público</option>
                                          <option value="6">Semi-Público</option>
                                          <option value="7">Outros</option>
                                        </select>
                                      </div>
                                    </div>

                                    <div class="group-default default-group col-sm-6 col-12">
                                      <label for="">Grupo Tensão (Energia):</label>
                                      <div class="relative">
                                        <select name="" id="txtGrupoTensao" class="input-default">
                                          <option value="">Informe um Grupo de Tensão</option>
                                          <option value="00">Não Informado</option>
                                          <option value="01-A1"> Alta Tensão (230kV ou mais)</option>
                                          <option value="02-A2"> Alta Tensão (88 a 138kV)</option>
                                          <option value="03-A3"> Alta Tensão (69kV)</option>
                                          <option value="04-A3a">Alta Tensão (30kV a 44kV)</option>
                                          <option value="05-A4"> Alta Tensão (2,3kV a 25kV)</option>
                                          <option value="06-AS"> Alta Tensão Subterrâneo 06</option>
                                          <option value="07-B1"> Residencial 07</option>
                                          <option value="08-B1"> Residencial Baixa Renda 08</option>
                                          <option value="09-B2"> Rural 09</option>
                                          <option value="10-B2"> Cooperativa de Eletrificação Rural</option>
                                          <option value="11-B2"> Serviço Público de Irrigação</option>
                                          <option value="12-B3"> Demais Classes</option>
                                          <option value="13-B4a">Iluminação Pública - rede de distribuição</option>
                                          <option value="14-B4b">Iluminação Pública - bulbo de lâmpada</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row" style="margin-top: 15px;">
                                    <div class="group-default default-group col-12">
                                      <label for="">Cod. Classe Consumo:</label>
                                      <div class="relative">
                                        <select name="" id="txtCodClasseConsumo" class="input-default">
                                          <option value="">Informe uma Classe de Consumo</option>
                                          <option value="00-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física até R$ 50,00</option>
                                          <option value="01-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 50,01 a R$ 100,00</option>
                                          <option value="02-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 100,01 a R$ 200,00</option>
                                          <option value="03-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 200,01 a R$ 300,00</option>
                                          <option value="04-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 300,01 a R$ 400,00</option>
                                          <option value="05-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 400,01 a R$ 500,00</option>
                                          <option value="06-01"> Registro consolidando os documentos de consumo
                                            residencial/pessoa física de R$ 500,01 a R$ 1000,00</option>
                                          <option value="07-01"> Registro por documento fiscal de consumo
                                            residencial/pessoa física acima de R$ 1.000,01</option>
                                          <option value="10-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial até R$ 50,00 </option>
                                          <option value="11-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 50,01 a R$ 100,00</option>
                                          <option value="12-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 100,01 a R$ 200,00</option>
                                          <option value="13-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 200,01 a R$ 300,00</option>
                                          <option value="14-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 300,01 a R$ 400,00</option>
                                          <option value="15-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 400,01 a R$ 500,00</option>
                                          <option value="16-01"> Registro consolidando os documentos de consumo
                                            comercial/industrial de R$ 500,01 a R$ 1.000,00</option>
                                          <option value="17-01"> Registro por documento fiscal de consumo
                                            comercial/industrial acima de R$ 1.000,01</option>
                                          <option value="70-01"> Registro consolidando os documentos de consumo do poder
                                            público até R$ 50,00</option>
                                          <option value="71-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 50,01 a R$ 100,00</option>
                                          <option value="72-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 100,01 a R$ 200,00</option>
                                          <option value="73-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 200,01 a R$ 300,00</option>
                                          <option value="74-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 300,01 a R$ 400,00</option>
                                          <option value="75-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 400,01 a R$ 500,00</option>
                                          <option value="76-01"> Registro consolidando os documentos de consumo poder
                                            público de R$ 500,01 a R$ 1.000,00</option>
                                          <option value="77-01"> Registro por documento fiscal de consumo poder público
                                            acima de R$ 1.000,01</option>
                                          <option value="78-01"> Registro por documento fiscal de consumo de órgão público
                                            isento do ICMS</option>
                                          <option value="79-01"> Registro por documento fiscal de consumo de órgãos
                                            semipúblicos</option>
                                          <option value="90-01"> Registro consolidando os documentos de outros tipos de
                                            consumo até R$ 50,00</option>
                                          <option value="91-01"> Registro consolidando os documentos de outros tipos de
                                            consumo de R$ 50,01 a R$ 100,00</option>
                                          <option value="92-01"> Registro consolidando os documentos de outros tipos de
                                            consumo de R$ 100,01 a R$ 200,00</option>
                                          <option value="93-01"> Registro consolidando os documentos de outros tipos de
                                            consumo de R$ 200,01 a R$ 300,00</option>
                                          <option value="95-01"> Registro consolidando os documentos de outros tipos de
                                            consumo de R$ 400,01 a R$ 500,00</option>
                                          <option value="96-01"> Registro consolidando os documentos de outros tipos de
                                            consumo de R$ 500,01 a R$ 1.000,00</option>
                                          <option value="97-01"> Registro por documento fiscal de outros tipos de consumo
                                            acima de R$ 1.000,01</option>
                                          <option value="99-01"> Registro por documento fiscal emitido</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>

                          <div class="card d-none" id="bases">

                            <div class="card card-header" role="tab">
                              <a style="width:100%;" id="cobranca" data-toggle="collapse" data-parent="#totais" href="#totais" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-right"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Totais
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse show" id="totais">
                              <div class="card-body">
                                <div class="row" style="margin-bottom: -2%;">
                                  <div class="form-group group-default col-12 col-md-6 d-none">
                                    <label for="">Valor Contabilização:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default valorMask" name="txtValorContabilização" id="txtValorContabilização">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-12">
                                    <label for="">Valor da NF:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default valorMask" name="txtValordaNF" id="txtValordaNF">
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab">
                              <a style="width:100%;" data-toggle="collapse" data-parent="#fretes" href="#fretes" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-right"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Frete
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse show" id="fretes">
                              <div class="card-body">
                                <div class="row" style="margin-bottom: -2%;">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Frete Conhecimento</label>
                                    <div class="relative">
                                      <input type="text" value="0.00" class="input-default validate" name="txtFreteConhecimento" id="txtFreteConhecimento">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Frete NF</label>
                                    <div class="relative">
                                      <input type="text" value="0.00" class="input-default validate" name="txtFreteNF" id="txtFreteNF">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Outras/Desp:</label>
                                    <div class="relative">
                                      <input type="text" value="0.00" class="input-default validate" name="txtOutrasDesp" id="txtOutrasDesp">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Descontos</label>
                                    <div class="relative">
                                      <input type="text" value="0.00" class="input-default validate" name="txtDesconto" id="txtDesconto">
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab" id="observacao" style="width:100%">
                              <a style="width:100%" data-toggle="collapse" data-parent="#produtoMaterial" href="#produtoMaterial" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-down"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Produto/Material
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse show" id="produtoMaterial">
                              <div class="card-body" style="max-height: 342px; padding-top: 0.5rem!important;">
                                <div class="row" style="margin-top: 7px;">
                                  <div class="form-group group-default col-12 col-md-4">
                                    <label for="">Base ICMS/ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseICMSISS" id="txtBaseICMSISS">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-4">
                                    <label for="">Base ICMS.ST:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseICMSST1" id="txtBaseICMSST1">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-4">
                                    <label for="">Base IPI:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseIPI" id="txtBaseIPI">
                                    </div>
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Outras ICMS/ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtOutrasICMSISS" id="txtOutrasICMSISS">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor ICMS.ST:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorICMSST" id="txtValorICMSST">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Outras IPI:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtOutrasIPI" id="txtOutrasIPI">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Dif. de ICMS ST:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtDifICMSSTRecolher" id="txtDifICMSSTRecolher">
                                    </div>
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Isento ICMS/ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtIsentoICMSISS" id="txtIsentoICMSISS">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Base ICMS.ST Calc:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseICMSST2" id="txtBaseICMSST2">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Isento IPI:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtIsentoIPI" id="txtIsentoIPI">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor Produtos:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorProdutos" id="txtValorProdutos">
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-bottom: -13px;">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor ICMS/ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorICMSISS" id="txtValorICMSISS">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor ICMS.ST Calc:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorICMSSTCalc" id="txtValorICMSSTCalc">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor IPI:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorIPI" id="txtValorIPI">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="">Valor Estoque/Cardex:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorEstoqueCardex" id="txtValorEstoqueCardex">
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" role="tab" style="width:100%">
                              <a style="width:100%" data-toggle="collapse" data-parent="#servicosRetencoes" href="#servicosRetencoes" aria-expanded="true" aria-controls="collapseOne3">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-down"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Serviços/Retenções
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse" id="servicosRetencoes">
                              <div class="card-body" style="max-height: 342px; padding-top: 0.5rem!important;">
                                <div class="row" style="margin-top: 7px;">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseIRRFServicos">Base IRRF:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseIRRFServicos" id="txtBaseIRRFServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseCSLLServicos">Base CSLL:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseCSLLServicos" id="txtBaseCSLLServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBasePISServicos">Base PIS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBasePISServicos" id="txtBasePISServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseCSRFServicos">Base CSRF:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseCSRFServicos" id="txtBaseCSRFServicos">
                                    </div>
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorIRRFServicos">Valor IRRF:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtValorIRRFServicos" id="txtValorIRRFServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorCSLLServicos">Valor CSLL:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorCSLLServicos" id="txtValorCSLLServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorPISServicos">Valor PIS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtValorPISServicos" id="txtValorPISServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorCSRFServicos">Valor CSRF:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtValorCSRFServicos" id="txtValorCSRFServicos">
                                    </div>
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseISSServicos">Base ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseISSServicos" id="txtBaseISSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseINSSServicos">Base INSS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseINSSServicos" id="txtBaseINSSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtBaseCOFINSServicos">Base COFINS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseCOFINSServicos" id="txtBaseCOFINSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtDeducoesServicos">Deduções:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate" name="txtDeducoesServicos" id="txtDeducoesServicos">
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-bottom: -13px;">
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorISSServicos">Valor ISS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorISSServicos" id="txtValorISSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorINSSServicos">Valor INSS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorINSSServicos" id="txtValorINSSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorCOFINSServicos">Valor COFINS:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorCOFINSServicos" id="txtValorCOFINSServicos">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-12 col-md-3">
                                    <label for="txtValorServicos">Valor Serviços:</label>
                                    <div class="relative">
                                      <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorServicos" id="txtValorServicos">
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="card card-header" style="margin-top:10px" role="tab">
                              <a style="width:100%;" id="endereco" data-toggle="collapse" data-parent="#geral" href="#geral" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="row">
                                  <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                    <i class="fas fa-angle-right"></i>
                                  </div>
                                  <div class="col-11">
                                    <h4 class="title-page">
                                      Geral
                                    </h4>
                                  </div>
                                </div>
                              </a>
                            </div>
                            <div class="collapse" id="geral">
                              <div class="card card-body">
                                <div class="card card-header" role="tab" id="observacao" style="width:100%; margin-top: -30px">
                                  <a style="width:100%;" data-toggle="collapse" data-parent="#Geraltab" href="#Geraltab" aria-expanded="true" aria-controls="collapseOne1">
                                    <div class="row">
                                      <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                        <i class="fas fa-angle-down"></i>
                                      </div>
                                      <div class="col-11">
                                        <h4 class="title-page">
                                          Geral
                                        </h4>
                                      </div>
                                    </div>
                                  </a>
                                </div>
                                <div class="collapse show" id="Geraltab">
                                  <div class="card-body">
                                    <div class="row">
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Base Cofins:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtBaseCofins" id="txtBaseCofins">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Diferencial Alíquota:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtDiferencialAliquota" id="txtDiferencialAliquota">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Valor Cofins:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorCofins" id="txtValorCofins">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Diferencial Valor:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtDiferencialValor" id="txtDiferencialValor">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Base PIS:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtBasePIS2" id="txtBasePIS2">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Alíq. Créd. Simples Nac.:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtAliqCredSimplesNac" id="txtAliqCredSimplesNac">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Valor PIS:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValorPIS2" id="txtValorPIS2">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Val. Créd. Simples Nac.:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtValCredSimplesNac" id="txtValCredSimplesNac">
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="card card-header" role="tab">
                                  <a style="width:100%;" id="entrega" data-toggle="collapse" data-parent="#beneficioFiscal" href="#beneficioFiscal" aria-expanded="true" aria-controls="collapseOne1">
                                    <div class="row">
                                      <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                        <i class="fas fa-angle-right"></i>
                                      </div>
                                      <div class="col-11">
                                        <h4 class="title-page">
                                          Benefício Fiscal
                                        </h4>
                                      </div>
                                    </div>
                                  </a>
                                </div>
                                <div class="collapse" id="beneficioFiscal">
                                  <div class="card-body">
                                    <div class="row">
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Perc.:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate" name="txtPerc" id="txtPerc">
                                        </div>
                                      </div>
                                      <div class="form-group group-default col-12 col-md-6">
                                        <label for="">Valor:</label>
                                        <div class="relative">
                                          <input type="text" readonly value="0.00" class="input-default validate valorMask" name="txtValor" id="txtValor">
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                              </div>
                            </div>
                          </div>
                          <!-- notas referenciadas -->
                          <div class="card d-none" id="notasReferenciadas">
                            <div class="form-card">
                              <div class="card card-header" role="tab">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#notasRefCol" href="#notasRefCol" aria-expanded="true" aria-controls="collapseOne1">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-down"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page">
                                        Notas Referenciadas
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse show" id="notasRefCol">
                                <div class="card-body" style="min-height: 553px;">
                                  <div class="form-row col-12">
                                    <div class="form-group col-lg-3 col-12">
                                      <label class="labelGeral" for="txtOperacaoNR">Operação:</label>
                                      <select class="drilldown-item form-control select2 select2-danger focus classNR" disabled data-dropdown-css-class="select2-danger" id="txtOperacaoNR" style="border-color: #a9a9a9">
                                        <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                        <option class="drilldown-item" value="0">Entrada/Aquisição</option>
                                        <option class="drilldown-item" value="1">Saída/Prestação</option>
                                      </select>
                                    </div>
                                    <div class="form-group col-lg-3 col-12">
                                      <label class="labelGeral" for="txtEmitenteNR">Emitente:</label>
                                      <select class="drilldown-item form-control select2 select2-danger focus classNR" disabled data-dropdown-css-class="select2-danger" id="txtEmitenteNR" style="border-color: #a9a9a9">
                                        <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                        <option class="drilldown-item" value="0">Emissão própria</option>
                                        <option class="drilldown-item" value="1">Terceiros</option>
                                      </select>
                                    </div>
                                    <div class="form-group col-lg-4 col-12">
                                      <label class="labelGeral" for="txtNotaFiscalNR">Nota Fiscal:</label>
                                      <div class="input-group" id="search-setor">
                                        <input type="text" class="input-default focus form-control classNR" disabled id="txtNotaFiscalNR" aria-describedby="codError" name="txtNotaFiscalNR" class="form-control" placeholder="Nota Fiscal">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger classNR" disabled id="btnNotaFiscalNR" name="btnNotaFiscalNR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger classNR" disabled id="btnLimpaNotaFiscalNR" name="btnLimpaNotaFiscalNR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="form-group col-lg-2 col-12">
                                      <label class="labelGeral" for="txtEmissaoNR">Emissão:</label>
                                      <input type="date" class="input-default focus form-control classNR" onchange="converterParaFormatoISO()" disabled id="txtEmissaoNR" aria-describedby="codError" name="txtEmissaoNR" class="form-control">
                                    </div>
                                    <div class="form-group col-lg-5 col-12">
                                      <label class="labelGeral" for="txtChaveNR">Chave NFE:</label>
                                      <input type="text" class="input-default focus form-control classNR" disabled id="txtChaveNR" aria-describedby="codError" name="txtChaveNR" class="form-control" placeholder="Chave NFE">
                                    </div>
                                    <div class="form-group col-lg-1 col-12">
                                      <label class="labelGeral" for="txtSerieNR">Série:</label>
                                      <input type="text" class="input-default focus form-control classNR" disabled id="txtSerieNR" aria-describedby="codError" name="txtSerieNR" class="form-control" placeholder="Série">
                                    </div>
                                    <div class="form-group col-lg-2 col-12">
                                      <label class="labelGeral" for="txtValorNR">Valor:</label>
                                      <input type="text" class="input-default focus form-control classNR controleFloat" disabled id="txtValorNR" aria-describedby="codError" name="txtValorNR" class="form-control" placeholder="0.00">
                                    </div>
                                    <div class="form-group col-lg-2 col-12">
                                      <label class="labelGeral" for="txtValorLiqNR">Valor Líquido:</label>
                                      <input type="text" class="input-default focus form-control classNR controleFloat" disabled id="txtValorLiqNR" aria-describedby="codError" name="txtValorLiqNR" class="form-control" placeholder="0.00">
                                    </div>
                                    <div class="form-group col-lg-2 col-12">
                                      <label class="labelGeral" for="txtPesoNR">Peso:</label>
                                      <input type="text" class="input-default focus form-control classNR controleFloat" disabled id="txtPesoNR" aria-describedby="codError" name="txtPesoNR" class="form-control" placeholder="0.00">
                                    </div>
                                    <div class="form-group col-lg-4 col-12">
                                      <label class="labelGeral" for="txtClienteNR">Cliente:</label>
                                      <div class="input-group" id="search-setor">
                                        <input type="text" class="input-default focus form-control classNR" disabled id="txtClienteNR" aria-describedby="codError" name="txtClienteNR" class="form-control" placeholder="Cliente">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger classNR" disabled id="btnClienteNR" name="btnClienteNR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger classNR" disabled id="btnLimpaClienteNR" name="btnLimpaClienteNR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="form-group col-lg-4 col-12">
                                      <label class="labelGeral" for="txtModeloNR">Modelo Docto:</label>
                                      <div class="input-group" id="search-setor">
                                        <input type="text" class="input-default focus form-control classNR" disabled id="txtModeloNR" aria-describedby="codError" name="txtModeloNR" class="form-control" placeholder="Modelo Docto">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger classNR" disabled id="btnModeloNR" name="btnModeloNR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger classNR" disabled id="btnLimpaModeloNR" name="btnLimpaModeloNR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="form-group col-lg-4 col-12">
                                      <label class="labelGeral" for="txtInfComplNR">Inf. Complementar:</label>
                                      <div class="input-group" id="search-setor">
                                        <input type="text" class="input-default focus form-control classNR" disabled id="txtInfComplNR" aria-describedby="codError" name="txtInfComplNR" class="form-control" placeholder="Inf. Complementar">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger classNR" disabled id="btnInfComplNR" name="btnInfComplNR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger classNR" disabled id="btnLimpaInfComplNR" name="btnLimpaInfComplNR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="d-flex col-12 px-0">
                                      <button class="btn btn-primary btn-sisp d-none" id="btnConfirmarNR">Confirmar</button>
                                      <button class="btn btn-danger btn-sisp ml-2 d-none" id="btnDesistirNR">Desistir</button>
                                      <button class="btn btn-primary btn-sisp" id="btnIncluirNR">Incluir</button>
                                      <button class="btn btn-secondary btn-sisp ml-2" id="btnAlterarNR">Alterar</button>
                                      <button class="btn btn-danger btn-sisp ml-2 mr-auto" id="btnExcluirNR">Excluir</button>
                                    </div>
                                    <div class="row col-12 m-0 p-0">
                                      <div class="col-lg-12 table-responsive card-body p-1" style="max-height: 220px">
                                        <table id="tabelaNotasNR" class="table table-sm table-select table-hover" width="100%">
                                          <thead>
                                          </thead>
                                          <tbody>
                                          </tbody>
                                        </table>
                                      </div>
                                    </div>
                                    <div class="d-flex col-12 justify-content-start">
                                      <div class="form-group col-lg-2 col-4">
                                        <label class="labelGeral" for="txtPesoTotalNR">Peso Total:</label>
                                        <input type="text" class="input-default focus form-control" disabled id="txtPesoTotalNR" aria-describedby="codError" name="txtPesoTotalNR" class="form-control" placeholder="0,00">
                                      </div>
                                      <div class="form-group col-lg-2 col-4">
                                        <label class="labelGeral" for="txtValorTotalNR">Valor Total:</label>
                                        <input type="text" class="input-default focus form-control" disabled id="txtValorTotalNR" aria-describedby="codError" name="txtValorTotalNR" class="form-control" placeholder="0,00">
                                      </div>
                                      <div class="form-group col-lg-2 col-4">
                                        <label class="labelGeral" for="txtValorLiqTotalNR">Valor Líquido Total:</label>
                                        <input type="text" class="input-default focus form-control" disabled id="txtValorLiqTotalNR" aria-describedby="codError" name="txtValorLiqTotalNR" class="form-control" placeholder="0,00">
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <!-- dados adicionais -->
                          <div class="card d-none" id="dadosAdicionais">
                            <div class="form-card">
                              <div class="card card-header" role="tab" id="observacao">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#dadosAdicionaisCol" href="#dadosAdicionaisCol" aria-expanded="true" aria-controls="collapseOne1">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-down"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page">
                                        Dados Adicionais
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse show" id="dadosAdicionaisCol">
                                <div class="card-body" style="min-height: 553px;">
                                  <div class="row">
                                    <div class="form-group group-default col-12">
                                      <label>Dados Adicionais</label>
                                      <textarea style="resize: none; padding: .7%" id="txtDadosAdicionais" placeholder="Dados adicionais" class="input-default focus form-control" rows="10"></textarea>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row" style="padding: 1.0rem;">
                            <div class="col-12">
                              <input id="btnGravar" type="submit" style="font-size:15px;" class="btn btn-danger btn-sisp action-button" value="Gravar">
                              <button type="button" id="btnVoltar" style="font-size:15px; background-color: #616161" class="btn btn-sisp action-button" data-dismiss="modal">Voltar</button>
                            </div>
                          </div>
                        </fieldset>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section><!-- /.section -->
    </div><!-- /.container-fluid -->
  </div><!-- /.content-wrapper -->

  <div class="modal fade" id="modalProduto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalProduto-titulo" class="modal-title">Pesquisa Item
            <label style="font-size: 60%" class="container">Produto 
              <input type="radio" checked="checked" value="P" id="radioProduto" name="tipoFat">
              <span class="checkmark"></span>
            </label>
            <label style="font-size: 60%; margin-left: -2.5%" class="container">Material 
              <input type="radio" id="radioMaterial" value="M" name="tipoFat">
              <span class="checkmark"></span>
            </label>
            <label style="font-size: 60%; margin-left: -2.5%" class="container">Serviço 
              <input type="radio" id="radioServico" value="S" name="tipoFat">
              <span class="checkmark"></span>
            </label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-2">
              <input class="d-none" id="idLinhaProd" />
              <input type="text" placeholder="Código" class="input-default focus" id="txtProdutoCodigo" name="txtProdutoCodigo">
            </div>
            <div class="col-sm-2">
              <input type="text" placeholder="Código 2" class="input-default focus" id="txtProdutoCodigo2" name="txtProdutoCodigo2">
            </div>
            <div class="col-sm-2">
              <input type="text" placeholder="Cor" class="input-default focus" id="txtProdutoCor" name="txtProdutoCor">
            </div>
            <div class="col-sm-2">
              <input type="text" placeholder="Tam" class="input-default focus" id="txtProdutoTam" name="txtProdutoTam">
            </div>
            <div class="col-sm-2">
              <input type="text" placeholder="Descrição" class="input-default focus" id="txtProdutoDescricao" name="txtProdutoDescricao">
            </div>
            <div class="col-sm-2" style="text-align:center">
              <button type="button" class="btn btn-info focus" id="btnConsultarProduto" name="btnConsultarProduto">
                <i class='fas fa-search'></i> Consultar
              </button>
            </div>
            <div class="col-sm-12 table-responsive">
              <table style="width:100%" width="100%" id="tabelaProdutos" class="table table-sm table-select table-hover table-condensed">
                <!-- <thead>
                                     </thead>
                                     <tbody>
                                     </tbody> -->
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btn_confirmar_produto" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEditarProduto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalEditarProduto-titulo" class="modal-title">Editar Produto   
            <input type="checkbox" id="manterDigitado">
            <label for="manterDigitado" style="font-size: 50%;">
              Manter valor digitado
            </label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <nav>
            <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
              <a class="nav-link abaLink active" id="tabFiscal" data-toggle="tab" href="#divFiscal" role="tab" aria-controls="divFiscal" aria-selected="true">Fiscal</a>
              <a class="nav-link abaLink" id="tabICMS" data-toggle="tab" href="#divICMS" role="tab" aria-controls="divICMS" aria-selected="false">ICMS</a>
              <a class="nav-link abaLink" id="tabIPI" data-toggle="tab" href="#diIPI" role="tab" aria-controls="diIPI" aria-selected="false">IPI</a>
              <a class="nav-link abaLink" id="tabPIS" data-toggle="tab" href="#divPIS" role="tab" aria-controls="divPIS" aria-selected="false">PIS</a>
              <a class="nav-link abaLink" id="tabCOFINS" data-toggle="tab" href="#divCOFINS" role="tab" aria-controls="divCOFINS" aria-selected="false">COFINS</a>
              <a class="nav-link abaLink" id="tabValidaEstoque" data-toggle="tab" href="#divValidaEstoque" role="tab" aria-controls="divValidaEstoque" aria-selected="false">Validade Estoque</a>
            </div>
          </nav>

          <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="divFiscal" role="tabpanel" aria-labelledby="tabFiscal">
              <div class="col-12">
                <div class="row">
                  <div class="col-12 text-left p-0 mt-3 mb-2 d-none">
                    <div class="col-12 col-md-6" id="NCMInfoTour">
                      <label data-error="wrong" data-success="right" for="txtNCM">NCM </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNCM" name="txtNCM" class="form-control" placeholder="NCM">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-NCM" name="btn-NCM" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-NCM" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-12 col-md-6" id="NaturezaInfoTour">
                      <label data-error="wrong" data-success="right" for="txtNaturezaItens">Natureza </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNaturezaItens" name="txtNaturezaItens" class="form-control" placeholder="Natureza">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-NaturezaItens" name="btn-Natureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-NaturezaItens" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-12 text-left p-0 mt-3 mb-2">
                    <div class="form-group group-default col-6 col-md-6">
                      <label for="txtNumeroFCI">Número FCI:</label>
                      <div class="relative">
                        <input type="text" class="input-default form-control" id="txtNumeroFCI" placeholder="Número FCI">
                      </div>
                    </div>
                    <div class="form-group group-default col-6  col-md-6">
                      <label for="txtInfAdProd">Inf. Ad. Prod.:</label>
                      <div class="relative">
                        <input type="text" class="input-default form-control" id="txtInfAdProd" placeholder="Inf. Ad. Prod.">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="tab-pane fade" id="divICMS" role="tabpanel" aria-labelledby="tabICMS">
              <div class="col-12 col-sm-12 col-md-12">
                <div class="col-12 text-left p-0 mt-3 mb-2">
                  <div class="row">
                    <div class="col-8 col-md-8" id="CSTInfoTour">
                      <label data-error="wrong" data-success="right" for="txtCSTICMS">CST: </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCSTICMS" name="txtCSTICMS" class="form-control" placeholder="CST">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-CSTICMS" name="btn-CST" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-CSTICMS" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-2 col-md-2" id="CSTInfoTour">
                      <label for="txtValorSTCalc">Valor ST Calc.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtValorSTCalc">
                      </div>
                    </div>
                    <div class="col-2 col-md-2" id="CSTInfoTour">
                      <label for="txtBaseSTCalc">Base ST Calc.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtBaseSTCalc">
                      </div>
                    </div>
                  </div>

                  <div class="row" style="margin-top: 15px">
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtBaseST">Base ST:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtBaseST">
                      </div>
                    </div>

                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtBaseICMS">Base:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtBaseICMS">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtPercICMS">Perc.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtPercICMS">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtOutrasICMS">Outras:</label>
                      <div class="relative">
                        <input type="text" class="input-default form-control" id="txtOutrasICMS">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtCredSN">% Cred. SN.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtCredSN">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtValorCredSN">Valor Cred. SN.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtValorCredSN">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtValorST">Valor ST:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtValorST">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtCST20">% CST .20:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtCST20">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtValorICMS">Valor:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtValorICMS">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtIsentasICMS">Isentas:</label>
                      <div class="relative">
                        <input type="text" value="0" class="input-default form-control" id="txtIsentasICMS">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtDifAliq">% Dif Aliq.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtDifAliq">
                      </div>
                    </div>
                    <div class="form-group group-default col-12 col-md-6 col-lg-2">
                      <label for="txtValorDifAliq">Valor Dif Aliq.:</label>
                      <div class="relative">
                        <input type="text" value="0.00" class="input-default form-control" id="txtValorDifAliq">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="tab-pane fade" id="diIPI" role="tabpanel" aria-labelledby="tabIPI">
              <div class="col-12 col-sm-12 col-md-12">
                <div class="col-12 text-left p-0 mt-3 mb-2">
                  <div class="row ml-1 mr-1">
                    <div class="col-12" id="CSTInfoTour">
                      <label data-error="wrong" data-success="right" for="txtCSTIPI">CST: </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCSTIPI" name="txtCSTIPI" class="form-control" placeholder="CST">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-CSTIPI" name="btn-CST" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-CSTIPI" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row mt-2">
                    <div class="col-12">
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtBaseIPI2">Base</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtBaseIPI2">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtPercentIPI">Percent.:</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtPercentIPI">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtValorIPI2">Valor:</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtValorIPI2">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12">
                      <div class="form-group group-default col-12 col-md-6 float-left">
                        <label for="txtOutrasIPI2">Outras:</label>
                        <div class="relative">
                          <input type="text" class="input-default form-control" id="txtOutrasIPI2">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-6 float-right">
                        <label for="txtIsentasIPI">Isentas:</label>
                        <div class="relative">
                          <input type="text" class="input-default form-control" id="txtIsentasIPI">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="tab-pane fade" id="divPIS" role="tabpanel" aria-labelledby="tabPIS">
              <div class="col-12 col-sm-12 col-md-12">
                <div class="col-12 text-left p-0 mt-3 mb-2">
                  <div class="row ml-1 mr-1">
                    <div class="col-12" id="CSTInfoTour">
                      <label data-error="wrong" data-success="right" for="txtCSTPIS">CST: </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCSTPIS" name="txtCSTPIS" class="form-control" placeholder="CST">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-CSTPIS" name="btn-CST" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-CSTPIS" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row mt-2">
                    <div class="col-12">
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtBasePIS">Base</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtBasePIS">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtAliquotaPIS">Aliquota.:</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtAliquotaPIS">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <div class="col-12">
                          <label for="txtValorPIS">Valor:</label>
                          <div class="relative">
                            <input type="text" value="0.00" class="input-default form-control" id="txtValorPIS">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="tab-pane fade" id="divCOFINS" role="tabpanel" aria-labelledby="tabCOFINS">
              <div class="col-12 col-sm-12 col-md-12">
                <div class="col-12 text-left p-0 mt-3 mb-2">
                  <div class="row ml-1 mr-1">
                    <div class="col-12" id="CSTInfoTour">
                      <label data-error="wrong" data-success="right" for="txtCSTCofins">CST: </label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCSTCofins" name="txtCSTCofins" class="form-control" placeholder="CST">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-CSTCofins" name="btn-CST" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-CSTCofins" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row mt-2">
                    <div class="col-12">
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtBaseCOFINS3">Base</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtBaseCOFINS3">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <label for="txtAliquotaCOFINS">Aliquota.:</label>
                        <div class="relative">
                          <input type="text" value="0.00" class="input-default form-control" id="txtAliquotaCOFINS">
                        </div>
                      </div>
                      <div class="form-group group-default col-12 col-md-4">
                        <div class="col-12">
                          <label for="txtValorCOFINS2">Valor:</label>
                          <div class="relative">
                            <input type="text" value="0.00" class="input-default form-control" id="txtValorCOFINS2">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="tab-pane fade" id="divValidaEstoque" role="tabpanel" aria-labelledby="tabValidaEstoque">
              <div class="col-12 col-sm-12 col-md-12">
                <div class="col-12 text-left p-0 mt-3 mb-2">
                  <div class="row">
                    <div class="form-group group-default col-6">
                      <label for="DtFabricacao">Data Fabricação:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" class="input-default form-control" id="DtFabricacao">
                      </div>
                    </div>
                    <div class="form-group group-default col-6">
                      <label for="txtDtValidaEstoque">Data Validade:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" class="input-default form-control" id="txtDtValidaEstoque">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <div class="col-sm-12">
                  <button id="btnGravaEdicao" class="btn btn-danger"> Confirmar </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalVincularProdutos" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalVincularProduto-titulo" class="modal-title">Importação de XML   
            <input type="checkbox" id="buscarTribXml">
            <label for="buscarTribXml" title="Irá respeitar os dados que estão no xml, não considerando operação" style="font-size:60%">
              Buscar Impostos da Nota
            </label>
            <button id="btnCadastrarItens" class="btn btn-danger" style="margin-left: 12px;"> Cadastrar itens novos </button>

            <button type="button" class="btn btn-icon-normal btn-danger divRFID d-none" style="border-radius: 4px!important; text-align: center; margin-left: 1px;" id="btn-iniciar-epc" name="btn-iniciar-epc" data-button="absolute" title="Iniciar RFID, Atalho (Alt + 1)">
              <i class="fas fa-play"></i>
            </button>
            <button type="button" class="btn btn-icon-normal btn-danger divRFID d-none" style="border-radius: 4px!important;" id="btn-parar-epc" name="btn-parar-epc" data-button="absolute" title="Parar RFID, Atalho (Alt + 2)">
              <i class="fas fa-pause"></i>
            </button>

          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <nav>
          <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
            <a class="nav-link abaLink active" id="tabFor" data-toggle="tab" href="#divFornecedor" role="tab" aria-controls="divFornecedor" aria-selected="true">Fornecedor</a>
            <a class="nav-link abaLink" id="tabVincProd" data-toggle="tab" href="#divProdutos" role="tab" aria-controls="divProdutos" aria-selected="false">Vincular Produtos</a>
          </div>
        </nav>

        <div class="tab-content" id="nav-tabContent">
          <div class="tab-pane fade show active" id="divFornecedor" role="tabpanel" aria-labelledby="tabFiscal">
            <div class="col-12">
              <div class="row">
                <div class="col-12 p-3 mt-4 mb-3" style="margin-left: 12%">
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtNomeEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtCnpjEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtIeEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtCrtEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtCepEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                  <div class="form-group group-default col-6 col-md-6">
                    <div class="relative">
                      <span id="txtCidadeEmpresa" class="modal-title"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="divProdutos" role="tabpanel" aria-labelledby="tabICMS">
            <div class="tab-content" id="nav-tabContent">
              <div class="tab-pane fade show active" id="divFiscal" role="tabpanel" aria-labelledby="tabFiscal">
                <div class="col-12">
                  <div class="row">
                    <div class="col-12 text-left p-0 mt-3 mb-2">
                      <table id="tabelaVincular" style="width: 100%; padding-left: 2%; padding-right: 2%" class="display">
                        <thead class="d-none">
                          <tr>
                            <th>LinhaAtual</th>
                            <th>Produto Sisplan</th>
                            <th>Produto XML</th>
                          </tr>
                        </thead>
                        <tbody>

                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button id="btnGravaProdutosModal" class="btn btn-danger"> Confirmar </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-importar-nota" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Importar Nota</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-lg-8 col-sm-8 form-group">
              <label data-error="wrong" data-success="right" for="txtEmpresa">Empresa *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtEmpresa" name="txtEmpresa" class="form-control" placeholder="Empresa">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnEmpresa" name="btnEmpresa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnAEmpresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-lg-4 col-sm-4 form-group" style="margin-top: 37px">
              <input type="checkbox" id="buscarTribNota">
              <label for="buscarTribNota">
                Buscar Impostos da Nota
              </label>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtNumeroNota">Nota / Série *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtNumeroNota" disabled name="txtNumeroNota" class="form-control" placeholder="Nota / Série">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnNumeroNota" name="btnNumeroNota" disabled data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnANumeroNota" disabled type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-6 col-sm-6 form-group">
              <label data-error="wrong" data-success="right" for="txtNaturezaImp">Natureza</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtNaturezaImp" name="txtNaturezaImp" class="form-control" placeholder="Natureza">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnNaturezaImp" name="btnNaturezaImp" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnANaturezaImp" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-lg-6 col-sm-6 form-group" id="NaturezaServInfoTour">
              <label data-error="wrong" data-success="right" for="txtOperacaoImp">Operação</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtOperacaoImp" name="txtOperacaoImp" class="form-control" placeholder="Operação">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-OperacaoImp" name="btn-OperacaoImp" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-OperacaoImp" name="btn-limpa-OperacaoImp" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btn-confirmar-nota" class="btn btn-danger"> Importar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalCadastrarItens" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" style="max-width: 98%; height: 95%;" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Cadastrar Itens</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <nav>
            <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
              <a class="nav-link abaLink active" id="tabItens" data-toggle="tab" href="#divItens" role="tab" aria-controls="divItens" aria-selected="true">Itens</a>
              <a class="nav-link abaLink" id="tabMaterial" data-toggle="tab" href="#divMaterial" role="tab" aria-controls="divMaterial" aria-selected="false">Material</a>
            </div>
          </nav>

          <div class="tab-content" id="nav-tabContent">

            <div class="tab-pane fade show active" id="divItens" role="tabpanel">
              <div class="col-sm-12 table-responsive card-body" style="margin-top: 1%;" id="tabelatuto">
                <label for="tabelaItensNovos">Lista Itens Novos</label>
                <table id="tabelaItensNovos" class="table table-sm table-select table-hover" style="width: 100%" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>

            <div class="tab-pane fade" id="divMaterial" role="tabpanel">
              <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade show active" role="tabpanel">
                  <div class="col-12">
                    <div class="row">

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtGrupoMaterial">Grupo *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtGrupoMaterial" name="txtGrupoMaterial" placeholder="Grupo">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupoMaterial" name="btnGrupoMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupoMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtSubGrupoMaterial">Sub. Grupo *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtSubGrupoMaterial" name="txtSubGrupoMaterial" placeholder="Sub. Grupo">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnSubGrupoMaterial" name="btnSubGrupoMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaSubGrupoMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtUnidadeMaterial">Unidade</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtUnidadeMaterial" name="txtUnidadeMaterial" placeholder="Unidade">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnUnidadeMaterial" name="btnUnidadeMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaUnidadeMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtUnidadeCompraMaterial">Unidade Compra</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtUnidadeCompraMaterial" name="txtUnidadeCompraMaterial" placeholder="Unidade Compra">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnUnidadeCompraMaterial" name="btnUnidadeCompraMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaUnidadeCompraMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtCSTICMSEntradaMaterial">CST ICMS Entrada *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCSTICMSEntradaMaterial" name="txtCSTICMSEntradaMaterial" placeholder="CST ICMS Entrada">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCSTICMSEntradaMaterial" name="btnCSTICMSEntradaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCSTICMSEntradaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtCSTICMSSaidaMaterial">CST ICMS Saída *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCSTICMSSaidaMaterial" name="txtCSTICMSSaidaMaterial" placeholder="CST ICMS Saída">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCSTICMSSaidaMaterial" name="btnCSTICMSSaidaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCSTICMSSaidaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtCSTIPIEntradaMaterial">CST IPI Entrada *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCSTIPIEntradaMaterial" name="txtCSTIPIEntradaMaterial" placeholder="CST IPI Entrada">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIPIEntradaMaterial" name="btnIPIEntradaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIPIEntradaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtCSTIPISaidaMaterial">CST IPI Saída *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCSTIPISaidaMaterial" name="txtCSTIPISaidaMaterial" placeholder="CST IPI Saída">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIPISaidaMaterial" name="btnIPISaidaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIPISaidaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-2" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtPercentualICMSMaterial">% ICMS</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtPercentualICMSMaterial" name="txtPercentualICMSMaterial" placeholder="% ICMS">
                        </div>
                      </div>

                      <div class="col-lg-2" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtPercentualIPIMaterial">% IPI</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtPercentualIPIMaterial" name="txtPercentualIPIMaterial" placeholder="% IPI">
                        </div>
                      </div>

                      <div class="col-lg-4" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtCodigoSpedMaterial">Cógido Sped *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCodigoSpedMaterial" name="txtCodigoSpedMaterial" placeholder="Cógido Sped">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCodigoSpedMaterial" name="btnCodigoSpedMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCodigoSpedMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4" style="margin-top: 1%;">
                        <label data-error="wrong" data-success="right" for="txtNaturezaMaterial">Natureza *</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtNaturezaMaterial" name="txtNaturezaMaterial" placeholder="Natureza">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNaturezaMaterial" name="btnNaturezaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNaturezaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-6" style="margin-top: 1%;">
                        <label>Tributação *</label>
                        <select id="rgTributacaoMaterial" class="input-default focus custom-select">
                          <option value="" selected>Selecione uma opção</option>
                          <option value="N">Normal</option>
                          <option value="D">Diferenciada</option>
                          <option value="1">1 - Produto Importado</option>
                          <option value="2">2 - Produto Importado Mercado Interno</option>
                          <option value="3">3 - Conteúdo de importação maior 40% e inferior ou igual 70%</option>
                          <option value="4">4 - Conformidade Processos básicos</option>
                          <option value="5">5 - Conteúdo de importação menor ou igual 40%</option>
                          <option value="6">6 - Prod. Importdado sem similar nacional</option>
                          <option value="7">7 - Adquirido merc. interno sem similar nacional</option>
                          <option value="8">8 - Conteúdo de importação superior 70%</option>
                        </select>
                      </div>

                      <div class="col-lg-6" style="margin-top: 1%;">
                        <label>Posse *</label>
                        <select id="rgPosseMaterial" class="input-default focus custom-select">
                          <option value="" selected>Não Informado</option>
                          <option value="0">0 - Mercadoria de propriedade do informante e em seu poder</option>
                          <option value="1">1 - Mercadoria de propriedade do informante em poder de terceiros</option>
                          <option value="2">2 - Mercadoria de propriedade de terceiros em poder do informante</option>
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-primary btn-sisp" id="btnCadastrar"> Cadastrar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalAdicionarVendaRegra" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modalContas-titulo" class="modal-title">Adicionar tipo de venda/regra</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-sm-12">
                <div class="row">
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTipoVenda">Tipo de venda</label>
                    <div class="input-group">
                      <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtTipoVenda" required aria-describedby="tipoError" class="custom-select focus">
                        <option disabled selected value=""></option>
                        <option value="0">0 - Produção</option>
                        <option value="1">1 - Revenda</option>
                      </select>
                      <!-- <input type="text" maxlength="1" class="input-default focus form-control" id="txtTipoVenda" name="txtTipoVenda" class="form-control" placeholder="Tipo de venda"> -->
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtEmpresaRegra">Empresa</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtEmpresaRegra" name="txtEmpresaRegra" class="form-control" placeholder="Empresa">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnEmpresaRegra" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnAEmpresaRegra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtRegra">Regra</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtRegra" name="txtRegra" class="form-control" placeholder="Regra">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnRegra" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnARegra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-12 col-12 form-group" style="margin-top: 12px;">
                    <label data-error="wrong" class="labelGeral" data-success="right" for="selectTrib">Tributação</label>
                    <div class="input-group">
                      <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectTrib" class="custom-select focus">
                        <option value="">Não informado</option>
                        <option value="N">Normal</option>
                        <option value="D">Diferenciada</option>
                        <option value="1">01-Produto Importado</option>
                        <option value="2">02-Produto Importado Mercado Interno</option>
                        <option value="3">03-Conteúdo de importação maior 40% e inferior ou igual 70%
                        </option>
                        <option value="4">04-Conformidade Processos básicos</option>
                        <option value="5">05-Conteúdo de importação menor ou igual 40%</option>
                        <option value="6">06-Prod. Importdado sem similar nacional</option>
                        <option value="7">07-Adquirido merc. interno sem similar nacional</option>
                        <option value="8">08-Conteúdo de importação superior 70%</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-12  col-12 form-group">
                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtSped">Código
                      SPED *</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtSped" name="txtSped" required aria-describedby="spedError" class="form-control" placeholder="Código SPED">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnSped" name="btnSped" data-button="absolute" type="button">
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button class="btn bg-danger" id="btnASped" type="button">
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12" style="margin-top:5px">
                    <button id="btnAdicionarTipoRegra" type="button" class="btn btn-primary btn-block mt-4">
                      Adicionar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  <div class="modal fade" id="modalImportarCte" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Importar CT-e</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <nav>
            <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
              <a class="nav-link abaLink active" id="tabGeralCte" data-toggle="tab" href="#divTabGeralCte" role="tab" aria-controls="divTabGeralCte" aria-selected="true">Geral</a>
              <a class="nav-link abaLink" id="tabItensCte" data-toggle="tab" href="#divTabItensCte" role="tab" aria-controls="tabItensCte" aria-selected="false">Itens</a>
            </div>
          </nav>
          <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="divTabGeralCte" role="tabpanel">
              <div class="form-row col-xl-12 col-12 pt-3 pr-0">
                <div class="form-group col-xl-6 col-6">
                  <label data-error="wrong" data-success="right" for="txtChaveCte">Chave CT-e:</label>
                  <input type="text" class="input-default focus form-control" id="txtChaveCte" name="txtChaveCte" placeholder="Chave">
                </div>
                <div class="form-group col-xl-2 col-6 d-none">
                  <label data-error="wrong" data-success="right" for="txtSugerirNaturezaCte">Sugerir Natureza:</label>
                  <input type="text" class="input-default focus form-control" id="txtSugerirNaturezaCte" name="txtSugerirNaturezaCte" placeholder="Natureza">
                </div>
                <div class="form-group col-xl-4 col-6 d-none">
                  <label data-error="wrong" data-success="right" for="txtNaturezaFreteCte">Natureza Frete:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNaturezaFreteCte" name="txtNaturezaFreteCte" placeholder="Natureza">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNaturezaFreteCte" name="btnNaturezaFreteCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNaturezaFreteCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-6">
                  <label data-error="wrong" data-success="right" for="selectTipoCte">Tipo CT-e:</label>
                  <select class="drilldown-item form-control focus input-default" id="selectTipoCte" data-dropdown-css-class="select2-danger">
                    <option class="drilldown-item" value="0">CT-e normal</option>
                    <option class="drilldown-item" value="1">CT-e de complemento de valores</option>
                    <option class="drilldown-item" value="2">CT-e emitido em hipótese de anulação de débito</option>
                    <option class="drilldown-item" value="3">CT-e substituto do CT-e anulado</option>
                  </select>
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" data-success="right" for="txtOperacaoCte">Operação Fiscal:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtOperacaoCte" name="txtOperacaoCte" placeholder="Operacao Gerencial">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOperacaoCte" name="btnOperacaoCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaOperacaoCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" data-success="right" for="txtClasseCte">Classe Gerencial:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control campoClasseCte" id="txtClasseCte" name="txtClasseCte" placeholder="Classe Gerencial">
                    <div class="input-group-append">
                      <button class="btn bg-danger campoClasseCte" id="btnClasseCte" name="btnClasseCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger campoClasseCte" id="btnLimpaClasseCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" data-success="right" for="txtHistoricoCte">Histórico:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control campoHistoricoCte" id="txtHistoricoCte" name="txtHistoricoCte" placeholder="Histórico">
                    <div class="input-group-append">
                      <button class="btn bg-danger campoHistoricoCte" id="btnHistoricoCte" name="btnHistoricoCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger campoHistoricoCte" id="btnLimpaHistoricoCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" data-success="right" for="txtBancoCte">Banco:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control campoBancoCte" id="txtBancoCte" name="txtBancoCte" placeholder="Banco">
                    <div class="input-group-append">
                      <button class="btn bg-danger campoBancoCte" id="btnBancoCte" name="btnBancoCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger campoBancoCte" id="btnLimpaBancoCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" data-success="right" for="txtSituacaoCte">Situação:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control campoSituacaoCte" id="txtSituacaoCte" name="txtSituacaoCte" placeholder="Situação">
                    <div class="input-group-append">
                      <button class="btn bg-danger campoSituacaoCte" id="btnSituacaoCte" name="btnSituacaoCte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger campoSituacaoCte" id="btnLimpaSituacaoCte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <input type="text" class="input-default focus form-control d-none" id="txtNumeroCte" name="txtNumeroCte">
                <input type="text" class="input-default focus form-control d-none" id="txtModeloCte" name="txtModeloCte">
                <input type="text" class="input-default focus form-control d-none" id="txtSerieCte" name="txtSerieCte">
                <input type="text" class="input-default focus form-control d-none" id="txtUFIniCte" name="txtUFIniCte">
                <input type="text" class="input-default focus form-control d-none" id="txtCidadeIniCte" name="txtCidadeIniCte">
                <input type="text" class="input-default focus form-control d-none" id="txtUFFimCte" name="txtUFFimCte">
                <input type="text" class="input-default focus form-control d-none" id="txtCidadeFimCte" name="txtCidadeFimCte">
                <input type="text" class="input-default focus form-control d-none" id="txtCNPJCte" name="txtCNPJCte">
                <input type="text" class="input-default focus form-control d-none" id="txtClienteCte" name="txtClienteCte">
                <input type="date" class="input-default focus form-control d-none" id="txtEmissaoCte" name="txtEmissaoCte">
                <input type="text" class="input-default focus form-control d-none" id="txtValorCte" name="txtValorCte">
                <input type="text" class="input-default focus form-control d-none" id="txtPedagioCte" name="txtPedagioCte">
                <input type="text" class="input-default focus form-control d-none" id="txtBaseIcmsCte" name="txtBaseIcmsCte">
                <input type="text" class="input-default focus form-control d-none" id="txtValorIcmsCte" name="txtValorIcmsCte">
                <input type="text" class="input-default focus form-control d-none" id="txtPercIcmsCte" name="txtPercIcmsCte">
                <input type="text" class="input-default focus form-control d-none" id="txtTipoFreteCte" name="txtTipoFreteCte">
                <table id="tabelaNotasReferenciadasCte" class="table table-sm table-select table-hover d-none" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
                <table id="tabelaDuplicatasCte" class="table table-sm table-select table-hover d-none" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
            <div class="tab-pane fade" id="divTabItensCte" role="tabpanel">
              <div class="form-row col-12">
                <div class="col-12 table-responsive">
                  <table id="tabelaItensCte" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button id="btnConfirmarCte" class="btn btn-sisp btn-danger"> Confirmar </button>
        </div>
      </div>
    </div>
  </div>

  <input type="text" required class="input-default focus form-control validate  d-none" id="txtEmpId" name="txtEmpId">
  <input type="text" required class="input-default focus form-control validate  d-none" id="txtEmpPathXml" name="txtEmpPathXml">

  </div><!-- /.wrapper -->

  <?php include_once('../../modais.php'); ?>

  <script src="../plugins/jquery/jquery.min.js?versao=3.255.29.2"></script>

  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.255.29.2"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.255.29.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.29.2"></script>
  <script src="../dist/js/sisplan.js?versao=3.255.29.2"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.255.29.2"></script>
  <script src="../utils/funcoes.js?versao=3.255.29.2"></script>
  <script src="../dist/js/xml2json.js?versao=3.255.29.2"></script>
  <script src="../pages/compras/js/entradanf.js?versao=3.255.29.2"></script>
  <script src="../pages/compras/js/financeiro.js?versao=3.255.29.2"></script>
  <script src="../pages/compras/js/itens.js?versao=3.255.29.2"></script>
  <script src="../utils/cookies.js?versao=3.255.29.2"></script>
  <script src="../dist/js/requisicoes.js?versao=3.255.29.2"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.255.29.2"></script>
  <script src="../dist/js/driver.min.js?versao=3.255.29.2"></script>
  <script src="../dist/js/datetime.js?versao=3.255.29.2"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.255.29.2"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.255.29.2"></script>
  <script src="../plugins/moment/moment.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="../dist/js/sum().js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="../config.js?versao=3.255.29.2"></script>
  <script type="text/javascript">
    $(document).ready(async function() {


      $('#dadosGeraisMenu').addClass('submenuAtivo');

      if (getCookie('usuario') == "") {
        window.location.href = "../login";
        return;
      }

      $('#btnInicio').on('click', function() {
        window.location.href = '../entrada_nf';
      });

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');
      $('#txtEmpId').val(getCookie('emp_id'));


      const temAcesso = await temAcessoTela('ENTRADA_NF');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("ENTRADA_NF");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/entrada_nf`
        });
        return;
      }

      $('#txttpMovimentacao').val('[5] - ENTRADA DE NOTA FISCAL');

      // $('#txtLancamento').val(lancamento);

      await insereJavaScriptTraducoes()

    });
  </script>
</body>

</html>