$('#txtClasseBaixaSafra').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaSafra').pesquisa('#txtClasseBaixaSafra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseBaixaSafra').on('click', function () {
  $('#txtClasseBaixaSafra').val('');
});

$('#txtClasseTaxaSafra').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseTaxaSafra').pesquisa('#txtClasseTaxaSafra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseTaxaSafra').on('click', function () {
  $('#txtClasseTaxaSafra').val('');
});

$('#txtClasseAntecSafra').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseAntecSafra').pesquisa('#txtClasseAntecSafra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseAntecSafra').on('click', function () {
  $('#txtClasseAntecSafra').val('');
});

$('#txtHistoricoSafra').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoSafra').pesquisa_serverside(['#txtHistoricoSafra'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaHistoricoSafra').on('click', function () {
  $('#txtHistoricoSafra').val('');
});

async function validaConfirmacaoSafra() {
  if (!$('#rgPrevisaoSafra').is(':checked')) {
    if (!$('#txtClasseBaixaSafra').val() || !await Existe('CLASSE_GER', ['CODIGO'], [pegaChave('#txtClasseBaixaSafra')])) {
      throw msgAlerta('Classe/Baixa não informado ou inválido!');
    }
    if (!$('#txtHistoricoSafra').val() || !await Existe('HISTCP', ['HISTORICO'], [pegaChave('#txtHistoricoSafra')])) {
      throw msgAlerta('Histórico não informado ou inválido!');
    }
  }
}

$('#btnConfirmarSafra').on('click', async function () {
  const Safra = await buscaDadosTabelaSafra();
  const SafraResumido = await buscaDadosTabelaSafraResumido();
  const params = await coletaDadosInputsSafra();

  await validaConfirmacaoSafra();

  const body = {
    Safra: Safra,
    SafraResumido: SafraResumido
  }

  const response = await requisicao('POST', `/sisplan/escretorno/V1/confirmasafra?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

  if (!response) {
    return;
  }
});

$('[name="chkSugestao"]').on('change', function () {
  if ($('#rgPrevisaoSafra').is(':checked')) {
    $('#divTabelaSafraResumo').addClass('d-none');
    $('#txtClasseBaixaSafra', '#btnClasseBaixaSafra', '#btnLimpaClasseBaixaSafra').attr('readonly', true)
    $('#txtClasseTaxaSafra').attr('readonly', true)
    $('#txtClasseAntecSafra').attr('readonly', true)
    $('#txtHistoricoSafra').attr('readonly', true)
  } else {
    $('#divTabelaSafraResumo').removeClass('d-none');
    $('#txtClasseBaixaSafra').attr('readonly', false)
    $('#txtClasseTaxaSafra').attr('readonly', false)
    $('#txtClasseAntecSafra').attr('readonly', false)
    $('#txtHistoricoSafra').attr('readonly', false)
  }
});

async function buscaDadosTabelaSafraResumido() {
  const tabelaSafra = $('#tabelaSafraResumo').DataTable().rows().data().toArray();
  const objeto = tabelaSafra.map((dados) => ({
    dataPagamento: dados.dataPagamento,
    banco: dados.banco,
    tipoLancamento: dados.tipoLancamento,
    codConta: dados.codConta,
    conta: dados.conta,
    bandeira: dados.bandeira,
    modalidade: dados.modalidade,
    valor: dados.valor,
  }))
  return objeto;
};




async function buscaDadosTabelaSafra() {
  const tabelaSafra = $('#tabelaSafra').DataTable().rows().data().toArray();
  const objeto = tabelaSafra.map((dados) => ({
    sel: dados.sel = true ? 'S' : 'N',
    numero: dados.numero,
    codCli: dados.codCli,
    nome: dados.nome,
    fatura: dados.fatura,
    dataEmissao: dados.dataEmissao,
    dataVencimento: dados.dataVencimento,
    dataPagamento: dados.dataPagamento,
    nsu: dados.nsu,
    numeroTerminal: dados.numeroTerminal,
    parcela: dados.parcela,
    valor: dados.valor,
    valorPago: dados.valorPago,
    valorTarifa: dados.valorTarifa,
    valorLiquido: dados.valorLiquido,
    difMaior: dados.difMaior,
    difMenor: dados.difMenor,
    bandeira: dados.bandeira,
    saldo: dados.saldo,
    banco: dados.banco,
    agencia: dados.agencia,
    conta: dados.conta,
    modalidade: dados.modalidade,
    tipoRecto: dados.tipoRecto,
    tipoLancamento: dados.tipoLancamento,
    taxa: dados.taxa,
    taxaRec: dados.taxaRec,
  }))
  return objeto;
};

async function coletaDadosInputsSafra() {
  let tipoLancamento = 0;

  if ($('#rgPrevisaoSafra').is(':checked')) {
    tipoLancamento = 0;
  }
  if ($('#rgLiquidacaoNormalSafra').is(':checked')) {
    tipoLancamento = 1;
  }
  if ($('#rgLiquidacaoAntecipadaSafra').is(':checked')) {
    tipoLancamento = 2;
  }
  if ($('#rgLiquidadaAmortizacaoSafra').is(':checked')) {
    tipoLancamento = 3;
  }

  objeto = {
    nomeArquivo: $('#txtNomeArquivoSafra').val(),
    classeBaixa: pegaChave('#txtClasseBaixaSafra'),
    classeTaxa: pegaChave('#txtClasseTaxaSafra'),
    classeAntec: pegaChave('#txtClasseAntecSafra'),
    historico: pegaChave('#txtHistoricoSafra'),
    tipoLancamento: tipoLancamento,
  }
  return objeto;
}

$('#btnVerBaixasSafra').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasSafra();
});

async function preencheSafraResumido(json) {
  if (!$.fn.DataTable.isDataTable("#tabelaSafraResumo")) {
    $('#tabelaSafraResumo').DataTable({
      paging: false,
      filter: false,
      info: false,
      length: false,
      order: false,
      scrollX: '150px',
      columns: dataSetColsSafraResumido,
      columnDefs: [{
        targets: [0],
        render: function (data, type, row) {
          if (type === 'display' || type === 'filter') {
            var date = new Date(data);
            var dia = date.getDate();
            var mes = date.getMonth() + 1;
            var ano = date.getFullYear();
            if (dia < 10) {
              dia = '0' + dia;
            }
            if (mes < 10) {
              mes = '0' + mes;
            }
            return dia + '/' + mes + '/' + ano;
          } else {
            return data;
          }
        },
      },
      {
        "targets": 11,
        "render": function (data, type, row, meta) {
          if (type === 'display' || type === 'filter') {
            return parseFloat(data).toFixed(2);
          }
          return data;
        }
      }]
    });
  }

  adicionaTabelaResumo({
    dataPagamento: json.dataPagamento,
    tipoLancamento: json.tipoLancamento,
    banco: json.banco,
    descricaoBanco: json.descricaoBanco,
    codConta: json.codConta,
    conta: json.conta,
    descricaoConta: json.descricaoConta,
    bandeira: json.bandeira,
    descricaoBandeira: json.descricaoBandeira,
    modalidade: json.modalidade,
    descricaoModalidade: json.descricaoModalidade,
    valor: json.valor
  });
}

function adicionaTabelaResumo(item) {
  let tabela = $('#tabelaSafraResumo').DataTable();
  let rows = tabela.rows().data().toArray();

  let itemExistente = rows.find(function (row) {
    return (
      row.dataPagamento === item.dataPagamento &&
      row.tipoLancamento === item.tipoLancamento &&
      row.banco === item.banco &&
      row.codConta === item.codConta &&
      row.bandeira === item.bandeira &&
      row.modalidade === item.modalidade
    );
  });

  if (itemExistente) {
    itemExistente.valor += item.valor;
    tabela.row(rows.indexOf(itemExistente)).data(itemExistente).draw(false);
  } else {
    tabela.row.add(item).draw(false);
  }
}

async function verBaixasSafra() {
  $('#squareDesdAgrup').addClass('d-none');
  $.LoadingOverlay('show');
  try {
    if ($.fn.DataTable.isDataTable("#tabelaSerasa")) {
      $("#tabelaSerasa").DataTable().destroy();
      $("#tabelaSerasa").empty();
    }
    if ($.fn.DataTable.isDataTable("#tabelaSafraResumo")) {
      $("#tabelaSafraResumo").DataTable().destroy();
      $("#tabelaSafraResumo").empty();
    }

    let dados = (($('#conteudoFormatado').text()).replaceAll(',', '')).split('\n');
    if (dados.length == 0) {
      throw msgErro('Arquivo sem movimento, impossível continuar.');
    }
    let params = await coletaDadosInputsSafra()

    const body = {
      dados: dados
    }

    let response = await requisicao('POST', '/sisplan/escretorno/V1/buscabaixassafra?', `TIPO_LANCAMENTO=${params.tipoLancamento}`, JSON.stringify(body), 500000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    dataSetColsSafra[0].render = function (data, type, row, meta) {
      let checked = true;
      let bloqueia = false;

      if (row.sel == 'S' && row.deixaSel == 'N') {
        checked = false;
        bloqueia = true;
      }
      if (row.sel = 'S' && row.naoSeleciona == 'N') {
        checked = false;
        bloqueia = true;
      }
      let disabledAttribute = bloqueia ? 'disabled' : '';
      return `<div class="icheck-danger d-inline">
                  <input type="checkbox" ${disabledAttribute} ${checked ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
              </div>`
    }

    let filter = jsonStr.filter(function (data) {
      return data.tipoLancamento == params.tipoLancamento;
    });

    $('#tabelaSafra').DataTable({
      paging: false,
      filter: false,
      info: false,
      length: false,
      order: false,
      destroy: true,
      data: filter,
      columns: dataSetColsSafra,
      columnDefs: [{
        targets: [5, 6, 7],
        render: function (data, type, row) {
          if (type === 'display' || type === 'filter') {
            var date = new Date(data);
            var dia = date.getDate();
            var mes = date.getMonth() + 1;
            var ano = date.getFullYear();
            if (dia < 10) {
              dia = '0' + dia;
            }
            if (mes < 10) {
              mes = '0' + mes;
            }
            return dia + '/' + mes + '/' + ano;
          } else {
            return data;
          }
        },
      }],
      rowCallback: async function (row, data) {
        await preencheSafraResumido(data.safraResumido)
        if (data.tipoDuplicata == 'AGRU' || data.tipoDuplicata == 'DESD') {
          $(row).css('background-color', '#f7a156');
          $(row).css('color', '#2c2f28');
          if ($('#squareDesdAgrup').hasClass('d-none')) {
            $('#squareDesdAgrup').removeClass('d-none');
          }
        }
        else if ((data.taxa > 0) && ((((data.modalidade == 'CRAV') || (data.modalidade == 'DBAV')) && (!(data.previsao == '')) && (data.taxa != data.taxaRec)) || ((!(data.modalidade == 'CRAV') && !(data.modalidade == 'DBAV')) && (data.taxaRec > 0) && (data.taxa != data.taxaRec)))) {
          $(row).css('background-color', '#fdfd96');
          $(row).css('color', '#2c2f28');
        } else if (data.numero !== '' && data.saldo === 0) {
          $(row).css('background-color', 'seagreen');
          $(row).css('color', '#ecfdff');
        }
      },
    });

    $('.remover-linha').remove();
    $('.campoSel').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });

  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }
}
