$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a consulta.',
                position: 'bottom'
            }
        },
        {
            element: '#txtNumeroAP',
            popover: {
                title: 'Campo Obrigatório',
                description: 'Esse é um campo obrigatório, preencha com um número da AP que deseja estornar.',
                position: 'top'
            }
        },
        {
            element: '#btnConsultar',
            popover: {
                title: 'Botão Consulta',
                description: 'Clique aqui para realizar a consulta.',
                position: 'left'
            }
        },
        {
            element: '#btnReabrirPgto',
            popover: {
                title: 'Botão Reabrir Pagamento',
                description: 'Clique aqui para reabrir o pagamento.',
                position: 'right'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    //Pesquisas

    $('#txtPeriodoDe').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoDe').pesquisa(
        '#txtPeriodoDe',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoDe').on('click', function () {
        $('#txtPeriodoDe').val('');
    });

    $('#txtPeriodoAte').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoAte').pesquisa(
        '#txtPeriodoAte',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoAte').on('click', function () {
        $('#txtPeriodoAte').val('');
    });

    $('#txtTipo').autocompleta(
        1,
        `JSON={ 
            "tabela":"TIPO", 
            "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnTipo').pesquisa(
        '#txtTipo',
        'ID',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO", "camposSelect":["ID", "DESCRICAO", "AREA"], "where": null}',
        'Pesquisa de Tipo',
        'TIPO'
    );

    $('#btnLimpaTipo').on('click', function () {
        $('#txtTipo').val('');
    });


    $('#txtPedido').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null}
            `,
        "NUMERO",
        "NOME");

    $("#btnPedido").pesquisa_serversideSel(
        "#txtPedido",
        `{
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME", "PEDIDO.CODCLI", "PEDIDO.DT_FATURA", "PEDIDO.DT_EMISSAO", "PEDIDO.COLECAO", "PEDIDO.DT_SAIDA", "PEDIDO.ENTREGA",  "PEDIDO.TIPO"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null
        }`,
        "Pesquisa de Pedido");

    $('#btnLimpaPedido').on('click', function () {
        $('#txtPedido').empty().trigger('change');
    });

    $('#txtSetor').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO"], 
            "where": null}
            `,
        "CODIGO",
        "DESCRICAO");

    $("#btnSetor").pesquisa_serversideSel(
        "#txtSetor",
        `{
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO", "ORDEM", "CUSTO"], 
            "where": null
        }`,
        "Pesquisa de Setor");

    $('#btnLimpaSetor').on('click', function () {
        $('#txtSetor').empty().trigger('change');
    });

    $('#txtFaccao').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME"], 
            "where": null}
            `,
        "CODCLI",
        "NOME");

    $("#btnFaccao").pesquisa_serversideSel(
        "#txtFaccao",
        `{
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME", "CNPJ", "FANTASIA"], 
            "where": null
        }`,
        "Pesquisa de Facção");

    $('#btnLimpaFaccao').on('click', function () {
        $('#txtFaccao').empty().trigger('change');
    });

    $('#txtOF').pesquisa_variosServerside(
        2,
        `{ 
            "tabela":"FACCAO", 
            "camposSelect":["FACCAO.NUMERO", "ENTIDADE.NOME"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = FACCAO.CODCLI"}],
            "where": null}
            `,
        "NUMERO",
        "NOME");

    $("#btnOF").pesquisa_serversideSel(
        "#txtOF",
        `{
            "tabela":"FACCAO", 
            "camposSelect":["FACCAO.NUMERO", "ENTIDADE.NOME", "FACCAO.CODCLI", "FACCAO.PEDIDO", "FACCAO.DT_S", "FACCAO.TAM", "FACCAO.IDENTIFICADOR", "FACCAO.OP", "FACCAO.QUANT"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = FACCAO.CODCLI"}],
            "where": null
        }`,
        "Pesquisa de OF");

    $('#btnLimpaOF').on('click', function () {
        $('#txtOF').empty().trigger('change');
    });

    async function consultaEstornoFaccao() {
        // event.preventDefault();
        if (!$('#txtNumeroAP').val()) {
            msgAlerta('Insira o número de AP para consulta.');
            return
        }

        $.LoadingOverlay("show");

        if ($.fn.DataTable.isDataTable('#tabelaEstorno')) {
            $("#tabelaEstorno").DataTable().destroy();
            $("#tabelaEstorno").empty();
        }

        try {
            const params = await buscaDadosCampos();
            const response = await requisicao('GET', `/sisplan/facpreco/v1/facestornopag?`, `JSON=${JSON.stringify(params)}`, '', 90000);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            if (jsonStr[1].length > 0 || jsonStr[0].length > 0) {
                let dataSetCols = [
                    { title: "Sel", data: "SEL", width: "15px" },
                    { title: "Lanc. Manual", data: "LANCTO_MANUAL" },
                    { title: "Fac. Cód. Cli.", data: "FAC_CODCLI" },
                    { title: "Fac. Data S.", data: "FAC_DT_S" },
                    { title: "Fac. Data Lanc.", data: "FAC_DT_LAN" },
                    { title: "Fac. Data Prev.", data: "FAC_DT_PREV" },
                    { title: "Fac. Número", data: "FAC_NUMERO" },
                    { title: "Fac. OP", data: "FAC_OP" },
                    { title: "Fac. Desc. Setor", data: "FAC_DESCSETOR" },
                    { title: "Fac. Preço", data: "FAC_PRECO" },
                    { title: "Fac. Qtde Orig.", data: "FAC_QT_ORIG" },
                    { title: "Fac. Obs.", data: "FAC_OBS" },
                    { title: "Fac. Ficha", data: "FAC_FICHA" },
                    { title: "Fac. Qtde", data: "FAC_QUANT" },
                    { title: "Fac. Qtde 2", data: "FAC_QUANT_2" },
                    { title: "Fac. Qtde I", data: "FAC_QUANT_I" },
                    { title: "Fac. Qtde F", data: "FAC_QUANT_F" },
                    { title: "Fac. Valor", data: "FAC_VALOR" },
                    { title: "Unitário", data: "UNITARIO" },
                    { title: "Fac. Lanc.", data: "FAC_LANCTO" },
                    { title: "Fac. Unitário", data: "FAC_UNITARIO" },
                    { title: "Fac. Nota", data: "FAC_NOTA" },
                    { title: "Pago", data: "PAGO" },
                    { title: "Fac. Código", data: "FAC_CODIGO" },
                    { title: "Cód. Coleção", data: "COD_COLECAO" },
                    { title: "Desc. Coleção", data: "DESC_COLECAO" },
                    { title: "Fac. Grupo", data: "FAC_GRUPO" },
                    { title: "Desc. Grupo", data: "DESC_GRUPO" },
                    { title: "Fac. Pedido", data: "FAC_PEDIDO" },
                    { title: "Fac. Tam.", data: "FAC_TAM" },
                    { title: "Fac. Cor", data: "FAC_COR" },
                    { title: "Fac. Parte", data: "FAC_PARTE" },
                    { title: "Núm. AP", data: "NUM_AP" },
                    { title: "Fac. Desc. Parte", data: "FAC_DESCPARTE" },
                    { title: "Cor Parte", data: "COR_PARTE" },
                    { title: "Desc. Cor Parte", data: "DESC_COR_PARTE" },
                    { title: "Fac. Estoque", data: "FAC_ESTOQUE" },
                    { title: "Prod. Desc.", data: "PRODUTO_DESCRICAO" },
                    { title: "Prod. Unidade", data: "PRODUTO_UNIDADE" },
                    { title: "Largura", data: "LARGURA" },
                    { title: "Estimativa Mês", data: "ESTIMATIVA_MES" },
                    { title: "Etiqueta", data: "ETIQUETA" },
                    { title: "Desc. Etiqueta", data: "DES_ETIQUETA" },
                    { title: "Cód. FIS", data: "CODFIS" },
                    { title: "Desc. FIS", data: "DESC_FIS" },
                    { title: "Produto Uniconv", data: "PRODUTO_UNICONV" },
                    { title: "Nome Cliente", data: "CLIENTE_NOME" },
                    { title: "DDD Fone", data: "DDD_FONE" },
                    { title: "Fone Cliente", data: "CLIENTE_FONE" },
                    { title: "Fone Compl.", data: "FONE_COMPL" },
                    { title: "Observação", data: "OBSERVACAO" },
                    { title: "Bonificação", data: "BONIFICACAO" },
                    { title: "Fac. Desc. Cor", data: "FAC_DESCCOR" },
                    { title: "Pagamento", data: "DT_PAGTO" },
                    { title: "Mov.", data: "MOV" },
                    { title: "Identificador", data: "IDENTIFICADOR" },
                    { title: "OF Cód. Cli.", data: "OF_CODCLI" },
                    { title: "OF Cli. Nome", data: "OF_CLINOME" },
                    { title: "OF Pedido", data: "OF_PEDIDO" },
                    { title: "Período", data: "PERIODO" },
                    { title: "Fac. ID Ant.", data: "FAC_ID_ANT" },
                    { title: "DI", data: "DI" },
                    { title: "DF", data: "DF" },
                    { title: "Setor", data: "SETOR" },
                    { title: "PCP Qtde Orig.", data: "PCP_QTDE_ORIG" },
                    { title: "Qtde Tot. PCP", data: "QTDE_TOT_PCP" },
                    { title: "Tempo", data: "TEMPO" },
                    { title: "Tempo Total", data: "TEMPO_TOTAL" },
                    { title: "Mov. Ant.", data: "MOV_ANT" },
                    { title: "Fac. Núm. Ref.", data: "FAC_NUMERO_REF" },
                    { title: "Fac. OP Ref.", data: "FAC_OP_REF" },
                    { title: "Fac. Mov. Ref.", data: "FAC_MOV_REF" },
                    { title: "Reprocesso", data: "REPROCESSO" },
                    { title: "Qtde Orig. Mov. Ant.", data: "QT_ORIG_MOV_ANT" },
                    { title: "Ped. Cli.", data: "PED_CLI" },
                    { title: "ABVTEX", data: "ABVTEX" },
                    { title: "Mov. Ligação", data: "MOV_LIGACAO" },
                    { title: "Entrega", data: "ENTREGA" },
                    { title: "Dt. Orig. Entrega", data: "DT_ORIG_ENTREGA" },
                    { title: "Endereço", data: "ENDERECO" },
                    { title: "Num. End.", data: "NUM_END" },
                    { title: "Bairro", data: "BAIRRO" },
                    { title: "CEP", data: "CEP" },
                    { title: "Complemento", data: "COMPLEMENTO" },
                    { title: "Cidade", data: "CIDADE" },
                    { title: "Cód. UF", data: "COD_UF" },
                    { title: "CNPJ", data: "CNPJ" },
                    { title: "Funcionário", data: "FUNCIONARIO" },
                    { title: "Nome Funcionário", data: "NOME_FUNCIONARIO" },
                    { title: "Máquina", data: "MAQUINA" },
                    { title: "Desc. Máquina", data: "DESC_MAQUINA" },
                    { title: "Turno", data: "TURNO" },
                    { title: "Marca", data: "MARCA" },
                    { title: "Desc. Marca", data: "DESC_MARCA" },
                    { title: "Mês Ano", data: "MES_ANO" },
                    { title: "Perc.", data: "PERC" },
                    { title: "Código 2", data: "CODIGO2" },
                    { title: "Protótipo", data: "PROTOTIPO" },
                    { title: "Tam. Posição", data: "TAM_POSICAO" },
                    { title: "Cubagem", data: "CUBAGEM" },
                    { title: "Qtde", data: "QUANT" },
                    { title: "Linha", data: "LINHA" },
                    { title: "Obs. OF", data: "OBS_OF" },
                    { title: "Desc. Linha", data: "DESC_LINHA" },
                    { title: "Tipo OF", data: "TIPO_OF" },
                    { title: "Lanc. Pag.", data: "LANCTO_PAGAR" },
                    { title: "Valor", data: "VALOR" },
                    { title: "Val. Pag.", data: "VAL_PAG" },
                    { title: "Saldo", data: "SALDO" }
                ];

                dataSetCols[0].render = function (data, type, row, meta) {
                    return '<div class="icheck-primary d-inline">' +
                        '<input type="checkbox" id="check_col_' + [meta.row] + '_row_' + [meta.col] + '" class="campoCheck"><label for="check_col_' + [meta.row] + '_row_' + [meta.col] + '"></label>' +
                        '</div>';
                }

                let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                if (colunasInvisiveis == null || colunasInvisiveis.acessoFacEstornoPag == undefined) {
                    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacEstornoPag: ['EMPRESA'] }));
                    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                }

                let tabelaEstorno = $('#tabelaEstorno').DataTable({
                    paging: true,
                    filter: false,
                    searching: true,
                    info: true,
                    colReorder: false,
                    destroy: true,
                    lengthChange: true,
                    scrollX: true,
                    scrollY: '310px',
                    lengthMenu: [10, 25, 50, 100],
                    pageLength: 10,
                    processing: true,
                    "data": jsonStr[1],
                    "columns": dataSetCols,
                    columnDefs: [{
                        targets: [3, 4, 5, 53, 77, 78, 94],
                        render(data) {
                            const dateObject = new Date(data);
                            const dia = dateObject.getDate().toString().padStart(2, '0');
                            const mes = (dateObject.getMonth() + 1).toString().padStart(2, '0');
                            const ano = dateObject.getFullYear();
                            const dataFormatada = `${dia}/${mes}/${ano}`;
                            return dataFormatada;
                        },
                    }]
                });

                $('#btnReabrirPgto').removeClass('d-none');

                $('#tabelaEstorno').on('click', '.campoCheck', function () {
                    let checkbox = $(this);
                    let rowIndex = tabelaEstorno.row(checkbox.closest('tr')).index();
                    let rowData = tabelaEstorno.row(rowIndex).data();

                    let currentPage = tabelaEstorno.page.info().page; // Armazena o número da página atual
                    let changeMade = false; // Marcador de mudança

                    for (let page = 0; page < tabelaEstorno.page.info().pages; page++) {
                        tabelaEstorno.page(page).draw('page'); // Vai para a página correspondente
                        tabelaEstorno.rows().every(function () { // Percorre todas as linhas da página atual
                            let currentRowData = this.data();
                            let currentRowIndex = this.index();

                            if (
                                currentRowData.LANCTO_PAGAR === rowData.LANCTO_PAGAR &&
                                currentRowData.FAC_NUMERO === rowData.FAC_NUMERO
                            ) {
                                $('#check_col_' + currentRowIndex + '_row_0').prop('checked', checkbox.prop('checked'));

                                // Adiciona/Remove a classe 'selected' apenas na linha clicada
                                this.nodes().to$().toggleClass('selected', checkbox.prop('checked'));

                                changeMade = true; // Mudança foi feita
                            }
                        });
                    }

                    if (changeMade) {
                        tabelaEstorno.page(currentPage).draw('page'); // Volta para a página original apenas se alguma mudança foi feita
                    }

                    tabelaEstorno.rows('.selected').data().length;
                });

                $('#modal-filtros').modal('hide');

                $('#tabelaEstorno_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaEstorno_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const dados = $("#tabelaEstorno").DataTable().data().toArray();
                    await exportaCSV("", "", undefined, null, 'Relatório da aba acesso estorno de pagamento de terceiros', '', '', 999, false, false, dados);
                });

                $('#tabelaEstorno').DataTable().columns().every(function () {
                    if ((colunasInvisiveis.acessoFacEstornoPag).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                });

            } else {
                msgErro('Sem dados na consulta');
                return
            }
        } catch (error) {
            console.error(error)
            msgErro('Não foi possível fazer a consulta. Erro: ' + $(error));
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaEstorno').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoFacEstornoPag ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacEstornoPag: novasColunas }));

            $('#tabelaEstorno').DataTable().columns().visible(true);

            $('#tabelaEstorno').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#btnConsultar').on('click', consultaEstornoFaccao);


    $('#btnReabrirPgto').on('click', async function () {
        estornoPagamento();
    })

    async function estornoPagamento() {
        let _url = `/Sisplan/facpreco/v1/facestornopag?`;
        let arrayLancamentos = [];
        let valoresSelecionados = {};

        try {
            $.LoadingOverlay("show");
            let tabelaEstornoInstance = $('#tabelaEstorno').DataTable();

            for (let page = 0; page < tabelaEstornoInstance.page.info().pages; page++) {   // Percorre todas as páginas do DataTable
                tabelaEstornoInstance.page(page).draw('page'); // Vai para a página correspondente

                tabelaEstornoInstance.rows().every(function () {  // Percorre todas as linhas da tabela na página atual
                    let currentRowData = this.data();
                    let rowIndex = this.index();

                    if ($('#check_col_' + rowIndex + '_row_0').prop('checked')) {
                        let identifier = currentRowData.LANCTO_PAGAR + '_' + currentRowData.FAC_NUMERO;  // Cria um identificador único para a linha
                        if (!valoresSelecionados[identifier]) { // Verifica se o identificador já foi adicionado

                            let Tabela = {
                                lancamentoPagar: currentRowData.LANCTO_PAGAR,
                                numeroFaccao: currentRowData.FAC_NUMERO,
                                numeroAp: $('#txtNumeroAP').val()
                            };
                            arrayLancamentos.push(Tabela);

                            valoresSelecionados[identifier] = true; // Marca o identificador como já adicionado para evitar duplicatas
                        }
                    }
                });
            }

            const body = {
                Tabela: arrayLancamentos
            }

            let response = await requisicao('POST', _url, '', JSON.stringify(body), 60000)

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(
                    'Não é possível fazer o estorno dessa AP, pois a mesma possui baixas!',
                    async function () {
                        consultaEstornoFaccao()
                    },
                    async function () {
                        consultaEstornoFaccao()
                    });

                return
            }

            toastr.success(
                'Estorno efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: async function () {
                    tabelaEstornoInstance.clear().destroy();
                    $('#btnConsultar').click();
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });;
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(error);
        }
    };



    async function buscaDadosCampos() {
        inputsTela = {
            retornoDe: $('#txtRetornoDe').val() != '' ? formataDataBonita($('#txtRetornoDe').val()) : '01/01/1200',
            retornoAte: $('#txtRetornoAte').val() != '' ? formataDataBonita($('#txtRetornoAte').val()) : '31/12/2500',
            pagamentoDe: $('#txtPagamentoDe').val() != '' ? formataDataBonita($('#txtPagamentoDe').val()) : '01/01/1200',
            pagamentoAte: $('#txtPagamentoAte').val() != '' ? formataDataBonita($('#txtPagamentoAte').val()) : '31/12/2500',
            envioDe: $('#txtEnvioDe').val() != '' ? formataDataBonita($('#txtEnvioDe').val()) : '01/01/1200',
            envioAte: $('#txtEnvioAte').val() != '' ? formataDataBonita($('#txtEnvioAte').val()) : '31/12/2500',
            periodoDe: pegaChave('#txtPeriodoDe'),
            periodoAte: pegaChave('#txtPeriodoAte'),
            numeroAP: $('#txtNumeroAP').val(),
            pedido: $('#txtPedido').val() != '' ? await formataListas($('#txtPedido').val().toString()) : '',
            setor: $('#txtSetor').val() != '' ? await formataListas($('#txtSetor').val().toString()) : '',
            consideraFaccao: $('#cbConsideraFaccao').is(':checked') ? '0' : '1',
            faccao: $('#txtFaccao').val() != '' ? await formataListas($('#txtFaccao').val().toString()) : '',
            consideraOF: $('#cbConsideraOF').is(':checked') ? '0' : '1',
            offaccao: $('#txtOF').val() != '' ? await formataListas($('#txtOF').val().toString()) : '',
            tipo: pegaChave('#txtTipo')
        }
        return inputsTela;
    }

});