$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnIncluir',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar um Lançamento.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaDados',
                popover: {
                    title: 'Tabela Lançamentos',
                    description: 'Aqui estão os dados dos Lançamentos consultados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("FACLANCA");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            await buscaDados();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    componenteFiltro('produto', false, false);
    componenteFiltro('cliente', false, false, 'Entidade');
    componenteFiltro('setor', false, false);

    $('#btnLimparFiltros').on('click', function () {
        $.LoadingOverlay('show');
        try {
            $('#dtLancamentoDe').val('1200-01-01');
            $('#dtLancamentoAte').val('2500-12-31');
            $('#dtVencimentoDe').val('1200-01-01');
            $('#dtVencimentoAte').val('2500-12-31');
            $('#dtPagamentoDe').val('1200-01-01');
            $('#dtPagamentoAte').val('2500-12-31');
            $('#rdTodos').prop('checked', true);
            $('#btnLimpaProduto').trigger('click');;
            $('#btnLimpaEntidade').trigger('click');
            $('#btnLimpaSetor').trigger('click');
            $('#txtObs').val('');
            $('#txtDescricao').val('');
            $('#txtLancamento').val('');
            $('#txtNumero').val('');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaDados() {
        try {
            let filtros = await retornaFiltros();

            const response = await requisicao('GET', '/sisplan/faclanca/v1/buscadados?', `JSON=${encodeURIComponent(JSON.stringify(filtros))}`, '', 600000);
            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            criaTabela(jsonStr);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function retornaFiltros() {
        return {
            LANCTO_DE: $('#dtLancamentoDe').val(),
            LANCTO_ATE: $('#dtLancamentoAte').val(),
            VENCTO_DE: $('#dtVencimentoAte').val(),
            VENCTO_ATE: $('#dtVencimentoAte').val(),
            PAGTO_DE: $('#dtPagamentoAte').val(),
            PAGTO_ATE: $('#dtPagamentoAte').val(),
            PAGOS: $('[name="rdPagos"]:checked').val(),
            PRODUTO: pegaChave($('#txtProduto')),
            TERCEIRO: pegaChave($('#txtEntidade')),
            SETOR: pegaChave($('#txtSetor')),
            OBS: $('#txtObs').val(),
            DESCRICAO: $('#txtDescricao').val(),
            LANCTO: $('#txtLancamento').val(),
            NUMERO: $('#txtNumero').val()
        }
    }

    function criaTabela(data) {
        if ($.fn.DataTable.isDataTable('#tabelaDados')) {
            $('#tabelaDados').DataTable().destroy();
            $('#tabelaDados').empty();
        }

        let cols = [{
            data: 'LANCAMENTO',
            title: 'Lançamento'
        },
        {
            data: 'NUMERO',
            title: 'Número'
        },
        {
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'DESC_SETOR',
            title: 'Desc. Setor'
        },
        {
            data: 'CODIGO',
            title: 'Código'
        },
        {
            data: 'DESCRICAO',
            title: 'Descrição'
        },
        {
            data: 'CODCLI',
            title: 'Cod. Cli.'
        },
        {
            data: 'NOME',
            title: 'Nome'
        },
        {
            data: 'QUANT',
            title: 'Qtde'
        },
        {
            data: 'PRECO',
            title: 'Preço'
        },
        {
            data: 'VALOR',
            title: 'Valor'
        },
        {
            data: 'DT_LAN',
            title: 'Lançamento'
        },
        {
            data: 'DT_PAGO',
            title: 'Pagamento'
        },
        {
            data: 'PAGO',
            title: 'Pago'
        },
        {
            data: 'OBS',
            title: 'Observação'
        },
        {
            data: 'DT_INI',
            title: 'Data Iníc.'
        },
        {
            data: 'DT_FIM',
            title: 'Data Fim'
        }];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoFacLanca == undefined) {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacLanca: ['EMPRESA'] }));
            colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        $("#tabelaDados").DataTable({
            order: false,
            sort: true,
            paging: true,
            destroy: true,
            lengthChange: true,
            searching: true,
            info: true,
            autoWidth: true,
            scrollX: true,
            scrollY: '360px',
            data: data,
            columns: cols,
            columnDefs: [
                {
                    targets: [0],
                    render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                },
                {
                    targets: [9, 10],
                    render: function (data) {
                        if (!data) {
                            return '0,00'
                        }                        
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    targets: [11, 12],
                    type: "date-br",
                    render(data) {
                        if (!data) {
                            return '';
                        }
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                },
            ]
        });

        $('#modal-filtros').modal('hide');

        $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show');
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaDados").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório da aba acesso lançamento de terceiros', '', '', 999, false, false, dados);
        });

        $('#tabelaDados').DataTable().columns().every(function () {
            if ((colunasInvisiveis.acessoFacLanca).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
            }
        });
    }

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '       <button class="dropdown-item" id="btn-alterar">Alterar</button> ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button> ' +
            '       <button class="dropdown-item" id="btn-duplicar">Duplicar</button> ' +
            '</div>';
        return retorno;
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaDados').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoFacLanca ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacLanca: novasColunas }));

            $('#tabelaDados').DataTable().columns().visible(true);

            $('#tabelaDados').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaDados').on('click', '#btn-alterar', function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                window.location.href = `faclanca/${data.LANCAMENTO}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaDados').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Tem certeza que deseja excluir esse registro?', () => { }, () => { }, async () => {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(linha) {
        $.LoadingOverlay('show');
        try {
            try {
                let response = await requisicao("DELETE", "/sisplan/faclanca/v1/excluir?", `&LANCTO=${linha.LANCAMENTO}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            } catch (e) {
                msgErro(`Não foi possível excluir o registro: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    $('#btnIncluir').on('click', function () {
        $.LoadingOverlay('show');
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                $.LoadingOverlay('show');
                try {
                    window.location.href = `faclanca/create`;
                } finally {
                    $.LoadingOverlay('hide');
                }
            } else {
                msgAlertaSemConfirmacao("Sem permissão para incluir!");
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

});