$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnIncluir',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um preço terceiros.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaDados',
                popover: {
                    title: 'Tabela Preço Terceiros',
                    description: 'Aqui estão os dados dos preços terceiros consultados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("FACPRECO");

    componenteFiltro('produto', true, true);
    componenteFiltro('tabPreco', true, true);
    componenteFiltro('colecao', true, true);
    componenteFiltro('grupoPA', true, true);
    componenteFiltro('etiqueta', true, true);
    componenteFiltro('linha', true, true);
    componenteTipoClassificacao();

    $('#btnLimparFiltros').on('click', function () {
        $.LoadingOverlay('show');
        try {
            $('#btnLimpaProduto').trigger('click');
            $('#btnLimpaTabPreco').trigger('click');
            $('#btnLimpaColecao').trigger('click');
            $('#btnLimpaGrupoPA').trigger('click');
            $('#btnLimpaEtiqueta').trigger('click');
            $('#btnLimpaLinha').trigger('click');
            $('#btnLimpaProdClasTipo').trigger('click');
            $('#txtParte').val('');
            $('#txtTipo').val('0');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    try {
        $.LoadingOverlay('show');
        await adicionaPartes();
    } finally {
        $.LoadingOverlay('hide');
    }

    async function adicionaPartes() {
        try {

            let response = await requisicao('GET',
                '/Sisplan/Funcoes/V1/pesquisa?',
                `JSON={ "tabela":"TIPO_APL", 
                        "camposSelect":["TIPO_APL.CODIGO", "TIPO_APL.DESCRICAO"],
                        "where": null,
                        "orderby": ["TIPO_APL.CODIGO"]
                        }`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status !== 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            jsonStr = jsonStr.RESULT[0];

            jsonStr.map((e) => {
                $('#txtParte').append(`<option class="drilldown-item" value="${e.CODIGO}">${e.CODIGO} - ${e.DESCRICAO}</option>`);
            });

        } catch (e) {
            msgErro(`Não foi possível carregar as partes: ${e}`);
            console.log(e);
        }
    }

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            await buscaDados();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaDados() {
        try {
            let filtros = await retornaFiltros();

            const response = await requisicao('GET', '/sisplan/facpreco/v1/buscadados?', `JSON=${encodeURIComponent(JSON.stringify(filtros))}`, '', 600000);
            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            criaTabela(jsonStr);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function retornaFiltros() {
        return {
            PRODUTO: await formataListas($('#txtProduto').val().toString()),
            TABELA: await formataListas($('#txtTabPreco').val().toString()),
            COLECAO: await formataListas($('#txtColecao').val().toString()),
            GRUPO: await formataListas($('#txtGrupoPA').val().toString()),
            ETIQUETA: await formataListas($('#txtEtiqueta').val().toString()),
            LINHA: await formataListas($('#txtLinha').val().toString()),
            ID: await formataListas($('#txtProdClasTipo').val().toString()),
            PARTE: $('#txtParte').val(),
            TIPO: $('#txtTipo').val()
        }
    }

    function criaTabela(data) {
        if ($.fn.DataTable.isDataTable('#tabelaDados')) {
            $('#tabelaDados').DataTable().destroy();
            $('#tabelaDados').empty();
        }

        let cols = [{
            data: 'TABELA',
            title: 'Tabela'
        },
        {
            data: 'DESC_TABELA',
            title: 'Desc. Tabela'
        },
        {
            data: 'PRODUTO',
            title: 'Produto'
        },
        {
            data: 'DESC_PRODUTO',
            title: 'Desc. Produto'
        },
        {
            data: 'PARTE',
            title: 'Parte'
        },
        {
            data: 'DESC_PARTE',
            title: 'Desc. Parte'
        },
        {
            data: 'TIPO',
            title: 'Tipo'
        },
        {
            data: 'COR',
            title: 'Cor'
        },
        {
            data: 'DESC_COR',
            title: 'Desc. Cor'
        },
        {
            data: 'GRUPO',
            title: 'Grupo'
        },
        {
            data: 'DESC_GRUPO',
            title: 'Desc. Grupo'
        },
        {
            data: 'ETIQUETA',
            title: 'Etiqueta'
        },
        {
            data: 'DESC_ETIQUETA',
            title: 'Desc. Etiqueta'
        },
        {
            data: 'LINHA',
            title: 'Linha'
        },
        {
            data: 'DESC_LINHA',
            title: 'Desc. Linha'
        },
        {
            data: 'BLOQ_MUDANCA',
            title: 'Bloq. Mudança'
        }];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoFacPreco == undefined) {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacPreco: ['EMPRESA'] }));
            colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        $("#tabelaDados").DataTable({
            order: false,
            sort: true,
            paging: true,
            destroy: true,
            screenX: true,
            scrollX: true,
            scrollY: '350px',
            lengthChange: true,
            searching: true,
            info: true,
            autoWidth: true,
            data: data,
            columns: cols,
            columnDefs: [{
                targets: [15],
                visible: false
            },
            {
                targets: [0],
                render: function (data, type, row) {
                    return retornaBotaoOpcoes(data);
                }
            },]
        });

        $('#modal-filtros').modal('hide');

        $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show');
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaDados").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório da aba acesso preço terceiros', '', '', 999, false, false, dados);
        });

        $('#tabelaDados').DataTable().columns().every(function () {
            if ((colunasInvisiveis.acessoFacPreco).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
            }
        });
    }

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '       <button class="dropdown-item" id="btn-alterar">Alterar</button> ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button> ' +
            '</div>';
        return retorno;
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaDados').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoFacPreco ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacPreco: novasColunas }));

            $('#tabelaDados').DataTable().columns().visible(true);

            $('#tabelaDados').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaDados').on('click', '#btn-alterar', function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                window.location.href = `facpreco/${data.PRODUTO}#${data.TABELA}#${data.PARTE}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaDados').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Tem certeza que deseja excluir esse registro?', () => { }, () => { }, async () => {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(linha) {
        $.LoadingOverlay('show');
        try {
            try {
                let response = await requisicao("DELETE", "/sisplan/facpreco/v1/excluiregistro?", `&PRODUTO=${linha.PRODUTO}&TABELA=${linha.TABELA}&PARTE=${linha.PARTE}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            } catch (e) {
                msgErro(`Não foi possível excluir o registro: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    $('#btnIncluir').on('click', function () {
        $.LoadingOverlay('show');
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                $.LoadingOverlay('show');
                try {
                    window.location.href = `facpreco/create`;
                } finally {
                    $.LoadingOverlay('hide');
                }
            } else {
                msgAlertaSemConfirmacao("Sem permissão para incluir!");
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

});