<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Tipo</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.255.29.2">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.255.29.2">

    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


    <link rel="stylesheet" href="dist/css/custom.css?versao=3.255.29.2">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.255.29.2">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.255.29.2" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.255.29.2">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.255.29.2" />
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.255.29.2">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.255.29.2">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.255.29.2">

    <style>
        #tabelaTipo td div button {
            padding: .0rem .5rem;
            margin-top: .1rem;
            margin-bottom: .2rem;
        }

        #tabelaTipo td {
            padding: 0 !important;
            padding-left: 10px !important;
        }

        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .quadrado {
            width: 25px;
            margin-right: 5px;
            height: 25px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Cotações de Frete</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaTipoForne">
                    <div class="row card">
                        <div class="col-sm-12 mt-3 row pl-3">
                            <button class="btn btn-success btn-sisp mr-2" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp mr-2" id="btnNovoTipo"><span class="fas fa-plus"></span> Incluir</button>
                            <button class="btn btn-secondary btn-sisp mr-2" id="btnImprimir"><i class="fas fa-print"></i> Imprimir</button>

                            <div class="d-flex align-items-center gap-2">
                                <div class="quadrado" style="background: rgba(245, 81, 81, 1);">
                                </div>
                                <span> Finalizado </span>
                            </div>

                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Cotações</h5>
                            <table id="tabelaCotacao" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Filtros</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                                    <div class="">
                                        <label for="txtDataDe">Data de/até:</label>
                                        <div class="input-group">
                                            <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDe" name="DataDe">
                                            <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="DataAte">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-5 mt-3 pr-2">
                                    <div class="form" id="area">
                                        <fieldset class="form border-Field">
                                            <legend class="textoBorda mb-0 pb-0">Tipo Nota</legend>
                                            <div class="form-row ml-auto">
                                                <div class="icheck-primary mr-2">
                                                    <input type="radio" id="rdTodos" checked name="rdTipoNota" class='rdTipoNota' value="0">
                                                    <label class="labelCheck" for="rdTodos">Todos</label>
                                                </div>
                                                <div class="icheck-primary mr-2">
                                                    <input type="radio" id="rdCotacao" name="rdTipoNota" class='rdTipoNota' value="1">
                                                    <label class="labelCheck" for="rdCotacao">Cotação Frete</label>
                                                </div>
                                                <div class="icheck-primary">
                                                    <input type="radio" id="rdNotaEntrada" name="rdTipoNota" class='rdTipoNota' value="2">
                                                    <label class="labelCheck" for="rdNotaEntrada">Nota de Entrada</label>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4 mt-3 pr-2">
                                    <div class="form" id="area">
                                        <fieldset class="form border-Field">
                                            <legend class="textoBorda mb-0 pb-0">Situação Orçamento</legend>
                                            <div class="form-row ml-auto">
                                                <div class="icheck-primary mr-2">
                                                    <input type="radio" id="rdTodos" checked name="rdSituacaoOrcamento" class='rdSituacaoOrcamento' value="0">
                                                    <label class="labelCheck" for="rdTodos">Todos</label>
                                                </div>
                                                <div class="icheck-primary mr-2">
                                                    <input type="radio" id="rdAberto" name="rdSituacaoOrcamento" class='rdSituacaoOrcamento' value="1">
                                                    <label class="labelCheck" for="rdAberto">Aberto</label>
                                                </div>
                                                <div class="icheck-primary">
                                                    <input type="radio" id="rdFechado" name="rdSituacaoOrcamento" class='rdSituacaoOrcamento' value="2">
                                                    <label class="labelCheck" for="rdFechado">Fechado</label>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-group col-lg-4 col-12 col-sm-12">
                                    <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-lg-4 col-12 col-sm-12">
                                    <label data-error="wrong" data-success="right" for="txtTransportadora">Transportadora: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtTransportadora" name="txtTransportadora" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnTransportadora" name="btnTransportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaTransportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-lg-4 col-12 col-sm-12">
                                    <label data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="row">
                                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.255.29.2"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.255.29.2"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.29.2"></script>
    <script src="dist/js/adminlte.min.js?versao=3.255.29.2"></script>
    <script src="dist/js/sisplan.js?versao=3.255.29.2"></script>
    <script src="utils/funcoes.js?versao=3.255.29.2"></script>
    <script src="utils/cookies.js?versao=3.255.29.2"></script>
    <script src="dist/js/requisicoes.js?versao=3.255.29.2"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.255.29.2"></script>
    <script src="dist/js/driver.min.js?versao=3.255.29.2"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.255.29.2"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.255.29.2"></script>
    <script type="text/javascript" src="config.js?versao=3.255.29.2"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('FRETECOTA');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/fretecota/acesso_fretecota/acesso_fretecota.js?versao=3.255.29.2`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>