$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

      {
        element: '#btn-filtros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("INVENTARIO");
  const parametrosVenda = await BuscaParametrosVenda();
  setarDataAtual('txtDataEditar')
  setarDataAtual('dtFabricacaoEditar')

  let filtroSetor;
  filtroSetor = await buscaSetorUsuario();
  filtroSetor = filtroSetor == '' ? null : `"CODIGO IN (${filtroSetor})"`;

  let filtroDeposito;
  filtroDeposito = await buscaDepositoEmpresaUsuario();
  filtroDeposito = filtroDeposito == '' ? null : `"CODIGO IN (${filtroDeposito})"`;

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#btn-filtros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  const bProduto = parametrosVenda[17] == 0;
  if (bProduto) {
    $("#radioProduto").prop("checked", true);
  } else {
    $("#radioMaterial").prop("checked", true);
  }

  $('#btnIncluirManutencao').on('click', function () {
    $('#confirmar-dados').addClass('d-none');
    $('#confirmar-dadosincluir').removeClass('d-none');
    $('#modal-manutencao').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    if ($.fn.DataTable.isDataTable('#tabelaInventario')) {
      $('#tabelaInventario').DataTable().destroy();
      $('#tabelaInventario').empty();
    };
    if ($('#radioMaterial').is(':checked')) {
      await consultaInventarioMat();
    } else {
      await consultaInventario(true);
    }
  });

  adicionaPesquisaDepositoPadrao()
  adicionaPesquisaSetorPadrao()
  adicionaPesquisaCodigoPadrao()
  adicionaPesquisaCorPadrao()
  adicionaPesquisaQualidadePadrao()
  adicionaPesquisaTamanhoPadrao()

  $('#txtCnpjEditar').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "CNPJ DESCRICAO"], "where": null}`);
  $('#btnCnpjEditar').pesquisa_serverside(['#txtCnpjEditar'], ['CODCLI'], ['CNPJ'], '{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME", "CNPJ"], "where": null}', 'Pesquisa CNPJ');
  $('#btnLimpaCnpjEditar').on('click', function () {
    $('#txtCnpjEditar').val('');
  });

  function adicionaPesquisaSetorPadrao() {
    $('#txtSetorEditar').autocompleta(
      1,
      `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroSetor}]}`,
      [],
      [],
      [],
      () => {
        if ($('#txtSetorEditar').val()) {
          $('#txtSetorEditar').attr('disabled', true)
          $('#btnSetorEditar').attr('disabled', true)
          $('#btnLimpaSetorEditar').attr('disabled', true)
        }
      });

    $("#btnSetorEditar").pesquisa_array(
      ["#txtSetorEditar"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADFLUXO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroSetor}]}`,
      "Pesquisa Setor",
      "CADFLUXO",
      () => {
        if ($('#txtSetorEditar').val()) {
          $('#txtSetorEditar').attr('disabled', true)
          $('#btnSetorEditar').attr('disabled', true)
          $('#btnLimpaSetorEditar').attr('disabled', true)
        }
      }
    );
    $('#btnLimpaSetorEditar').on('click', function () {
      $('#txtSetorEditar').val('');
    });
  }

  function adicionaPesquisaDepositoPadrao() {
    $("#txtDepositoEditar").autocompleta(
      1,
      `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroDeposito}]}`,
      [],
      [],
      [],
      () => {
        if ($('#txtDepositoEditar').val()) {
          $('#txtDepositoEditar').attr('disabled', true)
          $('#btnDepositoEditar').attr('disabled', true)
          $('#btnLimpaDeposito').attr('disabled', true)
          $('.controleBlur').attr('disabled', false)
        }
      }
    );

    $("#btnDepositoEditar").pesquisa_array(
      ["#txtDepositoEditar"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroDeposito}]}`,
      "Pesquisa Depósito",
      "DEPOSITO",
      () => {
        if ($('#txtDepositoEditar').val()) {
          $('#txtDepositoEditar').attr('disabled', true)
          $('#btnDepositoEditar').attr('disabled', true)
          $('#btnLimpaDepositoEditar').attr('disabled', true)
          // $('.controleBlur').attr('disabled', false) //comentado pois no back-end não deixa alterar essas infos, apenas incluir.
        }
      }
    );
    $('#btnLimpaDepositoEditar').on('click', function () {
      $('#txtDepositoEditar').val('');
    });
  }

  function adicionaPesquisaCodigoPadrao() {
    if ($('#radioMaterial').is(':checked')) {
      $('#btnCodigoEditar').pesquisa_array(
        ['#txtCodigoEditar'],
        ['CODIGO'],
        ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}`,
        'Pesquisa Material',
        'MATERIAL',
        async () => {
          await buscaLoteBarra()
          $('#txtQualidadeEditar').val('');
        }
      );

      $('#txtCodigoEditar').autocompleta(
        1,
        'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
        [],
        [],
        [],
        async () => {
          await buscaLoteBarra()
        });
      $('#btnLimpaCodigoEditar').on('click', function () {
        $('#txtCodigoEditar').val('');

        $('#txtQualidadeEditar').autocompleta(
          1,
          'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
          [],
          [],
          [],
          async () => {
            await buscaLoteBarra()
            await saidaCamposQualidade()
          });

        $('#btnQualidadeEditar').pesquisa_array(
          ['#txtQualidadeEditar'],
          ['CODIGO'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = MAT_ITEN.QUALIDADE" }], "where": ["(MAT_ITEN.QUALIDADE <> '' OR MAT_ITEN.QUALIDADE IS NOT NULL) AND MAT_ITEN.CODIGO = '${pegaChave('#txtCodigoEditar')}'"], "groupBy": ["MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO"]}`,
          'Pesquisa Qualidade',
          'TABQUL',
          async () => {
            await buscaLoteBarra()
            await saidaCamposQualidade()
          });
      });
    } else {
      $('#btnCodigoEditar').pesquisa_array(
        ['#txtCodigoEditar'],
        ['CODIGO'],
        ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}`,
        'Pesquisa Produto',
        'PRODUTO',
        async () => {
          $('#txtQualidadeEditar').val('');
        }
      );

      $('#txtCodigoEditar').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
      $('#btnLimpaCodigoEditar').on('click', function () {
        $('#txtCodigoEditar').val('');

        $('#txtQualidadeEditar').autocompleta(
          1,
          'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
          [],
          [],
          [],
          async () => {
            await saidaCamposQualidade()
          });

        $('#btnQualidadeEditar').pesquisa_array(
          ['#txtQualidadeEditar'],
          ['CODIGO'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.TIPO", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = PA_ITEN.TIPO" }], "where": ["(PA_ITEN.TIPO <> '' OR PA_ITEN.TIPO IS NOT NULL) AND PA_ITEN.CODIGO = '${pegaChave('#txtCodigoEditar')}'"], "groupBy": ["PA_ITEN.TIPO", "TABQUL.DESCRICAO"]}`,
          'Pesquisa Qualidade',
          'TABQUL',
          async () => {
            await saidaCamposQualidade()
          });
      });
    }
  }

  async function saidaCamposQualidade() {
    if ($('#radioMaterial').is(':checked')) {
      $('#btnLoteEditar').attr('disabled', false)
      $('#btnLoteEditar').pesquisa_array(
        ['#txtLoteEditar'],
        ['LOTE'],
        ['CODIGO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["(LOTE <> '' OR LOTE IS NOT NULL) AND CODIGO = '${pegaChave('#txtCodigoEditar')}' AND MAT_ITEN.COR = '${pegaChave('#txtCorEditar')}' AND MAT_ITEN.QUALIDADE = '${pegaChave('#txtQualidadeEditar')}' AND MAT_ITEN.DEPOSITO='${pegaChave('#txtDepositoEditar')}'"], "groupBy": ["LOTE", "CODIGO"]}`,
        'Pesquisa Lote',
        'MAT_ITEN',
        async () => {
          await buscaLoteBarra()
        });
      $('#btnLimpaLoteEditar').on('click', function () {
        $('#txtLoteEditar').val('')
      })
    } else {
      $('#btnLoteEditar').attr('disabled', false)
      $('#btnLoteEditar').pesquisa_array(
        ['#txtLoteEditar'],
        ['BARRA'],
        ['CODIGO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "BARRA", "CODIGO" ], "where": ["(BARRA <> '' OR BARRA IS NOT NULL) AND CODIGO = '${pegaChave('#txtCodigoEditar')}' AND PA_ITEN.COR = '${pegaChave('#txtCorEditar')}' AND PA_ITEN.TIPO = '${pegaChave('#txtQualidadeEditar')}' AND PA_ITEN.DEPOSITO='${pegaChave('#txtDepositoEditar')}'"], "groupBy": ["BARRA", "CODIGO"]}`,
        'Pesquisa Barra',
        'PA_ITEN');
      $('#btnLimpaLoteEditar').on('click', function () {
        $('#txtLoteEditar').val('')
      })
    }
  }

  function adicionaPesquisaCorPadrao() {
    $('#btnCorEditar').pesquisa_array(
      ['#txtCorEditar'],
      ['COR'],
      ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`,
      'Pesquisa Cor',
      'CADCOR',
      async () => {
        await buscaLoteBarra()
      });

    $('#txtCorEditar').autocompleta(
      1,
      'JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
      [],
      [],
      [],
      async () => {
        await buscaLoteBarra()
      });

    $('#btnLimpaCorEditar').on('click', function () {
      $('#txtCorEditar').val('')
    })
  }

  function adicionaPesquisaQualidadePadrao() {
    if ($('#radioMaterial').is(':checked')) {
      $('#btnQualidadeEditar').pesquisa_array(
        ['#txtQualidadeEditar'],
        ['CODIGO'],
        ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = MAT_ITEN.QUALIDADE" }], "where": ["(MAT_ITEN.QUALIDADE <> '' OR MAT_ITEN.QUALIDADE IS NOT NULL) AND MAT_ITEN.CODIGO = '${pegaChave('#txtCodigoEditar')}'"], "groupBy": ["MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO"]}`,
        'Pesquisa Qualidade',
        'TABQUL',
        async () => {
          await buscaLoteBarra()
          await saidaCamposQualidade()
        });

      $('#txtQualidadeEditar').autocompleta(
        1,
        'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
        [],
        [],
        [],
        async () => {
          await buscaLoteBarra()
          await saidaCamposQualidade()
        });
      $('#btnLimpaQualidadeEditar').on('click', function () {
        $('#txtQualidadeEditar').val('');
      });
    } else {
      $('#btnQualidadeEditar').pesquisa_array(
        ['#txtQualidadeEditar'],
        ['CODIGO'],
        ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.TIPO", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = PA_ITEN.TIPO" }], "where": ["(PA_ITEN.TIPO <> '' OR PA_ITEN.TIPO IS NOT NULL) AND MAT_ITEN.CODIGO = '${pegaChave('#txtCodigoEditar')}'"], "groupBy": ["PA_ITEN.TIPO", "TABQUL.DESCRICAO"]}`,
        'Pesquisa Qualidade',
        'TABQUL',
        async () => {
          await saidaCamposQualidade()
        });

      $('#txtQualidadeEditar').autocompleta(
        1,
        'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
        [],
        [],
        [],
        async () => {
          await saidaCamposQualidade()
        });
      $('#btnLimpaQualidadeEditar').on('click', function () {
        $('#txtQualidadeEditar').val('');
      });
    }
  }

  function adicionaPesquisaTamanhoPadrao() {
    $('#btnTamEditar').pesquisa_array(
      ['#txtTamEditar'],
      ['TAM'],
      ['ACRESCIMO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM", "ACRESCIMO" ], "where": null}`,
      'Pesquisa Tamanho',
      'TABTAM');

    $('#txtTamEditar').autocompleta(1, 'JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM CHAVE", "ACRESCIMO DESCRICAO"], "where": null}');

    $('#btnLimpaTamEditar').on('click', function () {
      $('#txtTamEditar').val('');
    });
  }

  $('#txtTonalidadeEditar').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE CHAVE", "ATIVO DESCRICAO"], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`);
  $('#btnTonalidadeEditar').pesquisa_array(['#txtTonalidadeEditar'], ['TONALIDADE'], ['ATIVO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa Tonalidade', 'MAT_ITEN');
  $('#btnLimpaTonalidadeEditar').on('click', function () {
    $('#txtTonalidadeEditar').val('');
  });

  $('#txtLote').on('blur', async function () {
    await buscaLoteBarra()
  })

  await blurCampoCodigo()
  async function blurCampoCodigo() {
    $('#txtCodigoEditar').on('blur', async function () {
      if ($('#radioMaterial').is(':checked')) {
        $('#txtCorEditar').unbind('autocompleta');
        $('#btnCorEditar').off();
        $('#btnCorEditar').unbind('pesquisa_array');

        $('#txtCorEditar').autocompleta(
          1,
          `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR CHAVE", "CADCOR.DESCRICAO DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
          [],
          [],
          [],
          async () => {
            await buscaLoteBarra()
          });

        $('#btnCorEditar').pesquisa_array(
          ['#txtCorEditar'],
          ['COR'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
          'Pesquisa Cor',
          'CADCOR',
          async () => {
            await buscaLoteBarra()
          });

        $('#txtQualidadeEditar').unbind('autocompleta');
        $('#btnQualidadeEditar').off();
        $('#btnQualidadeEditar').unbind('pesquisa_array');

        $('#txtQualidadeEditar').autocompleta(
          1,
          'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
          [],
          [],
          [],
          async () => {
            await buscaLoteBarra()
            await saidaCamposQualidade()
          });

        $('#btnQualidadeEditar').pesquisa_array(
          ['#txtQualidadeEditar'],
          ['QUALIDADE'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = MAT_ITEN.QUALIDADE" }], "where": ["(MAT_ITEN.QUALIDADE <> '' OR MAT_ITEN.QUALIDADE IS NOT NULL) AND MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}' AND MAT_ITEN.DEPOSITO='${pegaChave('#txtDepositoEditar')}'"], "groupBy": ["MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO"]}`,
          'Pesquisa Qualidade',
          'TABQUL',
          async () => {
            await buscaLoteBarra()
            await saidaCamposQualidade()
          });

        $('#btnLoteEditar').attr('disabled', false)
        $('#btnLoteEditar').pesquisa_array(
          ['#txtLoteEditar'],
          ['LOTE'],
          ['CODIGO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["(LOTE <> '' OR LOTE IS NOT NULL) AND CODIGO = '${$(this).attr('data-chave')}' AND MAT_ITEN.COR = '${pegaChave('#txtCorEditar')}' AND MAT_ITEN.QUALIDADE = '${pegaChave('#txtQualidadeEditar')}' AND MAT_ITEN.DEPOSITO='${pegaChave('#txtDepositoEditar')}'"], "groupBy": ["LOTE", "CODIGO"]}`,
          'Pesquisa Lote',
          'MAT_ITEN',
          async () => {
            await buscaLoteBarra()
          });
        $('#btnLimpaLoteEditar').on('click', function () {
          $('#txtLoteEditar').val('')
        })

        if ($('#txtCodigoEditar').val() !== '') {
          const codigo = pegaChave('#txtCodigoEditar')
          const pesquisa = {
            tabela: 'MATERIAL',
            camposSelect: ['UNIDADE', 'UNI_AUX', 'RENDIMENTO'],
            where: [`CODIGO = '${codigo}'`]
          }
          const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          $('#txtUnEditar').val(matIten[0].UNIDADE)
          $('#txtUnidadeAuxEditar').val(matIten[0].UNI_AUX)
          $('#txtRendimentoEditar').val(matIten[0].RENDIMENTO)
        }
      } else {
        $('#txtCorEditar').unbind('autocompleta');
        $('#btnCorEditar').off();
        $('#btnCorEditar').unbind('pesquisa_array');

        $('#txtCorEditar').autocompleta(
          1,
          `JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR CHAVE", "CADCOR.DESCRICAO DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
          [],
          [],
          [],
          async () => {
          });

        $('#btnCorEditar').pesquisa_array(
          ['#txtCorEditar'],
          ['COR'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
          'Pesquisa Cor',
          'CADCOR',
          async () => {
          });

        $('#txtQualidadeEditar').unbind('autocompleta');
        $('#btnQualidadeEditar').off();
        $('#btnQualidadeEditar').unbind('pesquisa_array');

        $('#txtQualidadeEditar').autocompleta(
          1,
          'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
          [],
          [],
          [],
          async () => {
            await saidaCamposQualidade()
          });

        $('#btnQualidadeEditar').pesquisa_array(
          ['#txtQualidadeEditar'],
          ['TIPO'],
          ['DESCRICAO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.TIPO", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = PA_ITEN.TIPO" }], "where": ["(PA_ITEN.TIPO <> '' OR PA_ITEN.TIPO IS NOT NULL) AND PA_ITEN.CODIGO = '${$(this).attr('data-chave')}' AND PA_ITEN.DEPOSITO='${pegaChave('#txtDepositoEditar')}'"], "groupBy": ["PA_ITEN.TIPO", "TABQUL.DESCRICAO"]}`,
          'Pesquisa Qualidade',
          'TABQUL',
          async () => {
            await saidaCamposQualidade()
          });

        if ($('#txtCodigoEditar').val() !== '') {
          const codigo = pegaChave('#txtCodigoEditar')
          const pesquisa = {
            tabela: 'PRODUTO',
            camposSelect: ['UNIDADE'],
            where: [`CODIGO = '${codigo}'`]
          }
          const prod = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          $('#txtUnEditar').val(prod[0].UNIDADE)
          $('#txtUnidadeAuxEditar').val(prod[0].UNIDADE)
        }
      }

    });
  }

  async function buscaLoteBarra() {
    try {
      let lote = ''
      const codigo = pegaChave('#txtCodigoEditar')
      const cor = pegaChave('#txtCorEditar')
      const qualidade = pegaChave('#txtQualidadeEditar')

      if ($('#txtLoteEditar').val().includes('[')) {
        lote = pegaChave('#txtLoteEditar')
      } else {
        lote = $('#txtLoteEditar').val()
      }

      if (codigo && cor && qualidade && lote) {
        const pesquisa = {
          tabela: 'MAT_ITEN',
          camposSelect: ['LOTE_INTERNO', 'BARRA', 'DT_FAB', 'TONALIDADE'],
          where: [`CODIGO = '${codigo}' AND COR = '${cor}' AND QUALIDADE = '${qualidade}' AND LOTE = '${lote}'`]
        }
        const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (matIten.length > 0) {
          if (matIten[0].TONALIDADE) {
            insereValor('#txtTonalidadeEditar', matIten[0].TONALIDADE, 'S')
          } else {
            $('#txtTonalidadeEditar').attr('disabled', false)
            $('#btnTonalidadeEditar').attr('disabled', false)
            $('#btnLimpaTonalidadeEditar').attr('disabled', false)
          }
          if (matIten[0].DT_FAB) {
            $('#dtFabricacaoEditar').val(matIten[0].DT_FAB.split(' ')[0])
          } else {
            $('#dtFabricacaoEditar').attr('disabled', false)
          }
          if (matIten[0].LOTE_INTERNO) {
            $('#txtLoteInternoEditar').val(matIten[0].LOTE_INTERNO)
          } else {
            $('#txtLoteInternoEditar').attr('disabled', false)
            $('#btnLoteInternoEditar').attr('disabled', false)
            $('#btnLimpaLoteInternoEditar').attr('disabled', false)
          }
          if (matIten[0].BARRA) {
            $('#txtBarraEditar').val(matIten[0].BARRA)
          } else {
            $('#txtBarraEditar').attr('disabled', false)
            $('#btnBarraEditar').attr('disabled', false)
            $('#btnLimpaBarraEditar').attr('disabled', false)
          }
        } else {
          $('#txtTonalidadeEditar').val('')
          $('#txtBarraEditar').val('')
          $('#dtFabricacaoEditar').val('')
          $('#btnLoteInternoEditar').val('')

          $('.controleBlur2').attr('disabled', false)
        }
        $('.controleBlur3').attr('disabled', false)
        $('.controleBlur4').attr('disabled', false)
      }
    } catch (error) {
    }
  }

  $('#txtLoteEditar').on('blur', async function () {
    await buscaLoteBarra()
  })

  //BOTÕES DE RADIO
  $('#radioProduto, #radioMaterial').on('change', async function () {
    $('#btnCodigoEditar').unbind();
    $('#btnProduto').unbind();
    $('#btnGrupo').unbind();
    $('#btnGrupoMA').unbind();
    $('#txtProduto').val('');
    await adicionaPesquisaCampos()
  });

  async function adicionaPesquisaCampos() {
    if ($('#radioMaterial').is(':checked')) {
      //EDITAR
      $("#txtCodigoEditar").attr("placeholder", "Material");
      $("#lblCodigoEditar").text("Material *");

      $("#txtCodigoEditar").autocompleta(
        1,
        `JSON={"tabela": "material", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`,
        [],
        [],
        [],
        async () => {
          await buscaLoteBarra()
        }
      );
      $('#btnCodigoEditar').pesquisa_serverside(
        [`#txtCodigoEditar`],
        ['CODIGO'],
        ['DESCRICAO'],
        '{"tabela": "material", "camposSelect": ["CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Material',
        async () => {
          await buscaLoteBarra()
          $('#txtQualidadeEditar').val('');
        });

      await blurCampoCodigo()

      $('.divDtFab').removeClass('d-none')
      $('#divTamEditar').addClass('d-none')
      $('#divTonalidadeEditar').removeClass('d-none')
      $('#divLoteInternoEditar').removeClass('d-none')
      $('#divLoteEditar').removeClass('d-none')

      //FILTRO
      $("#txtGrupo").attr("id", "txtGrupoMA");
      $("#btnGrupo").attr("id", "btnGrupoMA");
      $("#btnLimpaGrupo").attr("id", "btnLimpaGrupoMA");
      $('#divSubGrupo').removeClass('d-none')
      $('#divSubGrupo').addClass('col-6')
      $('#divGrupo').removeClass('col-12')
      $('#divGrupo').addClass('col-6')

      $("#lblProduto").text("Material");
      $("#txtProduto").attr("placeholder", "Material");

      componenteFiltro('grupoMA', false, false)
      $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Material');
    } else {
      //EDITAR
      $("#txtCodigoEditar").attr("placeholder", "Produto");
      $("#lblCodigoEditar").text("Produto");

      $("#btnCodigoEditar").pesquisa_array(
        ["#txtCodigoEditar"],
        ["CODIGO"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PRODUTO", "camposSelect": ["CODIGO", "DESCRICAO", "CODIGO2"], "where": null}`,
        "Pesquisa Produto",
        "PRODUTO",
        () => {
          $('#txtQualidadeEditar').val('');
        }
      );

      $('#divTonalidadeEditar').addClass('d-none')
      $('#divLoteInternoEditar').addClass('d-none')
      $('#divLoteEditar').addClass('d-none')
      $('#divTamEditar').removeClass('d-none')
      $('.divDtFab').addClass('d-none')

      //FILTRO
      $("#txtProduto").attr("placeholder", "Produto");
      $("#lblProduto").text("Produto");
      $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Produto');
      $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

      $("#txtGrupoMA").attr("id", "txtGrupo");
      $("#btnGrupoMA").attr("id", "btnGrupo");
      $("#btnLimpaGrupoMA").attr("id", "btnLimpaGrupo");
      componenteFiltro('grupo', false, false)

      $('#divGrupo').removeClass('col-6')
      $('#divGrupo').addClass('col-12')
      $('#divSubGrupo').addClass('d-none')
    }
  }

  $('txtLancamentoPesquisa').pesquisa_serverside(['#txtLancamentoPesquisa'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"INVENTARIO", "camposSelect":[ "LANCAMENTO"], "where": null,}', 'Pesquisa Lancamento');
  $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Produto');
  $('#btnDeposito').pesquisa_serverside(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": [${filtroDeposito}]}`, `Pesquisa Deposito`);
  $('#btnSetor').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": [${filtroSetor}]}`, 'Pesquisa Setor');
  $('#btnLote').pesquisa_serverside(['#txtLote'], ['LOTE'], ['CODIGO'], `{"tabela":"MAT_ITEN", "camposSelect":["LOTE", "CODIGO", "COR"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

  $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "CODIGO CHAVE", "descricao"], "where": null}`);
  $('#txtDeposito').autocompleta(3, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "descricao"], "where": [${filtroDeposito}]}`);
  $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": [${filtroSetor}]}`);
  $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`);

  $('#btnLimpaProduto').on('click', function () {
    $('#txtProduto').val('');
  });

  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btnLimpaCodigo').on('click', function () {
    $('#txtLancamentoPesquisa').val('');
  });

  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#btnLimpaSetor').on('click', function () {
    $('#txtSetor').val('');
  });

  componenteFiltro('grupoMA', false, false);
  componenteFiltro('qualidade', false, false);
  componenteFiltro('subGrupo', false, false);
  componenteFiltro('linha', false, false);
  componenteFiltro('cor', false, false);

  $('#btnLimpaLote').on('click', function () {
    $('#txtLote').val('');
  });

  $('#txtLancamentoPesquisa').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#txtLancamentoPesquisa').click();
    }
  });

  $('#txtProduto').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnProduto').click();
    }
  });

  $('#txtDeposito').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnDeposito').click();
    }
  });

  $('#txtSetor').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnSetor').click();
    }
  });

  $('#txtCor').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnCor').click();
    }
  });

  $('#txtCodigoEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnCodigoEditar').click();
    }
  });

  $('#txtDepositoEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnDepositoEditar').click();
    }
  });

  $('#txtSetorEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnSetorEditar').click();
    }
  });

  $('#txtCorEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnCorEditar').click();
    }
  });

  $('#txtTamEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnTamEditar').click();
    }
  });

  $('#txtQualidadeEditar').keydown(function (e) {
    if (e.which == 115) {
      e.preventDefault();
      $('#btnQualidadeEditar').click();
    }
  });

  $('#btnLimparFiltros').on('click', async function () {
    await setarDataAtual('dtCadastroDe');
    await setarDataAtual('dtCadastroAte');
    $('#txtLancamentoPesquisa').val('')
    $('#txtDeposito').val('')
    $('#txtSetor').val('')
    $('#txtGrupoMA').val('')
    $('#txtSubGrupo').val('')
    $('#txtLinha').val('')
    $('#txtProduto').val('')
    $('#txtCor').val('')
    $('#txtQualidade').val('')
    $('#txtLote').val('')
  })

  async function consultaInventarioMat() {
    try {
      $.LoadingOverlay("show");
      const dtCadastroDe = "'" + $('#dtCadastroDe').val() + "'";
      const dtCadastroAte = "'" + $('#dtCadastroAte').val() + "'";
      let lancamento = $('#txtLancamentoPesquisa').val() != '' ? ` AND INVENTARIO.LANCAMENTO = '${$('#txtLancamentoPesquisa').val()}'` : '';
      let produto = pegaChave('#txtProduto') != '' ? ` AND INVENTARIO.CODIGO = '${pegaChave('#txtProduto')}'` : '';
      let deposito = pegaChave('#txtDeposito') != '' ? ` AND INVENTARIO.DEPOSITO = '${pegaChave('#txtDeposito')}'` : '';
      let setor = pegaChave('#txtSetor') != '' ? ` AND INVENTARIO.CODSETOR = '${pegaChave('#txtSetor')}'` : '';
      let cor = pegaChave('#txtCor') != '' ? ` AND INVENTARIO.COR = '${pegaChave('#txtCor')}'` : '';
      let tipo = $('#radioMaterial').is(':checked') ? ` AND INVENTARIO.TIPO_IT = 'M'` : ` AND INVENTARIO.TIPO_IT = 'P'`;

      let grupo = pegaChave('#txtGrupoMA') != '' ? ` AND INVENTARIO.GRUPO = '${pegaChave('#txtGrupoMA')}'` : '';
      let subGrupo = pegaChave('#txtSubGrupo') != '' ? ` AND INVENTARIO.SUB_GRUPO = '${pegaChave('#txtSubGrupo')}'` : '';
      let linha = pegaChave('#txtLinha') != '' ? ` AND INVENTARIO.LINHA = '${pegaChave('#txtLinha')}'` : '';
      let qualidade = pegaChave('#txtQualidade') != '' ? ` AND INVENTARIO.QUALIDADE = '${pegaChave('#txtQualidade')}'` : '';
      let lote = pegaChave('#txtLote') != '' ? ` AND INVENTARIO.LOTE = '${pegaChave('#txtLote')}'` : '';

      if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
        msgAlerta('Informe uma data para consultar!')
        return;
      }

      let obj = {
        tabela: "INVENTARIO",
        camposSelect: ["INVENTARIO.TIPO_IT", "INVENTARIO.CHAVE", "INVENTARIO.LANCAMENTO", "INVENTARIO.CODIGO", "INVENTARIO.DESCRICAO", "MATERIAL.CODIGO2", "INVENTARIO.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO",
          "INVENTARIO.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "INVENTARIO.TAM", "INVENTARIO.CODSETOR", "CADFLUXO.DESCRICAO DESC_SETOR",
          "INVENTARIO.COR", "CADCOR.DESCRICAO DESC_COR", "INVENTARIO.QTDE", "INVENTARIO.PRECO", "INVENTARIO.PRECO_DIV",
          "INVENTARIO.PRECO_COR", "INVENTARIO.DT_MES", "INVENTARIO.LOTE", "INVENTARIO.QUALIDADE", "TABQUL.DESCRICAO DESC_QUALIDADE",
          "INVENTARIO.GRUPO", "GRUPO_MA.DESCRICAO DESC_GRUPO", "INVENTARIO.SUB_GRUPO", "SUBGRUPO_MA.DESCRICAO DESC_SUBGRUPO",
          "INVENTARIO.LINHA", "TABLIN.DESCRICAO DESC_LINHA"],
        leftJoin: [
          { tabela: "MATERIAL", condicao: "MATERIAL.CODIGO = INVENTARIO.CODIGO" },
          { tabela: "GRUPO_MA", condicao: "GRUPO_MA.CODIGO = INVENTARIO.GRUPO" },
          { tabela: "SUBGRUPO_MA", condicao: "SUBGRUPO_MA.CODIGO = INVENTARIO.SUB_GRUPO" },
          { tabela: "TABLIN", condicao: "TABLIN.CODIGO = INVENTARIO.LINHA" },
          { tabela: "TABQUL", condicao: "TABQUL.CODIGO = INVENTARIO.QUALIDADE" },
          { tabela: "DEPOSITO", condicao: "DEPOSITO.CODIGO = INVENTARIO.DEPOSITO" },
          { tabela: "CADCOR", condicao: "CADCOR.COR = INVENTARIO.COR" },
          { tabela: "CADFLUXO", condicao: "CADFLUXO.CODIGO = INVENTARIO.CODSETOR" },
        ],
        where: [`(INVENTARIO.DT_MES >= ${dtCadastroDe} and INVENTARIO.DT_MES <= ${dtCadastroAte}) AND TP_INV IN ('I', 'M') ${lancamento} ${produto} ${deposito} ${setor} ${cor} ${tipo} ${grupo} ${subGrupo} ${linha} ${qualidade} ${lote}`]
      }

      const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON=${JSON.stringify(obj)}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaInventario').DataTable({
        destroy: true,
        lengthChange: false,
        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [
          { "data": "TIPO_IT", "title": "Tipo" },
          { "data": "CHAVE", "title": "Chave" },
          { "data": "LANCAMENTO", "title": "Lançamento" },
          { "data": "CODIGO", "title": "Código" },
          { "data": "DESCRICAO", "title": "Descrição" },
          { "data": "CODIGO2", "title": "Código2" },
          { "data": "DEPOSITO", "title": "Depósito" },
          { "data": "DESC_DEPOSITO", "title": "Desc_depósito" },
          { "data": "LOTE", "title": "Lote" },
          { "data": "TAM", "title": "Tamanho" },
          { "data": "COR", "title": "Cor" },
          { "data": "DESC_COR", "title": "Desc_Cor" },
          { "data": "CODSETOR", "title": "Setor" },
          { "data": "DESC_SETOR", "title": "Desc_Setor" },
          { "data": "QTDE", "title": "Qtde" },
          { "data": "QUALIDADE", "title": "Qualidade" },
          { "data": "DESC_QUALIDADE", "title": "Desc_Qualidade" },
          { "data": "GRUPO", "title": "Grupo" },
          { "data": "DESC_GRUPO", "title": "Desc_Grupo" },
          { "data": "SUB_GRUPO", "title": "SubGrupo" },
          { "data": "DESC_SUBGRUPO", "title": "Desc_SubGrupo" },
          { "data": "LINHA", "title": "Linha" },
          { "data": "DESC_LINHA", "title": "Desc_Linha" },
        ],
        "columnDefs": [
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          }
        ]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function consultaInventario(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      const dtCadastroDe = "'" + $('#dtCadastroDe').val() + "'";
      const dtCadastroAte = "'" + $('#dtCadastroAte').val() + "'";
      let lancamento = $('#txtLancamentoPesquisa').val() != '' ? ` AND INVENTARIO.LANCAMENTO = '${$('#txtLancamentoPesquisa').val()}'` : '';
      let produto = pegaChave('#txtProduto') != '' ? ` AND INVENTARIO.CODIGO = '${pegaChave('#txtProduto')}'` : '';
      let deposito = pegaChave('#txtDeposito') != '' ? ` AND INVENTARIO.DEPOSITO = '${pegaChave('#txtDeposito')}'` : '';
      let setor = pegaChave('#txtSetor') != '' ? ` AND INVENTARIO.CODSETOR = '${pegaChave('#txtSetor')}'` : '';
      let cor = pegaChave('#txtCor') != '' ? ` AND INVENTARIO.COR = '${pegaChave('#txtCor')}'` : '';
      let tipo = $('#radioMaterial').is(':checked') ? ` AND TIPO_IT = 'M'` : ` AND TIPO_IT = 'P'`;
      let tipoInv = ` AND INVENTARIO.TP_INV IN ('I', 'P')`;

      if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
        msgAlerta('Informe uma data para consultar!')
        return;
      }
      if (bBotao) {
        response = await requisicao(
          'GET',
          '/Sisplan/Funcoes/V1/pesquisa?',
          `JSON={"tabela": "INVENTARIO", "camposSelect": ["INVENTARIO.TIPO_IT", "INVENTARIO.CHAVE", "INVENTARIO.LANCAMENTO", "INVENTARIO.CODIGO", "PRODUTO.CODIGO2", "INVENTARIO.DESCRICAO", "INVENTARIO.DEPOSITO", "INVENTARIO.TAM", "INVENTARIO.CODSETOR", "INVENTARIO.COR", "CADCOR.DESCRICAO DESC_COR", "INVENTARIO.QTDE", "INVENTARIO.PRECO", "INVENTARIO.PRECO_DIV", "INVENTARIO.PRECO_COR", "INVENTARIO.DT_MES", "INVENTARIO.LOTE"], "where": ["(INVENTARIO.DT_MES >= ${dtCadastroDe} AND INVENTARIO.DT_MES <= ${dtCadastroAte}) ${tipoInv} ${lancamento} ${produto} ${deposito} ${setor} ${cor} ${tipo}"], "leftJoin": [{ "tabela": "PRODUTO", "condicao": "INVENTARIO.CODIGO = PRODUTO.CODIGO"}, { "tabela": "CADCOR", "condicao": "INVENTARIO.COR = CADCOR.COR"}]}`, null);
      } else {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"INVENTARIO", "camposSelect":["TIPO_IT", "DT_MES"], "where": null, "limit": 10000}', null);
      }

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaInventario').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [
          { "data": "TIPO_IT", "title": "Tipo" },
          { "data": "CHAVE", "title": "Chave" },
          { "data": "LANCAMENTO", "title": "Lançamento" },
          { "data": "CODIGO", "title": "Código" },
          { "data": "CODIGO2", "title": "Código 2" },
          { "data": "DESCRICAO", "title": "Descrição" },
          { "data": "TAM", "title": "Tamanho" },
          { "data": "COR", "title": "Cor" },
          { "data": "DESC_COR", "title": "Descrição Cor" },
          { "data": "CODSETOR", "title": "CodSetor" },
          { "data": "QTDE", "title": "Quantidade" },
        ],
        "columnDefs": [{
          targets: [1], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function buscaDadosItem(chave) {
    const pesquisa = {
      tabela: "INVENTARIO",
      camposSelect: ["TIPO_IT, CNPJ, CHAVE, LANCAMENTO, CODIGO, DESCRICAO, DEPOSITO, TAM, CODSETOR, COR, QTDE, PRECO, PRECO_DIV, PRECO_COR, DT_MES, LOTE, QUALIDADE, POSSE, UNIDADE, LOTE_INTERNO, TONALIDADE, BARRA, DT_FAB"],
      where: [`CHAVE = '${chave}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return jsonStr[0];
  }

  $('#txtPrecoEditar').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtPrecoCorEditar').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtPrecoDivEditar').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtQtdeEditar').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 6
  });

  $('#txtQtdeAuxEditar').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 6
  });

  $('#txtQtdeAuxEditar').on('blur', function () {
    const qtdeAtual = $('#txtQtdeAuxEditar').val()
    const rendimento = $('#txtRendimentoEditar').val()
    if (qtdeAtual != '') {
      const qtdeNova = qtdeAtual * rendimento
      $('#txtQtdeEditar').val(TruncaDecimaisNova(6, qtdeNova))
    }
  })

  $('#tabelaInventario').on('click', '#btn-editar', async function () {
    $('.controleBlur4').attr('disabled', false)
    try {
      try {
        $.LoadingOverlay("show");
        $('#modal-manutencao').modal('show');
        $('#txtLinhaEditada').val($(this).closest("tr")[0].rowIndex - 1);
        let tabela = $('#radioMaterial').is(':checked') ? 'MATERIAL' : 'PRODUTO'
        const data = $('#tabelaInventario').DataTable().row($(this).parents('tr')).data();

        const dadosItem = await buscaDadosItem(data.CHAVE)

        $('#txtChaveEditar').val(dadosItem.CHAVE);
        $('#txtLancamentoEditar').val(dadosItem.LANCAMENTO);
        insereValor('#txtCodigoEditar', dadosItem.CODIGO, { tabela: tabela, campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.CODIGO });
        insereValor('#txtDepositoEditar', dadosItem.DEPOSITO, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.DEPOSITO });
        insereValor('#txtCorEditar', dadosItem.COR, { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'COR', valorWhere: dadosItem.COR });
        insereValor('#txtTamEditar', dadosItem.TAM, { tabela: 'TABTAM', campoBusca: 'TAM', campoWhere: 'TAM', valorWhere: dadosItem.TAM });
        $('#txtLoteEditar').val(dadosItem.LOTE);
        insereValor('#txtSetorEditar', dadosItem.CODSETOR, { tabela: 'CADFLUXO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.CODSETOR });
        insereValor('#txtQualidadeEditar', dadosItem.QUALIDADE, { tabela: 'TABQUL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.QUALIDADE });
        $('#txtDataEditar').val(dadosItem.DT_MES.split(' ')[0]);
        $('#txtQtdeEditar').val(dadosItem.QTDE);
        $('#txtPrecoEditar').val(dadosItem.PRECO);
        $('#txtPrecoDivEditar').val(dadosItem.PRECO_DIV);
        $('#txtPrecoCorEditar').val(dadosItem.PRECO_COR);
        $('#txtCnpjEditar').val(dadosItem.CNPJ);
        $('#txtUnEditar').val(dadosItem.UNIDADE);
        $('#txtPosseEditar').val(dadosItem.POSSE);
        $('#txtLoteInternoEditar').val(dadosItem.LOTE_INTERNO);
        insereValor('#txtTonalidadeEditar', dadosItem.TONALIDADE, 'S');
        $('#txtBarraEditar').val(dadosItem.BARRA);
        $('#dtFabricacaoEditar').val(dadosItem.DT_FAB);

      } catch (error) {
        msgErro('Erro ao buscar dados da nota');
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  function limpaCampos() {
    $('#txtChaveEditar').val('');
    $('#txtLancamentoEditar').val('');
    $('#txtCodigoEditar').val('');
    $('#txtDepositoEditar').val('');
    $('#txtCorEditar').val('');
    $('#txtSetorEditar').val('');
    $('#txtTamEditar').val('');
    $('#txtLoteEditar').val('');
    $('#txtQtdeEditar').val('');
    $('#txtPrecoEditar').val('');
    $('#txtPrecoDivEditar').val('');
    $('#txtPrecoCorEditar').val('');
    $('#txtLinhaEditada').val('');
    $('#txtCnpjEditar').val('');
    $('#txtUnEditar').val('');
    $('#txtPosseEditar').val('');
    $('#txtQualidadeEditar').val('');
    $('#txtLoteInternoEditar').val('');
    $('#txtTonalidadeEditar').val('');
    $('#txtBarraEditar').val('');
    $('#txtQtdeAuxEditar').val('')
    $('#txtUnidadeAuxEditar').val('')
    $('#txtRendimentoEditar').val(0)
  }

  $('#modal-manutencao').on('hidden.bs.modal', async function (e) {
    $('.controleBlur').attr('disabled', true)
    $('.controleBlur2').attr('disabled', true)
    $('.controleBlur3').attr('disabled', true)
    $('.controleBlur4').attr('disabled', true)
    limpaCampos()
    await setarDataAtual('txtDataEditar');
    await setarDataAtual('dtFabricacaoEditar');

    $('#txtSetorEditar').attr('disabled', false)
    $('#btnSetorEditar').attr('disabled', false)
    $('#btnLimpaSetorEditar').attr('disabled', false)

    $('#txtDepositoEditar').attr('disabled', false)
    $('#btnDepositoEditar').attr('disabled', false)
    $('#btnLimpaDepositoEditar').attr('disabled', false)
  });

  $('#confirmar-dados').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {

        const linhaEditada = $('#txtLinhaEditada').val();
        const dataOld = $('#tabelaInventario').DataTable().row(linhaEditada).data();

        dataOld.CHAVE = $('#txtChaveEditar').val();
        dataOld.CODIGO = pegaChave('#txtCodigoEditar');
        dataOld.DEPOSITO = pegaChave('#txtDepositoEditar');
        dataOld.COR = pegaChave('#txtCorEditar');
        dataOld.TAM = pegaChave('#txtTamEditar');
        dataOld.DT_MES = $('txtDataEditar').val();
        dataOld.CODSETOR = pegaChave('#txtSetorEditar');
        dataOld.LOTE = $('#txtLoteEditar').val();
        dataOld.QTDE = $('#txtQtdeEditar').val();
        dataOld.PRECO = $('#txtPrecoEditar').val();
        dataOld.PRECO_DIV = $('#txtPrecoDivEditar').val();
        dataOld.PRECO_COR = $('#txtPrecoCorEditar').val();
        dataOld.CNPJ = pegaChave('#txtCnpjEditar');
        dataOld.UNIDADE = $('#txtUnEditar').val();
        dataOld.POSSE = $('#txtPosseEditar').val();
        dataOld.QUALIDADE = pegaChave('#txtQualidadeEditar');
        dataOld.LOTE_INTERNO = $('#txtLoteInternoEditar').val();
        dataOld.TONALIDADE = pegaChave('#txtTonalidadeEditar');
        dataOld.BARRA = pegaChave('#txtBarraEditar');
        dataOld.DT_FAB = $('#dtFabricacaoEditar').val() ? $('#dtFabricacaoEditar').val() : $('#txtDataEditar').val();
        dataOld.TIPOIT = $('#radioMaterial').is(':checked') ? 'M' : 'P';

        // grava no banco com as informações novas  

        let response = await requisicao("POST", "/sisplan/inventario/v1/manutencaoinventario?", `JSON=${encodeURIComponent(JSON.stringify(dataOld))}`, null);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Cadastro efetuado com sucesso!')
        $('#btnConsultar').trigger('click');

      } catch (error) {

      }
    } finally {
      $('#modal-manutencao').modal('hide');
      $.LoadingOverlay("hide");
    }
  });

  async function verificaInventarioExistente() {
    try {
      $.LoadingOverlay('show')
      let where = ''

      where += ` AND DT_MES = '${$('#txtDataEditar').val()}'`
      where += ` AND DEPOSITO = '${pegaChave('#txtDepositoEditar')}'`
      where += ` AND CODIGO = '${pegaChave('#txtCodigoEditar')}'`
      where += ` AND COR = '${pegaChave('#txtCorEditar')}'`
      where += ` AND QUALIDADE = '${pegaChave('#txtQualidadeEditar')}'`
      where += ` AND LOTE = '${$('#txtLoteEditar').val().includes('[') ? pegaChave('#txtLoteEditar') : $('#txtLoteEditar').val()}'`

      const response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"INVENTARIO", "camposSelect":["CODIGO", "COR", "QUALIDADE", "LOTE", "DT_MES", "DEPOSITO"], "where":["1=1 ${where}"]}`,
        null);

      if (response.status !== 200) {
        throw msgAlerta('Não foi possível realizar a busca pelo item, verifique!')
      }

      const jsonStr = await response.json()
      if (jsonStr.RESULT[0].length) {
        return true
      } else {
        return false
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#confirmar-dadosincluir').on('click', async function () {
    if ($("#txtCodigoEditar").val() == "") {
      msgAlerta("Código não informado, favor verificar.");
      return;
    }
    if ($("#txtDepositoEditar").val() == "") {
      msgAlerta("Depósito não informado, favor verificar.");
      return;
    }
    if ($("#txtSetorEditar").val() == "") {
      msgAlerta("Setor não informado, favor verificar.");
      return;
    }
    if ($("#txtCorEditar").val() == "") {
      msgAlerta("Cor não informada, favor verificar.");
      return;
    }
    if ($("#txtDataEditar").val() == "") {
      msgAlerta("Data não informada, favor verificar.");
      return;
    }
    if ($("#txtTamEditar").val() == "" && $('#radioProduto').is(':checked')) {
      msgAlerta("Tamanho não informado, favor verificar.");
      return;
    }
    if ($("#txtQtdeEditar").val() == "") {
      msgAlerta("Quantidade não informado, favor verificar.");
      return;
    }
    if ($("#txtPrecoEditar").val() == "") {
      msgAlerta("Preço não informado, favor verificar.");
      return;
    }
    if ($("#txtCnpjEditar").val() == "") {
      msgAlerta("CNPJ não informado, favor verificar.");
      return;
    }
    if ($("#txtUnEditar").val() == "") {
      msgAlerta("Unidade não informado, favor verificar.");
      return;
    }
    if ($("#txtPosseEditar").val() == 0) {
      msgAlerta("Posse não informado, favor verificar.");
      return;
    } if ($("#txtQualidadeEditar").val() == 0) {
      msgAlerta("Qualidade não informada, favor verificar.");
      return;
    }

    const bExiste = await verificaInventarioExistente()
    if (bExiste) {
      throw msgAlerta('Item já existe em inventário para esta data, verifique!')
    }

    try {
      $.LoadingOverlay("show");
      try {
        let lote = ''
        if ($('#txtLoteEditar').val().includes('[')) {
          lote = pegaChave('#txtLoteEditar')
        } else {
          lote = $('#txtLoteEditar').val()
        }
        const envio = {
          CHAVE: pegaChave('#txtChaveEditar') == '' ? 0 : $('#txtChaveEditar').val(),
          CODIGO: pegaChave('#txtCodigoEditar'),
          DESCRICAO: pegaDescricao('#txtCodigoEditar'),
          DEPOSITO: pegaChave('#txtDepositoEditar'),
          COR: pegaChave('#txtCorEditar'),
          TAMANHO: pegaChave('#txtTamEditar'),
          LOTE: lote,
          CODSETOR: pegaChave('#txtSetorEditar'),
          SETOR: pegaDescricao('#txtSetorEditar'),
          DT_MES: $('#txtDataEditar').val(),
          QTDE: $('#txtQtdeEditar').val(),
          PRECO: $('#txtPrecoEditar').val(),
          PRECO_DIV: $('#txtPrecoDivEditar').val(),
          PRECO_COR: $('#txtPrecoCorEditar').val(),
          LANCAMENTO: pegaChave('#txtLancamentoEditar'),
          CNPJ: pegaDescricao('#txtCnpjEditar'),
          UNIDADE: $('#txtUnEditar').val(),
          POSSE: $('#txtPosseEditar').val(),
          TP_INV: 'I',
          TIPOIT: $('#radioMaterial').is(':checked') ? 'M' : 'P',
          QUALIDADE: pegaChave('#txtQualidadeEditar'),
          LOTE_INTERNO: $('#txtLoteInternoEditar').val(),
          TONALIDADE: pegaChave('#txtTonalidadeEditar'),
          DT_FAB: $('#dtFabricacaoEditar').val() ? $('#dtFabricacaoEditar').val() : $('#txtDataEditar').val(),
          BARRA: $('#txtBarraEditar').val(),
          GRUPO: (await buscaValor("MATERIAL", "GRUPO", "CODIGO", pegaChave('#txtCodigoEditar'))).GRUPO,
          SUBGRUPO: (await buscaValor("MATERIAL", "SUB_GRUPO", "CODIGO", pegaChave('#txtCodigoEditar'))).SUB_GRUPO,
          LINHA: (await buscaValor("MATERIAL", "LINHA", "CODIGO", pegaChave('#txtCodigoEditar'))).LINHA,
        }

        const retorno = await requisicao(
          "POST",
          "/sisplan/inventario/v1/manutencaoinventario?",
          '',
          `JSON=${JSON.stringify(envio)}`,
          900000
        );
        if (retorno.status != 200) {
          return msgAlerta('Não foi possível gravar a manutenção, verifique!')
        }
        if (retorno.status === 200) {
          criaMensagemSucesso('Cadastro efetuado com sucesso!');
        }
      } catch (error) {
        msgAlerta(error)
      }
    } finally {
      $('#modal-manutencao').modal('hide');
      $.LoadingOverlay("hide");
      limpaCampos()
      await setarDataAtual('txtDataEditar');
      await setarDataAtual('dtFabricacaoEditar');
      $('#btnConsultar').trigger('click')
    }
  });

  $('#tabelaInventario').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaInventario").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  function retornaParams() {
    const dtCadastroDe = $('#dtCadastroDe').val();
    const dtCadastroAte = $('#dtCadastroAte').val();

    if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
      msgAlerta('Informe uma data para consultar!')
      return;
    }
    let lancamento = $('#txtLancamentoPesquisa').val();
    let deposito = pegaChave('#txtDeposito');
    let setor = pegaChave('#txtSetor');
    let codigo = pegaChave('#txtProduto');
    let cor = pegaChave('#txtCor');
    let qualidade = pegaChave('#txtQualidade');
    let lote = pegaChave('#txtLote');

    const grupo = $('#txtGrupoMA').val() ? pegaChave('#txtGrupoMA') : $('#txtGrupo').val() ? pegaChave('#txtGrupo') : ''
    let subGrupo = pegaChave('#txtSubGrupo');
    let linha = pegaChave('#txtLinha');
    const tipoItem = $('#radioMaterial').is(':checked') ? 'M' : 'P'

    return `DT_MESI=${dtCadastroDe}` +
      `&DT_MESF=${dtCadastroAte}` +
      `&LANCAMENTO=${lancamento}` +
      `&DEPOSITO=${deposito}` +
      `&SETOR=${setor}` +
      `&CODIGO=${codigo}` +
      `&COR=${cor}` +
      `&QUALIDADE=${qualidade}` +
      `&LOTE=${lote}` +
      `&GRUPO=${grupo}` +
      `&SUB_GRUPO=${subGrupo}` +
      `&LINHA=${linha}` +
      `&TIPO_ITEM=${tipoItem}`;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const params = retornaParams()
      const url = `/sisplan/impressao/v1/manutencao_inventario?${params}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('ManutencaoInventario');
      const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'ManutencaoInventario');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/inventario/v1/manutencaoinventario?", `CHAVE=${valorLinha.CHAVE}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  await setarDataAtual('dtCadastroDe');
  await setarDataAtual('dtCadastroAte');

  adicionaPesquisaCampos()
});
