$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#tutorialFiltros',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar a solicitação de compra a ser liberada.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta da solicitação de compra.',
          position: 'left'
        }
      },
      {
        element: '#tutorialTabelaSolicitacoes',
        popover: {
          title: 'Tabela de Registros',
          description: 'Este são os itens referente a solicitação.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  function pesquisaAutoCompleta() {
    $('#txtNumero').pesquisa_variosServerside(1, `{ "tabela":"SOL_COMPRA", "camposSelect":["NUMERO", "USUARIO"], "where": null}`, "NUMERO", "USUARIO")
    $('#btnNumero').pesquisa_serversideSel('#txtNumero', `{ "tabela":"SOL_COMPRA", "camposSelect":["NUMERO", "USUARIO", "SOLICITANTE", "DATA", "ENTREGA", "STATUS", "TIPO"], "where": null}`, 'Pesquisa Solicitação de Compra');
    $('#btnLimpaNumero').on('click', function () { $('#txtNumero').empty().trigger('change') })

    $('#txtCentroCusto').pesquisa_variosServerside(1, `{ "tabela":"CENTROCUSTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, "CODIGO", "DESCRICAO")
    $('#btnCentroCusto').pesquisa_serversideSel('#txtCentroCusto', `{ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Centro de Custo');
    $('#btnLimpaCentroCusto').on('click', function () { $('#txtCentroCusto').empty().trigger('change') })

    $('#txtSetor').pesquisa_variosServerside(1, `{ "tabela":"CADFLUXO", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, "CODIGO", "DESCRICAO")
    $('#btnSetor').pesquisa_serversideSel('#txtSetor', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Centro de Setor');
    $('#btnLimpaSetor').on('click', function () { $('#txtSetor').empty().trigger('change') })
    
    $('#txtSolicitante').pesquisa_variosServerside(1, `{ "tabela":"PESSOAL", "camposSelect":["CODIGO", "NOME"], "where": null}`, "CODIGO", "NOME")
    $('#btnSolicitante').pesquisa_serversideSel('#txtSolicitante', `{ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"], "where": null}`, 'Pesquisa Solicitante');
    $('#btnLimpaSolicitante').on('click', function () { $('#txtSolicitante').empty().trigger('change') })
    
    $('#txtPedido').pesquisa_variosServerside(3, `{ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME"], "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI= PEDIDO.CODCLI"}]}`, "NUMERO", "NOME")
    $('#btnPedido').pesquisa_serversideSel('#txtPedido', `{"tabela":"PEDIDO", "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME"],  "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "PEDIDO.CODCLI = ENTIDADE.CODCLI"}],  "where": null}`, 'Pesquisa de Pedido');
    $('#btnLimpaPedido').on('click', function () { $('#txtPedido').empty().trigger('change') })
    
    $('#txtNumOF').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["NUMERO", "CODIGO"], "where": null}`, "NUMERO", "CODIGO")
    $('#btnNumOF').pesquisa_serversideSel('#txtNumOF', `{ "tabela":"OF1", "camposSelect":[ "NUMERO", "CODIGO", "PERIODO", "PARTE", "TIPO"], "where": null}`, 'Pesquisa de OF');
    $('#btnLimpaNumOF').on('click', function () { $('#txtNumOF').empty().trigger('change') })

    $('#txtTipo').pesquisa_variosServerside(1, `{ "tabela":"TIPO", "camposSelect":["ID", "DESCRICAO"], "where": null}`, "ID", "DESCRICAO")
    $('#btnTipo').pesquisa_serversideSel('#txtTipo', `{ "tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}`, 'Pesquisa de Tipo');
    $('#btnTipo').on('click', function () { $('#txtTipo').empty().trigger('change') })
  }

  pesquisaAutoCompleta();

  $('#btnConsultar').on('click', async () => {
    await buscaSolicitacao()
  });


  async function buscaSolicitacao() {
    $.LoadingOverlay('show');
    try {
      const jsonStr = await retornaDados();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        $('#tabelaSc').DataTable().clear().draw();
        return;
      }

      let dataSetCols = [];

      const keys = Object.keys(jsonStr[0]);
      dataSetCols.push({
        'title': 'SEL',
        'data': 'SEL',
        'width': '15px'
      });

      dataSetCols[0].render = function (data, type, row, meta) {
        return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
      };

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $("#tabelaSc").DataTable({
        destroy: true,
        filter: false,
        lengthChange: false,
        serverside: false,
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        columnDefs: [
          {
            "type": 'date-br',
            "targets": [3, 10, 11],
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
        ],
      });

      $('.campoSel').on('click', function () {
        if (this.checked) {
          $(this).addClass('selecionado');
        } else {
          $(this).removeClass('selecionado');
        }
      });
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
    finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados() {
    try {
      let params = await buscaParametros();
      const response = await requisicao('GET', '/sisplan/liberacaosc/v1/liberacao?', params, '', 15000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return response.json();
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  }

  async function buscaParametros() {
    let pEmissaoDe = $('#txtEmissaoDe').val();
    let pEmissaoAte = $('#txtEmissaoAte').val();
    let pObs = pegaValor('#txtObs');
    let pNumero = await formataListas($('#txtNumero').val().toString());
    let pSetor = await formataListas($('#txtSetor').val().toString());
    let pSolicitante = await formataListas($('#txtSolicitante').val().toString());
    let pPedido = await formataListas($('#txtPedido').val().toString());
    let pTipo = await formataListas($('#txtTipo').val().toString());
    let pNumOf = await formataListas($('#txtNumOF').val().toString());
    let pCentroCusto = await formataListas($("#txtCentroCusto").val().toString());
    let pStatusLiberacao = isChecked('#rdLiberada') ? 1 : (isChecked('#rdBloqueada') ? 2 : (isChecked('#rdBloqDiretoria') ? 3 : 0));
    let pSituacao = isChecked('#rdSemOrdem') ? 1 : (isChecked('#rdComOrdem') ? 2 : 0);

    let retorno =
      `EMISSAODE=${pEmissaoDe}` +
      `&EMISSAOATE=${pEmissaoAte}` +
      `&NUMERO=${pNumero}` +
      `&SETOR=${pSetor}` +
      `&SOLICITANTE=${pSolicitante}` +
      `&PEDIDO=${pPedido}` +
      `&OBS=${pObs}` +
      `&TIPO=${pTipo}` +
      `&NUMOF=${pNumOf}` +
      `&CENTROCUSTO=${pCentroCusto}` +
      `&STATUSLIBERACAO=${pStatusLiberacao}` +
      `&SITUACAO=${pSituacao}`;
    return retorno;
  };

  // async function retornaFiltros() {
  //   return {
  //     // EMISSAODE: formataDataBonita($('#txtEmissaoDe').val()),
  //     // EMISSAOATE: formataDataBonita($('#txtEmissaoAte').val()),
  //     EMISSAODE: $('#txtEmissaoDe').val(), // Assumindo que pegaValor retorna a data no formato "aaaa-mm-dd"
  //     EMISSAOATE: $('#txtEmissaoAte').val(),
  //     NUMERO: pegaValor('#txtListaScs'),
  //     SETOR: pegaChave('#txtSetor'),
  //     SOLICITANTE: pegaChave('#txtSolicitante'),
  //     PEDIDO: pegaChave('#txtPedido'),
  //     OBS: pegaValor('#txtObs'),
  //     TIPO: pegaChave('#txtTipo'),
  //     NUMOF: pegaChave('#txtNumOF'),
  //     CENTROCUSTO: await formataListas($("#txtCentroCusto").val().toString()),
  //     STATUSLIBERACAO: isChecked('#rdLiberada') ? 1 : (isChecked('#rdBloqueada') ? 2 : (isChecked('#rdBloqDiretoria') ? 3 : 0)),
  //     SITUACAO: isChecked('#rdSemOrdem') ? 1 : (isChecked('#rdComOrdem') ? 2 : 0),
  //   }
  // }

  $('#tabelaSc').on('dblclick', 'tr', async function () {
    $.LoadingOverlay('show');
    try {
      $('.selected').removeClass('selected');
      $(this).closest('tr').addClass('selected');
      await buscaItensSc($(this).closest('tr')[0].children[4].innerHTML);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-itens').modal('show');
      $('#tabelaItens').DataTable().columns.adjust().draw(false);
    }
  });

  async function retornaItens(sNumero) {
    let url = '/sisplan/liberacaosc/v1/itenssolicitacao?';

    let jsonStr = [];
    try {
      const filtros = { NUMERO: `${sNumero}` }
      const response = await requisicao('GET', url, `JSON=${JSON.stringify(filtros)}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return response.json();
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  }

  async function buscaItensSc(sNumero) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sNumero);
      insereItens(itens);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function insereItens(sDados) {
    const keys = Object.keys(sDados[0]);
    let dataSetCols = [];
    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    }

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    let materialItems = [];
    let produtoItems = [];
    let servicoItems = [];

    for (let item of sDados) {
      if (item.TP_ITEM === 'M') {
        materialItems.push(item);
      } else if (item.TP_ITEM === 'P') {
        produtoItems.push(item);
      } else if (item.TP_ITEM === 'S') {
        servicoItems.push(item);
      }
    }

    $("#tabelaMaterial").DataTable({
      destroy: true,
      lengthChange: false,
      serverside: false,
      filter: false,
      autoWidth: true,
      data: materialItems,
      columns: dataSetCols,
      columnDefs: [],
    });

    $("#tabelaProduto").DataTable({
      destroy: true,
      lengthChange: false,
      serverside: false,
      filter: false,
      autoWidth: true,
      data: produtoItems,
      columns: dataSetCols,
      columnDefs: [],
    });

    $("#tabelaServico").DataTable({
      destroy: true,
      lengthChange: false,
      serverside: false,
      filter: false,
      autoWidth: true,
      data: servicoItems,
      columns: dataSetCols,
      columnDefs: [],
    });
  }

  // Liberação

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrScs = [];

    $('.selecionado').closest('tr').map((index, item) => {
      arrScs.push({
        NUMERO: item.children[4].innerHTML,
      })
    });

    if (arrScs.length == 0) {
      msgAlerta('Nenhuma ordem de compra selecionada para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/liberacaosc/v1/liberacao?', '', JSON.stringify({ SCS: arrScs }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }



})