/* eslint-disable prefer-destructuring */
async function avancarPag() {
  if ($("#txtCodigo").val() == '') {
    $("#txtCodigo").val(0);
  }
  if ($("#txtMoeda").val() == '') {
    $("#txtMoeda").val(' ');
  }
  if ($("#txtClasse").val() == '') {
    $("#txtClasse").val(' ');
  }
  if ($("#txtHistorico").val() == '') {
    $("#txtHistorico").val(' ');
  }
}

$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          avancarPag();
          $('#avancar1').trigger('click');
        };
        if ((Element.node.id == 'avancar2')) {
          $('#avancar2').trigger('click');
        };
        if ((Element.node.id == 'avancar3')) {
          $('#avancar3').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'contas') {
          $('#voltar').trigger('click');
        }
        if (Element.node.id == 'tipoDep') {
          $('#voltar2').trigger('click');
        }
        if (Element.node.id == 'configuracao') {
          $('#voltar3').trigger('click');
        }
        if (Element.node.id == 'datatables') {
          $('#voltar4').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtClasse',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtHistorico',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#contas',
      popover: {
        title: 'Contas',
        description: 'Aqui estão as contas que podem ser configuradas.',
        position: 'top'
      }
    },
    {
      element: '#avancar2',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#configuracao',
      popover: {
        title: 'Configurações da Moeda',
        description: 'Aqui você selecionará algumas configurações.',
        position: 'top'
      }
    },
    {
      element: '#avancar3',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'top'
      }
    },
    {
      element: '#datatables',
      popover: {
        title: 'Condições e Contas',
        description: 'Aqui você poderá adicionar condições de pagamento e contas.',
        position: 'top'
      }
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a moeda.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtTaxaCartao').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtDescAut').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtDescMaximo').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtNrMaxParcelas').maskMoney({
    decimal: '',
    thousands: '',
    precision: 0
  });

  $('#txtTaxaAdm').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtValMinimo').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let moeda = parametros[parametros.length - 1];

  const paramECF = await CopiaParametro('VENDA', 8);

  async function conectaECF(ipInterno, ipExterno, chave) {
    let ipPorta = getCookie('conexao') == 'interna' ? ipInterno : ipExterno;
    let url = `/cupom/conectaecf?`;

    try {
      let response = await requisicao_ecf('POST', url, `ip_porta=${ipPorta}&chave=${chave}`, '', null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if ((jsonStr.valor.toUpperCase() != 'TRUE') && (jsonStr.valor.toUpperCase() != 'FALSE')) {
        setCookie('serie_ecf', jsonStr.valor);
        $('#txtSerie').val(jsonStr.valor);
      }

      if (response.status != 200) {
        msgErro('Não foi possível conectar com a ECF, tente novamente.');
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível conectar com a ECF, tente novamente.');
    }
  }

  if (paramECF == '1') {
    await conectaECF(ipInterno, ipExterno, basicAuth);
  } else {
    $('#addMoedaECF').addClass('d-none');
  }

  let contaFs = 1;

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('MOEDA', getCookie('usuario'), moeda);
    window.location.href = `${BASE_URI}/moeda`;
  });

  $('#tabelaCondicoesDePagamento').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
  });

  $('#tabelaContas').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
  });

  $('#tabelaMoedaECF').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
  });

  $(document).ready(function () {

    let currentFs; let nextFs; let previousFs; // fieldsets
    let opacity;

    $(".next").click(function () {

      if (($(this).attr('id') == 'avancar3') && ($('#tipoInteg').val() == '')) {
        msgAlerta('Necessário informar tipo de integração, favor verificar.', undefined, undefined, setaFocoInput);
        return;
      };

      contaFs += 1;

      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      // erros = validator.numberOfInvalids();

      if (erros == 0) {

        currentFs = $(this).parent();
        nextFs = $(this).parent().next();

        $("#progressbar li").eq($(".msfieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate({
          opacity: 0
        }, {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              'display': 'none',
              'position': 'relative'
            });
            nextFs.css({
              'opacity': opacity
            });
          },
          duration: 600
        });
      }
    });

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtMoeda: {
          required: true,
        },
        txtClasse: {
          required: true,
        },
        txtHistorico: {
          required: true,
        }
      },
      messages: {
        txtMoeda: {
          required: "Informe uma descrição válida.",
        },
        txtClasse: {
          required: "Informe uma classe válida."
        },
        txtHistorico: {
          required: "Informe um histórico válido."
        }

      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $(".previous").click(function () {

      contaFs -= 1;

      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();
      $("#progressbar li").eq($(".msfieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          previousFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    });

    $('.radio-group .radio').click(function () {
      $(this).parent().find('.radio').removeClass('selected');
      $(this).addClass('selected');
    });

    $(".submit").click(function () {
      return false;
    });
  });

  function setaFocoInput() {
    $('#tipoInteg').focus();
  }

  $('#txtCodigo').prop('disabled', true);

  $('#btnAbrirCondicao').on('click', function () {
    $('#modalCondicao-titulo').html('Adicionar condição de pagamento');
    $('#txtCondPagto').attr('disabled', false);
    $('#btn-CondPagto').attr('disabled', false);
    $('#btn-limpa-CondPagto').attr('disabled', false);
    $('#txtCondPagto').val('');
    $('#txtTaxaAdm').val(0);
    $('#txtValMinimo').val(0);
    $('#txtTrIndex').val('');
    $('#modalCondicao').modal('show');
  });

  $('#btn-limpa-CondPagto').on('click', function () {
    $('#txtCondPagto').val('');
  });

  $('#selectTipo').on('change', function () {
    const tipo = $(this).val()
    $('#aplicaDescValPag').prop('checked', false)
    if (tipo === '3') {
      $('#selectNenhum').addClass('d-none');
      $('label[for="aplicaDescValPag"]').addClass('d-none')
      if ($('#tipoInteg').val() == 0) {
        $('#tipoInteg').val('');
      }
    } else if (tipo === '0' || tipo === '5') {
      $('label[for="aplicaDescValPag"]').removeClass('d-none')
      $('#selectNenhum').removeClass('d-none');
    } else {
      $('#selectNenhum').removeClass('d-none');
      $('label[for="aplicaDescValPag"]').addClass('d-none')
    }
  });

  $('#btnAdicionar').on('click', async function () {
    const desc = $('#txtCondPagto').val();
    if (desc == '') {
      msgAlerta('Campo deve ser preenchido');
      return;
    }
    addValorCond();
    $('#txtCondPagto').val('');
    $('#txtTaxaAdm').val('0.00');
    $('#cbRestricao').prop('checked', false);
  });

  async function addValorCond() {
    const codCond = pegaChave('#txtCondPagto');
    const descCond = pegaDescricao('#txtCondPagto');
    const taxa = $('#txtTaxaAdm').val() == '' ? '0.00' : $('#txtTaxaAdm').val();
    const valorMinimo = $('#txtValMinimo').val() == '' ? '0.00' : $('#txtValMinimo').val();
    const restricao = $('#cbRestricao').is(':checked') ? 'S' : 'N'

    if ($('#txtTrIndex').val() != '') {
      const tr = $('#txtTrIndex').val();
      const data = $('#tabelaCondicoesDePagamento').DataTable().row(tr).data();
      data[2] = taxa;
      data[3] = valorMinimo;
      data[4] = restricao;
      $('#tabelaCondicoesDePagamento').DataTable().row(tr).data(data).draw(false);

    }
    else {
      $('#tabelaCondicoesDePagamento').DataTable().row.add([codCond, descCond, taxa, valorMinimo, restricao,
        '<div style="text-align:center; display: flex; gap: 2px;"> ' +
        '   <button class="btn btn-info btn-sm" id="btnAlterarCond" type="button"> ' +
        '      Alterar' +
        '   </button> ' +
        '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
        '      Excluir' +
        '   </button> ' +
        '</div>'
      ]).draw(false);
    };
    $('#modalCondicao').modal('hide');
  }

  $('#tabelaCondicoesDePagamento').on('click', '#btnAlterarCond', async function () {
    const data = $('#tabelaCondicoesDePagamento').DataTable().row($(this).parents('tr')).data();
    const tr = $(this).parents('tr')[0].rowIndex - 1;
    insereValor('#txtCondPagto', data[0], data[1]);
    $('#txtTaxaAdm').val(data[2]);
    $('#txtValMinimo').val(data[3]);
    data[4] === 'S' ? $('#cbRestricao').prop('checked', true) : $('#cbRestricao').prop('checked', false)
    $('#txtTrIndex').val(tr);

    $('#modalCondicao-titulo').html('Editar condição de pagamento');
    $('#txtCondPagto').attr('disabled', true);
    $('#btn-CondPagto').attr('disabled', true);
    $('#btn-limpa-CondPagto').attr('disabled', true);
    $('#modalCondicao').modal('show');

    // let table = $('#tabelaCondicoesDePagamento').DataTable();
    // table
    //   .row($(this).parents('tr'))
    //   .remove()
    //   .draw(false);
  });

  $('#tabelaCondicoesDePagamento').on('click', '#btnExluirCond', async function () {
    let table = $('#tabelaCondicoesDePagamento').DataTable();
    table
      .row($(this).parents('tr'))
      .remove()
      .draw(false);
  });

  $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "CODCOND chave", "descricao descricao"], "where": null}`);
  $('#txtContas').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "conta chave", "descricao descricao"], "where": null}`);
  $('#txtContasEmpresa').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "EMP_PAT chave", "emp_nome descricao"], "where": null}`);

  $('#btn-CondPagto').pesquisa_array(['#txtCondPagto', '#txtNrParcelasCondPagto'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
  $('#btn-Contas').pesquisa('#txtContas', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":["conta", "descricao"]}`, 'Pesquisa Conta', 'cadconta');
  $('#btnContasEmpresa').pesquisa('#txtContasEmpresa', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":["replace(emp_pat, '_', '') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');

  $('#txtContasEmpresa').change(async function () {
    valor = $('#txtContasEmpresa').val();
    $('#txtContasEmpresa').val(valor.replace('_', ''));
  });

  $('#btnAbrirContas').on('click', function () {
    $('#modalContas').modal('show');
  });

  $('#modalContas').on('hidden.bs.modal', function () {
    removeSelecaoTransferencia();
  });

  $('#btnAbrirMoedasECF').on('click', function () {
    insereValor('#txtMoedas', $('#txtCodigo').val(), $('#txtMoeda').val());
    $('#modalMoedaECF').modal('show');
  });



  $('#btn-limpa-Contas').on('click', function () {
    $('#txtContas').val('');
  });

  $('#btn-limpa-ContasEmpresa').on('click', function () {
    $('#txtContasEmpresa').val('');
  });

  $('#btnAdicionarContas').on('click', async function () {
    const desc = $('#txtContas').val();
    const emp = $('#txtContasEmpresa').val();
    const empTransferencia = $('#txtContasEmpresaTransferencia').val();
    const contaTransferencia = $('#txtContasTransferencia').val();
    if ((desc == '') || (emp == '')) {
      msgAlerta('Campo deve ser preenchido');
      return;
    }

    if ((contaTransferencia != '') && (empTransferencia == '')) {
      msgAlerta('Necessário informar a empresa de transferência.');
      return;
    }

    addValorContas();
    $('#txtContas').val('');
    $('#txtContasEmpresa').val('');
    $('#txtContasTransferencia').val('');
    $('#txtContasEmpresaTransferencia').val('');
    $('#txtChavePix').val('');
    removeSelecaoTransferencia();
  });

  function removeSelecaoTransferencia() {
    $('#radioTodos').prop('checked', false);
    $('#radioSaida').prop('checked', false);
    $('#radioEntrada').prop('checked', false);
  }

  async function addValorContas() {
    const empresa = pegaChave('#txtContasEmpresa').replace('_', '');
    const codContas = pegaChave('#txtContas');
    const descContas = pegaDescricao('#txtContas');
    const empresaTransferencia = pegaChave('#txtContasEmpresaTransferencia').replace('_', '');
    const codContasTransferencia = pegaChave('#txtContasTransferencia');
    const descContasTransferencia = pegaDescricao('#txtContasTransferencia');
    const chavePix = $('#txtChavePix').val();
    const transfere = retornaValorTransfere();

    $('#tabelaContas').DataTable().row.add([
      empresa,
      codContas,
      descContas,
      empresaTransferencia != '' ? empresaTransferencia : '',
      codContasTransferencia != '' ? codContasTransferencia : '',
      descContasTransferencia != '' ? descContasTransferencia : '',
      chavePix,
      transfere,
      '<div style="text-align:center;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnExluirContas" type="button"> ' +
      '      Excluir' +
      '   </button> ' +
      '</div>'
    ]).draw(false);
  };

  function retornaValorTransfere() {
    let valor = 'TRANSFERE';

    if (isChecked('#radioTodos')) {
      valor = 'NÃO TRANSFERE ENTRADA/SAÍDA';
    } else if (isChecked('#radioSaida')) {
      valor = 'NÃO TRANSFERE SAÍDA';
    } else if (isChecked('#radioEntrada')) {
      valor = 'NÃO TRANSFERE ENTRADA';
    }

    return valor;
  }

  function converteValorTransfere(valor) {
    const mapeamento = {
      'TRANSFERE': 'S',
      'NÃO TRANSFERE ENTRADA/SAÍDA': 'T',
      'NÃO TRANSFERE SAÍDA': 'N',
      'NÃO TRANSFERE ENTRADA': 'E'
    };

    return mapeamento[valor] || null;
  }

  $('#tabelaContas').on('click', '#btnExluirContas', async function () {
    let table = $('#tabelaContas').DataTable();
    table
      .row($(this).parents('tr'))
      .remove()
      .draw(false);
  });

  $('#btnAdicionarMoedaECF').on('click', async function () {
    const serie = $('#txtSerie').val();
    const moedas = pegaChave('#txtMoedas');
    const moedaECF = $('#txtMoedaECF').val();

    if ((serie === '') || (moedas === '') || (moedaECF === '')) {
      msgAlerta('Campo deve ser preenchido');
      return;
    }
    addMoedaECF();
    $('#txtMoedaECF').val('');
    $('#txtMoedas').val('');
    ;
  });

  async function addMoedaECF() {
    let serie = $('#txtSerie').val();
    const moedas = pegaChave('#txtMoedas');
    let moedaECF = $('#txtMoedaECF').val();

    $('#tabelaMoedaECF').DataTable().row.add([
      serie,
      moedas,
      moedaECF,
      '<div style="text-align:center;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnExluirMoedaECF" type="button"> ' +
      '      Excluir' +
      '   </button> ' +
      '</div>'
    ]).draw(false);
  };

  $('#tabelaMoedaECF').on('click', '#btnExluirMoedaECF', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let table = $('#tabelaMoedaECF').DataTable();
        const url = `/Sisplan/Cadastros/v1/ecfmoeda?`;
        const serie = table.row($(this).closest('tr')).data()[0];
        const codMoeda = table.row($(this).closest('tr')).data()[1];
        const moedaECF = table.row($(this).closest('tr')).data()[2];

        const response = await requisicao('DELETE', url, `serie_ecf=${serie}&moeda=${codMoeda}&moeda_ecf=${moedaECF}`, null);

        if (!response) {
          return;
        }
        if (response.status == 200) {
          toastr.success(
            'Moeda ECF excluída com sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning',
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          },
          ).css({
            'margin-top': '20%',
            width: '500px',
            'max-width': '500px',
          });

          table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
        } else {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtOperadora').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO chave", "descricao descricao"], "where": null}`);
  $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCond').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond chave", "descricao descricao"], "where": null}`);
  $('#txtContaDebito1').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtContaCredito1').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtContaJuros').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtContaDesc').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
  $('#txtBandeira').autocompleta(1, `JSON={ "tabela":"BANDEIRA", "camposSelect":[ "ID chave", "DESCRICAO descricao"], "where": null}`);
  $('#txtMoedas').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "codmoe chave", "descricao descricao"], "where": null}`);
  $('#txtContasCorrenteEmpresa').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "conta chave", "descricao descricao"], "where": null}`);
  $('#txtContasTransferencia').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "conta chave", "descricao descricao"], "where": null}`);
  $('#txtContasEmpresaTransferencia').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "EMP_PAT chave", "emp_nome descricao"], "where": null}`);

  $('#btn-ContasTransferencia').pesquisa('#txtContasTransferencia', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":["conta", "descricao"]}`, 'Pesquisa Conta', 'cadconta');
  $('#btn-limpa-ContasTransferencia').on('click', function () {
    $('#txtContasTransferencia').val('');
  });

  $('#btnContasEmpresaTransferencia').pesquisa('#txtContasEmpresaTransferencia', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":["replace(emp_pat, '_', '') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');
  $('#btn-limpa-ContasEmpresaTransferencia').on('click', function () {
    $('#txtContasEmpresaTransferencia').val('');
  });

  $('#btnContasCorrenteEmpresa').pesquisa('#txtContasCorrenteEmpresa', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":["conta", "descricao"]}`, 'Pesquisa Conta', 'cadconta');
  $('#btn-limpa-ContasTransferencia').on('click', function () {
    $('#txtContasCorrenteEmpresa').val('');
  });


  $('#btn-Moedas').pesquisa('#txtMoedas', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao"]}`, 'Pesquisa Moeda', 'moeda');
  $('#btn-limpa-Moedas').on('click', function () {
    $('#txtMoedas').val('');
  });

  $('#btnOperadora').pesquisa('#txtOperadora', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Operadora', 'entidade');
  $('#btnExcluiOperadora').on('click', function () {
    $('#txtOperadora').val('');
  });

  $('#btnClasseGerencial').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btnExcluiClasse').on('click', function () {
    $('#txtClasse').val('');
  });

  $('#btnHistorico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "descricao"]}`, 'Pesquisa Histórico', 'HISTCP');
  $('#btnExcluiHistorico').on('click', function () {
    $('#txtHistorico').val('');
  });

  $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
  $('#btnASituacao').on('click', function () {
    $('#txtSituacao').val('');
  });

  $('#btnCondPagamento').pesquisa_array(['#txtCond', '#txtNrParcelasCondPagto'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
  $('#btnACondicaoPagamento').on('click', function () {
    $('#txtCond').val('');
  });

  $('#btnContaDebito').pesquisa('#txtContaDebito1', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta Débito', 'CONTA_CONT');
  $('#btnAContaDebito').on('click', function () {
    $('#txtContaDebito1').val('');
  });

  $('#btnContaCredito').pesquisa('#txtContaCredito1', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta Crédito', 'CONTA_CONT');
  $('#btnAContaCredito').on('click', function () {
    $('#txtContaCredito1').val('');
  });

  $('#btnContaJuros').pesquisa('#txtContaJuros', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta Juros', 'CONTA_CONT');
  $('#btnAContaJuros').on('click', function () {
    $('#txtContaJuros').val('');
  });

  $('#btnContaDesc').pesquisa('#txtContaDesc', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta Desconto', 'CONTA_CONT');
  $('#btnAContaDesconto').on('click', function () {
    $('#txtContaDesc').val('');
  });

  $('#btnBanco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa Banco', 'CADBAN');
  $('#btnLimparBanco').on('click', function () {
    $('#txtBanco').val('');
  });

  $('#btnBandeira').pesquisa('#txtBandeira', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"BANDEIRA", "camposSelect":[ "ID", "DESCRICAO"]}`, 'Pesquisa Bandeira', 'BANDEIRA');
  $('#btnLimparBandeira').on('click', function () {
    $('#txtBandeira').val('');
  });

  componenteFiltro('moeda', true, false, 'MoedasBaixaRec');

  async function retornaDadosDaMoeda(codMoeda) {
    try {
      const url = '/sisplan/moeda/v1/consultamoeda?';
      const params = `moeda=${codMoeda}`;

      const response = await requisicao('GET', url, params, '', 30000);

      if (!response) {
        return;
      }
      const json = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return json[0];


    } catch (error) {
      console.error();
    }
  }

  if (moeda != '' && moeda != 'create') {

    $('#account').css('cursor', 'pointer');
    $('#payment').css('cursor', 'pointer');
    $('#personal').css('cursor', 'pointer');
    $('#confirm').css('cursor', 'pointer');

    // if (await liberarRegistro('MOEDA', moeda) == false) {
    //   window.location.href = '../moeda';
    // } else {

    try {
      $.LoadingOverlay("show");

      try {
        const classeMoeda = await retornaDadosDaMoeda(moeda);

        $('#txtCodigo').val(classeMoeda.CODMOE);
        $('#txtMoeda').val(classeMoeda.DESCRICAO);
        $('#txtObservacao').val(classeMoeda.OBSERVACAO);
        $('#txtMensagem').val(classeMoeda.MENSAGEM);
        $('#formaPagto').val(classeMoeda.FORMA_PAGTO);
        $('#bandCartao').val(classeMoeda.BANDEIRA);
        $('#tipoInteg').val(classeMoeda.TP_INTEGRACAO);
        $('#txtTaxaCartao').val(classeMoeda.TAXA != null ? classeMoeda.TAXA : '0.00');
        $('#txtDescAut').val(classeMoeda.DESC_AUTO != null ? classeMoeda.DESC_AUTO : '0.00');
        $('#txtDescMaximo').val(classeMoeda.DESCMAX != null ? classeMoeda.DESCMAX : '0.00');
        $('#txtNrMaxParcelas').val(classeMoeda.MAX_PARCELAS != null ? classeMoeda.MAX_PARCELAS : '0');


        insereValor('#txtOperadora', classeMoeda.CODCLI, classeMoeda.NOME_CLIENTE);
        insereValor('#txtBanco', classeMoeda.BANCO, classeMoeda.NOME_BANCO);
        insereValor('#txtClasse', classeMoeda.CLASSE, classeMoeda.DESC_CLASSE);
        insereValor('#txtHistorico', classeMoeda.CODHISTORICO, classeMoeda.DESC_HISTORICO);
        insereValor('#txtSituacao', classeMoeda.CODSIT, classeMoeda.DESC_SIT);
        if (classeMoeda.ID_BANDEIRA != null) {
          insereValor('#txtBandeira', classeMoeda.ID_BANDEIRA, classeMoeda.DESC_BANDEIRA);
        }

        if (classeMoeda.CODCOND == null) {
          $('#txtCond').val('');
        } else {
          insereValor('#txtCond', classeMoeda.CODCOND, classeMoeda.DESC_CONDI);
        }
        insereValor('#txtContaDebito1', classeMoeda.CONTA_D, classeMoeda.DESC_CONTA_CONT);

        try {
          let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CONTA_CONT", 
                        "camposSelect":["DESCRICAO"], 
                        "where": ["codigo = '${classeMoeda.CONTA_C}'"]}`, null);

          if (!responseClasse) {
            return;
          }
          let jsonStrClasse = await responseClasse.json();
          if (responseClasse.status != 200) {
            msgErro(jsonStrClasse.RESULT[0].mensagem);
            return;
          }
          if (jsonStrClasse.RESULT[0][0]) {
            insereValor('#txtContaCredito1', classeMoeda.CONTA_C, jsonStrClasse.RESULT[0][0].DESCRICAO);
          }
        } catch (error) {
          console.error(error);
        }

        try {
          let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CONTA_CONT", 
                        "camposSelect":["DESCRICAO"], 
                        "where": ["codigo = '${classeMoeda.CONTA_JUROS}'"]}`, null);

          if (!responseClasse) {
            return;
          }
          let jsonStrClasse = await responseClasse.json();
          if (responseClasse.status != 200) {
            msgErro(jsonStrClasse.RESULT[0].mensagem);
            return;
          }
          if (jsonStrClasse.RESULT[0][0]) {
            insereValor('#txtContaJuros', classeMoeda.CONTA_JUROS, jsonStrClasse.RESULT[0][0].DESCRICAO);
          }
        } catch (error) {
          console.error(error);
        }

        try {
          let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CONTA_CONT", 
                        "camposSelect":["DESCRICAO"], 
                        "where": ["codigo = '${classeMoeda.CONTA_DESCONTO}'"]}`, null);

          if (!responseClasse) {
            return;
          }
          let jsonStrClasse = await responseClasse.json();
          if (responseClasse.status != 200) {
            msgErro(jsonStrClasse.RESULT[0].mensagem);
            return;
          }
          if (jsonStrClasse.RESULT[0][0]) {
            insereValor('#txtContaDesc', classeMoeda.CONTA_DESCONTO, jsonStrClasse.RESULT[0][0].DESCRICAO);
          }
        } catch (error) {
          console.error(error);
        }

        if (!!classeMoeda.MOEDA_BAIXAREC) {
          const responseMoeda = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "MOEDA", "camposSelect": ["CODMOE", "DESCRICAO"], "where": ["CODMOE IN (${classeMoeda.MOEDA_BAIXAREC})"]}`)

          if (!responseMoeda) {
            return;
          }

          const jsonMoeda = await responseMoeda.json();
          if (responseMoeda.status != 200) {
            msgAlerta(jsonMoeda.RESULT[0].mensagem);
            return;
          }

          await insereValorPesquisaVarios('txtMoedasBaixaRec', 'CODMOE', 'DESCRICAO', jsonMoeda.RESULT[0]);
        }

        $('#selectTipo').val(classeMoeda.TIPO);
        // if (classeMoeda.TIPO == "0") {
        //   $('#radioNormal').prop('checked', true);
        // }

        // if (classeMoeda.TIPO == "1") {
        //   $('#radioCheque').prop('checked', true);
        // }

        // if (classeMoeda.TIPO == "2") {
        //   $('#radioCrediario').prop('checked', true);
        // }

        // if (classeMoeda.TIPO == "3") {
        //   $('#radioCartao').prop('checked', true);
        // }

        if (classeMoeda.TIPO_CARTAO == "0") {
          $('#radioCredito').prop('checked', true);
        }

        if (classeMoeda.TIPO_CARTAO == "1") {
          $('#radioDebito').prop('checked', true);
        }

        if (classeMoeda.BAIXA == "1") {
          $('#baixaReceber').prop('checked', true);
        }

        if (classeMoeda.BAIXA_VENCTO == "S") {
          $('#baixaReceberDtVenc').prop('checked', true);
        }

        if (classeMoeda.MODORAPIDO == "S") {
          $('#modoRapido').prop('checked', true);
        }

        if (classeMoeda.GERA_TROCO == "S") {
          $('#moedaTroco').prop('checked', true);
        }

        if (classeMoeda.IMP_GERENCIAL == "S") {
          $('#imprimeRel').prop('checked', true);
        }

        if (classeMoeda.IMP_CARNE == "S") {
          $('#imprimeCarne').prop('checked', true);
        }

        if (classeMoeda.CONT_LIM_FAT == "S") {
          $('#controlaLim').prop('checked', true);
        }

        if (classeMoeda.TEF == "S") {
          $('#comunicTef').prop('checked', true);
        }

        if (classeMoeda.USA_ADM_CARTAO == "S") {
          $('#utilAdm').prop('checked', true);
        }

        if (classeMoeda.RECRIA_DUPL_FAT == "S") {
          $('#recriaDup').prop('checked', true);
        }

        if (classeMoeda.BAIXA_ANTE == "S") {
          $('#habBaixar').prop('checked', true);
        }

        if (classeMoeda.NAO_GERA_RECEBER == "S") {
          $('#naoGeraContas').prop('checked', true);
        }

        if (classeMoeda.CARTAO_PRESENTE == "S") {
          $('#cartaoPres').prop('checked', true);
        }

        if (classeMoeda.OBRIGA_DOC_FISCAL == "S") {
          $('#obrigaDocFiscal').prop('checked', true);
        }
        if (classeMoeda.ATIVO == "S") {
          $('#moedaAtivo').prop('checked', true);
        }
        if (classeMoeda.APLICA_DESC_PAG == "S") {
          $('#aplicaDescValPag').prop('checked', true);
        }
        if (classeMoeda.CONT_ITEM_BRINDE == "S") {
          $('#itemBrinde').prop('checked', true);
        }

        try {
          let response1 = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"COND_MOEDA",
                        "camposSelect":["CONDICAO.CODCOND", "CONDICAO.DESCRICAO", "COND_MOEDA.TAXA", "COND_MOEDA.VALOR_MINIMO", "COND_MOEDA.RESTRICAO"],
                        "innerJoin": [{"tabela": "CONDICAO",
                        "condicao": "cond_moeda.CODCOND = condicao.CODCOND"}],
                        "where": ["COND_MOEDA.MOEDA = '${moeda}'"],
                        "orderBy": ["CONDICAO.NRPAR", "CONDICAO.CODCOND"]}`, null);

          if (!response1) {
            return;
          }
          let jsonStr1 = await response1.json();
          if (response1.status != 200) {
            msgErro(jsonStr1.RESULT[0].mensagem);
            return;
          }

          let listaCond = jsonStr1;

          for (let i = 0; i < listaCond.RESULT[0].length; i++) {
            $('#tabelaCondicoesDePagamento').DataTable().row.add([
              listaCond.RESULT[0][i].CODCOND,
              listaCond.RESULT[0][i].DESCRICAO,
              listaCond.RESULT[0][i].TAXA != '' && listaCond.RESULT[0][i].TAXA != undefined ? (listaCond.RESULT[0][i].TAXA) : listaCond.RESULT[0][i].TAXA,
              listaCond.RESULT[0][i].VALOR_MINIMO != '' && listaCond.RESULT[0][i].VALOR_MINIMO != undefined ? (listaCond.RESULT[0][i].VALOR_MINIMO) : listaCond.RESULT[0][i].VALOR_MINIMO,
              listaCond.RESULT[0][i].RESTRICAO != '' ? listaCond.RESULT[0][i].RESTRICAO : 'N',
              '<div style="text-align:center; display: flex; gap: 2px;"> ' +
              '   <button class="btn btn-info btn-sm" id="btnAlterarCond" type="button"> ' +
              '      Alterar' +
              '   </button> ' +
              '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
              '      Excluir' +
              '   </button> ' +
              '</div>'
            ]).draw(false);
          }

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados da região: ${error}`);
        }

        const caseTransfere = `CASE ` +
          `WHEN MOEDA_CONTA.TRANSFERE = 'T' THEN 'NÃO TRANSFERE ENTRADA/SAÍDA' ` +
          `WHEN MOEDA_CONTA.TRANSFERE = 'N' THEN 'NÃO TRANSFERE SAÍDA' ` +
          `WHEN MOEDA_CONTA.TRANSFERE = 'E' THEN 'NÃO TRANSFERE ENTRADA' ` +
          `ELSE 'TRANSFERE' ` +
          `END TRANSFERE `;

        try {
          let response2 = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"MOEDA_CONTA", 
                        "camposSelect":["moeda_conta.EMPRESA", "cadconta.CONTA", "moeda_conta.CONTA_TRANSF", "(CASE WHEN moeda_conta.CONTA_TRANSF IS NOT NULL THEN (SELECT MAX(CONTA.DESCRICAO) DESCRICAO FROM CADCONTA_001 CONTA WHERE CONTA.CONTA = MOEDA_CONTA.CONTA_TRANSF) END) AS DESCRICAO_TRANSFERENCIA", "moeda_conta.EMP_TRANSF", "cadconta.DESCRICAO", "MOEDA_CONTA.CHAVE_PIX", "${caseTransfere}"], 
                        "innerJoin": [{"tabela": "CADCONTA", 
                        "condicao": "cadconta.CONTA = moeda_conta.CONTA"}], 
                        "where": ["MOEDA_CONTA.MOEDA = '${moeda}'"]}`, null);
          if (!response2) {
            return;
          }
          let jsonStr2 = await response2.json();
          if (response2.status != 200) {
            msgErro(jsonStr2.RESULT[0].mensagem);
            return;
          }

          let listaConta = jsonStr2;

          for (let i = 0; i <= listaConta.RESULT[0].length; i++) {
            if (listaConta.RESULT[0][i]) {
              $('#tabelaContas').DataTable().row.add([
                listaConta.RESULT[0][i].EMPRESA,
                listaConta.RESULT[0][i].CONTA,
                listaConta.RESULT[0][i].DESCRICAO,
                listaConta.RESULT[0][i].EMP_TRANSF,
                listaConta.RESULT[0][i].CONTA_TRANSF,
                listaConta.RESULT[0][i].DESCRICAO_TRANSFERENCIA,
                listaConta.RESULT[0][i].CHAVE_PIX,
                listaConta.RESULT[0][i].TRANSFERE,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm" id="btnExluirContas" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
              ]).draw(false);
            }
          }

        } catch (error) {
          console.error(error);
        }

        if (paramECF == '1') {
          try {
            response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={"tabela":"MOEDA_ECF", "camposSelect":["SERIE_ECF","MOEDA_ECF", "MOEDA"], "where": ["MOEDA = '''${moeda}'''"]}`, null);

            if (!response) {
              return;
            }
            jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.RESULT[0][0].mensagem);
              return;
            }

            let moedaECF = jsonStr;

            for (let i = 0; i < moedaECF.RESULT[0].length; i++) {
              $('#tabelaMoedaECF').DataTable().row.add([
                moedaECF.RESULT[0][i].SERIE_ECF,
                moedaECF.RESULT[0][i].MOEDA,
                moedaECF.RESULT[0][i].MOEDA_ECF,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm btnExluirMoedaECF" id="btnExluirMoedaECF" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
              ]).draw(false);
            }

          } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados da MoedaECF: ${error}`);
          }
        }

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados da região: ${error}`);
      }

    } finally {
      $.LoadingOverlay('hide');
    }
    // }

  };

  $('#account').on('click', function () {
    if (moeda != 'create') {
      if (contaFs == 2) {
        $('#voltar').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltar3').trigger('click');
        $('#voltar').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
        $('#voltar3').trigger('click');
        $('#voltar').trigger('click');
      }
    }
  });

  $('#payment').on('click', function () {
    if (moeda != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltar3').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
        $('#voltar3').trigger('click');
      }
    }
  });

  $('#personal').on('click', function () {
    if (moeda != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancar2').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
      }
      if (contaFs == 2) {
        $('#avancar2').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
      }
    }
  });

  $('#confirm').on('click', function () {
    if (moeda != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
        $($('fieldset')[1]).css('display', 'none');
      }
      if (contaFs == 2) {
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
        $($('fieldset')[1]).css('display', 'none');
      }
      if (contaFs == 3) {
        $('#avancar3').trigger('click');
      }
    }
  });

  $("#gravar").click(async function () {
    $("#gravar").prop('disabled', true);
    try {

      let validator = $("#msform").validate()
      validator.form()
      let erros = validator.numberOfInvalids()

      if (erros && erros > 0) {
        for (e in validator.invalid) {
          const campo = $(`#${e}`).attr('placeholder')
          msgErro(`${campo} não informado(a), impossível continuar.`)
          return
        }
        return
      }

      const TIPO_PIX = '5';
      const PIX_INFORMADO = $('#tabelaContas').DataTable().data().toArray().filter(conta => conta[6] !== '').length > 0;

      if (($('#selectTipo').val() == TIPO_PIX) && (!PIX_INFORMADO)) {
        msgErro('Moeda do tipo PIX, necessário informar uma chave_pix nas contas da moeda.');
        return;
      }

      const codmoe = $('#txtCodigo').val() == '' ? await RetornaProximo('MOEDA', 'MOEDA', 'CODMOE', 6) : $('#txtCodigo').val()

      const arrayContas = [];


      for (let index = 0; index < $('#tabelaContas').DataTable().rows().count(); index++) {
        const data = $('#tabelaContas').DataTable().row(index).data();
        const conta = {
          MOEDA: codmoe,
          CONTA: data[1],
          EMPRESA: data[0],
          EMP_TRANSF: data[3],
          CONTA_TRANSF: data[4],
          CHAVE_PIX: data[6],
          TRANSFERE: converteValorTransfere(data[7])
        };
        arrayContas.push(conta);
      }

      if (arrayContas.length === 0) {
        msgErro('Nenhuma conta adicionada, impossível continuar.')
        return
      }


      $.LoadingOverlay("show");
      let moedaClasse = {};

      moedaClasse.CODMOE = codmoe
      moedaClasse.DESCRICAO = $('#txtMoeda').val();
      moedaClasse.ABREV = $('#txtMoeda').val().substr(0, 2).toUpperCase();
      moedaClasse.CODCLI = pegaChave($('#txtOperadora').val(), moedaClasse.CODCLI);
      moedaClasse.CLASSE = pegaChave($('#txtClasse').val(), moedaClasse.CLASSE);
      moedaClasse.HISTORICO = pegaChave($('#txtHistorico').val(), moedaClasse.HISTORICO);
      moedaClasse.CODSIT = pegaChave($('#txtSituacao').val(), moedaClasse.CODSIT);
      moedaClasse.BANCO = pegaChave($('#txtBanco').val(), moedaClasse.BANCO);

      if (($('#txtCond').val() == '')) {
        moedaClasse.CDCONDI = -1;
      } else {
        moedaClasse.CDCONDI = pegaChave($('#txtCond').val(), moedaClasse.CDCONDI);
      }

      moedaClasse.OBSERVACAO = $('#txtObservacao').val();
      moedaClasse.MENSAGEM = $('#txtMensagem').val();
      moedaClasse.CONTA_D = pegaChave($('#txtContaDebito1').val(), moedaClasse.CONTA_D);
      moedaClasse.CONTA_C = pegaChave($('#txtContaCredito1').val(), moedaClasse.CONTA_C);
      moedaClasse.CONTA_JUROS = pegaChave($('#txtContaJuros').val(), moedaClasse.CONTA_JUROS);
      moedaClasse.CONTA_DESCONTO = pegaChave($('#txtContaDesc').val(), moedaClasse.CONTA_DESCONTO);
      moedaClasse.FORMA_PAGTO = $('#formaPagto').val();
      moedaClasse.BANDEIRA = $('#bandCartao').val();
      moedaClasse.TP_INTEGRACAO = $('#tipoInteg').val();
      moedaClasse.TAXA = parseFloat($('#txtTaxaCartao').val().replace(',', '.'));
      moedaClasse.DESC_AUTO = parseFloat($('#txtDescAut').val().replace(',', '.'));
      moedaClasse.DESCMAX = parseFloat($('#txtDescMaximo').val() != '' ? $('#txtDescMaximo').val() : 0);
      moedaClasse.MAX_PARCELAS = parseFloat($('#txtNrMaxParcelas').val() != '' ? $('#txtNrMaxParcelas').val() : 0);
      moedaClasse.ID_BANDEIRA = pegaChave('#txtBandeira');

      moedaClasse.CONTAS = arrayContas;

      let arrayCondicoes = [];
      for (let index = 0; index < $('#tabelaCondicoesDePagamento').DataTable().rows().count(); index++) {
        let data = $('#tabelaCondicoesDePagamento').DataTable().row(index).data();
        let conta = {};
        conta.CODCOND = data[0];
        conta.MOEDA = moedaClasse.CODMOE;
        conta.TAXA = data[2];
        conta.VALORMINIMO = data[3];
        conta.RESTRICAO = data[4];
        arrayCondicoes.push(conta);
      }
      moedaClasse.CONDICOES = arrayCondicoes;

      let arrayMoedaECF = [];
      for (let index = 0; index < $('#tabelaMoedaECF').DataTable().rows().count(); index++) {
        let data = $('#tabelaMoedaECF').DataTable().row(index).data();
        let objmoeda = {};
        objmoeda.SERIEECF = data[0];
        objmoeda.MOEDA = `'${moedaClasse.CODMOE}'`;
        objmoeda.MOEDAECF = data[2];
        arrayMoedaECF.push(objmoeda);
      }
      moedaClasse.MOEDAECF = arrayMoedaECF;
      moedaClasse.TIPO = $('#selectTipo').val();
      moedaClasse.MOEDA_BAIXAREC = await formataListas($('#txtMoedasBaixaRec').val().toString());

      // if ($('#radioNormal').prop('checked')) {
      //   moedaClasse.TIPO = 0;
      // }
      // if ($('#radioCheque').prop('checked')) {
      //   moedaClasse.TIPO = 1;
      // }
      // if ($('#radioCrediario').prop('checked')) {
      //   moedaClasse.TIPO = 2;
      // }
      // if ($('#radioCartao').prop('checked')) {
      //   moedaClasse.TIPO = 3;
      // }

      if ($('#radioCredito').prop('checked')) {
        moedaClasse.TIPO_CARTAO = '0';
      }
      if ($('#radioDebito').prop('checked')) {
        moedaClasse.TIPO_CARTAO = '1';
      }

      if ($('#baixaReceber').prop('checked')) {
        moedaClasse.BAIXA = 1;
      } else {
        moedaClasse.BAIXA = 0;
      }
      if ($('#baixaReceberDtVenc').prop('checked')) {
        moedaClasse.BAIXA_VENCTO = 'S';
      } else {
        moedaClasse.BAIXA_VENCTO = 'N';
      }
      if ($('#modoRapido').prop('checked')) {
        moedaClasse.MODORAPIDO = 'S';
      } else {
        moedaClasse.MODORAPIDO = 'N';
      }
      if ($('#moedaTroco').prop('checked')) {
        moedaClasse.GERA_TROCO = 'S';
      } else {
        moedaClasse.GERA_TROCO = 'N';
      }
      if ($('#imprimeRel').prop('checked')) {
        moedaClasse.IMP_GERENCIAL = 'S';
      } else {
        moedaClasse.IMP_GERENCIAL = 'N';
      }
      if ($('#imprimeCarne').prop('checked')) {
        moedaClasse.IMP_CARNE = 'S';
      } else {
        moedaClasse.IMP_CARNE = 'N';
      }
      if ($('#controlaLim').prop('checked')) {
        moedaClasse.CONT_LIM_FAT = 'S';
      } else {
        moedaClasse.CONT_LIM_FAT = 'N';
      }
      if ($('#comunicTef').prop('checked')) {
        moedaClasse.TEF = 'S';
      } else {
        moedaClasse.TEF = 'N';
      }
      if ($('#utilAdm').prop('checked')) {
        moedaClasse.USA_ADM_CARTAO = 'S';
      } else {
        moedaClasse.USA_ADM_CARTAO = 'N';
      }
      if ($('#recriaDup').prop('checked')) {
        moedaClasse.RECRIA_DUPL_FAT = 'S';
      } else {
        moedaClasse.RECRIA_DUPL_FAT = 'N';
      }
      if ($('#habBaixar').prop('checked')) {
        moedaClasse.BAIXA_ANTE = 'S';
      } else {
        moedaClasse.BAIXA_ANTE = 'N';
      }
      if ($('#naoGeraContas').prop('checked')) {
        moedaClasse.NAO_GERA_RECEBER = 'S';
      } else {
        moedaClasse.NAO_GERA_RECEBER = 'N';
      }
      if ($('#cartaoPres').prop('checked')) {
        moedaClasse.CARTAO_PRESENTE = 'S';
      } else {
        moedaClasse.CARTAO_PRESENTE = 'N';
      }
      if ($('#obrigaDocFiscal').prop('checked')) {
        moedaClasse.OBRIGA_DOC_FISCAL = 'S';
      } else {
        moedaClasse.OBRIGA_DOC_FISCAL = 'N';
      }
      if ($('#moedaAtivo').prop('checked')) {
        moedaClasse.ATIVO = 'S';
      } else {
        moedaClasse.ATIVO = 'N';
      }
      if ($('#itemBrinde').prop('checked')) {
        moedaClasse.CONT_ITEM_BRINDE = 'S';
      } else {
        moedaClasse.CONT_ITEM_BRINDE = 'N';
      }
      if ($('#aplicaDescValPag').prop('checked')) {
        moedaClasse.APLICA_DESC_PAG = 'S';
      } else {
        moedaClasse.APLICA_DESC_PAG = 'N';
      }

      let response = await requisicao('POST', '/Sisplan/Cadastros/v1/moeda?', '', `JSON=${JSON.stringify(moedaClasse)}`);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        `Cadastro efetuado com sucesso!
                    Moeda: ${moedaClasse.CODMOE}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 5000,
        fadeOut: 3000,
        onHidden() {
          window.location.href = `${BASE_URI}/moeda`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados da moeda`);
    } finally {
      $("#gravar").prop('disabled', false);
    }
  });
});