$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique nesse botão para filtrar sua consulta.',
                position: 'bottom'
            }
        },
        {
            element: '#tabelaNotas_wrapper',
            popover: {
                title: 'Notas Fiscais',
                description: 'Aqui ficam as notas fiscais filtradas.',
                position: 'top'
            }
        },
        {
            element: '#dadosnota',
            popover: {
                title: 'Dados da Nota',
                description: 'Aqui ficam os dados da nota que está selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnGerar',
            popover: {
                title: 'Botão Gerar',
                description: 'Clique aqui para gerar a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnCancelar',
            popover: {
                title: 'Botão Cancelar',
                description: 'Clique aqui para cancelar a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnExcluir',
            popover: {
                title: 'Botão Excluir',
                description: 'Clique aqui para excluir a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnConsultar',
            popover: {
                title: 'Botão Consultar',
                description: 'Clique aqui para consultar a nota fiscal selecionada.',
                position: 'top'
            }
        }

        ]);
        driver.start();
        driver.getHighlightedElement();
    });
});


$(document).ready(async function () {
    await setarDataAtual('txtEmiDe');
    await setarDataAtual('txtEmiAte');
    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2);


    $('input[name=rg_status]:checked').on('change', function () {
        $('#btn-consultar').trigger('click');
    });
    $('input[name=rg_protocolo]:checked').on('change', function () {
        $('#btn-consultar').trigger('click');
    });

    $('#tabelaNotas').DataTable({
        paging: true,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        key: true,
    });

    // $('#checkTodosItens').on('change', function () {
    //     $('.campoSel').prop('checked', $('#checkTodosItens').prop('checked'));
    //     if ($('#checkTodosItens').prop('checked')) {
    //         $('.campoSel').addClass('selecionado');
    //     } else {
    //         $('.campoSel').removeClass('selecionado');
    //     }
    //     $('.campoSel').trigger('change');
    //     $('#tabelaNotas tr').removeClass('selected');
    //     $('.campoSel').toArray().forEach(comp => {
    //         const linhaAtual = $(comp).closest('tr');
    //         if (!linhaAtual.hasClass('selected') && $('#checkTodosItens').prop('checked')) {
    //             linhaAtual.addClass('selected');
    //         } else {
    //             linhaAtual.removeClass('selected');
    //         }
    //     });
    // });

    // $('#tabelaItens').DataTable({
    //     paging: false,
    //     filter: false,
    //     info: false,
    //     order: false,
    //     destroy: true,
    //     autowidth: true,
    //     "language": {
    //         "sEmptyTable": "Nenhum registro encontrado",
    //         "sInfo": "_TOTAL_ registros",
    //         "sInfoEmpty": " 0 registros",
    //         "sInfoFiltered": "(Filtrados de _MAX_ registros)",
    //         "sInfoPostFix": "",
    //         "sInfoThousands": ".",
    //         "sLengthMenu": "_MENU_ resultados",
    //         "sLoadingRecords": "Carregando...",
    //         "sProcessing": "Processando...",
    //         "sZeroRecords": "Nenhum registro encontrado",
    //         "sSearch": "Pesquisar",
    //         "oPaginate": {
    //             "sNext": "Próximo",
    //             "sPrevious": "Anterior",
    //             "sFirst": "Primeiro",
    //             "sLast": "Último"
    //         },
    //         "oAria": {
    //             "sSortAscending": ": Ordenar colunas de forma ascendente",
    //             "sSortDescending": ": Ordenar colunas de forma descendente"
    //         }
    //     }
    // });

    async function buscaNotas() {
        const sDataIni = `'${$('#txtEmiDe').val()}'`;
        const sDataFim = `'${$('#txtEmiAte').val()}'`;
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        const sStatusPed = pegaChave('#txtStatusPed');
        const sRPS = $('#txtRPS').val();
        const sCodObra = $('#txtCodObra').val();
        let filtroPedido = '';
        let filtroRPS = '';
        let filtroCodObra = '';
        if (sStatusPed != '') {
            filtroPedido = ` AND NOTASERV.PEDIDO = '${sStatusPed}'`;
        };
        let impresso = '';
        const iImpresso = $('input[name="rg_status"]:checked').val()
        let sCodCli = pegaChave('#txtCliente');
        if (sCodCli != '') {
            sCodCli = ` AND NOTASERV.CODCLI = '${sCodCli}'`;
        }
        let sNumero = pegaChave('#txtNFSe');
        if (sNumero != '') {
            sNumero = ` AND NOTASERV.NUM_NFSE = '${sNumero}'`;
        }
        if (sRPS != '') {
            filtroRPS = ` AND NOTASERV.NUMERO = '${sRPS}'`
        }
        if (sCodObra != '') {
            filtroCodObra = ` AND NOTASERV.CODOBRA = '${sCodObra}' `
        }
        switch (iImpresso) {
            case '1':
                {
                    impresso = 'S';
                    break;
                }
            case '2':
                {
                    impresso = 'N';
                    break;
                }
            case '3':
                {
                    impresso = 'C';
                    break;
                }
            default:
                impresso = '';
                break;
        }

        try {
            if (impresso != '') {
                impresso = `AND NOTASERV.IMPRESSO = '${impresso}'`;
            }
            let response = await requisicao('GET', url, `JSON={ "tabela":"NOTASERV", "camposSelect":[ "NOTASERV.NUMERO", "NOTASERV.NUM_NFSE", "NOTASERV.IMPRESSO","NOTASERV.SERIE", "NOTASERV.CODCLI", "ENTIDADE.NOME", "NOTASERV.EMISSAO_NFSE", "NOTASERV.NATUREZA", "NOTASERV.VALOR", "NOTASERV.VALOR_LIQ", "NOTASERV.BASE_CALC", "NOTASERV.VALOR_ISS", "NOTASERV.VAL_IRPJ", "NOTASERV.COD_VERIFICACAO"], "leftjoin": [{"tabela":"ENTIDADE", "condicao":"ENTIDADE.CODCLI = NOTASERV.CODCLI"}, {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = NOTASERV.PEDIDO"}], "where": ["NOTASERV.EMP_ID = ${getCookie('emp_id')} AND (NOTASERV.DT_EMISSAO >= ${sDataIni} and NOTASERV.DT_EMISSAO <= ${sDataFim}) ${impresso} ${sNumero} ${sCodCli} ${filtroPedido} ${filtroRPS} ${filtroCodObra}"],  "orderby": ["NOTASERV.NUMERO DESC"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as notas fiscais');
        }
    }

    function retornaBotaoOpcoes(data) {
        return '<div style="text-align:left;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '    ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <a id="btn-mostrar-itens" class="dropdown-item" href="">Mostrar Serviços</a>' +
            '    </div>' +
            '  </div>' +
            '</div>';
    }

    $('#btn-cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome", "fantasia", "cnpj" ], "where": null}', 'Pesquisa Cliente', 'entidade');
    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
    $('#btn-limpa-cliente').on('click', function () {
        $('#txtCliente').val('');
    });

    $('#btn-Nfse').pesquisa('#txtNFSe', 'FATURA', 'VALOR', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTASERV", "camposSelect":[ "num_nfse", "dt_emissao", "codcli" ], "where": null}', 'Pesquisa Notas de Serviço', 'notaserv');
    $('#txtNFSe').autocompleta(3, `JSON={ "tabela":"NOTASERV", "camposSelect":["NUM_NFSE CHAVE", "DT_EMISSAO DESCRICAO"], "where": [] }`);
    $('#btn-limpa-Nfse').on('click', function () {
        $('#txtNFSe').val('');
    });

    retornaHintRelatorio('btnImprimir', 'NFSe')

    $('#btnImprimir').on('click', async function () {
        const tr = $('#tabelaNotas tr.selected')[0];
        const data = $('#tabelaNotas').DataTable().row($(tr)).data();
        const numero = data.NUMERO;
        const serie = data.SERIE;

        if (numero == '') {
            msgAlerta('Nenhuma nota selecionada, impossível continuar.');
            return;
        }

        const url = `/sisplan/impressao/v1/imprimirdanfenfse?NUMERO=${numero}&SERIE=${serie}`;
        try {
            $.LoadingOverlay("show");
            const bImprimeAutomatico = await verificaImprimirAutomatico('DanfeNFSe');
            const arquivo = await GeraRelatorio(`${url}`, 'GET', 600000, false, 'DanfeNFSe');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnCancelar').on('click', async function () {
        let tr = $('#tabelaNotas tr.selected')[0];
        let data = $('#tabelaNotas').DataTable().row($(tr)).data();
        $('#txtCancFatura').val(data.NUMERO);
        $('#txtCancSerie').val(data.SERIE);
        if (data.IMPRESSO == 'C') {
            msgAlerta('Esta nota fiscal já está cancelada. Impossível continuar.');
            return;
        }

        if ((data.IMPRESSO == 'N') && ($('#txtCodigoVerificacao').val() == '')) {
            $('#btn-confirmar-cancelamento').trigger('click');
        } else {
            $('#modal-cancelamento').modal('show');
        };   
    });

    $('#btn-confirmar-cancelamento').on('click', async function () {
        try {
            try {
                $('#btnCancelar').attr('disabled', true);
                try {
                    $.LoadingOverlay("show");
                    let tr = $('#tabelaNotas tr.selected')[0];
                    let data = $('#tabelaNotas').DataTable().row($(tr)).data();
                    let fatura = data.NUMERO;
                    let serie = data.SERIE;
                    let motivo = $('#txtCancJustificativa').val();

                    const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

                    let responseNotaServ = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTASERV", "camposSelect":["NUMERO", "SERIE", "CODCLI", "CODREP", "NATUREZA", "OUTRAS_INFOR", "CIDADE", "CODOBRA", "CODART", "DT_EMISSAO"], "where": ["NUMERO = '${fatura}' AND SERIE = '${serie}'"] }`, null);

                    if (!responseNotaServ) {
                        return;
                    }

                    let jsonStrNotaServ = await responseNotaServ.json();
                    if (responseNotaServ.status != 200) {
                        msgErro(jsonStrNotaServ.RESULT[0].mensagem);
                        return;
                    }

                    const nfse = {};

                    nfse.NUMERO = fatura;
                    nfse.SERIE = serie;
                    nfse.CODCLI = jsonStrNotaServ.RESULT[0][0].CODCLI;
                    nfse.CODREP = jsonStrNotaServ.RESULT[0][0].CODREP;
                    nfse.NATUREZA = jsonStrNotaServ.RESULT[0][0].NATUREZA;
                    nfse.OUTRASINF = jsonStrNotaServ.RESULT[0][0].OUTRAS_INFOR;
                    nfse.CIDADE = jsonStrNotaServ.RESULT[0][0].CIDADE;
                    nfse.CODOBRA = jsonStrNotaServ.RESULT[0][0].CODOBRA;
                    nfse.CODART = jsonStrNotaServ.RESULT[0][0].CODART;
                    nfse.DT_EMISSAO = jsonStrNotaServ.RESULT[0][0].DT_EMISSAO;
                    nfse.ITENS = [];
                    nfse.DUPLICATAS = [];

                    const response = await requisicao('PUT', `/sisplan/fatservico/v1/cancelarnfse?MOTIVO_CANC=${motivo}&`, '', `JSON=${encodeURIComponent(JSON.stringify(nfse))}`, 90000);


                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }


                    toastr.success(
                        'NFS-e cancelada com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#modal-cancelamento').modal('hide');
                            $('#txtCancJustificativa').val('');
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } finally {
                    $.LoadingOverlay("hide");
                }
            } catch (error) {
                console.error(error);
                msgErro('Erro ao cancelar NFS-e');
            }
        } finally {
            $('#btnCancelar').attr('disabled', false);
        }
    });

    async function retornaInformacaoEmpresa() {
        try {
            let url = `/sisplan/funcoes/v1/pesquisa?`;
            let response = await requisicao('GET', url, `JSON={ 
            "tabela":"empresa", 
            "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert", "emp_crt", "emp_cnpj", "emp_id"], 
            "where": ["emp_id = ${getCookie('emp_id')}"] 
          }`, null);
            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            return jsonStr.RESULT[0][0];
        } catch (error) {
            console.error(error);
            msgErro('Erro ao retornar dados da empresa, Erro: ');
        }
    }

    $('#btnEnviarEmail').on('click', async function () {
        try {
            try {
                $('#btnEnviarEmail').attr('disabled', true);
                try {
                    $.LoadingOverlay("show");
                    const tr = $('#tabelaNotas tr.selected')[0];
                    const data = $('#tabelaNotas').DataTable().row($(tr)).data();
                    const fatura = data.NUMERO;
                    const serie = data.SERIE;

                    const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

                    let responseNotaServ = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTASERV", "camposSelect":["NUMERO", "SERIE", "CODCLI", "CODREP", "NATUREZA", "OUTRAS_INFOR", "CIDADE", "CODOBRA", "CODART", "DT_EMISSAO"], "where": ["NUMERO = '${fatura}' AND SERIE = '${serie}'"] }`, null);

                    if (!responseNotaServ) {
                        return;
                    }

                    let jsonStrNotaServ = await responseNotaServ.json();
                    if (responseNotaServ.status != 200) {
                        $.LoadingOverlay('hide');
                        msgErro(jsonStrNotaServ.RESULT[0].mensagem);
                        return;
                    }

                    const nfse = {};

                    nfse.NUMERO = fatura;
                    nfse.SERIE = serie;
                    nfse.CODCLI = jsonStrNotaServ.RESULT[0][0].CODCLI;
                    nfse.CODREP = jsonStrNotaServ.RESULT[0][0].CODREP;
                    nfse.NATUREZA = jsonStrNotaServ.RESULT[0][0].NATUREZA;
                    nfse.OUTRASINF = jsonStrNotaServ.RESULT[0][0].OUTRAS_INFOR;
                    nfse.CIDADE = jsonStrNotaServ.RESULT[0][0].CIDADE;
                    nfse.CODOBRA = jsonStrNotaServ.RESULT[0][0].CODOBRA;
                    nfse.CODART = jsonStrNotaServ.RESULT[0][0].CODART;
                    nfse.DT_EMISSAO = jsonStrNotaServ.RESULT[0][0].DT_EMISSAO;
                    nfse.ITENS = [];
                    nfse.DUPLICATAS = [];

                    const response = await requisicao('POST', `/sisplan/fatservico/v1/enviaemailnfse?`, '', `JSON=${encodeURIComponent(JSON.stringify(nfse))}`, 90000);


                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        $.LoadingOverlay('hide');
                        let jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }


                    toastr.success(
                        'NFS-e enviada por email com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } finally {
                    $.LoadingOverlay("hide");
                }
            } catch (error) {
                console.error(error);
                msgErro('Erro ao enviar NFS-e por email.');
            }
        } finally {
            $('#btnEnviarEmail').attr('disabled', false);
        }
    });

    $('#btnGerar').on('click', async function () {
        try {
            try {
                $('#btnGerar').attr('disabled', true);
                try {
                    $.LoadingOverlay("show");
                    let tr = $('#tabelaNotas tr.selected')[0];
                    let data = $('#tabelaNotas').DataTable().row($(tr)).data();
                    let fatura = data.NUMERO;
                    let serie = data.SERIE;

                    const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

                    let responseNotaServ = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTASERV", "camposSelect":["NUMERO", "SERIE", "CODCLI", "CODREP", "NATUREZA", "OUTRAS_INFOR", "CIDADE", "CODOBRA", "CODART", "DT_EMISSAO"], "where": ["NUMERO = '${fatura}' AND SERIE = '${serie}'"] }`, null);

                    if (!responseNotaServ) {
                        return;
                    }

                    let jsonStrNotaServ = await responseNotaServ.json();
                    if (responseNotaServ.status != 200) {
                        msgErro(jsonStrNotaServ.RESULT[0].mensagem);
                        return;
                    }

                    const nfse = {};

                    nfse.NUMERO = fatura;
                    nfse.SERIE = serie;
                    nfse.CODCLI = jsonStrNotaServ.RESULT[0][0].CODCLI;
                    nfse.CODREP = jsonStrNotaServ.RESULT[0][0].CODREP;
                    nfse.NATUREZA = jsonStrNotaServ.RESULT[0][0].NATUREZA;
                    nfse.OUTRASINF = jsonStrNotaServ.RESULT[0][0].OUTRAS_INFOR;
                    nfse.CIDADE = jsonStrNotaServ.RESULT[0][0].CIDADE;
                    nfse.CODOBRA = jsonStrNotaServ.RESULT[0][0].CODOBRA;
                    nfse.CODART = jsonStrNotaServ.RESULT[0][0].CODART;
                    nfse.DT_EMISSAO = jsonStrNotaServ.RESULT[0][0].DT_EMISSAO;
                    nfse.ITENS = [];
                    nfse.DUPLICATAS = [];

                    const response = await requisicao('PUT', '/sisplan/fatservico/v1/transmitenfse?', '', `JSON=${encodeURIComponent(JSON.stringify(nfse))}`, 90000);


                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        $.LoadingOverlay('hide');
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    try {
                        $.LoadingOverlay("show");
                        const urlImprimir = `/sisplan/impressao/v1/imprimirdanfenfse?NUMERO=${fatura}&SERIE=${serie}`;
                        const bImprimeAutomatico = await verificaImprimirAutomatico('DanfeNFSe');
                        const arquivo = await GeraRelatorio(`${urlImprimir}&`, 'GET', 15000, false, 'DanfeNFSe');
                        if (arquivo != undefined) {
                            if (!bImprimeAutomatico) {
                                window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                            }
                            await limparRelatorios();
                        }
                    } finally {
                        $.LoadingOverlay("hide");
                    }

                    toastr.success(
                        'NFS-e gerada com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } finally {
                    $.LoadingOverlay("hide");
                }
            } catch (error) {
                console.error(error);
                // msgErro('Erro ao gerar NFS-e');
            }
        } finally {
            $('#btnGerar').attr('disabled', false);
        }
    });

    $('#btnExcluir').on('click', async function () {
        try {
            try {
                if ($('#txtCodigoVerificacao').val() != '') {
                    msgAlerta('Nota não pode ser excluída, pois consta na PREFEITURA como autorizada ou cancelada.');
                    return;
                }
                $.LoadingOverlay("show");

                let tr = $('#tabelaNotas tr.selected')[0];
                let data = $('#tabelaNotas').DataTable().row($(tr)).data();

                msgAguardaConfirmacao('Tem certeza que deseja excluir a NFS-e selecionada?', async () => {
                    $.LoadingOverlay("show");
                    let fatura = data.NUMERO;
                    let serie = data.SERIE;

                    const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

                    let responseNotaServ = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTASERV", "camposSelect":["NUMERO", "SERIE", "CODCLI", "CODREP", "NATUREZA", "OUTRAS_INFOR", "CIDADE", "CODOBRA", "CODART", "DT_EMISSAO"], "where": ["NUMERO = '${fatura}' AND SERIE = '${serie}'"] }`, null);

                    if (!responseNotaServ) {
                        return;
                    }

                    let jsonStrNotaServ = await responseNotaServ.json();
                    if (responseNotaServ.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStrNotaServ.RESULT[0].mensagem);
                        return;
                    }

                    const nfse = {};

                    nfse.NUMERO = fatura;
                    nfse.SERIE = serie;
                    nfse.CODCLI = jsonStrNotaServ.RESULT[0][0].CODCLI;
                    nfse.CODREP = jsonStrNotaServ.RESULT[0][0].CODREP;
                    nfse.NATUREZA = jsonStrNotaServ.RESULT[0][0].NATUREZA;
                    nfse.OUTRASINF = jsonStrNotaServ.RESULT[0][0].OUTRAS_INFOR;
                    nfse.CIDADE = jsonStrNotaServ.RESULT[0][0].CIDADE;
                    nfse.CODOBRA = jsonStrNotaServ.RESULT[0][0].CODOBRA;
                    nfse.CODART = jsonStrNotaServ.RESULT[0][0].CODART;
                    nfse.DT_EMISSAO = jsonStrNotaServ.RESULT[0][0].DT_EMISSAO;
                    nfse.ITENS = [];
                    nfse.DUPLICATAS = [];

                    const response = await requisicao('PUT', '/sisplan/fatservico/v1/excluinfse?', `JSON=${encodeURIComponent(JSON.stringify(nfse))}`, '', 90000);


                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    toastr.success(
                        'NFS-e excluída com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $.LoadingOverlay("hide");
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                }, () => {});
                
            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Erro ao excluir NFC-e');
        }
    });

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay("show");
        let tr = $('#tabelaNotas tr.selected')[0];
        let data = $('#tabelaNotas').DataTable().row($(tr)).data();
        let fatura = data.NUMERO;
        let serie = data.SERIE;

        const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

        try {
            try {

                let responseNotaServ = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTASERV", "camposSelect":["NOTASERV.NUMERO", "NOTASERV.SERIE", "NOTASERV.CODCLI", "NOTASERV.CODREP", "NOTASERV.NATUREZA", "NOTASERV.OUTRAS_INFOR", "NOTASERV.CIDADE", "NOTASERV.CODOBRA", "NOTASERV.CODART", "NOTASERV.DT_EMISSAO", "NOTASERV.NUM_NFSE", "NOTASERV.COD_VERIFICACAO", "CIDADE.CODIGOTOM"], "leftjoin": [{"tabela": "CIDADE", "condicao": "CIDADE.CODIGO = NOTASERV.CIDADE"}], "where": ["NOTASERV.NUMERO = '${fatura}' AND NOTASERV.SERIE = '${serie}'"] }`, null);

                if (!responseNotaServ) {
                    return;
                }

                let jsonStrNotaServ = await responseNotaServ.json();
                if (responseNotaServ.status != 200) {
                    $.LoadingOverlay('hide');
                    msgErro(jsonStrNotaServ.mensagem);
                    return;
                }

                const response = await requisicao('GET', `/sisplan/fatservico/v1/consultanfse?CODIGO_CIDADE=${jsonStrNotaServ.RESULT[0][0].CIDADE}&NUM_NFSE=${jsonStrNotaServ.RESULT[0][0].NUM_NFSE}&SERIE=${jsonStrNotaServ.RESULT[0][0].SERIE}&NUMERO=${jsonStrNotaServ.RESULT[0][0].NUMERO}&COD_VERIFICACAO=${jsonStrNotaServ.RESULT[0][0].COD_VERIFICACAO}&NUMERO_SEM_ID=${jsonStrNotaServ.RESULT[0][0].NUMERO}&CODCLI=${jsonStrNotaServ.RESULT[0][0].CODCLI}&CODIGO_TOM=${jsonStrNotaServ.RESULT[0][0].CODIGOTOM}&`, '', '', 90000);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();

                if (response.status != 200) {
                    $.LoadingOverlay('hide');
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                msgAlerta(jsonStr.mensagem.replaceAll('\\n', '\n'));

            } catch (error) {
                $.LoadingOverlay('hide');
                console.error(error);
            }

        } finally {
            $.LoadingOverlay('hide');
        }

    });

    $('#btn-consultar').on('click', async function () {
        $.LoadingOverlay("show");
        try {
            const notas = await buscaNotas();
            let dataSetCols = [];

            if (!$.isEmptyObject(notas.RESULT[0][0])) {

                let keys = Object.keys(notas.RESULT[0][0]);

                for (let k in keys) {
                    dataSetCols.push({
                        'title': keys[k],
                        'data': keys[k]
                    });
                };

                $('#tabelaNotas').DataTable({
                    paging: true,
                    filter: true,
                    info: true,
                    order: true,
                    destroy: true,
                    select: true,
                    keys: true,
                    "data": notas.RESULT[0],
                    "columns": dataSetCols,
                    "columnDefs": [
                        {
                            "targets": 12,
                            "visible": false
                        },
                        {
                            "render": function (data) {
                                return parseFloat(data).toLocaleString('pt-BR', {
                                    maximumFractionDigits: 2,
                                    minimumFractionDigits: 2
                                });
                            },
                            "targets": [8, 9, 10, 11],
                            "className": 'pr-4 text-right'
                        },
                        {
                            targets: [0], render: function (data, type, row) {
                                return retornaBotaoOpcoes(data);
                            },
                        },
                    ]
                });

                $('#tabelaNotas').on('draw.dt', function () {
                    $($('#tabelaNotas').DataTable().$('tr')[0]).trigger('click');
                });

                $("#tabelaNotas tbody").on("click", "tr", async function () {
                    $("#tabelaNotas").dataTable().$("tr.selected").removeClass("selected");
                    $(this).addClass("selected");
                    const data = $('#tabelaNotas').DataTable().row(this).data();
                    $('#txtNumeroNFSe').val(`${data.NUM_NFSE}`);
                    $('#txtEmissaoNFSe').val(`${data.EMISSAO_NFSE}`);
                    $('#txtCodigoVerificacao').val(`${data.COD_VERIFICACAO}`);
                });
            };

            $($('#tabelaNotas').DataTable().$('tr')[0]).trigger('click');

        } finally {
            $.LoadingOverlay("hide");
            $('#modal-filtros').modal('hide');
        }
    });

    // $('#tabelaNotas').on('click', '#btn-mostrar-itens', async function () {
    //     try {
    //         window.event.preventDefault();
    //         $.LoadingOverlay("show");
    //         let tr = this.closest('tr');
    //         let data = $('#tabelaNotas').DataTable().row($(tr)).data();
    //         let dados = await buscaItens(data.FATURA, data.SERIE);
    //         $('#txtNotaItens').val(data.FATURA);
    //         $('#txtSerieItens').val(data.SERIE);
    //         $('#modal-itens-title').html(`Itens da nota: ${data.FATURA}`);
    //         let dataSetCols = [];

    //         let keys = Object.keys(dados.RESULT[0][0]);
    //         // eslint-disable-next-line no-restricted-syntax, guard-for-in
    //         for (let k in keys) {
    //             dataSetCols.push({
    //                 'title': keys[k],
    //                 'data': keys[k]
    //             });
    //         }

    //         // eslint-disable-next-line no-shadow
    //         dataSetCols[8].render = function (data, _type, _row, meta) {
    //             return `${'<div class="group-default form-group">' +
    //                 '<div class="relative">' +
    //                 '<input type="text" placeholder="Natureza" id="natureza_col_'}${[meta.row]}_row_${[meta.col]}" readonly class="input-default focus form-control validate campoNatureza" value="${data}"> ` +
    //                 `</div>` +
    //                 `</div>`;
    //         };

    //         let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;
    //         if (isNaN(decimais)) {
    //             decimais = 2;
    //         }

    //         tabelaItens = $('#tabelaItens').DataTable({
    //             paging: false,
    //             filter: false,
    //             info: true,
    //             order: true,
    //             destroy: true,
    //             "language": {
    //                 "sEmptyTable": "Nenhum registro encontrado",
    //                 "sInfo": "_TOTAL_ registros",
    //                 "sInfoEmpty": " 0 registros",
    //                 "sInfoFiltered": "(Filtrados de _MAX_ registros)",
    //                 "sInfoPostFix": "",
    //                 "sInfoThousands": ".",
    //                 "sLengthMenu": "_MENU_ resultados",
    //                 "sLoadingRecords": "Carregando...",
    //                 "sProcessing": "Processando...",
    //                 "sZeroRecords": "Nenhum registro encontrado",
    //                 "sSearch": "Pesquisar",
    //                 "oPaginate": {
    //                     "sNext": "Próximo",
    //                     "sPrevious": "Anterior",
    //                     "sFirst": "Primeiro",
    //                     "sLast": "Último"
    //                 },
    //                 "oAria": {
    //                     "sSortAscending": ": Ordenar colunas de forma ascendente",
    //                     "sSortDescending": ": Ordenar colunas de forma descendente"
    //                 }
    //             },
    //             "data": dados.RESULT[0],
    //             "columns": dataSetCols,
    //             "columnDefs": [{
    //                 "targets": [9],
    //                 "visible": false
    //             },
    //             {
    //                 "render": function (data) {
    //                     return parseFloat(data).toLocaleString('pt-BR', {
    //                         maximumFractionDigits: 2,
    //                         minimumFractionDigits: 2
    //                     });
    //                 },
    //                 "targets": [6, 7],
    //                 "className": 'pr-4 text-right'
    //             },
    //             {
    //                 targets: [5],
    //                 "className": 'pr-4 text-right'
    //             }],
    //         });

    //         if ($('#txtProtocoloNF').val() == '') {
    //             for (let i = 0; i < $('.campoNatureza').length; i++) {
    //                 $(`#natureza_col_${i}_row_8`).pesquisa(`#natureza_col_${i}_row_8`, 'NATUREZA', 'NATUREZA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":["natureza"], "where": ["tipo = ${"'V'"} and tp_base = '1'"]}`, 'Pesquisa Natureza', 'natureza', 'S');
    //             }
    //         }

    //         $('#modal-itens').modal('show');
    //     } finally {
    //         $.LoadingOverlay("hide");
    //     }
    // });

    $('#btn-consultar').trigger('click');

    $("#btnVisualizarXML").on("click", async function() {
        $.LoadingOverlay("show");
        const numeroNFSE = $("#txtNumeroNFSe").val();
      try {
        
        if (numeroNFSE == "") {
            msgAlerta("NFS-e não gerada.");
          return;
        } else {
          await visualizarXML(numeroNFSE);
        }

      } finally {
        $.LoadingOverlay("hide");
        $('#dropdownVisualizar').removeClass("show");
      }
    })

    $("#btnBaixarXML").on("click", async function() {
      $.LoadingOverlay("show");
      const numeroNFSE = $("#txtNumeroNFSe").val();

      try {
        if (numeroNFSE == "") {
          msgAlerta("NFS-e não gerada.");
          return;
        } else {
          await baixarXML(numeroNFSE);
        }

      } finally {
        $.LoadingOverlay("hide");
        $('#dropdownVisualizar').removeClass("show");
      }
    })

    async function visualizarXML(chave) {
        try {
            const url = '/sisplan/fatservico/v1/visualizarxml?';
            const params = `NUMERO_NFSE=${chave}`;
            const response = await requisicao('GET', url, params, '', 180000);

            if (!response) {
            msgAlerta("Não foi possível realizar a ação.");
            return;
            }

            if (response.status != 200) {
            const jsonStr = await response.json();
            msgAlerta(jsonStr.mensagem);
            return;
            }

            window.open(`${BASE_URI}/XMLtemp/XMLVisualizar.xml`, "_blank");

        } catch (error) {
            console.log(error);
        }
    }

    async function baixarXML(chave) {
        try {
            const url = '/sisplan/fatservico/v1/retornaXML?';
            const params = `NUMERO_NFSE=${chave}`;
            const response = await requisicao('GET', url, params, '', 180000);

            if (!response) {
            msgAlerta("Não foi possível realizar a ação.");
            return;
            }

            if (response.status != 200) {
            const jsonStr = await response.json();
            msgAlerta(jsonStr.mensagem);
            return;
            }

            const xml = await response.text();

            if (xml != '') {
            const file = new Blob([xml], {type: "text/xml"});
            const fileName = `RPS_${chave}.xml`;
            saveAs(file, fileName);
            } else {
            msgAlerta('XML não encontrado!');
            return;
            }

        } catch (error) {
            console.log(error);
        }
    }
});