$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova operação.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Operações",
          description: "Aqui está a lista de operações cadastradas.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  preencherFiltrosSalvos()
  const permissaoUsuarioLogado = await permissaoAcessos('OPERACAO_TEMPOS');

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI === 'S') {
      window.location.href = 'operacao_tempos/create'
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  })

  componenteFiltro('operacaoTempos', true, true, 'Operacao')
  componenteFiltro('maquina', true, true)
  componenteFiltro('parte', true, true)
  componenteFiltro('setor', true, true, 'Grupo')

  $('#btnConsultar').on('click', function () {
    retornarDados()
  })

  async function retornarFiltros() {
    const operacoes = await formataListas($('#txtOperacao').val().toString())
    const maquinas = await formataListas($('#txtMaquina').val().toString())
    const partes = await formataListas($('#txtParte').val().toString())
    const grupos = await formataListas($('#txtGrupo').val().toString())
    const complemento = $('#txtComplemento').val()
    const gerarKanban = $('#selectGerarKanban').val()
    const ativos = $('#selectOperacoes').val()
    const apontamento = $('#selectApontamento').val()

    return {
      operacoes,
      maquinas,
      partes,
      grupos,
      complemento,
      gerarKanban,
      ativos,
      apontamento,
    }
  }

  async function retornarDados() {
    try {
      $.LoadingOverlay('show')

      const filtros = await retornarFiltros()

      atualizarFiltrosAbasAcessoSessionStorage('operacao_tempos', filtros)
      const response = await requisicao("POST", `/sisplan/operacaotempos/v1/retornardadosacesso?`, '', JSON.stringify(filtros), 3600000)

      const data = await response.json()

      if (data) {
        const { resultado, mensagem } = data
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (resultado) {
          const { itens } = resultado
          criarTabelaItens(itens || [])
          return
        }
      }
    } catch (error) {
      msgErro(error || 'Ocorreu um erro ao buscar os dados.')
    } finally {
      $('#modal-filtros').modal('hide')
      $.LoadingOverlay('hide')
    }
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '</div>'
    return retorno
  }

  function criarTabelaItens(data) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
        render: function (data) {
          return retornarBotaoOpcoes(data)
        },
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'maquina',
        title: 'Máquina',
      },
      {
        data: 'descricaoMaquina',
        title: 'Descrição Máquina',
      },
      {
        data: 'parte',
        title: 'Parte',
      },
      {
        data: 'descricaoParte',
        title: 'Descrição Parte',
      },
      {
        data: 'grupo',
        title: 'Grupo',
      },
      {
        data: 'descricaoGrupo',
        title: 'Descrição Grupo',
      },
      {
        data: 'complemento',
        title: 'Complemento',
      },
      {
        data: 'gerarKanban',
        title: 'Gera Kanban',
      },
      {
        data: 'ativo',
        title: 'Ativo',
      },
      {
        data: 'apontamento',
        title: 'Apontamento',
      },
    ]

    $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
    })
  }

  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (filtrosSessionStorage) {
      const { operacao_tempos: filtros } = JSON.parse(filtrosSessionStorage)
      if (filtros) {
        carregarFiltrosSalvos(filtros).then(({ operacoes, maquinas, partes, grupos, }) => {
          if (operacoes) operacoes.forEach((item) => adicionaValorPadraoVarios('operacao', item?.codigo, item?.descricao))
          if (maquinas) maquinas.forEach((item) => adicionaValorPadraoVarios('maquina', item?.codigo, item?.descricao))
          if (partes) partes.forEach((item) => adicionaValorPadraoVarios('parte', item?.codigo, item?.descricao))
          if (grupos) grupos.forEach((item) => adicionaValorPadraoVarios('grupo', item?.codigo, item?.descricao))
          if (filtros.complemento) insereValor('#txtComplemento', filtros.complemento)
          insereValor('#selectGerarKanban', filtros.gerarKanban)
          insereValor('#selectOperacoes', filtros.ativos)
          insereValor('#selectApontamento', filtros.apontamento)
          $('#btnConsultar').trigger('click')
        }).catch(
          () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
        ).finally(() => { })
      }
    }
  }

  async function carregarFiltrosSalvos(filtros) {
    const response = await requisicao("POST", `/Sisplan/operacaotempos/v1/retornardadosinputsfiltrosacesso?`, '', JSON.stringify(filtros), 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#txtOperacao').empty().trigger('change')
    $('#txtMaquina').empty().trigger('change')
    $('#txtParte').empty().trigger('change')
    $('#txtGrupo').empty().trigger('change')
    $('#txtComplemento').val('')
    $('#selectGerarKanban').val('')
    $('#selectOperacoes').val('')
    $('#selectApontamento').val('')
  })

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data && data?.codigo) {
        let registroLiberado = await verificarRegistro('OPERACAO_TEMPOS', data?.codigo)
        if (registroLiberado) {
          window.location.href = `operacao_tempos/${data?.codigo}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this)).data()
      if (data && data?.codigo) {
        let registroLiberado = await verificarRegistro('OPERACAO_TEMPOS', data?.codigo)
        if (registroLiberado) {
          window.location.href = `operacao_tempos/${data?.codigo}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
      let data = row.data()
      if (data && data?.codigo) {
        let registroLiberado = await verificarRegistro('OPERACAO_TEMPOS', data?.codigo)
        if (registroLiberado) {
          msgAlerta(
            'Deseja excluir a operação selecionada?',
            () => { },
            () => { },
            () => excluirOperacao(data?.codigo, row),
          )
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  })

  async function excluirOperacao(codigo, row) {
    if (!codigo || !row) return
    $.LoadingOverlay('show')
    requisicao("DELETE", `/sisplan/operacaotempos/v1/excluir?`, `&FILTROS=${encodeURIComponent(JSON.stringify({ chave: codigo }))}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          console.error(json?.mensagem?.mensagem)
          throw json?.mensagem?.mensagem
        }

        toastr.success("Operação excluída com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            row.remove().draw(false)
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      ).finally(() => $.LoadingOverlay('hide'))
  }
})