$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("REGRA_PROMOCAO");

  $('#txtRegra').autocompleta(1, `JSON={ "tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA chave", "DESC_REGRA descricao"], "where": null, "groupby": ["REGRA", "DESC_REGRA"]}`);
  $('#btnRegra').pesquisa('#txtRegra', 'REGRA', 'DESC_REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA", "DESC_REGRA"], "groupby": ["REGRA", "DESC_REGRA"]}`, 'Pesquisa Regra', 'regra_promocao');
  $('#btnARegra').on('click', function () {
    $('#txtRegra').val('');
  });

  $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
  $('#btnTabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela de Preço', 'regiao');
  $('#btnATabelaPreco').on('click', function () {
    $('#txtTabelaPreco').val('');
    $('#txtTabelaPreco').trigger('blur');
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item btn-editar" type="button" title="Editar">Editar</button>     ' +
      '    <button class="dropdown-item btn-excluir" type="button" title="Excluir">Excluir</button>  ' +
      `    <button class="dropdown-item btn-imprimir" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelRegraPromocao.FR3"' : 'title="Imprimir"'} title="Imprimir">Imprimir</button>  ` +
      '</div>';
    return retorno;
  };

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  function getFiltrosPesquisa() {
    const tabelaPreco = pegaChave('#txtTabelaPreco') != '' ? ` AND REGIAO = '${pegaChave('#txtTabelaPreco')}'` : '';
    const regra = pegaChave('#txtRegra') != '' ? ` AND REGRA = '${pegaChave('#txtRegra')}'` : '';
    const dataIni = $('#dataIni').val() != '' ? ` AND DT_INICIAL >= '${$('#dataIni').val()}'` : '';
    const dataIniAte = $('#dataFim').val() != '' ? ` AND DT_INICIAL <= '${$('#dataFim').val()}'` : '';
    const empresasSelecionadas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];
    let filtroEmpresa = '';

    const filtros = empresasSelecionadas.map(empresa =>
      `',' || EMPRESA || ',' LIKE '[PERCENTUAL],${empresa},[PERCENTUAL]'`
    );

    filtroEmpresa = ' AND (' + filtros.join(' OR ') + ')';

    return `${tabelaPreco}${regra}${filtroEmpresa}${dataIni}${dataIniAte}`
  }


  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let dataSetCols = [];
        const url = '/sisplan/funcoes/v1/pesquisa?';
        const filtros = getFiltrosPesquisa();
        const pesquisa = {
          tabela: 'REGRA_PROMOCAO',
          camposSelect: ['REGRA', 'DESC_REGRA'],
          where: [`1=1 ${filtros}`],
          groupby: ['REGRA', 'DESC_REGRA']
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

        if (!jsonStr) {
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k,
          });
        });

        $('#tabelaRegras').DataTable({
          filter: true,
          info: true,
          paging: true,
          destroy: true,
          order: [[0, 'asc']],
          ordering: true,
          "data": jsonStr,
          "columns": dataSetCols,
          "columnDefs": [
            {
              targets: [0],
              orderable: true,
              render: function (data, type, row) {
                if (type === 'display') {
                  return retornaBotaoOpcoes(data);
                }
                return data;
              }
            }
          ]
        });

        $('#tabelaRegras tbody').on('click', '.btn-editar', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-imprimir', async function () {
          $.LoadingOverlay("show");
          try {
            const data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            const codigoRegra = data.REGRA;
            const utilizaTabCorTam = (await CopiaParametro('VENDA', 5) == 1 ? 'S' : 'N');
            const url = `/sisplan/impressao/v1/imprimirregrapromocao?`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelRegraPromocao');
            const arquivo = await GeraRelatorio(`${url}CODIGO_REGRA=${codigoRegra}&PRECO_COR_TAM=${utilizaTabCorTam}`, "GET", 15000, false, 'RelRegraPromocao');

            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
              }
              await limparRelatorios();
            }
          } finally {
            $.LoadingOverlay("hide");
          }
        });

        $('#tabelaRegras tbody').on('dblclick', 'tr', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this)).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-excluir', async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            var data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            msgAlerta('Deseja realmente excluir essa regra?', deletaRegra);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }

          async function deletaRegra() {
            try {
              $.LoadingOverlay('show');
              try {
                url = '/sisplan/cadastros/v1/regrapromocao?';
                params = `REGRA=${data.REGRA}`;

                response = await requisicao('DELETE', url, params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {

                  toastr.success(
                    'Regra excluída com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/regrapromocao`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  jsonStr = await response.json();
                  msgErro(jsonStr.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }

        });

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#btnNovaRegraPromocao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "regrapromocao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').trigger('click');

});
