<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Peças Faturadas</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.255.29.2">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.255.29.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.255.29.2">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.255.29.2">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.255.29.2">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.255.29.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.255.29.2">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.255.29.2">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.255.29.2">
  <style>
    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Relatório de Peças Faturadas</h1>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltrosRel" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimirRel" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="col-sm-12 d-flex justify-content-center align-items-center" style="height: 100%;">
                      <div id="graficoRelPecasFaturadas" class="mt-5" style="width: 100%;"></div>
                    </div>
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaPecasFaturadas" class="table table-sm table-select table-hover" style="white-space: nowrap" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header col-12">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0">
            <div class="card-dark card-tabs col-12">
              <div class="card-body pt-0">
                <div class="row">

                  <div class="col-lg-auto col-12">
                    <fieldset class="form border-Field p-0" style="margin-bottom: 0.7em !important;">
                      <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                      <div class="form-row">
                        <div class="d-flex">
                          <div class="radio-group form-radio icheck-primary ml-3"><input type="radio" checked id="radioProduto" name="tipoItem"><label for="radioProduto" class="container escondeRadio">Produto</label></div>
                          <div class="radio-group form-radio icheck-primary"><input type="radio" id="radioMaterial" name="tipoItem"><label for="radioMaterial" class="container escondeRadio">Material</label></div>
                        </div>
                      </div>
                    </fieldset>
                  </div>

                  <div class="col-lg-auto col-12 mt-lg-2 mt-4">
                    <button id="btnCarregaEmpresas" class="btn btn-danger w-100" style="margin-top: 3px;">Selecionar Empresas</button>
                  </div>
                  <div class="col-lg-12 col-12">

                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2">
                        <label data-error="wrong" data-success="right" for="txtDataEmissaoNFI">Emissão NF de/até: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="date" max="2500-12-31" class="input-default focus form-control mr-1" id="txtDataEmissaoNFI" value="1200-01-01" name="txtDataEmissaoNFI" class="form-control">
                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataEmissaoNFF" value="<?php echo date('Y-m-d'); ?>" name="txtDataEmissaoNFF" class="form-control">
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="CodigoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtCodigo" id="lblInputCodigo">Produto: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCodigo" name="txtCodigo" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCodigo" name="btnCodigo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCodigo" name="btnLimpaCodigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="ClienteInfoTour">
                        <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="GrupoMatInfoTour">
                        <label data-error="wrong" data-success="right" for="txtGrupoMat">Grupo Mat: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtGrupoMat" name="txtGrupoMat" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupoMat" name="btnGrupoMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupoMat" name="btnLimpaGrupoMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="SubgrupoMatInfoTour">
                        <label data-error="wrong" data-success="right" for="txtSubgrupoMat">SubGrupo Mat: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtSubgrupoMat" name="txtSubgrupoMat" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnSubgrupoMat" name="btnSubgrupoMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaSubgrupoMat" name="btnLimpaSubgrupoMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="RepresentanteInfoTour">
                        <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaRepresentante" name="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="GrupoCliInfoTour">
                        <label data-error="wrong" data-success="right" for="txtGrupoCli">Grupo Cliente: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtGrupoCli" name="txtGrupoCli" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupoCli" name="btnGrupoCli" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupoCli" name="btnLimpaGrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="GrupoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupo" name="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="ComposicaoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtComposicao">Composição: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtComposicao" name="txtComposicao" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnComposicao" name="btnComposicao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaComposicao" name="btnLimpaComposicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="NCMInfoTour">
                        <label data-error="wrong" data-success="right" for="txtNCM">NCM: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNCM" name="txtNCM" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNCM" name="btnNCM" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNCM" name="btnLimpaNCM" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="CoordInfoTour">
                        <label data-error="wrong" data-success="right" for="txtCoord">Coord.: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCoord" name="txtCoord" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCoord" name="btnCoord" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCoord" name="btnLimpaCoord" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="DepositoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaDeposito" name="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="MoedaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMoeda" name="txtMoeda" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMoeda" name="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="LinhaMatInfoTour">
                        <label data-error="wrong" data-success="right" for="txtLinhaMat">Linha Mat.: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtLinhaMat" name="txtLinhaMat" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnLinhaMat" name="btnLinhaMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaLinhaMat" name="btnLimpaLinhaMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="LinhaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaLinha" name="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="NFInfoTour">
                        <label data-error="wrong" data-success="right" for="txtNF">Nota Fiscal: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNF" name="txtNF" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNF" name="btnNF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNF" name="btnLimpaNF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="ColecaoProdInfoTour">
                        <label data-error="wrong" data-success="right" for="txtColecaoProd">Coleção Prod.: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtColecaoProd" name="txtColecaoProd" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnColecaoProd" name="btnColecaoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaColecaoProd" name="btnLimpaColecaoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="ColecaoPedInfoTour">
                        <label data-error="wrong" data-success="right" for="txtColecaoPed">Coleção Ped.: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtColecaoPed" name="txtColecaoPed" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnColecaoPed" name="btnColecaoPed" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaColecaoPed" name="btnLimpaColecaoPed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="TipoVendaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtTipoVenda">Tipo Venda: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtTipoVenda" name="txtTipoVenda" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnTipoVenda" name="btnTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaTipoVenda" name="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="EstilistaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtEstilista">Estilista: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtEstilista" name="txtEstilista" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnEstilista" name="btnEstilista" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaEstilista" name="btnLimpaEstilista" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="MarcaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMarca" name="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>

                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="PedidoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaPedido" name="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="EstadoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtEstado">Estado: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtEstado" name="txtEstado" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnEstado" name="btnEstado" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaEstado" name="btnLimpaEstado" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="NaturezaInfoTour">
                        <label style="margin: 2px 2px;">
                          <div class="radio-group form-radio icheck-primary" title="Considerar ou desconsiderar natureza."><input type="checkbox" id="cbConsideraNatureza" checked><label for="cbConsideraNatureza"></label></div>
                        </label>
                        <label data-error="wrong" data-success="right" for="txtNatureza">Natureza: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNatureza" name="txtNatureza" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNatureza" name="btnNatureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNatureza" name="btnLimpaNatureza" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="PrazoEntInfoTour">
                        <label data-error="wrong" data-success="right" for="txtPrazoEnt">Prazo Ent.: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtPrazoEnt" name="txtPrazoEnt" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnPrazoEnt" name="btnPrazoEnt" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaPrazoEnt" name="btnLimpaPrazoEnt" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2">
                        <label data-error="wrong" data-success="right" for="txtLote">Lote: </label>
                        <div class="d-flex col-lg-auto col-sm-12 col-12" style="padding-left: 0px !important;">
                          <div class="relative">
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtLote" name="txtLote" class="form-control" placeholder="Lote">
                            </div>
                          </div>
                          <div class="col-auto icheck-primary" style="margin-top: 3%;">
                            <input class="form-check-input mb-0" type="checkbox" id="cbUtilizaPartedoLote" checked> <label for="cbUtilizaPartedoLote" style="margin-top: 8px !important;">Utiliza Parte do Lote.</label>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="MotivoInfoTour">
                        <label data-error="wrong" data-success="right" for="txtMotivo">Motivo: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMotivo" name="txtMotivo" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMotivo" name="btnMotivo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMotivo" name="btnLimpaMotivo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                    </div>
                    <div class="row">

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="CategoriaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtCategoria">Categoria: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCategoria" name="txtCategoria" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCategoria" name="btnCategoria" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCategoria" name="btnLimpaCategoria" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12 mt-2" id="EtiquetaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaEtiqueta" name="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <div class="col-md-6 col-sm-6 col-6">
                          <label data-error="wrong" data-success="right" for="txtCofins">Cofins: (%)</label>
                          <div class="relative">
                            <input type="number" class="input-default focus form-control" id="txtCofins" name="txtCofins" class="form-control" placeholder="Cofins" min="0">
                          </div>
                        </div>
                        <div class="col-md-6 col-sm-6 col-6">
                          <label data-error="wrong" data-success="right" for="txtPis">Pis: (%)</label>
                          <div class="relative">
                            <input type="number" class="input-default focus form-control" id="txtPis" name="txtPis" class="form-control" placeholder="Pis" min="0">
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-3 mt-md-3">
                        <div class="form" id="tiposNotas">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Notas</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="nota" value="0" class="form-check-input" id="cbTodas">
                                <label class="form-check-label" for="cbTodas">Todas</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="nota" value="1" checked="true" class="form-check-input " id="cbNormais">
                                <label class="form-check-label" for="cbNormais">Normais</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="nota" value="2" class="form-check-input" id="cbNormais-Den-Canc">
                                <label class="form-check-label" for="cbNormais-Den-Canc">Normais/Den/Canc</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="nota" value="3" class="form-check-input" id="cbNormais-Den">
                                <label class="form-check-label" for="cbNormais-Den">Normais/Den</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="nota" value="4" class="form-check-input" id="cbNormais-Canc">
                                <label class="form-check-label" for="cbNormais-Canc">Normais/Canc</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-0 mt-md-3">
                        <div class="form" id="tiposDups">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Duplicatas</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="tiposduplicatas" checked="true" value="0" class="form-check-input" id="cbTodasDups">
                                <label class="form-check-label" for="cbTodas">Todas</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="tiposduplicatas" value="1" class="form-check-input " id="cbComDups">
                                <label class="form-check-label" for="cbComDups">Com Duplicatas</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="tiposduplicatas" value="2" class="form-check-input" id="cbSemDups">
                                <label class="form-check-label" for="cbSemDups">Sem Duplicatas</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                        <div>
                          <div class="form" id="tipoInss">
                            <fieldset class="form border-Field col-12">
                              <legend class="textoBorda mb-0 pb-0">Inss</legend>
                              <div class="form-row ml-auto pl-2">
                                <div class="form-group form-check col-4 icheck-primary">
                                  <input type="radio" name="inss" value="0" checked="true" class="form-check-input" id="cbTodosInss">
                                  <label class="form-check-label" for="cbTodas">Todos</label>
                                </div>
                                <div class="form-group form-check col-4 icheck-primary">
                                  <input type="radio" name="inss" value="1" class="form-check-input " id="cbComInss">
                                  <label class="form-check-label" for="cbNormais">Com</label>
                                </div>
                                <div class="form-group form-check col-4 icheck-primary">
                                  <input type="radio" name="inss" value="2" class="form-check-input" id="cbSemInss">
                                  <label class="form-check-label" for="cbNormais-Den-Canc">Sem</label>
                                </div>
                              </div>
                            </fieldset>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12 mt-0 mt-md-3">
                        <div class="form" id="tipoNatureza">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Tipo (Natureza)</legend>
                            <div class="form-row ml-auto pl-3">
                              <div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="V" class="form-check-input " id="cbVendaCompra">
                                  <label class="form-check-label" for="cbVendaCompra">Venda/Compras</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="D" class="form-check-input" id="cbDevolucao">
                                  <label class="form-check-label" for="cbDevolucao">Devolução</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="R" class="form-check-input" id="cbRemessa">
                                  <label class="form-check-label" for="cbRemessa">Remessa</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="O" class="form-check-input" id="cbRetorno">
                                  <label class="form-check-label" for="cbRetorno">Retorno</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="C" class="form-check-input" id="cbConsignacao">
                                  <label class="form-check-label" for="cbConsignacao">Consignação</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="A" class="form-check-input" id="cbAntecipacao">
                                  <label class="form-check-label" for="cbAntecipacao">Antecipação</label>
                                </div>
                              </div>
                              <div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="S" class="form-check-input" id="cbServicos">
                                  <label class="form-check-label" for="cbServicos">Serviços</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="E" class="form-check-input" id="cbEnergiaTelefone">
                                  <label class="form-check-label" for="cbEnergiaTelefone">Energia/Telefone</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="B" class="form-check-input" id="cbBonificacao">
                                  <label class="form-check-label" for="cbBonificacao">Bonificação</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="P" class="form-check-input" id="cbPatrimonio">
                                  <label class="form-check-label" for="cbPatrimonio">Patrimônio</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza icheck-primary" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="I" class="form-check-input" id="cbEstornoImposto">
                                  <label class="form-check-label" for="cbEstornoImposto">Estorno/Imposto</label>
                                </div>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form" id="tipoFiltro">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Filtro</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="filtro" value="0" checked="true" class="form-check-input" id="cbTodosFiltros">
                                <label class="form-check-label" for="cbTodosFiltros">Todos</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="filtro" value="1" class="form-check-input " id="cbProduto">
                                <label class="form-check-label" for="cbProduto">Produto</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="filtro" value="2" class="form-check-input" id="cbMaterial">
                                <label class="form-check-label" for="cbMaterial">Material</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="radio" name="filtro" value="3" class="form-check-input" id="cbServico">
                                <label class="form-check-label" for="cbServico">Serviço</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form" id="tipoCategoria">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Categoria</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="checkbox" value="1" class="form-check-input" id="cbCliente">
                                <label class="form-check-label" for="cbCliente">Cliente</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="checkbox" value="2" class="form-check-input " id="cbFornecedor">
                                <label class="form-check-label" for="cbFornecedor">Fornecedor</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <input type="checkbox" value="3" class="form-check-input" id="cbTerceiros">
                                <label class="form-check-label" for="cbTerceiros">Terceiros</label>
                              </div>
                              <div class="form-group form-check col-12 icheck-primary">
                                <select class="input-default focus custom-select" style="width: 90%; height: 90%;" id="selectTipoEntidade">
                                  <option value="0">Considerar</option>
                                  <option value="1">Desconsiderar</option>
                                </select>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12" style="margin-top: 1%">
                        <div class="form-group form-check col-12 icheck-primary">
                          <input type="checkbox" value="3" class="form-check-input" id="cbMostraOuNaoNFEDevolucao">
                          <label class="form-check-label" for="cbMostraOuNaoNFEDevolucao">Não mostrar NFe de Devolução.</label>
                        </div>

                        <div class="form-group form-check col-12 icheck-primary">
                          <input type="checkbox" value="3" class="form-check-input" id="cbConsideraFatorConversao">
                          <label class="form-check-label" for="cbConsideraFatorConversao">Considerar Fator Conversão.</label>
                        </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start">
            <div class="row col-lg-12 col-12 pl-3">
              <div class="col-lg-4 col-sm-6 col-md-6">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimpaFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../modais.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.255.29.2"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.255.29.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.255.29.2"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.255.29.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.255.29.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.29.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.255.29.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.255.29.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.255.29.2"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.255.29.2"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.255.29.2"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.255.29.2"></script>
  <script src="dist/js/sisplan.js?versao=3.255.29.2"></script>
  <script src="utils/funcoes.js?versao=3.255.29.2"></script>
  <script src="utils/cookies.js?versao=3.255.29.2"></script>
  <script src="dist/js/driver.min.js?versao=3.255.29.2"></script>
  <script src="config.js?versao=3.255.29.2"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.255.29.2"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.255.29.2"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.255.29.2"></script>
  <script src="graficos/graficos.js?versao=3.255.29.2"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELPECASFATURADAS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relpecasfaturadas/relpecasfaturadas.js?versao=3.255.29.2`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela


      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);

    });
  </script>

</body>

</html>