$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#divCliente',
      popover: {
        title: 'Campo Cliente',
        description: 'Informe o campo cliente para mostrar o resumo dele.',
        position: 'bottom'
      }
    },
    {
      element: '#divBuscaGrupo',
      popover: {
        title: 'Buscar resumo pelo grupo do cliente.',
        description: 'Selecionando essa opção a consulta será realizada pelo grupo do cliente informado.',
        position: 'bottom'
      }
    },
    {
      element: '#btnConsultarCliente',
      popover: {
        title: 'Botão Consultar',
        description: 'Ao clicar nesse botão irá preencher os dados do resumo do cliente.',
        position: 'left'
      }
    },
    {
      element: '#btnImprimirCliente',
      popover: {
        title: 'Botão Imprimir',
        description: 'Ao clicar nesse botão você imprime os dados do resumo do cliente.',
        position: 'left'
      }
    },
    {
      element: "#abaGeral",
      popover: {
        title: "Abas de Consulta",
        description:
          "Ao clicar nessas abas você retorna pesquisa pelas informações do cliente Resumo/Estatística.",
        position: "bottom",
      },
    },
      // {
      //   element: '#dadosCliente',
      //   popover: {
      //     title: 'Dados do Cliente',
      //     description: 'Aqui estão os dados do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#dadosComercial',
      //   popover: {
      //     title: 'Dados Comercial',
      //     description: 'Aqui estão os dados comerciais do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#dadosFinanceiro',
      //   popover: {
      //     title: 'Dados Financeiro',
      //     description: 'Aqui estão os dados financeiros do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#obsCliente',
      //   popover: {
      //     title: 'Observações Cliente',
      //     description: 'Aqui estão as observações do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#empresaColigadasGrupoCliente',
      //   popover: {
      //     title: 'Empresas Coligadas por Grupo de Cliente',
      //     description: 'Aqui estão os dados das Empresas Coligadas por Grupo do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#abaEstatisticas',
      //   popover: {
      //     title: 'Aba Estatisticas',
      //     description: 'Aqui estão as estatisticas do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#divDuplicatas',
      //   popover: {
      //     title: 'Duplicatas',
      //     description: 'Aqui estão os dados do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#divPedidos',
      //   popover: {
      //     title: 'Pedidos',
      //     description: 'Aqui estão os dados do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#divVendas',
      //   popover: {
      //     title: 'Vendas',
      //     description: 'Aqui estão os dados do cliente informado.',
      //     position: 'top'
      //   }
      // },
      // {
      //   element: '#divFaturas',
      //   popover: {
      //     title: 'Faturas',
      //     description: 'Aqui estão os dados do cliente informado.',
      //     position: 'top'
      //   }
      // }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  /////COLUNAS INVISIVEIS
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.analiseDuplicatas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseDuplicatas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analisePedidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analisePedidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analiseVendas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseVendas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analiseFaturas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseFaturas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('analiseduplicatas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseDuplicatas: novasColunas }))
        $('#tabelaEstatisticasDuplicatas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisepedidos') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analisePedidos: novasColunas }))
        $('#tabelaEstatisticasPedidos').DataTable().columns().visible(true);
        $('#tabelaEstatisticasPedidos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisevendas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseVendas: novasColunas }))
        $('#tabelaEstatisticasVendas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasVendas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisefaturas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseFaturas: novasColunas }))
        $('#tabelaEstatisticasFaturas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasFaturas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('analiseduplicatas') == 'true') {
      $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseDuplicatas ?? [], ['NUMERO'])
    } else if (localStorage.getItem('analisepedidos') == 'true') {
      $('#tabelaEstatisticasPedidos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analisePedidos ?? [], [])
    } else if (localStorage.getItem('analisevendas') == 'true') {
      $('#tabelaEstatisticasVendas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseVendas ?? [], [])
    } else if (localStorage.getItem('analisefaturas') == 'true') {
      $('#tabelaEstatisticasFaturas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseFaturas ?? [], [])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('analiseduplicatas')
    localStorage.removeItem('analisepedidos')
    localStorage.removeItem('analisevendas')
    localStorage.removeItem('analisefiscais')
  })
  /////COLUNAS INVISIVEIS

  const columnsObservacao = [
    { data: "ID", title: 'Id' },
    { data: "NUMERO", title: 'Número' },
    { data: "OBS", title: 'Observação', width: '600px !important' },
    { data: "MOTIVO", title: 'Motivo', width: '200px' },
    { data: "USUARIO", title: 'Usuário' },
    { data: "DATA", title: 'Dt.Cadastro' },
    { data: "EMP_ID", title: 'EmpId' },
  ]
  const columnsObservacaoCliente = [
    { data: "ID", title: 'Id' },
    { data: "ORDEM", title: 'Ordem' },
    { data: "NUMERO", title: 'Número' },
    { data: "OBSERVACAO", title: 'Observação', width: '600px !important' },
    { data: "MOTIVO", title: 'Motivo', width: '200px' },
    { data: "USUARIO", title: 'Usuário' },
    { data: "DATA", title: 'Dt.Cadastro' },
  ]
  const columnsEmpresasColigadasGrupoCliente = [
    { data: "CODCLI", title: 'Cod. Cliente' },
    { data: "CNPJ", title: 'CNPJ' },
    { data: "NOME", title: 'Nome' },
    { data: "VALOR_CONSUMO_CLIENTE", title: 'Valor Consumo Cliente' },
  ]

  function retornaBotaoOpcoes(id) {
    const retorno = /*html*/`
        <div>
          <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> 
            ${id}  
          </button> 
          <div class="dropdown-menu dropdown" style="z-index:999999999"> 
            <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Visualizar</button>
          </div>
        </div>
  `
    return retorno;
  };

  function retornaBotaoOpcoesDuplicatasEstatisticas(id) {
    const retorno = /*html*/`
        <div>
          <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> 
            ${id}  
          </button> 
          <div class="dropdown-menu dropdown" style="z-index:999999999"> 
            <button class="dropdown-item" type="button" id="btnObservacao">Observação</button>
          </div>
        </div>
  `
    return retorno;
  };

  $('#btnAbrirModalObs').on('click', function () {
    $('#modal_obs').modal('show');
  });

  async function preencheMotivo(motivo) {
    if (motivo !== '') {
      const json = await retornaJsonPesquisaPadrao(`{ "tabela":"MENSAGEM", "camposSelect":["CODMEN", "DESCRICAO"], "where": ["CODMEN = '${motivo}'"] }`);
      if (!json) {
        return;
      }

      if (json.length == 0) {
        return;
      }
      insereValor(`#txtMotivoObs`, json[0].CODMEN, json[0].DESCRICAO);
    }
  }

  $('#tabelaObsCliente').on('click', '#btn-editar', async function () {
    $.LoadingOverlay('show');
    const data = $('#tabelaObsCliente').DataTable().row($(this).parents('tr')).data();
    await preencheMotivo(data.MOTIVO)
    $('#txtNumeroObs').val(data.NUMERO)
    $('#txtObs').val(data.OBSERVACAO)
    $('#txtDataObs').val(formataData(new Date(data.DATA)))
    $('#txtClienteObs').val(data.CODCLI)
    $('#txtUsuarioObs').val(data.USUARIO)
    $('#txtIdObs').val(data.ID)

    $('#txtNumeroObs').prop('disabled', true)
    $('#btnConfirmarObs').prop('disabled', true)
    $('#txtObs').prop('disabled', true)
    $('#txtMotivoObs').prop('disabled', true)
    $('#txtDataObs').prop('disabled', true)
    $('#txtClienteObs').prop('disabled', true)
    $('#txtUsuarioObs').prop('disabled', true)
    $('#txtIdObs').prop('disabled', true)
    $('#btnLimpaMotivoObs').prop('disabled', true)
    $('#btnMotivoObs').prop('disabled', true)

    $('#modal_obs').modal('show');
    $.LoadingOverlay('hide');

  });

  $('#btnFecharObs').on('click', function () {
    $('#modalObservacao').modal('hide');
  })

  $('#btnGravarObs').on('click', function () {

    $('#txtNumeroObs').prop('disabled', true)
    $('#btnConfirmarObs').prop('disabled', false)
    $('#txtObs').prop('disabled', false)
    $('#txtMotivoObs').prop('disabled', false)
    $('#txtDataObs').prop('disabled', false)
    $('#txtClienteObs').prop('disabled', false)
    $('#txtUsuarioObs').prop('disabled', false)
    $('#txtIdObs').prop('disabled', false)
    $('#btnLimpaMotivoObs').prop('disabled', false)
    $('#btnMotivoObs').prop('disabled', false)
    $('#txtObs').val('')
    limpaValor('#txtMotivoObs')
    $('#txtDataObs').val(formataData(new Date()))
    $('#txtClienteObs').val($('#txtCodigo').val())
    $('#txtUsuarioObs').val(sessionStorage.getItem("g_usuario_logado"))
    $('#txtIdObs').val('')

    if ($('#txtCodigo').val() === '') {
      msgAlerta('Informe um cliente para gravar a observação!');
      return;
    }

    $('#modal_obs').modal('show');
  })

  $('#btnConfirmarObs').on('click', async function () {
    try {
      $('#btnConfirmarObs').prop('disabled', true);

      $.LoadingOverlay('show');
      const obj = {
        id: $('#txtIdObs').val(),
        codcli: $('#txtClienteObs').val(),
        data: new Date($('#txtDataObs').val()),
        numero: $('#txtNumeroObs').val(),
        usuario: $('#txtUsuarioObs').val(),
        observacao: $('#txtObs').val(),
        ordem: $.fn.DataTable.isDataTable('#tabelaObsCliente') ? $('#tabelaObsCliente').DataTable().rows().count() + 1 : 1,
        motivo: pegaChave('#txtMotivoObs')
      }
      const resp = await requisicao('POST', '/sisplan/analisefinanceira/v1/observacaocliente?', '', JSON.stringify(obj))

      if (resp.status === 200 || resp.status == 502) {
        if (resp.status == 502) {
          const json = await resp.json();
          await msgAguardaConfirmacao(json.mensagem, () => { }, () => { }, false, true, "Continuar");
        }
        await criaTabelaObs()
        toastr
          .success(`Nova observação cadastrada para o cliente: ${$('#txtClienteObs').val()}!`, "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal_obs').modal('hide');
      $('#btnConfirmarObs').prop('disabled', false);
    }
  })

  async function criaTabelaObs() {
    const pesquisa = {
      camposSelect: ['ID', 'ORDEM', 'CODCLI', 'DATA', 'NUMERO', 'USUARIO', 'OBSERVACAO', 'MOTIVO'],
      tabela: 'ENTID_OBS',
      where: [`CODCLI = '${$('#txtCodigo').val()}'`],
      orderBy: ['ORDEM DESC']
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if ($.fn.DataTable.isDataTable('#tabelaObsCliente')) {
      $('#tabelaObsCliente').DataTable().clear().draw(false);
      $("#tabelaObsCliente").DataTable().destroy();
      $("#tabelaObsCliente").empty();
    }

    if (jsonStr.length > 0) {

      $('#tabelaObsCliente').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        "data": jsonStr,
        "columns": columnsObservacaoCliente,
        "columnDefs": [
          {
            targets: [0],
            render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 6,
          }
        ]
      });
      $('#tabelaObsCliente').DataTable().columns.adjust().draw(false);
    }
  }

  function criaTabelaEmpresasColigadasGrupoCliente(dados) {
    if (dados.length === 0) {
      if ($.fn.DataTable.isDataTable('#tabelaEmpresasColigadasGrupoCliente')) {
        $('#tabelaEmpresasColigadasGrupoCliente').DataTable().clear().draw(false);
        $("#tabelaEmpresasColigadasGrupoCliente").DataTable().destroy();
        $("#tabelaEmpresasColigadasGrupoCliente").empty();
      }
    } else {

      const data = JSON.parse(dados);

      $('#tabelaEmpresasColigadasGrupoCliente').DataTable({
        paging: true,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        "data": data,
        "columns": columnsEmpresasColigadasGrupoCliente
      });
    }
  }

  $('#tabelaEmpresasColigadasGrupoCliente tbody').on('dblclick', 'tr', async function () {
    const data = $('#tabelaEmpresasColigadasGrupoCliente').DataTable().row($(this)).data();

    insereValor('#txtCliente', data.CODCLI, data.NOME);

    $('#btnConsultarCliente').trigger('click');
    // await consultaDadosAnaliseFinanceira(data.CODCLI)
  })

  async function consultaDadosAnaliseFinanceira(codcli) {
    try {
      $.LoadingOverlay('show');

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/consultaanalisefinanceira?codcli=${codcli}&GRUPO=${$('#cbGrupoClienteResumo').prop('checked') ? 'S' : ''}&`)

      $('#multiCollapseExample1').addClass('show')
      $('#multiCollapseExample2').addClass('show')
      $('#multiCollapseExample3').addClass('show')
      $('#multiCollapseExample4').addClass('show')
      $('#multiCollapseExample5').addClass('show')

      if (resp.status === 200 || resp.status == 502) {
        let jsonStr = await resp.json();
        if (resp.status == 502) {
          await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
          jsonStr = JSON.parse(jsonStr.json)
        }
        preencheValoresCampo(jsonStr.analise[0])
        await criaTabelaObs()
      } else {
        $('#multiCollapseExample1').addClass('hide')
        $('#multiCollapseExample2').addClass('hide')
        $('#multiCollapseExample3').addClass('hide')
        $('#multiCollapseExample4').addClass('hide')
        $('#multiCollapseExample5').addClass('hide')
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $("#tabelaEstatisticasDuplicatas").on('click', "#btnObservacao", async function () {
    try {
      $.LoadingOverlay('show')

      const data = $('#tabelaEstatisticasDuplicatas').DataTable().row($(this).parents('tr')).data();

      await abreModalObservacao(data);

      $('#modalObservacao').modal('show')
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function abreModalObservacao(data) {
    await buscaObservacoesTituloSenior(data.NUMERO, data.TIPO_DOC, data.EMP_PAT)
    const observacao = await buscaObservacoesTitulo(data.NUMERO);
    const ID = (observacao.length + 1)
    $('#txtIdObservacaoReceber').val(ID)
    $('#txtNumeroObservacaoReceber').val(data.NUMERO)
    $('#txtUsuarioObservacaoReceber').val(getCookie('g_usuario_logado'))
    await setarDataAtual("dtCadastroObservacaoReceber")

    if ($.fn.DataTable.isDataTable('#tabelaObservacoesReceber')) {
      $('#tabelaObservacoesReceber').DataTable().destroy();
      $('#tabelaObservacoesReceber').empty();
    }

    $("#tabelaObservacoesReceber").DataTable({
      paging: false,
      filter: false,
      destroy: true,
      ordering: false,
      autoWidth: true,
      data: observacao,
      columns: columnsObservacao,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
          targets: 5,
        }
      ],
    });

  }

  async function buscaObservacoesTitulo(numero) {
    const pesquisa = {
      camposSelect: ['HIST_FINAN.ID', 'HIST_FINAN.NUMERO', 'HIST_FINAN.USUARIO', 'HIST_FINAN.DATA', "(HIST_FINAN.MOTIVO || '-' || MENSAGEM.DESCRICAO) MOTIVO", 'HIST_FINAN.OBS', 'HIST_FINAN.EMP_ID'],
      tabela: 'HIST_FINAN',
      leftJoin: [{ tabela: "MENSAGEM", condicao: "HIST_FINAN.MOTIVO = MENSAGEM.CODMEN" }],
      where: [`HIST_FINAN.NUMERO = '${numero}'`, `HIST_FINAN.TIPO IN ('O', 'M')`],
      orderBy: [`HIST_FINAN.ID DESC`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (!jsonStr.length) {
      return []
    } else {
      return jsonStr
    }
  }

  async function buscaObservacoesTituloSenior(numero, tipoTitulo, empPatTitulo) {
    const params = `NUMERO_TITULO=${numero}` +
      `&TIPO_TITULO=${tipoTitulo}` +
      `&EMP_ID_TITULO=${empPatTitulo.substring(1, 4)}`;
    try {

      const response = await requisicao("GET", `/sisplan/senior/v1/observacaoreceber?`, params, '', 30000);

      if (!response) {
        throw new Error("Não foi possível consultar as observações de título da Senior");
      }

      if (response.status != 200) {
        const json = await response.json();
        throw new Error(json.mensagem);
      }

    } catch (error) {
      await msgAguardaConfirmacao(error.message, () => { }, () => { }, false, true, "Continuar");
      console.error(error)
    }
  }

  $('#btnGravarObservacaoReceber').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      if ($('#txtMotivoObservacaoReceber').val() === '') {
        throw msgAlerta('Necessário informar um motivo, verifique!')
      }
      if ($('#txtAreaObservacaoReceber').val() === '') {
        throw msgAlerta('Necessário informar uma observação, verifique!')
      }
      const body = {
        id: $('#txtIdObservacaoReceber').val(),
        numero: $('#txtNumeroObservacaoReceber').val(),
        usuario: $('#txtUsuarioObservacaoReceber').val(),
        data: $('#dtCadastroObservacaoReceber').val(),
        motivo: pegaChave('#txtMotivoObservacaoReceber'),
        tipo: 'O',
        observacao: $('#txtAreaObservacaoReceber').val(),
      }

      let response = await requisicao("POST", `/sisplan/receber/v1/observacao?`, '', JSON.stringify(body), 30000);

      if (!response) {
        return
      }

      const observacao = await buscaObservacoesTitulo($('#txtNumeroObservacaoReceber').val())
      $("#tabelaObservacoesReceber").DataTable({
        paging: false,
        filter: false,
        destroy: true,
        autoWidth: true,
        data: observacao,
        columns: columnsObservacao,
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ],
      });

      toastr
        .success(`Nova observação cadastrada para o título: ${$('#txtNumeroObservacaoReceber').val()}!`, "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      await limpaCamposModalObs()

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  })


  async function limpaCamposModalObs() {
    await setarDataAtual("dtObservacaoCadastro");
    $('#txtMotivoObservacaoReceber').val('')
    $('#txtAreaObservacaoReceber').val('')
  }

  function preencheValoresCampo(data) {
    // Dados do Cliente
    $('#txtCodigo').val(data.codcli);
    $('#txtInscricao').val(data.inscricao);
    $('#txtCNPJ').val(data.cnpj);
    $('#txtRazaoSocial').val(`${data.nome}`);
    $('#txtFantasia').val(data.fantasia);
    $('#txtRepresentante').val(`${data.codrep} - ${data.nomeRep}`);
    $('#txtEmail').val(data.email);
    $('#txtEndereco').val(data.endereco);
    $('#txtBairro').val(data.bairro);
    $('#txtNumero').val(data.numero);
    $('#txtRamoAtividade').val(data.ramoAtividade);
    $('#txtCidade').val(data.cidade);
    $('#txtUf').val(data.uF);
    $('#txtPais').val(data.pais);
    $('#txtSig').val(data.siglaPais);
    $('#txtTelefone').val(`(${data.ddd_fone}) - ${data.telefone}`);
    $('#txtFax').val(`${data.dddFax}`);
    $('#txtGrupo').val(`${data.grupo}`);
    $('#txtCadastro').val(data.dataCad.split('T')[0]);
    $('#txtFundacao').val(data.dataFund.split('T')[0]);
    $('#txtClassificacao').val(data.classifica);
    $('#txtSituacaoComercial').val(data.situacaoComercial);
    $('#txtLimiteGrupo').val(data.limiteGrupo);
    $('#txtDataValidadeLimite').val(data.dtValidaLimite.split('T')[0]);

    // Dados Comercial
    $('#txtNumeroUltimoPedido').val(data.numeroUltimoPedido);
    $('#txtValorUltimoPedido').val(formataValor(TruncaDecimaisNova(2, data.valorUltimoPedido)));
    $('#txtDataUltimoPedido').val(data.dataUltimoPedido.split('T')[0]);
    $('#txtNumeroUltimaVenda').val(data.numeroUltimaVenda);
    $('#txtValorUltimaVenda').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaVenda)));
    $('#txtDataUltimaVenda').val(data.dataUltimaVenda.split('T')[0]);
    $('#txtSerieUltimaNFE').val(data.serieUltimaNFE);
    $('#txtValorUltimaNFE').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaNFE)));
    $('#txtDataUltimaNFE').val(data.dataUltimaNFE.split('T')[0]);
    $('#txtValorMaiorFaturaNFE').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorFaturaNFE)));
    $('#txtDataMaiorFaturaNFE').val(data.dataMaiorFaturaNFE.split('T')[0]);
    $('#txtSerieUltimaNFCE').val(data.serieUltimaNFCE);
    $('#txtValorUltimaNFCE').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaNFCE)));
    $('#txtDataUltimaNFCE').val(data.dataUltimaNFCE.split('T')[0]);
    $('#txtValorMaiorFaturaNFCE').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorFaturaNFCE)));
    $('#txtDataMaiorFaturaNFCE').val(data.dataMaiorFaturaNFCE.split('T')[0]);
    $('#txtValorMaiorAcumulo').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorAcumulo)));
    $('#txtDataMaiorAcumulo').val(data.dataMaiorAcumulo.split('T')[0]);

    // Dados Financeiro
    // 1° coluna
    $('#txtAtrasoMedio').val(data.mediaAtraso);
    $('#txtDiasEmAtraso').val(TruncaDecimaisNova(0, data.diasAtraso));
    $('#txtDupEmAberto').val(formataValor(TruncaDecimaisNova(2, data.emAberto)));
    $('#txtDupEmAtraso').val(formataValor(TruncaDecimaisNova(2, data.emAtraso)));
    $('#txtAntecipacaoDevolucao').val(formataValor(TruncaDecimaisNova(2, data.antecipacaoDevolucao)));
    $('#txtTotalEmAberto').val(formataValor(TruncaDecimaisNova(2, data.emAberto)));
    $('#txtSituacaoCobranca').val(data.infCobranca); // falta
    $('#txtDataSituacaoCobranca').val(data.dtAnalise.split('T')[0]); // falta
    $('#txtDataProximaCobranca').val(data.dtPrev_analise.split('T')[0]); // falta

    if (data.historicos) {
      data.historicos.forEach((element, i) => {
        $(`#txtHistorico-${i}`).val(element);
      });
    }

    // 2° coluna

    $('#txtDuplicataPedidoVista').val(formataValor(TruncaDecimaisNova(2, data.dupPedAvista)));
    $('#txtVistaVencida').val(formataValor(TruncaDecimaisNova(2, data.avistaVencida)));
    $('#txtJuros').val(formataValor(TruncaDecimaisNova(2, data.juros))); // falta
    $('#txtPedidosEmAberto').val(formataValor(TruncaDecimaisNova(2, data.pedPend)));
    $('#txtSituacaoCredito').val(data.limiteSuspenso);
    $('#txtLimiteDeCredito').val(formataValor(TruncaDecimaisNova(2, data.credito)));
    $('#txtTitulosReceber').val(formataValor(TruncaDecimaisNova(2, data.titulos)));
    $('#txtTotalPedidosTitulos').val(formataValor(TruncaDecimaisNova(2, data.totalPedidosTitulos)));
    $('#txtSaldoLimiteCredito').val(formataValor(TruncaDecimaisNova(2, data.saldoLimiteCredito)));
    $('#txtSaldoLimiteGrupo').val(data.saldoLimiteGrupo); // falta

    //  3° coluna dados financeiro
    $('#txtUltimoParecer').val(data.ultimoParecer); // falta
    $('#txtSituacaoParecer').val(data.situacaoParecer); // fata
    $('#txtUltimaCompra').val(data.ultPedido.split('T')[0]); // falta
    $('#txtUltimaFatura').val(data.ultFatura.split('T')[0]); // falta
    $('#txtSintegra').val(data.sintegra); // falta
    $('#txtUltimaConsSerasa').val(data.ultCons.split('T')[0]);
    $('#txtUltimaAtualizacaoLimite').val(data.dtUltAtuaLimite.split('T')[0]); // falta
    $('#txtValidadeLimiteCredito').val(data.dtValidaLimiteCli.split('T')[0]);

    $('#txtPeriodoBaseDe').val(data.dtPeriodoDe.split('T')[0]);
    $('#txtPeriodoBaseAte').val(data.dtPeriodoAte.split('T')[0]);

    $('#cbAtivo').prop('checked', data.ativo === 'S');
    $('#cbBloqueado').prop('checked', data.bloqueado === 'S');

    criaTabelaEmpresasColigadasGrupoCliente(data.grupoColigados)

    $('#tabelaEmpresasColigadasGrupoCliente').DataTable().columns.adjust().draw(false);
  }
  function criaTabelaEstatisticasPedidos(dados) {
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      if ($.fn.DataTable.isDataTable('#tabelaEstatisticasPedidos')) {
        $('#tabelaEstatisticasPedidos').DataTable().clear().draw(false);
        $("#tabelaEstatisticasPedidos").DataTable().destroy();
        $("#tabelaEstatisticasPedidos").empty();
      }
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasPedidos').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [2, 3],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [7, 9, 10, 22, 23, 24],
        },
        {
          className: 'pr-4 text-right',
          targets: [1, 4, 5, 6]
        }
      ],
    });

    $('#tabelaEstatisticasPedidos_length').prepend('<button class="buttonColVis" id="buttonColVisPedidos"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasPedidos_length').prepend('<button class="buttonExcel" id="buttonExcelPedidos"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPedidos').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPedidos').prop('title', 'Exportar')

    $('#buttonColVisPedidos').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisepedidos', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPedidos').on('click', async function () {
      let dados = $("#tabelaEstatisticasPedidos").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Pedidos', '#tabelaEstatisticasPedidos', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasPedidos').DataTable().columns(colunas.analisePedidos ?? []).visible(false);
    $('#tabelaEstatisticasPedidos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analisePedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaEstatisticasDuplicatas(dados) {
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      if ($.fn.DataTable.isDataTable('#tabelaEstatisticasDuplicatas')) {
        $('#tabelaEstatisticasDuplicatas').DataTable().clear().draw(false);
        $("#tabelaEstatisticasDuplicatas").DataTable().destroy();
        $("#tabelaEstatisticasDuplicatas").empty();
      }
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasDuplicatas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [1],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          targets: [0],
          render: function (data, type, row) {
            return retornaBotaoOpcoesDuplicatasEstatisticas(data);
          }
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [7, 9, 10],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [11, 12, 13, 14, 15],
        },
        {
          className: 'pr-4 text-right',
          targets: [4, 6]
        },
      ],
      "createdRow": function (row, data) {
        if ((data.VALOR_PAGO < data.VALOR) && (new Date() > new Date(data.DT_VENCTO.split(" ")[0]))) {
          $(row).css('background-color', 'rgba(245, 81, 81, 1)');
        }
      }
    });

    $('#tabelaEstatisticasDuplicatas_length').prepend('<button class="buttonColVis" id="buttonColVisDuplicatas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasDuplicatas_length').prepend('<button class="buttonExcel" id="buttonExcelDuplicatas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisDuplicatas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelDuplicatas').prop('title', 'Exportar')

    $('#buttonColVisDuplicatas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analiseduplicatas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelDuplicatas').on('click', async function () {
      let dados = $("#tabelaEstatisticasDuplicatas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Duplicatas', '#tabelaEstatisticasDuplicatas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasDuplicatas').DataTable().columns(colunas.analiseDuplicatas ?? []).visible(false);
    $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseDuplicatas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }


  function criaTabelaEstatisticasVendas(dados) {
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      if ($.fn.DataTable.isDataTable('#tabelaEstatisticasVendas')) {
        $('#tabelaEstatisticasVendas').DataTable().clear().draw(false);
        $("#tabelaEstatisticasVendas").DataTable().destroy();
        $("#tabelaEstatisticasVendas").empty();
      }
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasVendas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [2],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [5, 8, 10],
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat(
                "pt-BR",
                {
                  year: "numeric",
                  month: "2-digit",
                  day: "2-digit",
                  hour: "numeric",
                  minute: "numeric",
                  second: "numeric"
                })
                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                .replace(",", "");
            } else {
              return ''
            }
          },
          targets: [6],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [14],
        },
        {
          className: 'pr-4 text-right',
          targets: [4, 13]
        }
      ],
    });

    $('#tabelaEstatisticasVendas_length').prepend('<button class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasVendas_length').prepend('<button class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisVendas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelVendas').prop('title', 'Exportar')

    $('#buttonColVisVendas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisevendas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelVendas').on('click', async function () {
      let dados = $("#tabelaEstatisticasVendas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Vendas', '#tabelaEstatisticasVendas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasVendas').DataTable().columns(colunas.analiseVendas ?? []).visible(false);
    $('#tabelaEstatisticasVendas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseVendas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }


  function criaTabelaEstatisticasFaturas(dados) {
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      if ($.fn.DataTable.isDataTable('#tabelaEstatisticasFaturas')) {
        $('#tabelaEstatisticasFaturas').DataTable().clear().draw(false);
        $("#tabelaEstatisticasFaturas").DataTable().destroy();
        $("#tabelaEstatisticasFaturas").empty();
      }
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasFaturas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [3],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [14],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [11, 12, 13],
        },
        {
          className: 'pr-4 text-right',
          targets: [5, 16]
        }
      ],
    });

    $('#tabelaEstatisticasFaturas_length').prepend('<button class="buttonColVis" id="buttonColVisFaturas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasFaturas_length').prepend('<button class="buttonExcel" id="buttonExcelFaturas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisFaturas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelFaturas').prop('title', 'Exportar')

    $('#buttonColVisFaturas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisefaturas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelFaturas').on('click', async function () {
      let dados = $("#tabelaEstatisticasFaturas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Faturas', '#tabelaEstatisticasFaturas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasFaturas').DataTable().columns(colunas.analiseFaturas ?? []).visible(false);
    $('#tabelaEstatisticasFaturas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseFaturas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  $('#btnConsultarDuplicatas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtVencimentoDe: $('#txtDataVencimentoDuplicatasDe').val(),
        DtVencimentoAte: $('#txtDataVencimentoDuplicatasAte').val(),
        DtEmissaoDe: $('#txtEmissaoDuplicatasDe').val(),
        DtEmissaoAte: $('#txtEmissaoDuplicatasAte').val(),
        DtRecebimentoDe: $('#txtRecebimentoDuplicatasDe').val(),
        Grupo: $('#cbGrupoClienteDuplicatas').prop('checked') ? $('#txtGrupo').val() : '',
        DtRecebimentoAte: $('#txtRecebimentoDuplicatasAte').val(),
        Situacao: $("input[name=radioSituacaoDup]:checked").val(),
        Listar: $("input[name=radioListarDup]:checked").val(),
        CodCli: pegaChave('#txtCliente'),
        OrdemOrdenacao: $('#txtOrdemDuplicatas').val()
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscaduplicatas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();
        criaTabelaEstatisticasDuplicatas(jsonStr);

        const dados = $('#tabelaEstatisticasDuplicatas').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFDuplicatas',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Duplicatas',
          colunasAgrupamento: ['TIPO_DOC'],
          colunasValor: ['VALOR_PAGO']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  function formataValor(numero) {
    return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
  }

  $('#btnConsultarVendas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DataDe: $('#txtDtEmissaoVendaDe').val(),
        DataAte: $('#txtDtEmissaoVendaAte').val(),
        CodCli: pegaChave('#txtCliente'),
        Emitido: $('#cbEmitido').prop('checked'),
        Devolvido: $('#cbDevolvido').prop('checked'),
        Pendente: $('#cbPendente').prop('checked'),
        Grupo: $('#cbGrupoClienteVenda').prop('checked') ? $('#txtGrupo').val() : '',
        Agrupada: $('#cbAgrupada').prop('checked'),
        Canceladas: $('#checkCanceladas').prop('checked') ? '1' : '0'
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscavendas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();
        criaTabelaEstatisticasVendas(jsonStr)

        const dados = $('#tabelaEstatisticasVendas').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFVendas',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Vendas',
          colunasAgrupamento: ['STATUS'],
          colunasValor: ['VALOR']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarFaturas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoFaturaDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoFaturaAte').val(),
        Grupo: $('#cbGrupoClienteFatura').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscafaturas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();
        criaTabelaEstatisticasFaturas(jsonStr)

        const dados = $('#tabelaEstatisticasFaturas').DataTable().data().toArray();
        const legendaImpresso = {
          S: "Impresso",
          N: "Não impresso",
          C: "Cancelado",
          D: "Denegado"
        };
        const dadosFormatados = dados.map(item => ({
          ...item,
          IMPRESSO: legendaImpresso[item.IMPRESSO] || item.IMPRESSO
        }));

        Graficos.criarGrafico({
          container: 'graficoAFFaturas',
          tipo: 'donut',
          dados: dadosFormatados,
          nomeSerie: 'Faturas',
          colunasAgrupamento: ['IMPRESSO'],
          colunasValor: ['VALOR']
        })
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarPedidos').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoPedidoDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoPedidoAte').val(),
        DtPrevFaturamentoDe: $('#txtDtPrevFaturamentoPedidoDe').val(),
        DtPrevFaturamentoAte: $('#txtDtPrevFaturamentoPedidoAte').val(),
        Situacao: $("input[name=radioSituacaoPedido]:checked").val(),
        Grupo: $('#cbGrupoClientePedido').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscapedidos?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();
        criaTabelaEstatisticasPedidos(jsonStr)

        const dados = $('#tabelaEstatisticasPedidos').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFPedidos',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Pedidos',
          colunasAgrupamento: ['VAL_PEND', 'VAL_CANC', 'VAL_FAT'],
          colunasValor: ['VAL_PEND', 'VAL_CANC', 'VAL_FAT']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarCliente').on('click', async function () {
    if (pegaChave('#txtCliente') == '') {
      msgAlerta('Informe um cliente para consultar os dados!');
      return;
    }
    limpaTabelasEstatisticas()
    await consultaDadosAnaliseFinanceira(pegaChave('#txtCliente'));
    $('#modal_consulta').modal('hide')
  })


  const sWhere = []

  const selectTxtCliente = {
    tabela: "ENTIDADE",
    camposSelect: ["CODCLI CHAVE", "NOME ||' - '|| CNPJ DESCRICAO", "CNPJ"],
  }

  const selectBtnClienteLoja = {
    tabela: "ENTIDADE",
    camposSelect: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "ENTIDADE.COD_IMPORTADO", "CIDADE.NOME CIDADE", "CADCEP.ESTCEP"],
    leftJoin: [{
      tabela: "CADCEP",
      condicao: "CADCEP.CEP = ENTIDADE.CEP"
    },
    {
      tabela: "CIDADE",
      condicao: "CIDADE.CODIGO = CADCEP.CODMUN"
    }],
    where: sWhere,
    camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "ENTIDADE.COD_IMPORTADO", "CIDADE.NOME", "CADCEP.ESTCEP"]
  }

  $('#txtMotivoObservacaoReceber').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnMotivoObservacaoReceber').pesquisa('#txtMotivoObservacaoReceber', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnLimpaMotivoObservacaoReceber').on('click', function () { $('#txtMotivoObservacaoReceber').val('') })

  $('#txtMotivoObs').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnMotivoObs').pesquisa('#txtMotivoObs', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnLimpaMotivoObs').on('click', function () { $('#txtMotivoObs').val('') })

  $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
  $('#btnCliente').pesquisa_serverside(
    ['#txtCliente', '#txtCNPJ'],
    ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
    ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
    JSON.stringify(selectBtnClienteLoja),
    'Pesquisa Cliente',
    undefined,
    undefined,
    '',
    'S');

  $('#btnCliente').trigger('click');

  $('#btn-limpa-cliente').on('click', function () {
    limpaValor('#txtCliente')
  });

  $('#tabEstatisticas, #tabResumo ').on('click', function () {
    if ($(this)[0].id == 'tabEstatisticas') {
      $('.clientFields').prop('disabled', true)
    } else {
      $('.clientFields').attr('disabled', false)
    }
  })

  function limpaTabelasEstatisticas() {
    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasDuplicatas')) {
      $('#tabelaEstatisticasDuplicatas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasDuplicatas").DataTable().destroy();
      $("#tabelaEstatisticasDuplicatas").empty();
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasPedidos')) {
      $('#tabelaEstatisticasPedidos').DataTable().clear().draw(false);
      $("#tabelaEstatisticasPedidos").DataTable().destroy();
      $("#tabelaEstatisticasPedidos").empty();
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasVendas')) {
      $('#tabelaEstatisticasVendas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasVendas").DataTable().destroy();
      $("#tabelaEstatisticasVendas").empty();
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasFaturas')) {
      $('#tabelaEstatisticasFaturas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasFaturas").DataTable().destroy();
      $("#tabelaEstatisticasFaturas").empty();
    }
  }

  retornaHintRelatorio('btnImprimirCliente', 'RelAnaliseFinanceiraCliente')

  $('#btnImprimirCliente').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimircliente?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraCliente');
      const arquivo = await GeraRelatorio(`${url}codcli=${pegaChave('#txtCliente')}&GRUPO=${$('#cbGrupoClienteResumo').prop('checked') ? 'S' : ''}&`, 'POST', 360000, false, 'RelAnaliseFinanceiraCliente');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirDuplicatas', 'RelAnaliseFinanceiraDuplicatas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraDuplicatas', 'txtOrdemDuplicatas', 'divDuplicatas');

  $('#btnImprimirDuplicatas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirduplicatas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraDuplicatas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraDuplicatas&ORDEM_ORDENACAO=${$('#txtOrdemDuplicatas').val()}`;
      const filtros = {
        DtVencimentoDe: $('#txtDataVencimentoDuplicatasDe').val(),
        DtVencimentoAte: $('#txtDataVencimentoDuplicatasAte').val(),
        DtEmissaoDe: $('#txtEmissaoDuplicatasDe').val(),
        DtEmissaoAte: $('#txtEmissaoDuplicatasAte').val(),
        DtRecebimentoDe: $('#txtRecebimentoDuplicatasDe').val(),
        Grupo: $('#cbGrupoClienteDuplicatas').prop('checked') ? $('#txtGrupo').val() : '',
        DtRecebimentoAte: $('#txtRecebimentoDuplicatasAte').val(),
        Situacao: $("input[name=radioSituacaoDup]:checked").val(),
        Listar: $("input[name=radioListarDup]:checked").val(),
        CodCli: pegaChave('#txtCliente'),
        OrdemOrdenacao: $('#txtOrdemDuplicatas').val()
      }
      const arquivo = await GeraRelatorio(`${url}&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraDuplicatas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirPedidos', 'RelAnaliseFinanceiraPedidos');
  preencheOrdenacaoTela('RelAnaliseFinanceiraPedidos', 'txtOrdemPedidos', 'divPedidos');

  $('#btnImprimirPedidos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirpedidos?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraPedidos');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraPedidos&ORDEM_ORDENACAO=${$('#txtOrdemPedidos').val()}`;
      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoPedidoDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoPedidoAte').val(),
        DtPrevFaturamentoDe: $('#txtDtPrevFaturamentoPedidoDe').val(),
        DtPrevFaturamentoAte: $('#txtDtPrevFaturamentoPedidoAte').val(),
        Situacao: $("input[name=radioSituacaoPedido]:checked").val(),
        Grupo: $('#cbGrupoClientePedido').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraPedidos');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirVendas', 'RelAnaliseFinanceiraVendas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraVendas', 'txtOrdemVendas', 'divVendas');

  $('#btnImprimirVendas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirvendas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraVendas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraVendas&ORDEM_ORDENACAO=${$('#txtOrdemVendas').val()}`;
      const filtros = {
        DataDe: $('#txtDtEmissaoVendaDe').val(),
        DataAte: $('#txtDtEmissaoVendaAte').val(),
        CodCli: pegaChave('#txtCliente'),
        Emitido: $('#cbEmitido').prop('checked'),
        Devolvido: $('#cbDevolvido').prop('checked'),
        Pendente: $('#cbPendente').prop('checked'),
        Grupo: $('#cbGrupoClienteVenda').prop('checked') ? $('#txtGrupo').val() : '',
        Agrupada: $('#cbAgrupada').prop('checked'),
        Canceladas: $('#checkCanceladas').prop('checked') ? '1' : '0'
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraVendas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirFaturas', 'RelAnaliseFinanceiraFaturas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraFaturas', 'txtOrdemFaturas', 'divFaturas');

  $('#btnImprimirFaturas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirfaturas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraFaturas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraFaturas&ORDEM_ORDENACAO=${$('#txtOrdemFaturas').val()}`;
      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoFaturaDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoFaturaAte').val(),
        Grupo: $('#cbGrupoClienteFatura').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraFaturas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

});
