$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovaOrdemImpressao',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma regra.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdenacao',
        popover: {
          title: 'Tabela Regras',
          description: 'Aqui estão os dados das regras cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CONFIMPRESSAO");

  $('#txtOrdenacaoConsulta').autocompleta(1, `JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btn-Ordenacao').pesquisa('#txtOrdenacaoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Ordem Impressão', 'FATCONF_XML');
  $('#btn-limpa-Ordenacao').on('click', function () {
    $('#txtOrdenacaoConsulta').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovaOrdemImpressao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "confimpressao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>       ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '       <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>       ' +
      '       <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaRegra();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaRegra();
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtRegraConsulta').val('');
  });

  async function consultaRegra() {
    try {
      $.LoadingOverlay("show");
      let response;
      let codigo = pegaChave('#txtOrdenacaoConsulta') != '' ? ` AND CODIGO = '${pegaChave('#txtOrdenacaoConsulta')}'` : '';
      response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${codigo}"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaOrdenacao').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "CODIGO"
        },
        {
          "data": "DESCRICAO"
        },
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  }

  $('#tabelaOrdenacao').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOrdenacao').DataTable().row($(this).parents('tr')).data();
      window.location.href = `confimpressao/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdenacao').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOrdenacao').DataTable().row($(this)).data();
      window.location.href = `confimpressao/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdenacao').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaOrdenacao").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }


  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/confimpressao?", `CODIGOCONF=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});