$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um embarque.',
          position: 'right'
        }
      },
      {
        element: '#tabelaEmbarque',
        popover: {
          title: 'Tabela Embarque',
          description: 'Aqui estão os dados dos embarques cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("EMBARQUE");

  addFuncoesBotoes();
  await consultaEmbarque();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaEmbarque();
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "embarque/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-alterar-embarque', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaEmbarque').DataTable().row($(this).parents("tr")).data();
      window.location.href = `embarque/${data[1]}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-excluir-embarque', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $("#tabelaEmbarque").DataTable().row($(this).parents("tr")).data();
      await excluiRegistro(data[1]);
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $("#tabelaEmbarque").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaEmbarque").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("EMBARQUE", data[1]);
      if (registroLiberado) {
        window.location.href = `embarque/${data[1]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar");
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-finalizar-embarque', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaEmbarque').DataTable().row($(this).parents('tr')).data();
      await finalizaEmbarque(data);
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-reabrir-embarque', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaEmbarque').DataTable().row($(this).parents('tr')).data();
      await reabreEmbarque(data);
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '   <div class="dropdown"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      `      ${data}` +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-alterar-embarque" class="dropdown-item" href="">Alterar</button>' +
      '    <button id="btn-excluir-embarque" class="dropdown-item" href="">Excluir</button>' +
      '    <button id="btn-finalizar-embarque" class="dropdown-item" href="">Finalizar</button>' +
      '    <button id="btn-reabrir-embarque" class="dropdown-item" href="">Reabrir</button>';
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  async function consultaEmbarque() {
    try {
      $.LoadingOverlay("show");
      let where = '';

      if ($("#txtDataCadDe").val() != "01-01-1200" || $("#txtDataCadAte").val() != "01-12-2500") {
        where += `AND NOTA_EMBARQUE.DT_CADASTRO >= '${$("#txtDataCadDe").val()}' AND NOTA_EMBARQUE.DT_CADASTRO <= '${$("#txtDataCadAte").val()}'`;
      }
      where += pegaChave('#txtNumero') != '' ? ` AND NOTA_EMBARQUE.NUMERO = '${pegaChave('#txtNumero')}'` : '';
      where += pegaChave('#txtNota') != '' ? ` AND NOTA_EMBARQUE.FATURA = '${pegaChave('#txtNota')}'` : '';
      where += pegaChave('#txtCliente') != '' ? ` AND NOTA.CODCLI = '${pegaChave('#txtCliente')}'` : '';
      where += pegaChave('#txtTransporte') != '' ? ` AND NOTA_EMBARQUE.TRANSPORT = '${pegaChave('#txtTransporte')}'` : '';
      if ($("#radioPendentes").is(':checked')) {
        where += `AND NOTA_EMBARQUE.SITUACAO = '0'`
      }
      if ($('#radioFaturados').is(':checked')) {
        where += `AND NOTA_EMBARQUE.SITUACAO = '1'`
      }

      $("#tabelaEmbarque").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"NOTA_EMBARQUE", "camposSelect":["NOTA_EMBARQUE.FATURA", "NOTA_EMBARQUE.NUMERO", "NOTA_EMBARQUE.SERIE", "NOTA_EMBARQUE.SITUACAO",`+
                              `"NOTA_EMBARQUE.TRANSPORT", "NOTA_EMBARQUE.DT_CADASTRO", "NOTA_EMBARQUE.DT_FINALIZADO"],`+ 
            `"leftjoin": [`+
              `{"tabela" : "TABTRAN", "condicao" : "TABTRAN.CODIGO = NOTA_EMBARQUE.TRANSPORT"},`+
              `{"tabela" : "NOTA", "condicao" : "NOTA_EMBARQUE.FATURA = NOTA.FATURA"}],`+
             `"groupby": ["NOTA_EMBARQUE.NUMERO",`+
                       `"NOTA_EMBARQUE.FATURA",`+
                       `"NOTA_EMBARQUE.SERIE",`+
                       `"NOTA_EMBARQUE.TRANSPORT",`+
                       `"NOTA_EMBARQUE.SITUACAO",`+
                       `"NOTA_EMBARQUE.DT_CADASTRO",`+
                       `"NOTA_EMBARQUE.DT_FINALIZADO"], `+
             `"orderby": ["NOTA_EMBARQUE.DT_CADASTRO DESC"],`+
             `"where": ["1=1 ${where}"]}`,
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data
        const response = await requisicao('DELETE', '/sisplan/embarque/v1/excluirembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function finalizaEmbarque(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data[1];
        const response = await requisicao('POST', '/sisplan/embarque/v1/finalizarembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          msgAlerta('Não foi possivel finalizar o embarque, verifique!')
          return;
        }
        criaMensagemSucesso('Embarque finalizado!', () => { window.location.reload() });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function reabreEmbarque(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data[1]
        const response = await requisicao('POST', '/sisplan/embarque/v1/reabreembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          msgAlerta('Não foi possivel reabrir o embarque, verifique!')
          return;
        }
        criaMensagemSucesso('Embarque reaberto!', () => { window.location.reload() });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function addFuncoesBotoes() {

    $("#btn-Nota").pesquisa_serverside(
      ['#txtNota'],
      ["NOTA.FATURA"],
      ["TABTRAN.CODIGO"],
      `{
        "tabela":"NOTA", 
        "camposSelect":["NOTA.FATURA", "TABTRAN.CODIGO"],
        "leftjoin": [{"tabela": "TABTRAN", "condicao": "NOTA.TRANSPORT = TABTRAN.CODIGO"}
        ]
      }`,
      'Pesquisa Nota'
    );

    $("#txtNota").autocompleta(2,
      `JSON={ 
        "tabela":"NOTA",
        "camposSelect":"[NOTA.FATURA CHAVE, TABTRAN.CODIGO DESCRICAO]", 
        "leftjoin":[
          {"tabela":"TABTRAN", "condicao":"NOTA.TRANSPORT = TABTRAN.CODIGO"}
        ]
      }`);

    $('#btn-limpa-Nota').on('click', function () { $('#txtNota').val(''); });

    $("#btn-Numero").pesquisa_serverside(
      ['#txtNumero'],
      ["NOTA_EMBARQUE.NUMERO"],
      ["NOTA_EMBARQUE.FATURA"],
      `{
        "tabela":"NOTA_EMBARQUE", 
        "camposSelect":["NOTA_EMBARQUE.NUMERO", "NOTA_EMBARQUE.FATURA"]
      }`,
      'Pesquisa Número'
    );

    $("#txtNumero").autocompleta(
      1, `JSON={ "tabela":"NOTA_EMBARQUE", "camposSelect":[ "NUMERO chave", "FATURA descricao"], "where": null}`
    )

    $('#btn-limpa-Numero').on('click', function () { $('#txtNumero').val(''); });

    $("#txtCliente").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"]}`);
    $("#btn-Cliente").pesquisa_serverside(["#txtCliente"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $("#txtTransporte").autocompleta(2, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"]}`);
    $("#btn-Transporte").pesquisa_serverside(["#txtTransporte"], ["CODIGO"], ["NOME"], `{"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Trasnportadora");
    $('#btn-limpa-Transporte').on('click', function () { $('#txtTransporte').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtNota').val('');
      $('#txtCliente').val('');
      $('#txtNumero').val('');
      $('#txtTransporte').val('');
      $('#radioTodos').prop('checked', true);
      $('#txtGrupoProdConsulta').val('');
      $('#txtTipoProdConsulta').val('');
      $("#txtDataCadDe").val("1200-01-01");
      $("#txtDataCadAte").val("2500-12-31");
      $("#txtDataFinalizacaoAte").val("2500-12-31");
    });
  };

});