$('#txtClienteCielo').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClienteCielo').pesquisa('#txtClienteCielo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClienteCielo').on('click', function () {
  $('#txtClienteCielo').val('');
});

$('#txtClasseTaxaCielo').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseTaxaCielo').pesquisa('#txtClasseTaxaCielo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseTaxaCielo').on('click', function () {
  $('#txtClasseTaxaCielo').val('');
});

$('#txtContaCielo').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnContaCielo').pesquisa('#txtContaCielo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaContaCielo').on('click', function () {
  $('#txtContaCielo').val('');
});

$('#txtClasseBaixaCielo').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaCielo').pesquisa_serverside(['#txtClasseBaixaCielo'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaClasseBaixaCielo').on('click', function () {
  $('#txtClasseBaixaCielo').val('');
});

$('#txtClasseDespesaCielo').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseDespesaCielo').pesquisa_serverside(['#txtClasseDespesaCielo'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaClasseDespesaCielo').on('click', function () {
  $('#txtClasseDespesaCielo').val('');
});

$('#txtHistoricoCielo').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoCielo').pesquisa_serverside(['#txtHistóricoCielo'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaHistóricoCielo').on('click', function () {
  $('#txtHistóricoCielo').val('');
});

async function validaConfirmacaoCielo() {
  if (!$('#txtContaCielo').val()) {
    throw msgAlerta('Conta não informada, verifique!');
  }
  if ($('#cbAntecipacaoCielo').is(':checked') || $('#cbPagamentoCielo').is(':checked')) {
    if (!$('#txtClasseBaixaCielo').val()) {
      throw msgAlerta('Classe de baixa não informada, verifique!');
    }
    if (!$('#txtClasseTaxaCielo').val()) {
      throw msgAlerta('Classe de taxa não informada, verifique!');
    }
    if (!$('#txtClasseAntecipacao').val() && $('#cbAntecipacaoCielo').is(':checked')) {
      throw msgAlerta('Classe de taxa de antecipação não informada, verifique')
    }
    if (!$('#txtHistoricoCielo').val()) {
      throw msgAlerta('Histórico não informado, verifique!');
    }
  }
}

$('#btnConfirmarCielo').on('click', async function () {
  const Cielo = await buscaDadosTabelaCielo();
  const params = await coletaDadosInputsCielo();

  await validaConfirmacaoCielo();

  const body = {
    Cielo: Cielo
  }

  const response = await requisicao('POST', `/sisplan/escretorno/V1/confirmacielo?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

  if (!response) {
    return;
  }
});

async function buscaDadosTabelaCielo() {
  const tabelaCielo = $('#tabelaCielo').DataTable().rows().data().toArray();

  const objeto = tabelaCielo.map((dados) => dados.sel == 'S' ? ({
    sel: dados.sel,
    numero: dados.numero,
    codCli: dados.codCli,
    nome: dados.nome,
    fatura: dados.fatura,
    dataEmissao: dados.dataEmissao,
    dataVencimento: dados.dataVencimento,
    dataPagamento: dados.dataPagamento,
    nsu: dados.nsu,
    numeroTerminal: dados.numeroTerminal,
    parcela: dados.parcela,
    valorBrutoArq: dados.valorBrutoArq,
    valorDuplicata: dados.valorDuplicata,
    valorPago: dados.valorPago,
    valorTarifa: dados.valorTarifa,
    valorLiquido: dados.valorLiquido,
    difMaior: dados.difMaior,
    difMenor: dados.difMenor,
    bandeira: dados.bandeira,
    saldo: dados.saldo,
    banco: dados.banco,
    agencia: dados.agencia,
    conta: dados.conta,
    modalidade: dados.modalidade,
    tipoRecto: dados.tipoRecto,
    tipoLancamento: dados.tipoLancamento,
    taxa: dados.taxa,
    taxaRec: dados.taxaRec
  }) : null).filter((dados) => dados !== null)
  return objeto;
};

async function coletaDadosInputsCielo() {
  let tipoLancamento = 0;

  if ($('#rgPrevisaoCielo').is(':checked')) {
    tipoLancamento = 0;
  }
  if ($('#rgLiquidacaoNormalCielo').is(':checked')) {
    tipoLancamento = 1;
  }
  if ($('#rgLiquidacaoAntecipadaCielo').is(':checked')) {
    tipoLancamento = 2;
  }
  if ($('#rgLiquidadaAmortizacaoCielo').is(':checked')) {
    tipoLancamento = 3;
  }

  let NaoGeraCC = $('#cbNaoGeraCCStone').is(':checked') ? true : false

  objeto = {
    nomeArquivo: $('#txtNomeArquivoCielo').val(),
    numeroArquivo: $('#txtNumeroArquivoCielo').val(),
    cliente: pegaChave('#txtClienteCielo'),
    conta: pegaChave('#txtContaCielo'),
    classeBaixa: pegaChave('#txtClasseBaixaCielo'),
    classeTaxa: pegaChave('#txtClasseTaxaCielo'),
    classeDespesa: pegaChave('#txtClasseDespesaCielo'),
    historico: pegaChave('#txtHistoricoCielo'),
    tipoLancamento: tipoLancamento,
    NaoGeraCC: NaoGeraCC,
  }
  return objeto;
}

function selecionarTodosInputsCielo() {
  $(`#tabelaCielo`).DataTable().rows().data().$(`.campoConsulta`).toArray().filter((campoSel) => {
    if (!$(campoSel).prop('disabled')) {
      $(campoSel).prop('checked', !campoSel.checked)
      $('#tabelaCielo').DataTable().rows(campoSel.closest('tr')).data().toArray()[0].sel = campoSel.checked ? 'S' : 'N';
    }
  });
}

$('#checkTodosCielo').on('click', function () {
  selecionarTodosInputsCielo()
});

$('#tabelaCielo').on('click', '.campoConsulta', async function () {
  lineIsChecked = $('#tabelaCielo').DataTable().rows((this).closest('tr')).data().toArray()[0].sel == 'N' ? true : false
  newValue = lineIsChecked ? 'S' : 'N'
  $('#tabelaCielo').DataTable().rows((this).closest('tr')).data().toArray()[0].sel = newValue;
});

$('#btnVerBaixasCielo').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasCielo();
});

async function verBaixasCielo() {
  let isCieloTxT;
  let dados;
  let body;
  $.LoadingOverlay('show');
  try {
    if ($.fn.DataTable.isDataTable("#tabelaCielo")) {
      $("#tabelaCielo").DataTable().destroy();
      $("#tabelaCielo").empty();
    }
    if ($('#txtNomeArquivoCielo').val().indexOf('.XLS') !== -1) {
      isCieloTxT = false;
      dados = $('#conteudoFormatado').val();

      body = {
        dados: JSON.parse(dados)
      }
    } else {
      isCieloTxT = true;
      dados = (($('#conteudoFormatado').text()).replaceAll(',', '')).split('\n');

      body = {
        dados: dados
      }
    }

    if (dados.length == 0) {
      throw msgErro('Arquivo sem movimento, impossível continuar.');
    }

    let params = await coletaDadosInputsCielo();


    const response = await requisicao('POST', `/sisplan/escretorno/V1/buscabaixascielo?`, `PARAMS=${JSON.stringify(params)}&IS_CIELO_TXT=${isCieloTxT}`, JSON.stringify(body), 90000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    dataSetColsCielo[0].render = function (data, type, row, meta) {
      let checked = false;
      let bloqueia = false;

      if (row.naoSeleciona == '') {
        row.naoSeleciona = 'S'
      }
      if (row.tag != '0') {
        if (row.sel == 'S' && row.naoSeleciona != 'N') {
          checked = true;
          bloqueia = false;
        }
      }

      if (row.sel == 'N' && row.naoSeleciona == 'N') {
        checked = false;
        bloqueia = true;
      }
      let disabledAttribute = bloqueia ? 'disabled' : '';
      return `<div class="icheck-danger d-inline">
                  <input type="checkbox" ${disabledAttribute} ${checked ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
              </div>`
    }

    $('#tabelaCielo').DataTable({
      paging: true,
      filter: false,
      info: false,
      length: false,
      order: false,
      destroy: true,
      data: jsonStr,
      columns: dataSetColsCielo,
      columnDefs: [{
        targets: [6, 7, 8],
        render: function (data, type, row) {
          if (type === 'display' || type === 'filter') {
            var date = new Date(data);
            var dia = date.getDate();
            var mes = date.getMonth() + 1;
            var ano = date.getFullYear();
            if (dia < 10) {
              dia = '0' + dia;
            }
            if (mes < 10) {
              mes = '0' + mes;
            }
            return dia + '/' + mes + '/' + ano;
          } else {
            return data;
          }
        },
      }],

      rowCallback: async function (row, data) {
        if (data.numero == '') {
          $(row).css('background-color', '#B4524D');
          $(row).css('color', '#ecfdff');
        }
        else if (data.naoSeleciona == 'N') {
          $(row).css('background-color', '#3A5E44');
          $(row).css('color', '#ecfdff');
        }
        else if (data.valorDuplicata != data.valorPago && data.valorPago > 0) {
          $(row).css('background-color', '#04336C');
          $(row).css('color', '#ecfdff');
        }
      },
    });

    $('.remover-linha').remove();
    $('.campoSel').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });

  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }
}
