<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Extrato</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.255.15.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.255.15.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.255.15.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.255.15.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.255.15.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.255.15.1" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.255.15.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.255.15.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.255.15.1">

<style>
    .table.dataTable tbody td,
    th {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #txtTipo,
    #txtOpcaoImportacao {
      font-size: 14px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">



    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Extrato</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div><!-- /.col -->
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button class="btn btn-primary btn-sisp" id="btnImportar"><span class="fas fa-plus"></span> Importar</button>
              <button class="btn btn-secondary btn-sisp" id="btnImprimir"><span class="fas fa-print pr-1" style="color: white!important"></span>Imprimir</button>
            </div>
            <div class="col-sm-1 mt-3">
              <label data-error="wrong" data-success="right" for="txtSaldoAnterior">Saldo Anterior:</label>
              <input type="text" class="input-default form-control" id="txtSaldoAnterior" name="txtSaldoAnterior" placeholder="0,00" style="width: 120px" disabled>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Extratos</h5>
              <table id="tabelaDados" class="table table-sm table-select table-hover" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
              <div class="modal-header">
                <h4 class="modal-title">Filtros</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body pb-0">
                <div class="form-row">
                  <div class="col-lg-2 col-12 form-group">
                    <div class="">
                      <label for="txtDataIni">Período de:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataIni" name="DataDe">
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <div class="">
                      <label for="txtDataFim">Até:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataFim" name="DataAte">
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtDocto">Documento:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtDocto" name="txtDocto" required placeholder="Documento">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnLimpaDocto" name="btnLimpaDocto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtConta">Conta:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtConta" name="txtConta" required placeholder="Conta">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaConta" name="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <div class="">
                      <label for="txtValorIni">Valor de:</label>
                      <div class="relative">
                        <input type="number" class="input-default focus form-control validate campoValorDecimal" id="txtValorIni" name="ValorIni" placeholder="0,00">
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <div class="">
                      <label for="txtValorFim">Até:</label>
                      <div class="relative">
                        <input type="number" class="input-default focus form-control validate campoValorDecimal" id="txtValorFim" name="ValorFim" placeholder="0,00">
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtTipo">Tipo:</label>
                    <div class="input-group">
                      <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtTipo" style="border-color: #a9a9a9">
                        <option class="drilldown-item" value="">Todos</option>
                        <option class="drilldown-item" value="N">A conciliar</option>
                        <option class="drilldown-item" value="S">Conciliados</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-6 col-12 form-group">
                    <div class="">
                      <label for="txtObs">Observação:</label>
                      <div class="relative">
                        <input type="text" class="input-default focus form-control validate" id="txtObs" name="txtObs" placeholder="Observação">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <div class="row">
                    <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
                      Filtros</button>     
                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span>
                      Consultar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div id="modal-importar" data-backdrop="static" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog" role="document" style="min-width: 80%; min-height: 60%;">
            <div class="modal-content" id="modalBody">
              <div class="modal-header">
                <h4 class="modal-title">Importar Dados</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body pb-0">
                <div class="form-row">
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtContaImportacao">Conta:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtContaImportacao" name="txtContaImportacao" required placeholder="Conta">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnContaImportacao" name="btnContaImportacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaContaImportacao" name="btnLimpaContaImportacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtBancoImportacao">Banco:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtBancoImportacao" name="txtBancoImportacao" required placeholder="Banco">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnBancoImportacao" name="btnBancoImportacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaBancoImportacao" name="btnLimpaBancoImportacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <label for="txtDataImportacao">Data:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataImportacao">
                    </div>
                  </div>
                  <div class="col-lg-2 col-12 form-group">
                    <label for="txtSaldoImportacao">Saldo:</label>
                    <div class="relative">
                      <input type="text" class="input-default focus form-control validate" id="txtSaldoImportacao" disabled placeholder="0,00">
                    </div>
                  </div>
                  <div class="col-lg-5 col-12 form-group">
                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtArquivoImportacao">Arquivo:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtArquivoImportacao" name="txtArquivoImportacao" placeholder="Arquivo" disabled>
                      <input type="file" id="mdModalUpload" class="d-none">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnArquivoImportacao" name="btnArquivoImportacao" type="file" for="txtArquivoImportacao"><i class="m-0 p-0 fas fa-folder-plus"></i> </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtOpcaoImportacao">Opção Importação:</label>
                    <div class="input-group">
                      <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtOpcaoImportacao" style="border-color: #a9a9a9">
                        <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                        <option class="drilldown-item" value="0">Extrato por Posições</option>
                        <option class="drilldown-item" value="1">Extrato em Excel</option>
                        <option class="drilldown-item" value="2">Extrato em TXT</option>
                        <option class="drilldown-item" value="3">Extrato em OFX</option>
                        <!-- <option class="drilldown-item" value="4">Extrato em HTML</option> -->
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-1 col-12 form-group">
                    <label for="txtLinhaImportacao">Linha inicial:</label>
                    <div class="relative">
                      <input type="number" value='0' class="input-default focus form-control validate" id="txtLinhaImportacao">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12 d-flex align-items-center flex-wrap pl-3">
                    <div class="icheck-primary"><input type="checkbox" class="form-check-input" name="cbUltimaLinha" id="cbUltimaLinha"> <label for="cbUltimaLinha">Importar última linha</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="form-check-input" name="cbDataValida" id="cbDataValida"> <label for="cbDataValida">Importar somente com data válida</label></div>
                  </div>
                  <div class="col-lg-12 col-12 table-responsive card-body pt-0" style="max-height: 375px">
                    <table id="tabelaImportacao" class="table table-sm table-select table-hover" width="100%">
                      <thead>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                  <div class="form-group col-12 d-none">
                    <pre id="fileContent"></pre>
                  </div>
                </div>
              </div>
              <div class="modal-footer d-flex">
                <button class="btn bg-gradient-olive btn-sisp d-none" id="btnCriarAPImportacao">Criar e Baixar AP</button>
                <button class="btn bg-gradient-olive mr-auto btn-sisp d-none" id="btnCriarAntecipacaoImportacao">Criar Antecipação</button>
                <div class="col-lg-3 col-12 row d-flex justify-content-end" id="divSaldoFinalImportacao">
                  <label for="txtSaldoFinalImportacao" class="mr-2 mt-2">Saldo Final:</label>
                  <div class="relative">
                    <input type="text" class="input-default focus form-control validate" id="txtSaldoFinalImportacao" disabled placeholder="0,00">
                  </div>
                </div>
                <button class="btn bg-gradient-success btn-sisp d-none" id="btnConfirmarImportacao">Confirmar</button>
                <button class="btn btn-primary btn-sisp" id="btnConsultarImportacao"><span class="fas fa-search"></span>Consultar</button>
                <button class="btn bg-gradient-danger btn-sisp" id="btnFecharImportacao">Fechar</button>
              </div>
            </div>
          </div>
        </div>

        <div id="modal-pagar" data-backdrop="static" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody" style="min-height: 500px">
              <div class="modal-header">
                <h4 class="modal-title">Criar Pagar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body pb-0">
                <div class="form-row" id="divControlePagar">
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtClassePagar">Classe:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtClassePagar" name="txtClassePagar" required placeholder="Classe">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnClassePagar" name="btnClassePagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaClassePagar" name="btnLimpaClassePagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtClasseBaixaPagar">Classe Baixa:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtClasseBaixaPagar" name="txtClasseBaixaPagar" required placeholder="Classe">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnClasseBaixaPagar" name="btnClasseBaixaPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaClasseBaixaPagar" name="btnLimpaClasseBaixaPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtHistoricoPagar">Histórico:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtHistoricoPagar" name="txtHistoricoPagar" required placeholder="Histórico">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnHistoricoPagar" name="btnHistoricoPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaHistoricoPagar" name="btnLimpaHistoricoPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtHistoricoBaixaPagar">Histórico Baixa:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtHistoricoBaixaPagar" name="txtHistoricoBaixaPagar" required placeholder="Histórico">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnHistoricoBaixaPagar" name="btnHistoricoBaixaPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaHistoricoBaixaPagar" name="btnLimpaHistoricoBaixaPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtSituacaoPagar">Situação:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtSituacaoPagar" name="txtSituacaoPagar" required placeholder="Situação">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnSituacaoPagar" name="btnSituacaoPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaSituacaoPagar" name="btnLimpaSituacaoPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 form-group mt-4 pt-1 pl-2">
                    <button class="btn btn-primary btn-sisp" id="btnAtualizarPagar">Atualizar Informações</button>
                  </div>
                  <input id="txtIdPagar" class="d-none" type="text">
                  <input id="txtTipoModal" class="d-none" type="text">
                </div>
                <div class="form-row">
                  <div class="col-lg-12 col-12 table-responsive card-body" style="max-height: 375px">
                    <table id="tabelaPagar" class="table table-sm table-select table-hover" width="100%">
                      <thead>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer d-flex">
                <button class="btn btn-primary btn-sisp" id="btnConfirmarPagar">Confirmar</button>
                <button class="btn bg-gradient-danger btn-sisp" id="btnFecharPagar">Fechar</button>
              </div>
            </div>
          </div>
        </div>

      </div>

      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <?php
    include_once('../../../modais.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script src="plugins/jquery/jquery.min.js?versao=3.255.15.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.255.15.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.255.15.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.255.15.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.255.15.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.255.15.1"></script>
  <script src="dist/js/sisplan.js?versao=3.255.15.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.255.15.1"></script>
  <script src="utils/cookies.js?versao=3.255.15.1"></script>
  <script src="utils/funcoes.js?versao=3.255.15.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.255.15.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.255.15.1"></script>
  <script src="dist/js/driver.min.js?versao=3.255.15.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.255.15.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.255.15.1"></script>
  <script type="text/javascript" src="config.js?versao=3.255.15.1"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.8.0/jszip.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.8.0/xlsx.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.255.15.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('EXTRATO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/extrato/acesso_extrato/acesso_extrato.js?versao=3.255.15.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>