$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar os dados.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let ultpos = parametros[parametros.length - 1];
    ultpos = ultpos.split('#');
    let produto, tabela, parte;
    produto = ultpos[0];
    $('#cbAlteraPreco').prop('checked', (await buscaParametroERP('FAC', '500', '5', '1')) == 'S');
    $('#cbAlteraPreco').prop('disabled', true);
    if (produto != 'create') {
        tabela = ultpos[1];
        parte = ultpos[2];
        if (await Existe('TABELA', ['NUMERO', 'CODIGO', 'PARTE'], [tabela, produto, parte])) {
            $('.controle-edicao').prop('disabled', true);
        }
        $.LoadingOverlay('show');
        try {
            await preencheDados(produto, tabela, parte);
            await buscaSetores();
        } finally {
            $.LoadingOverlay('hide');
        }
    } else {
        $('.controle-edicao').prop('disabled', false);
        $('#btnDuplicar').addClass('d-none');
        $('#btnVoltar').addClass('ml-auto');
    }

    componenteFiltro('produto', false, false);
    componenteFiltro('tabPreco');

    async function preencheDados(codigo, tabela, parte) {
        try {

            let descprod = await buscaValor('PRODUTO', 'DESCRICAO', 'CODIGO', codigo);
            descprod = descprod != undefined ? descprod['DESCRICAO'] : '';
            let desctab = await buscaValor('REGIAO', 'DESCRICAO', 'REGIAO', tabela);
            desctab = desctab != undefined ? desctab['DESCRICAO'] : '';
            let tipo = await buscaValor('TABELA', 'TIPO', `CODIGO = '${codigo}' AND NUMERO`, tabela);
            tipo = tipo != undefined ? tipo['TIPO'] : '';
            let bloqAlteracao = await buscaValor('TABELA', 'BLOQ_MUDANCA', `PARTE = '${parte}' AND CODIGO = '${codigo}' AND NUMERO`, tabela);
            bloqAlteracao = bloqAlteracao != undefined ? bloqAlteracao['BLOQ_MUDANCA'] : '';

            $('#cbBloquear').prop('checked', bloqAlteracao == 'S' ? true : false);
            $('#cbBloquear').prop('disabled', true);

            if ($('#cbBloquear').prop('checked')) {
                $('#btnGravar').addClass('d-none');
                $('#btnDuplicar').addClass('d-none')
                $('#btnVoltar').addClass('ml-auto');
                msgErro('Opção "Bloquear alterações" marcada, impossível realizar alterações.');
            }

            insereValor('#txtProduto', codigo, descprod);

            let response = await requisicao('GET',
                '/Sisplan/Funcoes/V1/pesquisa?',
                `JSON={ "tabela":"PRO_FLUXO", 
                        "camposSelect":["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                        "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                        "where": ["PRO_FLUXO.CODIGO = '${codigo}'", "TIPO_APL.ATIVO = 'S'", "PRO_FLUXO.PARTE = '${parte}'"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status !== 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            jsonStr = jsonStr.RESULT[0];

            jsonStr.map((e) => {
                $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
            });

            insereValor('#txtTabPreco', tabela, desctab);

            $('#txtTipo').val(tipo);

            $('#cbFluxo').prop('checked', true);

        } catch (e) {
            msgErro(`Não foi possível buscar os dados: ${e}`);
            console.log(e);
        }
    }

    async function buscaSetores() {
        const obj = {
            CBFLUXO: $('#cbFluxo').prop('checked'),
            TIPO: $('#txtTipo').val(),
            PRODUTO: pegaChave('#txtProduto'),
            TABELA: pegaChave('#txtTabPreco'),
            PARTE: $('#txtParte').val()
        }

        let response = await requisicao('GET', '/Sisplan/facpreco/V1/facpreco?', `&CBFLUXO=${obj.CBFLUXO}&TIPO=${obj.TIPO}&PRODUTO=${obj.PRODUTO}&TABELA=${obj.TABELA}&PARTE=${obj.PARTE}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();

        criaTabelaSetores(jsonStr);

    }

    function criaTabelaSetores(data) {

        if ($.fn.DataTable.isDataTable('#tabelaSetores')) {
            $('#tabelaSetores').DataTable().destroy();
            $('#tabelaSetores').empty();
        }

        let cols = [{
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'DESCRICAO',
            title: 'Descrição'
        },
        {
            data: 'COR',
            title: 'Cor'
        },
        {
            data: 'DESC_COR',
            title: 'Desc. Cor'
        },
        {
            data: 'PRECO_MAXIMO',
            title: 'Preço Máximo'
        },
        {
            data: 'CUSTO_OPERACIONAL',
            title: 'Custo Operacional'
        },
        {
            data: 'PRECO',
            title: 'Preço'
        },
        {
            data: 'OBSERVACAO',
            title: 'Observação'
        }];

        let colunasInv = $('#txtTipo').val() != '1' ? [2, 3] : [];

        try {
            $("#tabelaSetores").DataTable({
                order: false,
                sort: true,
                paging: false,
                destroy: true,
                lengthChange: false,
                searching: false,
                info: false,
                autoWidth: true,
                data: data,
                columns: cols,
                columnDefs: [
                    {
                        targets: colunasInv,
                        visible: false
                    },
                    {
                        targets: [4],
                        render: function (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 4,
                                minimumFractionDigits: 4,
                            });
                        },
                    },
                    {
                        targets: [6, 7],
                        render: function (data, v2, v3, index) {
                            return carregaInput(data, index);
                        }
                    },
                    {
                        "targets": [4, 5],
                        "className": 'pr-4 text-right'
                    }
                ],
            });

            $('#tabelaSetores th').css('text-align', 'left');
            $('#tabelaSetores tr').css('text-align', 'left');

            $('.input-preco').on('blur', function () {
                if (this.value != '') {
                    this.value = parseFloat(this.value).toFixed(4);
                }
            });

        } catch (e) {
            msgErro(`Não foi possível carregar os dados: ${e}`);
            console.log(e);
        }
    }

    function carregaInput(valor, indices) {
        try {
            if (indices.col == 6) {
                return `<input style="width: 100px;" type="number" id="txtPreco_${indices.row}"
                        class="input-preco inputedit input-default focus form-control text-right"
                        value="${parseFloat(valor).toFixed(4)}">`;
            } else {
                return `<input style="width: 400px;" type="text" id="txtObs_${indices.row}"
                        class="input-obs inputedit input-default focus form-control text-left"
                        value="${valor}">`;
            }
        } catch (e) {
            msgErro(`Não foi possível carregar os dados: ${e}`);
            console.log(e);
        }
    }

    $('#cbFluxo').on('change', async function () {
        $.LoadingOverlay('show');
        try {
            await buscaSetores();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#txtTabPreco').on('focusout', async function () {
        if (!$('#btnDuplicar').hasClass('d-none') || produto == 'create') {
            $.LoadingOverlay('show');
            try {
                try {
                    await buscaSetores();
                } catch (e) {
                    msgErro(`Não foi possível buscar os dados: ${e}`);
                    console.log(e);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    });

    $('#txtProduto').on('blur', async function () {
        $.LoadingOverlay('show');
        try {
            try {

                $('#txtParte').empty();

                let response = await requisicao('GET',
                    '/Sisplan/Funcoes/V1/pesquisa?',
                    `JSON={ "tabela":"PRO_FLUXO", 
                            "camposSelect":["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                            "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                            "where": ["PRO_FLUXO.CODIGO = '${pegaChave(this)}'", "TIPO_APL.ATIVO = 'S'"]}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status !== 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                jsonStr = jsonStr.RESULT[0];

                jsonStr.map((e) => {
                    $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
                });

                const tabela = await buscaValor('REGIAO', 'REGIAO, DESCRICAO', 'PADRAO_PROD', 'S');

                if (tabela != undefined) {
                    insereValor('#txtTabPreco', tabela.REGIAO, tabela.DESCRICAO);
                    $('#txtTabPreco').trigger('focusout');
                } else {
                    return;
                }

            } catch (e) {
                msgErro(`Não foi possível buscar os dados: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#txtParte').on('change', async function () {
        $.LoadingOverlay('show');
        try {
            try {
                await buscaSetores();
            } catch (e) {
                msgErro(`Não foi possível buscar os dados: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#txtTipo').on('change', async function () {
        $.LoadingOverlay('show');
        try {
            try {
                await buscaSetores();
            } catch (e) {
                msgErro(`Não foi possível buscar os dados: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {

        if ($('#txtProduto').val() == '') {
            msgErro('É necessário informar um produto para gravar.');
            return;
        }

        if ($('#txtParte').val() == '' || $('#txtParte').val() == null) {
            msgErro('É necessário informar uma parte para gravar.');
            return;
        }

        await msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => {
            $.LoadingOverlay('show')
            try {
                await validaDados();
            } finally {
                $.LoadingOverlay('hide');
            }
        })
    });

    async function validaDados() {
        try {
            let tipo = await buscaValor('REGIAO', 'TIPO', 'REGIAO', pegaChave('#txtTabPreco'));
            tipo = tipo != undefined ? tipo['TIPO'] : '';

            if (pegaChave('#txtTabPreco') != '') {
                if (tipo != 'T' && tipo != 'M') {
                    msgErro('Tipo de tabela de preços não é de terceiros. Impossível continuar.');
                    return;
                }
            } else {
                msgErro('Nenhuma tabela informada. Impossível continuar.');
                return;
            }

            if ((produto == 'create') && (await Existe('TABELA', ['NUMERO', 'CODIGO', 'PARTE'], [pegaChave('#txtTabPreco'), pegaChave('#txtProduto'), $('#txtParte').val()]))) {
                msgErro('Já existe um registro com estas informações. Impossível continuar.');
                return;
            }

            let array = [];
            let data = $('#tabelaSetores').DataTable().data().toArray();

            if (await buscaParametroERP('FAC', '310', '1', '1') == 'S') {

                let tabPadrao = await buscaValor('REGIAO', 'REGIAO', 'PADRAO_PROD', 'S');

                tabPadrao = tabPadrao != undefined ? tabPadrao['REGIAO'] : '';

                if ((await buscaParametroERP('FAC', '310', '9', '1') == 'T') && (pegaChave('#txtTabPreco') == tabPadrao)) {
                    msgErro('Empresa usa preço setor cadastrado no custos. Impossivel alterar a tabela padrão nesta tela!');
                    // if not SolicitaSenhaSupervisor('Informe senha de supervisor para realizar operação.') then
                    // begin
                    // Application.MessageBox('Senha de supervisor não confere. Impossível realizar operação.', 'Atenção', MB_OK + MB_ICONERROR + MB_APPLMODAL);
                    return;
                }

                for (i = 0; i < data.length; i++) {
                    let e = data[i];

                    let preco = parseFloat($(`#txtPreco_${i}`).val());

                    if ((e.PRECO_MAXIMO == 0) && (preco != 0)) {
                        if (await buscaParametroERP('FAC', '310', '11', '1') == 'S') {
                            msgErro('Preço máximo não cadastrado. Impossível continuar.');
                            return;
                        }
                        e.PRECO_MAXIMO = preco;
                        await gravaPrecoMaximo(e.PRECO, e.SETOR, tabPadrao, e.COR);
                    }

                    if ((preco > e.PRECO_MAXIMO) && (e.PRECO_MAXIMO > 0.000001)) {
                        if (await buscaParametroERP('FAC', '310', '9', '1') == 'S') {
                            msgErro('Preço maior que o preço máximo para o setor ' + e.SETOR + '. Impossível continuar.');
                            return;
                        } else if (await buscaParametroERP('FAC', '310', '9', '1') == 'P') {
                            msgErro('Preço maior que o preço máximo para o setor ' + e.SETOR + '.');
                            // if not SolicitaSenhaSupervisor('Informe senha de supervisor para realizar operação.') then
                            // begin
                            // Application.MessageBox('Senha de supervisor não confere. Impossível realizar operação.', 'Atenção', MB_OK + MB_ICONERROR + MB_APPLMODAL);
                            return;
                        }

                    }

                    array.push({
                        CODIGO: pegaChave('#txtProduto'),
                        NUMERO: pegaChave('#txtTabPreco'),
                        SETOR: e.SETOR,
                        PARTE: $('#txtParte').val(),
                        COR: e.COR,
                        TAM: '',
                        TIPO: $('#txtTipo').val(),
                        BLOQ_MUDANCA: $('#cbBloquear').prop('checked') ? 'S' : 'N',
                        OBS: $(`#txtObs_${i}`).val(),
                        PRECO: preco,
                        DT_VALIDADE_INI: '1899-01-01',
                        DT_VALIDADE_FIM: '2500-12-31',
                        TP_ITEM: '',
                        PRECO_2: 0,
                        PRECO_ORIG: 0,
                        PRECO_MOST: 0,
                        DT_ULTMOD: '1899-01-01',
                        PRECO_MAX: e.PRECO_MAXIMO
                    })
                };
            } else {

                for (i = 0; i < data.length; i++) {
                    let e = data[i];

                    array.push({
                        CODIGO: pegaChave('#txtProduto'),
                        NUMERO: pegaChave('#txtTabPreco'),
                        SETOR: e.SETOR,
                        PARTE: $('#txtParte').val(),
                        COR: e.COR,
                        TAM: '',
                        TIPO: $('#txtTipo').val(),
                        BLOQ_MUDANCA: $('#cbBloquear').prop('checked') ? 'S' : 'N',
                        OBS: $(`#txtObs_${i}`).val(),
                        PRECO: parseFloat($(`#txtPreco_${i}`).val()),
                        DT_VALIDADE_INI: '1899-01-01',
                        DT_VALIDADE_FIM: '2500-12-31',
                        TP_ITEM: '',
                        PRECO_2: 0,
                        PRECO_ORIG: 0,
                        PRECO_MOST: 0,
                        DT_ULTMOD: '1899-01-01',
                        PRECO_MAX: e.PRECO_MAXIMO
                    })
                }
            }

            if (produto != 'create' && $('#btnDuplicar').hasClass('d-none')) {
                if (await Existe('TABELA', ['NUMERO', 'CODIGO', 'PARTE'], [pegaChave('#txtTabPreco'), pegaChave('#txtProduto'), $('#txtParte').val()])) {
                    msgErro('Já existe um registro com estas informações. Impossível continuar.');
                    return;
                }
                await gravaDados(array);
            } else {
                await gravaDados(array);
            }
        } catch (e) {
            msgErro(`Não foi possível validar os dados: ${e}`);
            console.log(e);
        }
    }

    async function gravaPrecoMaximo(preco, setor, tabela, cor) {
        try {
            let response = await requisicao("POST", `/Sisplan/facpreco/V1/precomaximo?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                `&PRECO=${preco}&TIPO=${$('#txtTipo').val()}&NUMERO=${tabela}&PRODUTO=${pegaChave('#txtProduto')}&PARTE=${$('#txtParte').val()}&SETOR=${setor}&COR=${cor}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                throw (response.statusText);
            }

        } catch (e) {
            msgErro(`Não foi possível gravar o preço máximo: ${e}`);
            console.log(e);
        }
    }

    async function gravaDados(data) {
        try {

            const obj = {
                ALTERA_PRECO: $('#cbAlteraPreco').prop('checked'),
                FACPRECO: data
            }

            let response = await requisicao("POST", `/Sisplan/facpreco/V1/facpreco?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}&ALTERA_PRECO=${$('#cbAlteraPreco').prop('checked')}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                throw (response.statusText);
            }

            toastr
                .success("Dados gravados com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/facpreco`;
                    },
                })
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

        } catch (e) {
            msgErro(`Não foi possível gravar os dados: ${e}`);
            console.log(e);
        }
    };

    $('#btnDuplicar').on('click', async function () {
        msgAlerta('Deseja duplicar este registro?', () => { }, () => { }, async () => {
            $.LoadingOverlay('show');
            try {
                await duplicaRegistro()
            } finally {
                $.LoadingOverlay('hide');
            }
        });
    });

    async function duplicaRegistro() {
        try {
            $('#btnDuplicar').addClass('d-none');
            $('#btnVoltar').addClass('ml-auto')
            $('.controle-edicao').prop('disabled', false);
            $('#txtProduto').prop('disabled', true);
            $('#btnProduto').prop('disabled', true);
            $('#btnLimpaProduto').prop('disabled', true);

            $('#txtParte').empty();

            let response = await requisicao('GET',
                '/Sisplan/Funcoes/V1/pesquisa?',
                `JSON={ "tabela":"PRO_FLUXO", 
                            "camposSelect": ["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                            "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                            "where": ["PRO_FLUXO.CODIGO = '${pegaChave('#txtProduto')}'", "TIPO_APL.ATIVO = 'S'"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status !== 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            jsonStr = jsonStr.RESULT[0];

            jsonStr.map((e) => {
                $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
            });
        } catch (e) {
            msgErro(`Não foi possível duplicar o registro: ${e}`);
            console.log(e);
        }
    }

    $('#btnVoltar').on('click', async function () {
        // event.preventDefault();
        window.history.back();
    });
});