$('#tutorial').on('click', function () {
  $(document).ready(async function () {

    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
    });
    driver.defineSteps([{
      element: '#valortotalInfoTour',
      popover: {
        title: 'Total a Pagar',
        description: 'Aqui está informado o valor total a pagar',
        position: 'bottom',
      },
    },
    {
      element: '#valorPagoInfoTour',
      popover: {
        title: 'Total Pago',
        description: 'Aqui está informado o valor que já foi pago.',
        position: 'bottom',
      },
    },
    {
      element: '#saldoInfoTour',
      popover: {
        title: 'Saldo',
        description: 'Aqui está informado o saldo restante.',
        position: 'bottom',
      },
    },
    {
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os campos disponíveis de filtro.',
        position: 'bottom',
      },
    },
    {
      element: '#btn-novoPagar',
      popover: {
        title: 'Botão Novo',
        description: 'Clique aqui para incluir um novo registro a pagar.',
        position: 'bottom',
      },
    },
    {
      element: '#tabelaPagar',
      popover: {
        title: 'Dados Pagar',
        description: 'Aqui estão os dados conforme filtros utilizados.',
        position: 'top',
      },
    },
    ]);
    driver.start();
  });
});

$(function () {
  $('[data-toggle="tooltip"]').tooltip()
})

bConsultou = false;

jQuery(async function () {
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  let grid;

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.acessoPagar == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoPagar: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.acessoPagarBaixas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoPagarBaixas: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      if (grid == 'baixas') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoPagarBaixas: novasColunas }))

        $('#tabelaBaixaPagar').DataTable().columns().visible(true);
        // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

        $('#tabelaBaixaPagar').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoPagar: novasColunas }))
        return
      }

      $('#tabelaPagar').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaPagar').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoPagar: novasColunas }))
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const campos = ['txtDataDe', 'txtDataAte', 'txtVenctoDe', 'dtBaixaDe', 'dtBaixaAte', 'txtVenctoAte', 'txtNum_ap', 'txtConsultaFornecedor', 'Status', 'txtSituacao']; //utilizado para salvar os filtros utilizados
  const permissaoUsuarioLogado = await permissaoAcessos("PAGAR");

  $('#txtDataDe').val('1200-01-01');
  $('#txtDataAte').val('2500-12-01');
  $('#txtVenctoDe').val('1200-01-01');
  $('#txtVenctoAte').val('2500-12-01');
  $('#dtBaixaDe').val('1200-01-01');
  $('#dtBaixaAte').val('2500-12-01');
  await setarDataAtual('txtDTPagamento');
  await setarDataAtual('txtDTContabilizacao');
  await setarDataAtual("txtDTPagamentoAnt");
  await setarDataAtual("txtDTContabilizacaoAnt");

  const FormatoDtNovo = 'DD/MM/YYYY';

  $('#checkTodasEmpresas').on('change', function () {
    if ($('#checkTodasEmpresas')[0].checked == true) {
      carregaEmpresasDisponiveis();
    }
  });

  await carregaValoresPadroes();
  restaurarFiltrosCache('filtrosAcessoPagar', campos);
  // $('#btnConsultar').trigger('click');


  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btn-novoPagar').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "pagar/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });


  await preencheOrdenacaoTela('Pagar');

  $('#txtConsultaFornecedor').pesquisa_variosServerside(1, `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME"], "where":null}`, 'CODCLI', 'NOME');
  $('#btn-ConsultaFornecedor').pesquisa_serversideSel('#txtConsultaFornecedor', `{ "tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA"], "where":null}`, 'Pesquisa Fornecedor');
  $('#btn-limpa-ConsultaFornecedor').on('click', function () {
    $('#txtConsultaFornecedor').empty().trigger('change');
  });

  $('#txtConsultaHistorico').pesquisa_variosServerside(1, `{"tabela":"histcp", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where":null}`, 'HISTORICO', 'DESCRICAO');
  $('#btn-ConsultaHistorico').pesquisa_serversideSel('#txtConsultaHistorico', `{ "tabela":"histcp", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where":null}`, 'Pesquisa Histórico');
  $('#btn-limpa-ConsultaHistorico').on('click', function () {
    $('#txtConsultaHistorico').empty().trigger('change');
  });

  $('#txtConsultaClasseGerencial').pesquisa_variosServerside(1, `{"tabela":"classe_ger", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where":null}`, 'CODIGO', 'DESCRICAO');
  $('#btn-ConsultaClasseGerencial').pesquisa_serversideSel('#txtConsultaClasseGerencial', `{ "tabela":"classe_ger", "camposSelect":[ "CODIGO", "DESCRICAO"], "where":null}`, 'Pesquisa Classe Gerencial');
  $('#btn-limpa-ConsultaClasseGerencial').on('click', function () {
    $('#txtConsultaClasseGerencial').empty().trigger('change');
  });

  $('#txtConsultaBanco').pesquisa_variosServerside(1, `{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where":null}`, 'BANCO', 'NOME_BANCO');
  $('#btn-ConsultaBanco').pesquisa_serversideSel('#txtConsultaBanco', `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"], "where":null}`, 'Pesquisa Banco');
  $('#btn-limpa-ConsultaBanco').on('click', function () {
    $('#txtConsultaBanco').empty().trigger('change');
  });

  $('#txtConsultaConta').pesquisa_variosServerside(1, `{"tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where":null}`, 'CONTA', 'DESCRICAO');
  $('#btn-ConsultaConta').pesquisa_serversideSel('#txtConsultaConta', `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"], "where":null}`, 'Pesquisa Conta');
  $('#btn-limpa-ConsultaConta').on('click', function () {
    $('#txtConsultaConta').empty().trigger('change');
  });

  $('#txtConsultaSituacao').pesquisa_variosServerside(1, `{"tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where":null}`, 'CODIGO', 'DESCRICAO');
  $('#btn-ConsultaSituacao').pesquisa_serversideSel('#txtConsultaSituacao', `{ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where":null}`, 'Pesquisa Situação');
  $('#btn-limpa-ConsultaSituacao').on('click', function () {
    $('#txtConsultaSituacao').empty().trigger('change');
  });

  $('#txtHistorico').autocompleta(1, 'JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}');
  $('#txtHistoricoAnt').autocompleta(1, 'JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}');
  $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO"], "where": null}');
  $('#txtClasse').autocompleta(1, 'JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}');
  $('#txtClasseAnt').autocompleta(1, 'JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}');
  $('#txtClasseJuros').autocompleta(1, 'JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}');

  $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}', 'Pesquisa Histórico', 'histcp');
  $('#btn-HistoricoAnt').pesquisa('#txtHistoricoAnt', 'HISTORICO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}', 'Pesquisa Histórico', 'histcp');
  $('#btn-Conta').pesquisa('#txtConta', 'CONTA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}', 'Pesquisa Conta', 'CADCONTA');
  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}', 'Pesquisa Classe', 'classe_ger');
  $('#btn-ClasseAnt').pesquisa('#txtClasseAnt', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}', 'Pesquisa Classe', 'classe_ger');
  $('#btn-ClasseJuros').pesquisa('#txtClasseJuros', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}', 'Pesquisa Classe', 'classe_ger');

  $('#btn-limpa-Historico').on('click', function () {
    $('#txtHistorico').val('');
  });
  $('#btn-limpa-HistoricoAnt').on('click', function () {
    $('#txtHistoricoAnt').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });
  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btn-limpa-ClasseAnt').on('click', function () {
    $('#txtClasseAnt').val('');
  });
  $('#btn-limpa-ClasseJuros').on('click', function () {
    $('#txtClasseJuros').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtNum_ap').val('');
    $('#txtConsultaFornecedor').val('');
    $('#txtDataDe').val('1200-01-01');
    $('#txtDataAte').val('2500-12-01');
    $('#txtVenctoDe').val('1200-01-01');
    $('#txtVenctoAte').val('2500-12-01');
    $('#dtBaixaDe').val('1200-01-01');
    $('#dtBaixaAte').val('2500-12-01');
    // $('#Status').val('');
    $('#modal-filtros .form-group .form-check-input').prop('checked', false);
    $('#txtSituacao').val('');
    limparFiltrosCache('filtrosAcessoPagar');
  });

  // async function buscaBaixas(sNumAp) {
  //   let url = '/sisplan/pagar/v1/baixaPagar?';
  //   let jsonStr = [];
  //   let response = '';
  //   try {
  //     response = await requisicao('GET', url, `NUM_AP=${sNumAp}`, null);

  //     if (!response) {
  //       return;
  //     }

  //     if (response.status != 200) {
  //       msgErro(jsonStr.RESULT[0].mensagem);
  //       return;
  //     }
  //     jsonStr = await response.json();

  //     return jsonStr;
  //   } catch (error) {
  //     console.error(error);
  //     msgAlerta('Não existem baixas cadastradas nessa AP');
  //   }
  // }

  function atualizaTotais(filtro) {
    let valorTotal = 0;
    let valorPago = 0;
    let valorSaldo = 0;
    valorTotal = $('#tabelaPagar').DataTable().column(6, {
      search: filtro,
    }).data()
      .sum();
    valorPago = $('#tabelaPagar').DataTable().column(7, {
      search: filtro,
    }).data()
      .sum();
    const valorDesconto = $('#tabelaPagar').DataTable().column(10, {
      search: filtro,
    }).data()
      .sum();
    const valorJuros = $('#tabelaPagar').DataTable().column(9, {
      search: filtro,
    }).data()
      .sum();

    const valorMulta = totalMulta = $('#tabelaPagar').DataTable().data().toArray()
      .reduce((soma, item) => soma + (parseFloat(item.MULTA) || 0), 0);

    valorSaldo = valorTotal - valorPago;

    $('#txt_val_total').html(parseFloat(valorTotal).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_pago').html(parseFloat(valorPago).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_Desconto').html(parseFloat(valorDesconto).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_Juros').html(parseFloat(valorJuros).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_saldo').html(parseFloat(valorSaldo).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_Multa').html(parseFloat(valorMulta).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));
  }

  async function buscaPagar() {
    let url = '/sisplan/pagar/v1/Pagar?';
    let sNumAp = $('#txtNum_ap').val();
    let sSituacaoAP = $('#txtSituacao').val();
    let sDTEmiI = moment($('#txtDataDe').val()).format('DD/MM/YYYY');
    let sDTEmiF = moment($('#txtDataAte').val()).format('DD/MM/YYYY');
    let sDtVenctoDe = moment($('#txtVenctoDe').val()).format('DD/MM/YYYY');
    let sDtVenctoAte = moment($('#txtVenctoAte').val()).format('DD/MM/YYYY');
    let dtBaixaDe = moment($('#dtBaixaDe').val()).format('DD/MM/YYYY');
    let dtBaixaAte = moment($('#dtBaixaAte').val()).format('DD/MM/YYYY');
    const ordenacao = $('#txtOrdem').val()
    const componentesStatus = ['cbDUPL', 'cbANTE', 'cbORCA', 'cbCHEQ', 'cbCHDE', 'cbCHCA', 'cbDESD', 'cbAGRU'];
    const sStatus = componentesStatus
      .filter(id => $(`#${id}`).prop('checked')) // Filtra os componentes que estão checados
      .map(id => id.replace('cb', ''))           // Remove o prefixo 'cb'
      .map(item => `'${item}'`)                  // Adiciona aspas simples em cada item
      .join(', ');                               // Junta tudo em uma string separada por vírgulas
    // const sStatus = $("#Status").val() === 'TODOS' ? '' : $("#Status").val();
    // let sStatus = $('#Status').val();
    let sFornecedor = await formataListas($('#txtConsultaFornecedor').val().toString()) != '' ? await formataListas($('#txtConsultaFornecedor').val().toString()) : '';
    let sHistorico = await formataListas($('#txtConsultaHistorico').val().toString()) != '' ? await formataListas($('#txtConsultaHistorico').val().toString()) : '';
    let sClasseGerencial = await formataListas($('#txtConsultaClasseGerencial').val().toString()) != '' ? await formataListas($('#txtConsultaClasseGerencial').val().toString()) : '';
    let sBanco = await formataListas($('#txtConsultaBanco').val().toString()) != '' ? await formataListas($('#txtConsultaBanco').val().toString()) : '';
    let sConta = await formataListas($('#txtConsultaConta').val().toString()) != '' ? await formataListas($('#txtConsultaConta').val().toString()) : '';
    let sSituacao = await formataListas($('#txtConsultaSituacao').val().toString()) != '' ? await formataListas($('#txtConsultaSituacao').val().toString()) : '';
    const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    let params = `ORDENACAO=${ordenacao}&NUM_AP=${sNumAp}&STATUS=${sStatus}&DT_EMISSAOI=${sDTEmiI}&DT_EMISSAOF=${sDTEmiF}&DT_VENCTOI=${sDtVenctoDe}&DT_VENCTOF=${sDtVenctoAte}&BAIXA_DE=${dtBaixaDe}&BAIXA_ATE=${dtBaixaAte}&SITUACAOAP=${sSituacaoAP}&FORNECEDOR=${sFornecedor}&HISTORICO=${sHistorico}&CLASSEGERENCIAL=${sClasseGerencial}&BANCO=${sBanco}&CONTA=${sConta}&SITUACAO=${sSituacao}&EMP_ID=${sEmpID}`;
    let jsonStr = [];
    let response = '';
    try {
      response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return await response.json();
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  }

  function retornaBotaoOpcoes(data) {
    return '<div style="text-align:left;"> '
      + '   <div class="dropdown"> '
      + '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> '
      + `      ${data}`
      + '    </button> '
      + '    <div class="dropdown-menu" style="min-width: 2rem;"> '
      + '    <a id="btn-editar" class="dropdown-item" href="#">Editar</a>'
      + '    <a id="btn-duplicar" class="dropdown-item" href="#">Duplicar</a>'
      // + '    <a id="btn-visualizar" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Visualizar Baixas</a>'
      + '    <a id="btnExcluir" class="dropdown-item" href="#">Excluir</a>'
      + '    <a id="btnLancRateio" class="dropdown-item" href="#">Rateio</a>'
      + '    </div>'
      + '  </div>'
      + '</div>';
  }

  function retornaBotaoEstornar(data) {
    return '<div style="text-align:center;"> '
      + '   <div class="dropdown"> '
      + '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> '
      + `     ${data}`
      + '    </button> '
      + '    <div class="dropdown-menu" style="min-width: 2rem;"> '
      + '    <a id="btnEstornar" class="dropdown-item"  >Estornar</a>'
      + '    </div>'
      + '  </div>'
      + '</div>';
  }

  function botaoSelecionarGrid() {
    return '<div class="form-check">'
      + '<div class="icheck-primary"><input class="align-self-center checkPagar" type="checkbox" value=""><label></label></div>'
      + '</div>';
  }

  $("#tabelaPagar").on("click", "#btnLancRateio", async function () {
    const table = $("#tabelaPagar").DataTable();
    const data = table.row($(this).parents("tr")).data();
    $('#txtNumeroRateio').val(data.NUM_AP)
    $('#txtClasseRateio').val(data.NUM_OS)
    $('#txtTipoRateio').val('CP')
    $('#txtValorRateio').val(data.VALOR.toFixed(2))
    $('#txtDataRateio').val(formataData(new Date()))
    $('#txtNumeroAnt').val(data.NUM_AP)
    $('#txtDataVencto').val(data.DT_VEN)
    $('#txtDuplicata').val('')
    $('#txtNumeroOC').val('')
    $('#txtCentroCustoFixo').val('')
    $('#txtEmpId').val(data.EMP_ID)
    $('#modalLancRateio').modal('show');
  })


  function liberaBotaoBaixa() {
    const table = retornaRegistrosSelecionados();
    if (table.length <= 0) {
      $('#btnBaixar').prop('disabled', true);
      // $("#btnBaixarComAntecipacao").prop("disabled", true);
    } else {
      $('#btnBaixar').prop('disabled', false);
      // $("#btnBaixarComAntecipacao").prop("disabled", false);
    }
  }

  // $('#btnBaixarComAntecipacao').on('click', async function () {
  //   try {
  //     $.LoadingOverlay("show");
  //     const dados = retornaRegistrosSelecionados();
  //     const listaDuplicatas = [];
  //     if (validaDadosBaixa(dados)) {
  //       dados.toArray().forEach(dado => listaDuplicatas.push(dado.NUMERO));
  //       await carregaAntecipacoes(dados[0].CODCRE);

  //       const totalSelecionado = dados.toArray().reduce((total, reg) => total += reg.SALDO, 0);

  //       $("#txtSaldoAPagarAnt").html(
  //         parseFloat(totalSelecionado).toLocaleString("pt-BR", {
  //           minimumFractionDigits: 2,
  //         })
  //       );
  //       $("#modalBaixarComAntecipacao").modal("show");
  //     }
  //   } catch (error) {
  //     console.error(error);
  //   } finally {
  //     $.LoadingOverlay("hide");
  //   }
  // });

  function pegaValoresPagar() {
    try {
      const data = retornaRegistrosSelecionados();

      const retorno = data.toArray().map(item => {
        return {
          NUM_AP: item.NUM_AP,
          VAL_PAG: item.SALDO,
          CLASSE: pegaChave('#txtClasseAnt'),
          HISTORICO: pegaChave('#txtHistoricoAnt'),
          DOCTO: item.DOCTO
        }
      });

      return retorno;
    } catch (error) {
      console.log(error);
    }
  }

  $('#btn-baixarAnt').on('click', async function () {
    const data = retornaRegistrosSelecionados();

    if (contemVariosFornecedores(data.toArray())) {
      msgAlerta(`Contém financeiro de dois ou mais fornecedores selecionados, impossível continuar.`);
      return;
    }

    if ($("#txtClasseAnt").val() == "") {
      msgAlerta("Classe não informada!");
      $("#btn-ClasseAnt").trigger("click");
      return;
    }

    if ($("#txtHistoricoAnt").val() == "") {
      msgAlerta("Histórico não informado!");
      $("#btn-HistoricoAnt").trigger("click");
      return;
    }

    if ($('.campoCheckManual:checked').toArray().length == 0) {
      msgAlerta('Nenhuma antecipação selecionada, impossível continuar.');
      return;
    }

    const listaBaixas = pegaValoresPagar();
    const listaAntecipacoes = await pegaValoresAntecipacao();
    const objeto = { listaAntecipacoes, listaBaixas };

    const response = await requisicao(
      'POST',
      "/Sisplan/pagar/V1/baixarpagarcomantecipacao?",
      "",
      `JSON=${JSON.stringify(objeto)}`,
      300000
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    toastr
      .success("Baixa efetuada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        async onHidden() {
          window.location.href = `${BASE_URI}/pagar`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  });

  async function pegaValoresAntecipacao() {
    try {
      const antecipacoesSelecionadas = retornaAntecipacoesSelecionadas();
      const objeto = antecipacoesSelecionadas.toArray().map((item) => {
        return {
          NUM_AP: item.NUM_AP,
          SALDOANTECIPACAO: item.VALOR,
          CLASSE: pegaChave('#txtClasseAnt'),
          HISTORICO: pegaChave('#txtHistoricoAnt'),
          DOCTO: item.DOCTO
        };
      });
      return objeto;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores das antecipações");
    }
  }

  async function carregaAntecipacoes(codCre) {
    const url = `/sisplan/pagar/v1/buscarantecipacao?`;
    try {
      const response = await requisicao('GET', url, `CODCRE=${codCre}`, null);

      if (!response) {
        return;
      }

      const data = await response.json();
      if (response.status != 200) {
        msgErro(data.mensagem);
        return;
      }

      await carregaTabelaAntecipacaoSelecaoManual(data);
    } catch (error) {
      console.error(error);
      msgAlerta('Não foi possível buscar as antecipações.');
    }
  }

  async function carregaTabelaAntecipacaoSelecaoManual(dataSet) {
    const dataSetCols = [];
    if (!$.isEmptyObject(dataSet[0])) {
      const keys = Object.keys(dataSet[0]);
      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      dataSetCols[0].render = function (data, type, row, meta) {
        $('.campoCheckManual').unbind('change');
        const sProp = (row.VALOR_PAGO > 0) ? 'checked' : '';

        return `${'<div class="group-default form-group">' +
          '<div class="relative">' +
          '<input '}${sProp}  style="height:15px" type="checkbox" id="check_col_${[meta.row]}_row_${[meta.col]
          }" class="input-default focus form-control validate campoCheckManual"> ` +
          `</div>` +
          `</div>`;
      };

      dataSetCols[2].type = 'date-br';
      dataSetCols[2].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };
      dataSetCols[3].type = 'date-br';
      dataSetCols[3].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };

      try {
        $('#tabelaAntecipacoesABaixar').DataTable({
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          "columns": dataSetCols,
          "data": dataSet,
          columnDefs: [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              "targets": [4, 5],
              "className": 'pr-4 text-right'
            }
          ],
        });
      } catch (error) {
        console.log(error)
      }
    }
  }

  $('#check_todos').on('change', async function () {
    await marcarTodos();
  });

  async function marcarTodos() {
    let isChecked = $('#check_todos').prop('checked');
    let table = $('#tabelaPagar').DataTable();

    // Iterar sobre todas as páginas
    table.rows().every(function () {
      let row = $(this.node());
      row.find('.checkPagar').prop('checked', isChecked);

      // Adicionar ou remover a classe 'selected' conforme o estado do checkbox
      if (isChecked) {
        row.addClass('selected');
      } else {
        row.removeClass('selected');
      }
    });

    await buscaBaixas();
    liberaBotaoBaixa()
  }

  $('#tabelaPagar').on('click', 'td', async function () {
    $('#tabelaPagar tbody tr.selected').each(function () {
      let $row = $(this);
      let $chk = $row.find('.checkPagar');
      if (!$chk.prop('checked')) {
        $row.removeClass('selected');
      }
    });

    let $tr = $(this).closest('tr');
    let $checkbox = $tr.find('.checkPagar');
    let isSelected = $tr.hasClass('selected');

    if (isSelected && !$checkbox.prop('checked')) {
      $checkbox.prop('checked', true);
    } else if (bConsultou) {
      $tr.addClass('selected');
    } else {
      if (isSelected) {
        $tr.removeClass('selected');
        $checkbox.prop('checked', false);
      } else {
        $tr.addClass('selected');
        $checkbox.prop('checked', true);
      }
    }

    bConsultou = false;
    liberaBotaoBaixa();
    await buscaBaixas();
  });


  $('#btnConsultar').on('click', async function () {
    bConsultou = true
    if ($.fn.DataTable.isDataTable('#tabelaBaixaPagar')) {
      $('#tabelaBaixaPagar').DataTable().clear().draw();
    }

    $("#tabelaPagarDiv").removeClass("d-none")

    Graficos.limpaGrafico(['graficoAcessoPagar']);
    limparFiltrosCache('filtrosAcessoPagar');
    $.LoadingOverlay('Show');
    try {
      try {
        let jsonStr = await buscaPagar();

        let table = $('#tabelaPagar').DataTable({
          destroy: true,
          pageLength: 10,
          colReorder: true,
          scrollX: true,
          scrollY: "350px",
          autoWidth: true,
          data: jsonStr,
          columns: [
            { data: null, },
            { data: 'NUM_AP', },
            { data: 'CODCRE', },
            { data: 'CLIENTE', },
            { data: 'LANCAMENTO', },
            { data: 'DUPLI', },
            { data: 'VALOR', },
            { data: 'VAL_PAG', },
            { data: 'SALDO', },
            { data: 'JUROS', },
            { data: 'MULTA', },
            { data: 'DESCONTO', },
            { data: 'DT_EMI', },
            { data: 'DT_VEN', },
            { data: 'NUM_OS', }, //classe
            { data: 'DESCRICAO_CLASSE', },
            { data: 'BANCO', },
            { data: 'CONTA', },
            { data: 'STATUS', },
            { data: 'SITUACAO', },
            { data: 'OBS', },
          ],
          columnDefs: [
            {
              type: 'date-br',
              render(data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              },
              targets: 12,
            },
            {
              type: 'date-br',
              render(data, type, row) {
                x = data.slice(0, 10).split('-');
                let icone = '';
                const dataVencimento = new Date(`${row.DT_VEN} 23:59:59`);
                if (dataVencimento < new Date()) {
                  icone = '<i class="fas fa-history" style="color: red" title="Título vencido"></i>';
                } else {
                  icone = '';
                }
                const retornaData = new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                return `${retornaData} ${icone}`;

              },
              targets: 13,
            },
            {
              type: 'date-br',
              render(data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              },
              targets: 13,
            },
            {
              render(data) {
                return parseFloat(data).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              targets: [6, 7, 8, 9, 11],
              "className": 'pr-4 text-right'
            },
            {
              targets: [1], render: function (data, type, row) {
                return retornaBotaoOpcoes(data);
              }
            },
            {
              targets: 0,
              data: null,
              defaultContent: botaoSelecionarGrid(),
            },
            {
              targets: [4, 10, 16, 17, 19, 20],
              visible: false,
            },
            {
              targets: 8,
              createdCell: function (td, cellData) {
                $(td).css({
                  'color': 'red',
                  'font-weight': 'bold'
                });
              }
            },
            {
              targets: 6,
              createdCell: function (td, cellData) {
                $(td).css({
                  'color': '#3ca2d3',
                  'font-weight': 'bold'
                });
              }
            },
            {
              targets: 7,
              createdCell: function (td, cellData) {
                $(td).css({
                  'color': '#28a745',
                  'font-weight': 'bold'
                });
              }
            }
          ],
        });

        $('#tabelaPagar tbody tr td [data-toggle="tooltip"]').tooltip();

        atualizaTotais('none');

        $('#tabelaPagar').on('click', '#btn-editar', async function () {
          if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = table.row($(this).parents('tr')).data();
            let pagarLiberado = await verificarRegistro('PAGAR', data.NUM_AP);
            if (pagarLiberado) {
              let numAp = btoa(data.NUM_AP);
              window.location.href = `pagar/${numAp}`;
            }
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });

        $('#tabelaPagar').on('click', '#btn-duplicar', async function () {
          if (permissaoUsuarioLogado.INCLUI == 'S') {
            try {
              salvarFiltrosCache('filtrosAcessoPagar', campos);
              const data = table.row($(this).parents('tr')).data();
              let response = await requisicao('POST', '/Sisplan/pagar/V1/duplicar?', `num_ap=${data.NUM_AP}`);

              if (!response) {
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
              }

              //validar qual será o número da ap para passar por parametro
              const numAp = btoa(jsonStr.mensagem);
              window.location.href = `pagar/${numAp}`;
            } catch (error) {
              console.error(error);
            }

          } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
          }
        });

        $('#tabelaPagar').on('click', '.btnOpcao', async function () {
          $('#check_todos').prop('checked', false);
          await marcarTodos();
          $('.checkPagar').prop('checked', false);
        });

        $('#modal-filtros').modal('hide');
        $('#btnBaixar').prop('disabled');
        // $("#btnBaixarComAntecipacao").prop("disabled", true);

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaPagar_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaPagar_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
        $("#tabelaPagar_length").parent().css("align-content", "end");

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          grid = 'pagar';
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = `/Sisplan/pagar/v1/Pagar?`;
          const dados = $("#tabelaPagar").DataTable().data().toArray();
          await exportaCSV(url, '', false, null, 'Relatório de Pagar', '#tabelaPagar', '', 999, false, false, dados);
        })

        $('#tabelaPagar').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.acessoPagar).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      } catch (error) {
        msgErro('Não foi possível buscar os dados do Pagamento: ');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (grid == 'baixas') {
      $('#tabelaBaixaPagar').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        });
      });

      const colunasVisiveis = cols.slice(1);
      adicionaColunas(colunasVisiveis, colunasInvisiveis.acessoPagarBaixas ?? ['']);
      return
    }

    $('#tabelaPagar').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    const colunasVisiveis = cols.slice(2)
    adicionaColunas(colunasVisiveis, colunasInvisiveis.acessoPagar ?? [''])
  })

  // $('#tabelaPagar').on('click', '#btn-visualizar', async function () {
  //   try {
  //     try {
  //       $.LoadingOverlay('show');
  //       let table = $('#tabelaPagar').DataTable();
  //       let data = table.row($(this).parents('tr')).data();
  //       let jsonStr = [];
  //       let response = '';
  //       let fornecedor = '';

  //       jsonStr = await buscaBaixas(data.NUM_AP);

  //       $('#tabelaBaixar').DataTable({
  //         destroy: true,
  //         language: {
  //           sEmptyTable: 'Nenhum registro encontrado',
  //           sInfo: '_TOTAL_ registros',
  //           sInfoEmpty: ' 0 registros',
  //           sInfoFiltered: '(Filtrados de _MAX_ registros)',
  //           sInfoPostFix: '',
  //           sInfoThousands: '.',
  //           sLengthMenu: '_MENU_ resultados',
  //           sLoadingRecords: 'Carregando...',
  //           sProcessing: 'Processando...',
  //           sZeroRecords: 'Nenhum registro encontrado',
  //           sSearch: 'Pesquisar',
  //           oPaginate: {
  //             sNext: 'Próximo',
  //             sPrevious: 'Anterior',
  //             sFirst: 'Primeiro',
  //             sLast: 'Último',
  //           },
  //           oAria: {
  //             sSortAscending: ': Ordenar colunas de forma ascendente',
  //             sSortDescending: ': Ordenar colunas de forma descendente',
  //           },
  //         },
  //         autoWidth: true,
  //         data: jsonStr,
  //         columns: [{
  //           data: 'NUM_AP',
  //         },
  //         {
  //           data: 'DT_LAN',
  //         },
  //         {
  //           data: 'VALOR',
  //         },
  //         {
  //           data: 'VAL_PAG',
  //         },
  //         {
  //           data: 'JURO',
  //         },
  //         {
  //           data: 'MULTA',
  //         },
  //         {
  //           data: 'DESCONTO',
  //         },
  //         ],
  //         columnDefs: [{
  //           targets: [0], render: function (data, type, row) {
  //             return retornaBotaoEstornar(data);
  //           }
  //         },
  //         {
  //           render: $.fn.dataTable.render.moment(FormatoDtNovo),
  //           targets: 1,
  //         },
  //         ],
  //       });

  //       response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.CODCRE", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}], "where": ["PAGTO.NUM_AP = '${data.NUM_AP}'"]}`, null);
  //       if (!response) {
  //         return;
  //       }
  //       jsonStr = await response.json();
  //       if (response.status != 200) {
  //         msgErro(jsonStr.RESULT[0].mensagem);
  //         return;
  //       }
  //       fornecedor = `[${jsonStr.RESULT[0][0].CODCRE}] - ${jsonStr.RESULT[0][0].NOME}`;

  //       $('#txtFornecedorVisual').val(fornecedor);
  //       $('#txtDTemissaoVisual').val(data.DT_EMI);
  //       $('#txtNotaFiscalVisual').val(data.DUPLI);
  //       $('#txtSaldoVisual').val(data.SALDO);
  //     } catch (error) {
  //       console.error(error);
  //       msgErro('Erro ao buscar as baixas para visualizar');
  //     }
  //   } finally {
  //     $.LoadingOverlay('hide');
  //   }
  // });

  async function buscaBaixas() {
    $.LoadingOverlay('show');
    try {
      if ($.fn.DataTable.isDataTable('#tabelaBaixaPagar')) {
        $('#tabelaBaixaPagar').DataTable().clear().draw();
      }
      Graficos.limpaGrafico(['graficoAcessoPagar']);

      const url = '/sisplan/pagar/v1/buscabaixas?';
      const table = $('#tabelaPagar').DataTable();
      const data = table.rows('.selected').data();
      const sNumAp = data.toArray().map(item => `'${item.NUM_AP}'`).join(",");

      if (sNumAp == '') return

      const response = await requisicao('POST', url, '', `NUM_AP=${sNumAp}`, 150000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      const jsonStr = await response.json();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      if (jsonStr.length == 0) {
        return;
      }

      const columns = [
        { data: 'NUM_AP' },
        { data: 'DT_LAN' },
        { data: 'VALOR' },
        { data: 'VAL_PAG' },
        { data: 'JURO' },
        { data: 'MULTA' },
        { data: 'DESCONTO' },
        { data: 'SALDO' },
        { data: 'CODCRE' },
        { data: 'NOME' },
        { data: 'DUPLI' },
        { data: 'DT_EMI' }
      ]

      $("#menuBaixas").removeClass("d-none")

      $('#tabelaBaixaPagar').DataTable({
        search: false,
        filter: true,
        order: [],
        sort: true,
        destroy: true,
        paging: true,
        pageLength: 10,
        pageLength: 10,
        colReorder: true,
        scrollY: "350px",
        scrollX: true,
        destroy: true,

        "autoWidth": true,
        "data": jsonStr,
        "columns": columns,
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoEstornar(data);
            }
          },
          {
            "type": 'date-br',
            "targets": [1, 11],
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [2, 3, 4, 5, 6, 7],
            "className": 'pr-4 text-right'
          }
        ]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaBaixaPagar_length').prepend('<button class="buttonColVis" id="buttonColVisBaixas"><i class="fas fa-cogs"></i></button>');
      $('#tabelaBaixaPagar_length').prepend('<button class="buttonExcel" id="buttonExcelBaixas"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVisBaixas').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcelBaixas').prop('title', 'Exportar')

      $('#buttonColVisBaixas').on('click', async function () {
        grid = 'baixas';
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcelBaixas').on('click', async function () {
        const url = `/Sisplan/pagar/v1/buscabaixas?`;
        const dados = $("#tabelaBaixaPagar").DataTable().data().toArray();
        await exportaCSV(url, '', false, null, 'Baixa Pagar', '#tabelaBaixaPagar', '', 999, false, false, dados);
      })

      $('#tabelaBaixaPagar').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.acessoPagarBaixas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      const dados = $('#tabelaBaixaPagar').DataTable().data().toArray();

      Graficos.criarGrafico({
        container: 'graficoAcessoPagar',
        tipo: 'donut',
        dados: dados,
        nomeSerie: 'Pagar',
        colunasAgrupamento: ['VAL_PAG', 'DESCONTO', 'JURO', 'MULTA', 'SALDO'],
        colunasValor: ['VAL_PAG', 'DESCONTO', 'JURO', 'MULTA', 'SALDO'],
        colunasDescricao: ['Valor Pago', 'Desconto', 'Juros', 'Multa', 'Saldo'],
        cores: {
          "Valor Pago": "#28a745",
          "Desconto": "blue",
          "Juros": "yellow",
          "Multa": "gray",
          "Saldo": "red",
        }
      })
    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('PAGTO')

    function primeiroDia() {
      let agora = new Date();
      let primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
      return primeiroDia;
    }

    let diaUm = primeiroDia();
    let dataISO = diaUm.toISOString();
    let dataString = dataISO.substr(0, 10);

    jsonStr.map(async item => {
      switch (item.CAMPO) {

        case 'STATUS': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#Status').val(item.VALOR).change();
          } else {
            $('#Status').val('').change();
          }

          break;
        }
        case 'SITUACAO': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#txtSituacao').val(item.VALOR).change();
          } else {
            $('#txtSituacao').val('Aberto').change();
          }

          break;
        }

        case 'EMISSAO_DE': {
          if (item.VALOR == 'S') {
            $('#txtDataDe').val(dataString);
          } else {
            $('#txtDataDe').val();
          }

          break;
        }

        case 'VENCIMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtVenctoDe').val(dataString);
          } else {
            $('#txtVenctoDe').val();
          }

          break;
        }
      }
    });
  }

  $('#tabelaPagar').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {

      try {
        $.LoadingOverlay('show');
        let table = $('#tabelaPagar').DataTable();
        let data = table.row($(this).parents('tr')).data();

        if ((data.STATUS == 'AGRU') || (data.STATUS == 'DESD')) {
          msgAlerta('Impossível excluir APs agrupadas ou desdobradas.');
          return;
        }

        let response = '';
        try {
          response = await requisicao('DELETE', '/Sisplan/pagar/v1/Pagar?', `num_ap=${data.NUM_AP}&lancamento=${data.LANCAMENTO}`, null);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }
          toastr.success(
            'Pagamento Excluido com Sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning',
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          },
          ).css({
            'margin-top': '20%',
            width: '500px',
            'max-width': '500px',
          });
        } catch (error) {
          console.error(error);
          msgErro('Erro ao excluir o registro.');
        }
      } finally {
        $.LoadingOverlay('hide');
        $('#btnConsultar').trigger('click');
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  // $('#tabelaBaixar').on('click', '#btnEstornar', async function () {
  //   try {
  //     $.LoadingOverlay('Show');
  //     let table = $('#tabelaBaixar').DataTable();
  //     let data = table.row($(this).parents('tr')).data();
  //     let response = '';
  //     try {
  //       response = await requisicao('POST', '/Sisplan/pagar/V1/Estornar?', `LANCAMENTO=${data.LANCAMENTO}&NUM_AP=${data.NUM_AP}`);

  //       if (!response) {
  //         return;
  //       }

  //       let jsonStr = await response.json();
  //       if (response.status != 200) {
  //         msgErro(jsonStr.mensagem);
  //         return;
  //       }
  //       $('#txtSaldoVisual').val(parseFloat($('#txtSaldoVisual').val()) + parseFloat(data.VAL_PAG));

  //       table.rows().remove().draw(false);

  //       toastr.success(
  //         'Pagamento Estornado com Sucesso!',
  //         'Confirmação', {
  //         toastClass: 'alert',
  //         iconClasses: {
  //           error: 'alert-error',
  //           info: 'alert-info',
  //           success: 'alert-success',
  //           warning: 'alert-warning',
  //         },
  //         positionClass: 'toast-top-center',
  //         progressBar: true,
  //         timeOut: 3000,
  //         fadeOut: 1000,
  //       },
  //       ).css({
  //         'margin-top': '20%',
  //         width: '500px',
  //         'max-width': '500px',
  //       });
  //     } catch (error) {
  //       console.error(error);
  //       msgErro('Erro ao estornar as baixas!');
  //     }
  //   } finally {
  //     $.LoadingOverlay('hide');
  //     $('#btnConsultar').trigger('click');
  //   }
  // });

  $('#tabelaPagar').on('init.dt', function () {
    selecionarPrimeiroRegistro();
  });

  function selecionarPrimeiroRegistro() {
    const $primeiraLinha = $('#tabelaPagar tbody tr:first');

    if ($primeiraLinha.length) {
      const $primeiroTd = $primeiraLinha.find('td:first');
      $primeiroTd.trigger('click');
    }
  }

  $('#tabelaBaixaPagar').on('click', '#btnEstornar', async function () {
    try {
      $.LoadingOverlay('Show');
      let table = $('#tabelaBaixaPagar').DataTable();
      let data = table.row($(this).parents('tr')).data();
      let response = '';
      try {
        response = await requisicao('POST', '/Sisplan/pagar/V1/Estornar?', `LANCAMENTO=${data.LANCAMENTO}&NUM_AP=${data.NUM_AP}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
        $('#txtSaldoVisual').val(parseFloat($('#txtSaldoVisual').val()) + parseFloat(data.VAL_PAG));

        table.rows().remove().draw(false);

        toastr.success(
          'Pagamento Estornado com Sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
        Graficos.limpaGrafico(['graficoAcessoPagar']);
      } catch (error) {
        console.error(error);
        msgErro('Erro ao estornar as baixas!');
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#btnConsultar').trigger('click');
    }
  });

  $('#modalBaixar').on('hidden.bs.modal', function () {
    $('#txtClasse').val('');
    $('#txtClasseJuros').val('');
    $('#txtConta').val('');
    $('#txtHistorico').val('');
  });

  $('#btnBaixar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {

        let sNumero = [];
        let table = $('#tabelaPagar').DataTable();
        let data = retornaRegistrosSelecionados();

        if (data[0].VALOR == data[0].VAL_PAG) {
          msgAlerta('Essa duplicata já está baixada!');
          return;
        }

        for (let i = 0; i < data.length; i++) {
          if ((data[i].STATUS === 'DESD') || (data[i].STATUS === 'AGRU')) {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `, 'modalBaixar');
            return;
          }

          if (data[i].STATUS === 'CHCA') {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um título de Cheque. Impossível Baixar.`, 'modalBaixar');
            return;
          }

          if (data[i].STATUS === 'ANTE') {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um título de Antecipação. Impossível Baixar. `, 'modalBaixar');
            return;
          }
          sNumero.push(data[i].NUM_AP);
        }

        const contasDiferentes = data.filter((registro) => registro.CONTA !== data[0].CONTA).length > 0;
        if (!contasDiferentes) {
          insereValor("#txtConta", data[0].CONTA, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: data[0].CONTA });
        }

        const classesDiferentes = data.filter(registro => registro.NUM_OS !== data[0].NUM_OS).length > 0;
        if (!classesDiferentes) {
          insereValor("#txtClasse", data[0].NUM_OS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data[0].NUM_OS });
        }

        $('#modalBaixar').modal('show');

        const ListaNumeros = `'${sNumero.toString().replaceAll(',', "','")}'`;

        let response = await requisicao('GET', '/Sisplan/Pagar/v1/Pagar?', `LISTA_NUM_APS=${ListaNumeros}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT.mensagem);
          return;
        }

        table = await $('#tabelaBaixarContas').DataTable({
          order: false,
          destroy: true,
          paging: false,
          autoWidth: true,
          data: jsonStr,
          columns: [
            { data: 'NUM_AP', title: 'NUM_AP' },
            { data: 'CODCRE', title: 'CODCRE' },
            { data: 'CLIENTE', title: 'CLIENTE' },
            { data: null, title: 'DESCONTO' },
            { data: null, title: 'JUROS' },
            { data: 'VALOR', title: 'VALOR' },
            { data: null, title: 'VAL_PAG' },
            { data: 'SALDO', title: 'SALDO' },
            { data: 'SALDOORIG', title: 'SALDOORIG' },
          ],
          columnDefs: [{
            targets: 3,
            data: null,
            defaultContent: retornaInputs(true, false, false),
          },
          {
            targets: 4,
            data: null,
            defaultContent: retornaInputs(false, true, false),
          },
          {
            targets: 6,
            data: null,
            defaultContent: retornaInputs(false, false, true),
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [5, 7, 8],
            "className": 'pr-4 text-right'
          },
          {
            targets: 8,
            visible: false,
          }],
        });

        $('#tabelaBaixarContas').on('draw.dt', function () {
          $('#desconto, #juros, #valorPago').maskMoney({
            prefix: '',
            allowNegative: false,
            thousands: '',
            decimal: '.',
            affixesStay: false,
            precision: 2
          }).maskMoney('mask');

          $('#desconto, #juros, #valorPago').each(function () {
            $(this).val('0.00').trigger('mask.maskMoney');
          });
        });

        let countRow = $('#tabelaBaixarContas').DataTable().rows().count();

        let tableBaixar = $('#tabelaBaixarContas').DataTable().rows().data();
        for (let i = 0; i < countRow; i++) {
          $($('.txtvalorPago')[i]).val(tableBaixar[i].SALDO);
          $($('.txtvalorPago')[i]).attr('data-valor-old', tableBaixar[i].SALDO);
        }
        verificarNumeroRegistros()

        await carregaAntecipacoes(data[0].CODCRE);

        const totalSelecionado = data.toArray().reduce((total, reg) => total += reg.SALDO, 0);

        $("#txtSaldoAPagarAnt").html(
          parseFloat(totalSelecionado).toLocaleString("pt-BR", {
            minimumFractionDigits: 2,
          })
        );
      } catch (error) {
        console.error(error);
        msgErro('Erro ao Realizar baixa');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  retornaHintRelatorio('btnImprimir', 'Pagar')
  $('#btnImprimir').on('click', async function () {
    try {
      try {
        $.LoadingOverlay('show');

        let numeros = [];
        let pagar = retornaRegistrosSelecionados();

        for (let i = 0; i < pagar.length; i++) {
          numeros.push(pagar[i].NUM_AP);
        }

        const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

        let situacaoFiltro = ''
        let fornecedorFiltro = ''
        let dataAteFiltro = ''
        let dataDeFiltro = ''
        let venctoAteFiltro = ''
        let venctoDeFiltro = ''
        let dataBaixaDeFiltro = ''
        let dataBaixaAteFiltro = ''
        let statusFiltro = ''
        let emp_id = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
          ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
          : getCookie('emp_id');

        if (numeros.length == 0) {
          situacaoFiltro = $('#txtSituacao').val();
          fornecedorFiltro = $('#txtConsultaFornecedor').val().substring(1, $('#txtConsultaFornecedor').val().indexOf('] - '));
          dataAteFiltro = moment($('#txtDataAte').val()).format('DD/MM/YYYY');
          dataDeFiltro = moment($('#txtDataDe').val()).format('DD/MM/YYYY');
          venctoAteFiltro = moment($('#txtVenctoAte').val()).format('DD/MM/YYYY');
          venctoDeFiltro = moment($('#txtVenctoDe').val()).format('DD/MM/YYYY');
          dataBaixaDeFiltro = moment($('#dtBaixaDe').val()).format('DD/MM/YYYY');
          dataBaixaAteFiltro = moment($('#dtBaixaAte').val()).format('DD/MM/YYYY');
          statusFiltro = $('#Status').val();
          emp_id = $('#checkTodasEmpresas').prop('checked') == false ? emp_id : $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : emp_id;
        }

        url = `/sisplan/impressao/v1/acesso_pagar?TELA_ORDENACAO=Pagar&NUM_AP=${ListaNumeros}&ORDEM_ORDENACAO=${$('#txtOrdem').val()}&SITUACAO=${situacaoFiltro}&FORNECEDOR=${fornecedorFiltro}&DATADE=${dataDeFiltro}&DATAATE=${dataAteFiltro}&VENCTODE=${venctoDeFiltro}&VENCTOATE=${venctoAteFiltro}&BAIXA_DE=${dataBaixaDeFiltro}&BAIXA_ATE=${dataBaixaAteFiltro}&STATUS=${statusFiltro}&EMP_ID=${emp_id}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('Pagar');
        arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Pagar');
        if (arquivo != undefined && arquivo != "") {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (err) {
        console.error(err);
        msgErro('Erro ao imprimir relatório.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function retornaInputs(bUsaDesconto = false, bUsaJuros = false, bUsaValor = false) {
    let retorno = '';
    if (bUsaDesconto) {
      retorno = '<div><input min="0" type="text" value="0.00" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtDesconto money" id="desconto"></div>';
    }
    if (bUsaJuros) {
      retorno = '<input min="0" type="text" value="0.00" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtJuros money" id="juros">';
    }
    if (bUsaValor) {
      retorno = '<input min="0" type="text" value="0.00" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtvalorPago money" id="valorPago">';
    }

    setTimeout(() => {
      $('.money').maskMoney({
        prefix: '',
        allowNegative: false,
        thousands: '',
        decimal: '.',
        affixesStay: false,
        precision: 2
      }).maskMoney('mask');
    }, 0);
    return retorno;
  }


  $('#tabelaBaixarContas').on('blur', '.txtvalorPago', async function () {
    let valor = parseFloat($(this).val());
    let saldo = parseFloat(($(this).closest('tr')[0].childNodes[7].childNodes[0].data).replace('.', '').replace(',', '.'));

    if (valor > saldo) {
      msgAlerta('Valor não pode ser maior que o Saldo');
      $(this).val(saldo);
      $(this).closest('tr').find('.txtJuros').val('0.00');
      $(this).closest('tr').find('.txtDesconto').val('0.00');
    }
  });

  // desconto
  $('#tabelaBaixarContas').on('blur', '.txtDesconto', async function () {
    $('.txtvalorPago').focus();
    if (parseFloat($(this).val()) < 0) {
      msgAlerta('Desconto não pode ser menor que 0!');
      $(this).val('0.00');
      return;
    }
    const desconto = parseFloat($(this).val());
    const juros = parseFloat($(this).parents('tr').find('.txtJuros').val()) || 0
    let saldoElement = $(this).closest('tr')[0].childNodes[7].childNodes[0]
    let saldoReal = parseFloat(saldoElement.data.replace('.', '').replace(',', '.'));
    let saldo = parseFloat($('#tabelaBaixarContas').DataTable().row($(this).parents('tr')).data().SALDOORIG);
    let novoValor = 0;
    let valorPago = (saldo + juros) - desconto;

    if (valorPago < 0) {
      msgAlerta('Valor pago não pode ser menor que 0.00!');
      $(this).closest('tr').find('.txtvalorPago').val(saldo);
      $(this).closest('tr').find('.txtJuros').val('0.00');
      $(this).val('0.00');
      return;
    }

    $(this).closest('tr').find('.txtvalorPago').val(await TruncaDecimais(2, valorPago, novoValor));
    saldoElement.data = parseFloat(valorPago + 0.01).toFixed(2).replace('.', ',');

    if (novoValor > saldoReal) {
      msgAlerta('Valor não pode ser maior que o Saldo');
      $(this).closest('tr').find('.txtvalorPago').val(saldoReal);
      $(this).closest('tr').find('.txtJuros').val('0.00');
      $(this).val('0.00');
    }
  });

  // juros
  $('#tabelaBaixarContas').on('blur', '.txtJuros', async function () {
    $('.txtvalorPago').focus();
    const juros = parseFloat($(this).val());
    const desconto = parseFloat($(this).parents('tr').find('.txtDesconto').val()) || 0
    let saldoElement = $(this).closest('tr')[0].childNodes[7].childNodes[0]
    let saldo = parseFloat($('#tabelaBaixarContas').DataTable().row($(this).parents('tr')).data().SALDOORIG);
    const valorPago = (saldo + juros) - desconto;

    if (juros < 0) {
      msgAlerta('Juros não pode ser menor que 0!');
      $(this).val('0.00');
      return;
    }

    $(this).closest('tr').find('.txtvalorPago').val(TruncaDecimaisNova(2, valorPago));
    saldoElement.data = parseFloat(valorPago + 0.01).toFixed(2).replace('.', ',');
  });

  let valorPagoMenorQueSaldo = false;

  async function pegaValoresBaixa() {
    try {
      let table = $('#tabelaBaixarContas').DataTable();
      let valores = [];

      // Usar data() em vez de rows() para pegar todas as linhas de todas as páginas
      let todasLinhasdaTabela = table.rows().data();

      for (let i = 0; i < todasLinhasdaTabela.length; i++) {
        if (((parseFloat(todasLinhasdaTabela[i].SALDO) + parseFloat($($('.txtJuros')[i]).val())) - (parseFloat($($('.txtDesconto')[i]).val()))) < parseFloat($($('#tabelaBaixarContas').find('.txtvalorPago')[i]).val())) {
          return valorPagoMenorQueSaldo = true;
        }

        let objeto = {
          VAL_PAG: parseFloat($($('#tabelaBaixarContas').find('.txtvalorPago')[i]).val()),
          DESCONTO: $($('#tabelaBaixarContas').find('.txtDesconto')[i]).val(),
          JURO: $($('#tabelaBaixarContas').find('.txtJuros')[i]).val(),
          LANCAMENTO: todasLinhasdaTabela[i].LANCAMENTO,
          NUM_AP: todasLinhasdaTabela[i].NUM_AP,
          DOCTO: todasLinhasdaTabela[i].DOCTO,
          DT_LAN: `${$('#txtDTPagamento').val()}T00:00:00Z`,
          VAL_DEV: todasLinhasdaTabela[i].VAL_DEV,
          DESP_COBRANCA: todasLinhasdaTabela[i].DESP_COBRANCA,
          VAR_CAMBIAL: todasLinhasdaTabela[i].VAR_CAMBIAL,
          HISTORICO: pegaChave('#txtHistorico'),
          OBS: todasLinhasdaTabela[i].OBS + ' ' + $('#txtObs').val(),
          SALDO: parseFloat(todasLinhasdaTabela[i].SALDO) - parseFloat($($('#tabelaBaixarContas').find('.txtvalorPago')[i]).val()),
          VALPAGO_MOEDA: todasLinhasdaTabela[i].VALPAGO_MOEDA,
          TAXA_MOEDA: todasLinhasdaTabela[i].TAXA_MOEDA,
          DT_PROCESSAMENTO: todasLinhasdaTabela[i].DT_PROCESSAMENTO,
          CLASSE: pegaChave('#txtClasse'),
          CLASSE_JUROS: pegaChave('#txtClasseJuros'),
          DT_CONT: `${$('#txtDTContabilizacao').val()}T00:00:00Z`
        };

        valores.push(objeto);
        valorPagoMenorQueSaldo = false;
      }

      return valores;
    } catch (error) {
      msgErro('Erro ao pegar os valores da tabela');
    }
  }

  $('#btn-baixar').on('click', async function () {
    $('#btn-baixar').prop('disabled', true)
    try {
      $.LoadingOverlay('show');
      if ($('#txtConta').val() == '') {
        msgAlerta('Conta não informada!');
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        $('#btn-Conta').trigger('click');
        return;
      }
      if ($('#txtClasse').val() == '') {
        msgAlerta('Classe não informada!');
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        $('#btn-Classe').trigger('click');
        return;
      }
      if ($('#txtHistorico').val() == '') {
        $('#btn-Historico').trigger('click');
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        msgAlerta('Histórico não informado!');
        return;
      }
      try {
        let table = $('#tabelaBaixarContas').DataTable();
        let rows = table.rows();
        let count = rows.count();
        let Baixas = {};
        let response = '';
        let jsonStr = [];
        let saldo;

        // valida se tem saldo
        for (let i = 0; i < rows[0].length; i++) {
          if (rows.data()[i].SALDO == 0) {
            msgAlerta('Registro já está baixado!');
            $('#tabelaBaixarContas').DataTable().rows([i]).remove().draw(false);
            if (rows[0].length == 1) {
              $('#modalBaixar').modal('hide');
            }
            saldo = rows.data()[i].SALDO;
            return;
          }
        }

        Baixas = await pegaValoresBaixa();

        if (valorPagoMenorQueSaldo) {
          msgAlerta('Valor Pago não pode ser maior que o Saldo')
          return
        }

        for (let i = 0; i < count; i++) {

          if (parseFloat(Baixas[i].VAL_PAG) <= 0) {
            msgAlerta('Valor pago não pode ser 0');
            return;
          }

          response = await requisicao('POST', '/Sisplan/Pagar/V1/baixaPagar?', `CONTA=${pegaChave('#txtConta')}`, `JSON=${encodeURIComponent(JSON.stringify(Baixas[i]))}`);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }
        }
        toastr.success(
          'Pagamento baixado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            $('#btnConsultar').trigger('click');
            $('#modalBaixar').modal('hide');
          },
        },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
      } catch (error) {
        console.error(error);
        msgAlerta('Erro ao realizar baixa!');
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#btn-baixar').prop('disabled', false)
      $('#btnBaixar').prop('disabled', true);
      // $("#btnBaixarComAntecipacao").prop("disabled", true);
    }
  });

  $('#btnDesdobrarAgrupar').on('click', async function () {

    const registrosSelecionados = retornaRegistrosSelecionados();
    const data = registrosSelecionados.toArray();

    if (data.length == 0) {
      msgErro('Nenhuma AP selecionada. Impossível continuar.')
      return;
    }

    let valida = data.filter(e => e.EMP_ID != getCookie('emp_id'));

    if (valida.length > 0) {
      msgErro('Não é possível desdobrar/agrupar APs de empresas diferentes da atual. Impossível continuar.')
      return;
    }

    valida = data.filter(e => (e.SALDO != e.VALOR) && (e.VALOR > 0));

    if (valida.length > 0) {
      msgErro('AP possui baixas. Impossível continuar.')
      return;
    }

    valida = undefined;

    const codcre = data[0].CODCRE;

    valida = data.find(e => codcre != e.CODCRE);

    if (valida != undefined) {
      msgErro('O fornecedor precisa ser o mesmo para todas as APs. Impossível continuar.');
      return;
    }
    msgAlerta('Deseja mesmo desdobrar/agrupar as APs selecionadas?', () => { }, () => { }, () => {
      $.LoadingOverlay('show');
      $('#modal-desdobra-pagar').modal('show');
      $.LoadingOverlay('hide');
    })
  });

  // $('#btnConsultar').trigger('click');

  $('#scrollToBottomBtn').click(function (event) {
    event.preventDefault();
    $(this).toggleClass('fa-arrow-up fa-arrow-down');
    let modalBody = $('.modal-body');
    let targetElement = $('#btn-baixar');
    let offset = targetElement.offset().top - modalBody.offset().top + modalBody.scrollTop();

    modalBody.animate({
      scrollTop: offset
    }, 'slow');
  });

  verificarNumeroRegistros()

  function verificarNumeroRegistros() {
    let numRegistros = $('#tabelaBaixarContas tbody tr').length;

    if (numRegistros < 5) {
      $('#scrollToBottomBtn').hide();
    } else {
      $('#scrollToBottomBtn').show();
    }
  }

  componenteFiltro('classe', false, false, 'ClasseGerencialAlterarPagarEmMassa', [`TP_CONTA <> 'T'`])
  componenteFiltro('historico', false, false, 'HistoricoAlterarPagarEmMassa')
  componenteFiltro('banco', false, false, 'BancoAlterarPagarEmMassa')
  componenteFiltro('situacao', false, false, 'SituacaoAlterarPagarEmMassa')
  componenteFiltro('conta', false, false, 'ContaAlterarPagarEmMassa')
  componenteFiltro('moeda', false, false, 'MoedaAlterarPagarEmMassa')

  $('#btnAlterarPagarEmMassa').on('click', () => carregarModalAlterarPagarEmMassa())

  const carregarModalAlterarPagarEmMassa = () => {
    const registrosSelecionados = retornaRegistrosSelecionados();
    const duplicatasSelecionadas = registrosSelecionados.toArray().map((e) => `'${e.NUM_AP}'`).join(',')
    if (!duplicatasSelecionadas)
      return msgErro('Nenhum registro selecionado, impossível continuar.')

    $('#modalAlterarPagarEmMassa').on('shown.bs.modal', function () {
      $('#tabelaAlterarPagarEmMassa')?.DataTable()?.columns?.adjust()?.draw()
    })

    retornarDadosAlterarPagarEmMassa(duplicatasSelecionadas)
  }

  $('#modalAlterarPagarEmMassa').on('hide.bs.modal', () => {
    $('#modalAlterarPagarEmMassa').off('shown.bs.modal')
    if ($.fn.DataTable.isDataTable('#tabelaAlterarPagarEmMassa')) {
      $('#tabelaAlterarPagarEmMassa').DataTable().destroy()
      $('#tabelaAlterarPagarEmMassa').empty()
    }
    $('.campoAlterarPagarEmMassa').val('')
  })

  const retornarDadosAlterarPagarEmMassa = (duplicatas) => {
    $.LoadingOverlay('show')
    const filtros = {
      duplicatas,
    }
    requisicao(
      'POST',
      `/sisplan/pagar/v1/retornardadosalterarpagaremmassa?`,
      '',
      JSON.stringify(filtros),
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { resultado, mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) return
        const { duplicatas } = resultado

        if (!duplicatas || !duplicatas.length) {
          msgErro('Nenhuma AP encontrado.')
        }

        criarTabelaAlterarPagarEmMassa(duplicatas ?? [])
      }
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => {
      $.LoadingOverlay('hide')
      $('#modalAlterarPagarEmMassa').modal('show')
    })
  }

  const criarTabelaAlterarPagarEmMassa = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaAlterarPagarEmMassa')) {
      $('#tabelaAlterarPagarEmMassa').DataTable().destroy()
      $('#tabelaAlterarPagarEmMassa').empty()
    }

    const columns = [
      {
        data: 'numero',
        title: 'Número',
      },
      {
        data: 'emissao',
        title: 'Emissão',
        type: 'date-br',
        render(data) {
          return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
        }
      },
      {
        data: 'vencimento',
        title: 'Vencimento',
        type: 'date-br',
        render(data) {
          return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
        }
      },
      {
        data: 'classeGerencial',
        title: 'Classe Gerencial',
      },
      {
        data: 'descricaoClasseGerencial',
        title: 'Descrição Classe Gerencial',
      },
      {
        data: 'historico',
        title: 'Histórico',
      },
      {
        data: 'descricaoHistorico',
        title: 'Descrição Histórico',
      },
      {
        data: 'banco',
        title: 'Banco',
      },
      {
        data: 'descricaoBanco',
        title: 'Descrição Banco',
      },
      {
        data: 'situacao',
        title: 'Situação',
      },
      {
        data: 'descricaoSituacao',
        title: 'Descrição Situação',
      },
      {
        data: 'conta',
        title: 'Conta',
      },
      {
        data: 'descricaoConta',
        title: 'Descrição Conta',
      },
      {
        data: 'moeda',
        title: 'Moeda',
      },
      {
        data: 'descricaoMoeda',
        title: 'Descrição Moeda',
      },
      {
        data: 'observacao',
        title: 'Observação',
      },
      {
        data: 'desconto',
        title: 'Desconto',
        render: function (data) {
          if (!data) {
            return '0.00'
          }
          return parseFloat(data).toFixed(2)
        },
        className: 'text-right',
      },
      {
        data: 'juros',
        title: 'Juros',
        render: function (data) {
          if (!data) {
            return '0.00'
          }
          return parseFloat(data).toFixed(2)
        },
        className: 'text-right',
      },
      {
        data: 'possuiDescontoNaBaixa',
        title: '',
        visible: false,
      },
      {
        data: 'possuiJurosNaBaixa',
        title: '',
        visible: false,
      },
    ]

    const table = $('#tabelaAlterarPagarEmMassa').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '350px',
      select: {
        style: 'single',
        toggleable: false,
      },
    })
    table.off('select')
    table.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        const [dados] = table.rows(indexes[0]).data().toArray()
        preencherCamposAlterarPagarEmMassa(dados)
      }
    })
    table.row(':first').select()
  }

  const preencherCamposAlterarPagarEmMassa = (dados) => {
    dados.numero ? insereValor('#txtNumeroAlterarPagarEmMassa', dados.numero) : $('#txtNumeroAlterarPagarEmMassa').val('')
    dados.emissao ? insereValor('#txtEmissaoAlterarPagarEmMassa', dados.emissao?.split('T')[0]) : $('#txtEmissaoAlterarPagarEmMassa').val('')
    dados.vencimento ? insereValor('#txtVencimentoAlterarPagarEmMassa', dados.vencimento?.split('T')[0]) : $('#txtVencimentoAlterarPagarEmMassa').val('')
    dados.classeGerencial ? insereValor('#txtClasseGerencialAlterarPagarEmMassa', dados.classeGerencial, dados.descricaoClasseGerencial) : $('#txtClasseGerencialAlterarPagarEmMassa').val('')
    dados.historico ? insereValor('#txtHistoricoAlterarPagarEmMassa', dados.historico, dados.descricaoHistorico) : $('#txtHistoricoAlterarPagarEmMassa').val('')
    dados.banco ? insereValor('#txtBancoAlterarPagarEmMassa', dados.banco, dados.descricaoBanco) : $('#txtBancoAlterarPagarEmMassa').val('')
    dados.situacao ? insereValor('#txtSituacaoAlterarPagarEmMassa', dados.situacao, dados.descricaoSituacao) : $('#txtSituacaoAlterarPagarEmMassa').val('')
    dados.conta ? insereValor('#txtContaAlterarPagarEmMassa', dados.conta, dados.descricaoConta) : $('#txtContaAlterarPagarEmMassa').val('')
    dados.moeda ? insereValor('#txtMoedaAlterarPagarEmMassa', dados.moeda, dados.descricaoMoeda) : $('#txtMoedaAlterarPagarEmMassa').val('')
    dados.observacao ? insereValor('#txtObservacaoAlterarPagarEmMassa', dados.observacao) : $('#txtObservacaoAlterarPagarEmMassa').val('')
    dados.desconto ? insereValor('#txtDescontoAlterarPagarEmMassa', parseFloat(dados.desconto).toFixed(2)) : $('#txtDescontoAlterarPagarEmMassa').val('0.00')
    dados.juros ? insereValor('#txtJurosAlterarPagarEmMassa', parseFloat(dados.juros).toFixed(2)) : $('#txtJurosAlterarPagarEmMassa').val('0.00')
  }

  $('#btnConfirmarRegistroSelecionado').on('click', () => {
    msgAlerta(
      'Deseja alterar os dados do registro selecionado?',
      () => null,
      () => null,
      () => alterarDadosRegistroSelecionado(),
    )
  })

  $('#btnConfirmarTodosRegistros').on('click', () => {
    msgAlerta(
      'Deseja alterar os dados de todos os registros?',
      () => null,
      () => null,
      () => alterarDadosEmMassa(),
    )
  })

  const alterarDadosRegistroSelecionado = () => {
    const dadosConfirmar = retornarDadosConfirmarPagarEmMassa({ alterarSomenteSelecionado: true })
    if (!validarDadosGravarPagarEmMassa(dadosConfirmar)) return
    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/pagar/v1/gravardadospagaremmassa?`,
      '',
      JSON.stringify(dadosConfirmar),
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            atualizarLinhaSelecionada(dadosConfirmar.dados)
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const alterarDadosEmMassa = () => {
    const dadosConfirmar = retornarDadosConfirmarPagarEmMassa({ alterarSomenteSelecionado: false })
    if (!validarDadosGravarPagarEmMassa(dadosConfirmar)) return
    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/pagar/v1/gravardadospagaremmassa?`,
      '',
      JSON.stringify(dadosConfirmar),
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            $('#modalAlterarPagarEmMassa').modal('hide')
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const retornarDadosConfirmarPagarEmMassa = ({ alterarSomenteSelecionado }) => {
    const emissao = $('#txtEmissaoAlterarPagarEmMassa').val() || '1200-01-01'
    const vencimento = $('#txtVencimentoAlterarPagarEmMassa').val() || '1200-01-01'
    const classeGerencial = pegaChave('#txtClasseGerencialAlterarPagarEmMassa')
    const descricaoClasseGerencial = pegaDescricao('#txtClasseGerencialAlterarPagarEmMassa')
    const historico = pegaChave('#txtHistoricoAlterarPagarEmMassa')
    const descricaoHistorico = pegaDescricao('#txtHistoricoAlterarPagarEmMassa')
    const banco = pegaChave('#txtBancoAlterarPagarEmMassa')
    const descricaoBanco = pegaDescricao('#txtBancoAlterarPagarEmMassa')
    const situacao = pegaChave('#txtSituacaoAlterarPagarEmMassa')
    const descricaoSituacao = pegaDescricao('#txtSituacaoAlterarPagarEmMassa')
    const conta = pegaChave('#txtContaAlterarPagarEmMassa')
    const descricaoConta = pegaDescricao('#txtContaAlterarPagarEmMassa')
    const moeda = pegaChave('#txtMoedaAlterarPagarEmMassa')
    const descricaoMoeda = pegaDescricao('#txtMoedaAlterarPagarEmMassa')
    const observacao = $('#txtObservacaoAlterarPagarEmMassa').val()
    const desconto = $('#txtDescontoAlterarPagarEmMassa').val() || 0
    const juros = $('#txtJurosAlterarPagarEmMassa').val() || 0

    const dados = {
      emissao,
      vencimento,
      classeGerencial,
      descricaoClasseGerencial,
      historico,
      descricaoHistorico,
      banco,
      descricaoBanco,
      situacao,
      descricaoSituacao,
      conta,
      descricaoConta,
      moeda,
      descricaoMoeda,
      observacao,
      desconto,
      juros,
    }

    const datatable = alterarSomenteSelecionado ? $('#tabelaAlterarPagarEmMassa').DataTable().rows({ selected: true }) : $('#tabelaAlterarPagarEmMassa').DataTable()

    const duplicatas = datatable.data().toArray().map((item) => ({
      numero: item.numero,
      possuiDescontoNaBaixa: item.possuiDescontoNaBaixa,
      possuiJurosNaBaixa: item.possuiJurosNaBaixa,
      banco: item.banco,
      vencimento: item.vencimento.split('T')[0],
    }))

    return {
      dados,
      duplicatas,
    }
  }

  const atualizarLinhaSelecionada = (dados) => {
    const datatable = $('#tabelaAlterarPagarEmMassa').DataTable()
    const [indiceLinhaSelecionada] = datatable?.rows({ selected: true }).indexes().toArray()
    const dadosAtuais = datatable.row(indiceLinhaSelecionada).data()
    const novosDados = { ...dadosAtuais, ...dados }
    datatable.row(indiceLinhaSelecionada).data(novosDados).draw(false)
  }

  $('.duasCasasDecimaisInput').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  const validarDadosGravarPagarEmMassa = ({ dados, duplicatas }) => {
    const dataVencimentoAlteracao = new Date(dados.vencimento)
    const dataEmissaoAlteracao = new Date(dados.emissao)

    if (dataVencimentoAlteracao < dataEmissaoAlteracao) {
      msgErro(`Data de vencimento não pode ser menor que a data de emissão.`)
      return false
    }
    const encontrouAlgumRegistroInvalido = duplicatas.some((duplicata) => {
      if (duplicata.possuiDescontoNaBaixa && parseFloat(dados.desconto) > 0) {
        msgErro(`Não é possível alterar o desconto programado quando já existem baixas com desconto.\nDuplicata: ${duplicata.numero}`)
        return true
      }

      if (duplicata.possuiJurosNaBaixa && parseFloat(dados.juros) > 0) {
        msgErro(`Não é possível alterar os juros programados quando já existem baixas com juros.\nDuplicata: ${duplicata.numero}`)
        return true
      }

      return false
    })

    return !encontrouAlgumRegistroInvalido
  }

  function retornaRegistrosSelecionados() {
    const tabela = $('#tabelaPagar').DataTable();
    const indicesSelecionados = [];

    tabela.rows().every(function (rowIdx, tableLoop, rowLoop) {
      const checkbox = $(this.node()).find('.checkPagar');
      if (checkbox.is(':checked')) {
        indicesSelecionados.push(rowIdx);
      }
    });

    return tabela.rows(indicesSelecionados).data();
  }

  function retornaAntecipacoesSelecionadas() {
    const tabela = $('#tabelaAntecipacoesABaixar').DataTable();
    const indicesSelecionados = [];

    tabela.rows().every(function (rowIdx, tableLoop, rowLoop) {
      const checkbox = $(this.node()).find('.campoCheckManual');
      if (checkbox.is(':checked')) {
        indicesSelecionados.push(rowIdx);
      }
    });

    return tabela.rows(indicesSelecionados).data();
  }

  function contemVariosFornecedores(data) {
    return new Set(data.map(item => item.CODCRE)).size > 1;
  }
});
