$(document).ready(async () => {
  const queryString = window.location.href;
  const parametros = queryString.split('/');
  const prioridadeProdutoMaterial = parametrosVenda[17] ?? '0';
  const parametrosPedido = await BuscaParametrosPedidoB2B();
  const permiteAlterarPreco = parametrosPedido[6].VALOR;
  const permiteConsultarClienteBloqueado = parametrosPedido[7].VALOR;
  const idUsuario = await retornaIDUsuario();
  let numeroAtendimentoPedido = parametros[parametros.length - 1];
  let pedido = await retornaDadosPedido();
  let corSelecionada;
  let estoquesSelecionados = [];
  let quantidadeEstoqueBase = [];
  let depositosMaisMix = await retornaDepositosMaisMix();
  let existePedidosGravadosNoAtendimento = false;

  navigator.geolocation.getCurrentPosition(async (position) => {
    sessionStorage.setItem('latitude', position.coords.latitude);
    sessionStorage.setItem('longitude', position.coords.longitude);
  });

  $("body").keydown(async function (e) {
    var keyCode = e.keyCode || e.which;
    if (keyCode == 116) {
      e.preventDefault();
      $("#btnInfo").trigger('click');
    }
    if (keyCode == 117) {
      e.preventDefault();
      $("#btnItens").trigger('click');
    }
    if (keyCode == 118) {
      e.preventDefault();
      $("#btnFinalizaPedido").trigger('click');
    }
  });

  $('#txtQtdeCoresTotal').inputmask('numeric', {
    min: 0,
    positionCaretOnClick: 'select',
    digits: 2,
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('#txtPercDescontoItens').inputmask('numeric', {
    min: 0,
    max: 99,
    positionCaretOnClick: 'select',
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('#txtPrecoItem').inputmask('numeric', {
    min: 0,
    max: 99,
    positionCaretOnClick: 'select',
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('#txtValorDescontoItem').inputmask('numeric', {
    min: 0,
    max: 99,
    positionCaretOnClick: 'select',
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('#txtPercDescontoItem').inputmask('numeric', {
    min: 0,
    max: 99,
    positionCaretOnClick: 'select',
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('#txtPrecoItemNovo').inputmask('numeric', {
    min: 0,
    positionCaretOnClick: 'select',
    digits: 2,
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $(`[name="selectFiltros"][value="${localStorage.getItem("@pedidob2b.selectFiltros") ?? '1'}"]`).click();

  $('[name="selectFiltros"]').on('change', function () {
    const valorSelecionado = $(this).val();
    localStorage.setItem("@pedidob2b.selectFiltros", valorSelecionado);
  });

  selectPadrao()

  async function salvarBackupPedido(objeto) {
    try {
      const empId = getCookie("emp_id");
      const hora = new Date()
        .toISOString()
        .slice(0, 19)
        .replaceAll("T", "_")
        .replaceAll(":", "");
      const response = await fetch(
        `../salvar_bkp.php?nome_arquivo=b2b_${objeto.numero}_${empId}_${hora}`,
        {
          method: "POST",
          body: `${JSON.stringify(objeto)}`,
        }
      );

      return response;
    } catch (error) {
      msgAlerta("Erro ao salvar dados digitados!");
    }
  }

  function selectPadrao() {
    $('#select2-selectFiltros-container').text(localStorage.getItem("@pedidob2b.selectFiltros") ?? 'DESCRICAO')
    $('#selectFiltros').val(localStorage.getItem("@pedidob2b.selectFiltros") ?? 'DESCRICAO')
  }

  if (prioridadeProdutoMaterial == '0') {
    $('#radioProduto').prop('checked', false);
    $('#radioProdutoPreco').prop('checked', false);
    $('#radioMaterial').prop('checked', true);
    $('#radioMaterialPreco').prop('checked', true);
    $('#radioProdutoPreco').trigger('change');
  } else {
    $('#radioMaterial').prop('checked', true);
    $('#radioMaterialPreco').prop('checked', true);
    $('#radioProdutoPreco').trigger('change');
  }

  $('#txtDescontoItens').inputmask('numeric', {
    min: 0,
    positionCaretOnClick: 'select',
    digits: 2,
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('.reacaoAtendimento').on('click', function () {
    $('.reacaoAtendimento').removeClass('selectedReacaoAtendimento');
    $(this).addClass('selectedReacaoAtendimento');
  });

  function msgConfirmacaoCancelarB2B($mensagem, $callbacks) {
    $("#modal-confirmacao-titulo").html("Atenção");
    $("#modal-confirmacao-conteudo").html($mensagem);
    if ($callbacks != undefined) {
      $("#modal-confirmacao-rodape").html(
        '<button title="Ao cancelar o atendimento, você perderá os dados que estão na tela." id="btn-cancelar-b2b" type="button" class="btn bg-gradient-danger btn-sisp">Cancelar Atendimento</button>' +
        '<button title="Desistir de cancelar o atendimento." type="button" class="btn bg-gradient-secondary btn-sisp" data-dismiss="modal">Voltar</button>'
      );
    }
    $("#modal-confirmacao").modal("show");
    $("#btn-cancelar-b2b").on("click", function () {
      if ($('#motivoSaida').val() == '') {
        $(".informeCancelamento").removeClass("d-none");
        return;
      }
      $(".informeCancelamento").addClass("d-none");
      $callbacks[0]();
      $("#modal-confirmacao").modal("hide");
      parent.removerTelaCheia();
      parent.document.querySelector('#abrirTelaCheia > i').classList.add('fa-expand');
      parent.document.querySelector('#abrirTelaCheia > i').classList.remove('fa-compress');
      parent.document.querySelector('#rodape').removeAttribute('style');
    });
    $("#btn-cfm-pendente").on("click", function () {
      $callbacks[1]();
      $("#modal-confirmacao").modal("hide");
    });
  }

  async function montaJsonPedido() {
    const arquivoPedido = await retornaDadosPedido();
    pedido = {
      ...pedido,
      cliente: {
        codCli: pegaChave('#txtCliente'),
        CNPJ_Consumidor: $('#txtCNPJ').val(),
        nome_Consumidor: pegaDescricao('#txtCliente'),
        limiteCredito: $('#txtLimiteCreditoCli').val() ?? 0,
        limiteCreditoDisponivel: $('#txtLimiteCreditoCliDisp').val() ?? 0,
        creditoGrupo: $('#txtLimiteCreditoConsignado').val() ?? 0,
        creditoGrupoDisponivel: $('#txtLimiteCreditoConsignadoDisp').val() ?? 0,
        classificacao: $('#txtClassificacaoCliente').val(),
        dadosAdicionais: {
          endereco: $('#txtEnderecoInfo').val(),
          barro: $('#txtBairroInfo').val(),
          cep: $('#txtCEPClienteInfo').val(),
          cidade: $('#txtCidadeEstadoInfo').val(),
          telefone: $('#txtTelefoneInfoCliente').val(),
        },
        // entrega: {}
      },
      vendedor: pegaChave('#txtVendedor'),
      designer: pegaChave('#txtDesigner'),
      nome_Vendedor: pegaDescricao('#txtVendedor'),
      responsavel: pegaChave('#txtResponsavel'),
      nome_responsavel: pegaDescricao('#txtResponsavel'),
      coordenador: pegaChave('#txtCoordenador'),
      nome_coordenador: pegaDescricao('#txtCoordenador'),
      formaContato: pegaChave('#txtFormaContato'),
      tabela: pegaChave('#txtTabela'),
      usuario: sessionStorage.getItem('g_usuario_logado'),
      observacao: $('#textDescricaoPedido').val() ? $('#textDescricaoPedido').val().toUpperCase() : '',
      data: `${formataData(new Date())}T00:00:00Z`,
      dataInicio: arquivoPedido ? arquivoPedido.dataInicio && arquivoPedido.dataInicio : `${formataDataCompleta(new Date())}`,
      latitude: sessionStorage.getItem('latitude'),
      longitude: sessionStorage.getItem('longitude'),
      numeroAtendimento: $('#txt_atendimento_atual').html(),
      itens: retornaItensPedido(),
      desistencias: retornaDesistencia(),
      datasPendentes: arquivoPedido ? arquivoPedido.datasPendentes && arquivoPedido.datasPendentes : [],
      statusPedido: arquivoPedido ? arquivoPedido.statusPedido && arquivoPedido.statusPedido : 'A',
      tempo: arquivoPedido ? arquivoPedido.tempo && arquivoPedido.tempo : '00:00:00',
      tiposPedidos: arquivoPedido ? separaItensPorTipo() : {
        programado: {},
        producao: {},
        pronta_entrega: {},
        mais_mix: {},
      },
    };
  }

  function retornaItensPedido() {
    const table = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const itens = table.map((data) => {
      const itens = {
        SITUACAO: data.SITUACAO,
        CODIGO: data.CODIGO,
        DESCRICAO: data.DESCRICAO,
        ACOES: data.ACOES,
        PRECO: data.PRECO,
        TIPO_ITEM: data.TIPO_ITEM,
        DATA: data.DATA,
        UNIDADE: data.UNIDADE,
        GRAMATURA: data.GRAMATURA,
        LARGURA: data.LARGURA,
        SITUACAO_CODIGO: data.SITUACAO_CODIGO,
        CORES: retornaCoresSelecionadas(data.CODIGO),
      };

      return itens;
    });

    return itens;
  }

  function retornaDesistencia() {
    const table = $('#tabelaDesistenciaItem').DataTable().rows().data()
      .toArray();
    const itens = table.map((data) => {
      const itens = {
        CODIGO: data.CODIGO,
        CODMEN: data.CODMEN,
        DESCRICAO: data.DESCRICAO,
      };

      return itens;
    });

    return itens;
  }

  function retornaCoresSelecionadas(codigo) {
    const data = $('#tabelaItensCompletos').DataTable().rows().data().toArray();

    const cores = data.filter((cor) => cor.CODIGO_ITEM == codigo);

    return cores;
  }

  async function retornaRepresentanteUsuario() {
    const pesquisaParam = {
      tabela: "ACESSO_USUARIOS",
      camposSelect: [
        `REPRESEN.CODREP`,
        'REPRESEN.NOME'
      ],
      leftJoin: [{ tabela: 'REPRESEN', condicao: 'ACESSO_USUARIOS.CODREP = REPRESEN.CODREP' }],
      where: [`CODIGO = '${getCookie('cod_usuario')}'`],

    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0]) return

    if (jsonStr.length == 1) {
      insereValor('#txtVendedor', jsonStr[0].CODREP, jsonStr[0].NOME);
      $('#txtVendedor').attr('disabled', true);
      $('#btn-Vendedor').attr('disabled', true);
      $('#btn-limpa-vendedor').attr('disabled', true);
      return;
    }
  }

  async function retornaVendendorResponsavel(codsdr) {
    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: [
        'CODREP',
        'NOME',
      ],
      where: [`CODSDR = '${codsdr}' AND ATIVO = 'S' `],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      await retornaRepresentanteUsuario();
      return;
    }

    $('#txtVendedor').unbind('autocompleta');
    $('#txtVendedor').autocompleta(1, `JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S' AND CODSDR = '${codsdr}'"] }`);
    $('#btn-Vendedor').off();
    $('#btn-Vendedor').unbind('pesquisa');
    $('#btn-Vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ATIVO = 'S' AND CODSDR = '${codsdr}'"] }`, 'Pesquisa Representante', 'represen');

    if (jsonStr.length == 1) {
      insereValor('#txtVendedor', jsonStr[0].CODREP, jsonStr[0].NOME);
      $('#txtVendedor').attr('disabled', true);
      $('#btn-Vendedor').attr('disabled', true);
      $('#btn-limpa-vendedor').attr('disabled', true);
      return;
    }

    $('#btn-Vendedor').trigger('click');
    return;
  }

  async function carregaDadosUsuario() {
    const pesquisaParam = {
      tabela: 'ACESSO_USUARIOS',
      camposSelect: [
        'PESSOAL.CODIGO',
        'PESSOAL.NOME NOME_FUNCIONARIO',
      ],
      leftJoin: [
        { tabela: 'PESSOAL', condicao: 'ACESSO_USUARIOS.CODFUN = PESSOAL.CODIGO' },
      ],
      where: [`ACESSO_USUARIOS.CODIGO = '${sessionStorage.getItem('cod_usuario')}'`],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODIGO != '') {
      insereValor('#txtResponsavel', jsonStr[0].CODIGO, jsonStr[0].NOME_FUNCIONARIO);
      $('#txtResponsavel').attr('disabled', true);
      $('#btn-Responsavel').attr('disabled', true);
      $('#btn-limpa-Responsavel').attr('disabled', true);

      await retornaVendendorResponsavel(jsonStr[0].CODIGO);
    }

    $('#txtVendedor').on('blur', async () => {
      const sCodRep = pegaChave('#txtVendedor');
      if (permiteConsultarClienteBloqueado == 0) {
        selectTxtCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S'`];
        selectBtnCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S'`];
      } else {
        selectTxtCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S' AND BLOQUEIO = 'N'`];
        selectBtnCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S' AND BLOQUEIO = 'N'`];
      }
      limpaValor('#txtCliente');
      $('#txtCliente').unbind('autocompleta');
      $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ'], carregaDadosClientes);
      $('#btn-cliente').off();
      $('#btn-cliente').unbind('pesquisa_serverside');
      $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], JSON.stringify(selectBtnCliente), 'Pesquisa Cliente', carregaDadosClientes);


      await retornaCooerdenador(sCodRep);
      if (sCodRep != '') {
        await verificaDeOndeCarregaTabelaDePreco();
      }
    });

    $('#txtVendedor').trigger('blur');
  }

  async function carregaDadosPedido() {
    try {
      $.LoadingOverlay('show');
      await carregaDadosUsuario();
      $('#txt_usuario_logado').text(sessionStorage.getItem('g_usuario_logado').toUpperCase());
      if (!pedido) {
        if ((numeroAtendimentoPedido == 'create') || (numeroAtendimentoPedido == 'create#')) {
          numeroAtendimentoPedido = await RetornaProximo('ATENDIMENTOSB2B', 'ATENDIMENTOSB2B', 'NUMERO_ATEND', 5)
          $('#txt_atendimento_atual').html(numeroAtendimentoPedido);
          window.history.pushState('', '', `${BASE_URI}/pedidosb2b/${numeroAtendimentoPedido}`);
        } else {
          $('#txt_atendimento_atual').html(numeroAtendimentoPedido);
        }
        await montaJsonPedido();
        await salvarArquivoPedido();
        await carregaDadosPedido();
        return;
      }
      const sTabela = pedido.tabela;
      const sVendedor = pedido.vendedor;
      const sCodCli = pedido.cliente.codCli;
      const sFormaContato = pedido.formaContato;
      const sResponsavel = pedido.responsavel;
      const sObservacao = pedido.observacao;

      if (pedido.numeroAtendimento == 'Novo') {
        pedido.numeroAtendimento = await RetornaProximo('ATENDIMENTOSB2B', 'ATENDIMENTOSB2B', 'NUMERO_ATEND', 5);
        $('#txt_atendimento_atual').html(pedido.numeroAtendimento);
      } else {
        $('#txt_atendimento_atual').html(pedido.numeroAtendimento);
      }

      mostraContador(pedido.dataInicio ? pedido.dataInicio : formataDataCompleta(new Data()));

      if (sCodCli != '') {
        await preencheDadosCliente(sCodCli);
        await carregaDadosClientes();
      }
      if (sTabela != '') {
        await preencheDadosTabelaPreco(sTabela);
      }
      if (sVendedor != '') {
        await preencheDadosVendedor(sVendedor);
      }
      if (sResponsavel != '') {
        await preencheDadosResponsavel(sResponsavel);
      }
      if (sFormaContato != '') {
        await preencheDadosFormaContato(sFormaContato);
      }

      if (sObservacao != '') {
        $('#textDescricaoPedido').val(sObservacao);
      }
      if (pedido.itens) {
        preencheItens(pedido.itens);
      }

      if (pedido.desistencias) {
        preencheDesistencia(pedido.desistencias);
      }

      $('#txtCliente').focus();
      //  aqui ve se da pra iniciar a tela direto nas ultimas abas ou apenas na aba informação
      if ((sTabela != '') && (sVendedor != '') && (sCodCli != '') && (sFormaContato != '') && (sResponsavel != '')) {
        if (($('#tabelaItensMesa').DataTable().rows().count() == 0) || (pedido.itens.filter((item) => item.CORES.length == 0 && item.SITUACAO_CODIGO == 'A'))) {
          $('#btnItens').trigger('click');
        } else {
          $('#btnFinalizaPedido').trigger('click');
        }
      }
      $('#txtVendedor').trigger('blur');
      $('#tabelaItensMesa').DataTable().columns.adjust().draw(false);
      await validaParametros();
      atualizaTotaisPedido();
      await montaJsonPedido();
      pedido.dtAbriu = formataDataCompleta(new Date());
      pedido.statusPedido = 'A';
      await salvarArquivoPedido();
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function carregaTabelaComercial() {
    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "REGIAO", 
              "camposSelect": ["REGIAO, DESCRICAO"],
              "where": ["TIPO_TABELA = 'C' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }

  async function carregaTabelaRepresentante() {
    const sCodRep = pedido.vendedor == '' ? pegaChave('#txtVendedor') : pedido.vendedor;

    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "REPRESEN", 
              "camposSelect": ["REPRESEN.REGIAO, REGIAO.DESCRICAO"],
              "leftJoin": [{"tabela": "REGIAO", "condicao": "REGIAO.REGIAO = REPRESEN.REGIAO"}], 
              "where": ["CODREP = '${sCodRep}' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }
  async function carregaTabelaCliente() {
    const sCodCli = pedido.cliente.codCli == '' ? pegaChave('#txtCliente') : pedido.cliente.codCli;

    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "ENTIDADE", 
              "camposSelect": ["ENTIDADE.TABELA, REGIAO.DESCRICAO"],
              "leftJoin": [{"tabela": "REGIAO", "condicao": "REGIAO.REGIAO = ENTIDADE.TABELA"}], 
              "where": ["CODCLI = '${sCodCli}' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }

  async function retornaIDUsuario() {
    const pesquisaParam = {
      tabela: 'ACESSO_USUARIOS',
      camposSelect: ['TIPO'],
      where: [`CODIGO = '${sessionStorage.getItem('cod_usuario')}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr;
  }

  function carregaTabelaPadraoParametro() {
    const tabelaPadrao = parametrosPedido[3].VALOR;
    if (tabelaPadrao == '') {
      msgAlerta('Tabela padrão não informada nos parametros, favor configurar os parametros');
      return
    }
    $('#txtTabela').val(tabelaPadrao)
  }

  async function verificaDeOndeCarregaTabelaDePreco() {
    const parametroCarregarTabelaDePreco = parametrosPedido[4].VALOR;

    if (parametroCarregarTabelaDePreco == 1) {
      await carregaTabelaRepresentante();
    }
    if (parametroCarregarTabelaDePreco == 2) {
      await carregaTabelaComercial();
    }
    if (parametroCarregarTabelaDePreco == 3) {
      await carregaTabelaCliente();
    }
    if (parametroCarregarTabelaDePreco == 4) {
      carregaTabelaPadraoParametro();
    }
  }

  function bloqueiaCamposTabela() {
    const parametroAlterarCampoTabelaPreco = parametrosPedido[2].VALOR;

    if (parametroAlterarCampoTabelaPreco == 0) {
      $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', true);
    } else if (parametroAlterarCampoTabelaPreco == 1) {
      $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', false);
    } else if (parametroAlterarCampoTabelaPreco == 2) {
      if (idUsuario[0].TIPO != 2) {
        $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', true);
      } else {
        $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', false);
      }
    }
  }

  function bloqueiaCamposVendedorResposavel() {
    const parametroBloquearAlterarVendedorResponsavel = parametrosPedido[1].VALOR;

    if (parametroBloquearAlterarVendedorResponsavel == 1) {
      $('#txtVendedor').attr('disabled', false);
      $('#btn-Vendedor').attr('disabled', false);
      $('#btn-limpa-vendedor').attr('disabled', false);
      $('#txtResponsavel').attr('disabled', false);
      $('#btn-Responsavel').attr('disabled', false);
      $('#btn-limpa-Responsavel').attr('disabled', false);
    }
  }

  async function validaParametros() {
    const sTabela = pedido.tabela;
    if (sTabela == '') {
      await verificaDeOndeCarregaTabelaDePreco();
    }
    bloqueiaCamposVendedorResposavel();

    if (pegaChave('#txtTabela') != '') {
      bloqueiaCamposTabela();
    }
  }

  async function retornaDepositosMaisMix() {
    const pesquisaParam = {
      tabela: 'DEPOSITO',
      camposSelect: ['CODIGO'],
      where: [`GERA_OC_PEDIDO = 'S'`]
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr.map(objeto => objeto.CODIGO).join(',');

  }

  async function retornaDadosPedido() {
    if ((numeroAtendimentoPedido != 'create') && (numeroAtendimentoPedido != 'create#')) {
      if (!await verificaAtendimentoGravados()) {
        const hostname = `JsonPedido-${numeroAtendimentoPedido}`;
        const resp = await carregaPedidoNaoSalvo(hostname);

        if (resp.status != 200) {
          return;
        }

        const jsonStr = await resp.json();

        return jsonStr;
      }
      toastr.success(
        'Atendimento já finalizado. Redirecionando para novo atendimento.',
        'Confirmação',
        {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 1800,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/pedidosb2b/create`;
          },
        },
      ).css({
        'margin-top': '20%',
        width: '500px',
        'max-width': '500px',
      });
    }
  }

  async function salvarArquivoPedido() {
    try {
      const response = await fetch(`../salvar_arquivo.php?tipo=JsonPedido&num_atendimento=${pedido.numeroAtendimento}`, {
        method: 'POST',
        body: `${JSON.stringify(pedido)}`,
      });
      return response;
    } catch (error) {
      msgAlerta('Erro ao salvar dados digitados!');
    }
  }

  async function deletaDadosNaoSalvos(sNomeMaquina) {
    let response;
    try {
      response = await fetch(`${BASE_URI}/deletar_arquivo.php?nomedoarquivo=${sNomeMaquina}`, {
        method: 'GET',
        body: null,
      });
    } catch (error) {
      return;
    }
    return response;
  }

  async function carregaPedidoNaoSalvo(sNomeMaquina) {
    let response;
    const myHeaders = new Headers();
    myHeaders.append('pragma', 'no-cache');
    myHeaders.append('cache-control', 'no-cache');
    try {
      response = await fetch(`../${sNomeMaquina}.txt`, {
        headers: myHeaders,
        method: 'GET',
        body: null,
      });
    } catch (error) {
      return;
    }
    return response;
  }

  async function preencheDadosVendedor(sCodRep) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "represen", "camposSelect": ["nome"], "where": ["codrep = '${sCodRep}' "] }`);
      const nome = jsonStr[0].NOME;
      $('#txtVendedor').val(`[${sCodRep}] - ${nome}`);
      $('#txtVendedor').attr('data-selecionado', true);

      await retornaCooerdenador(sCodRep);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do vendedor.');
    }
  }

  async function retornaCooerdenador(sCodRep) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "represen", "camposSelect": ["PESSOAL.CODIGO, PESSOAL.NOME"], "leftJoin": [{"tabela": "PESSOAL", "condicao": "PESSOAL.CODIGO = REPRESEN.COORDENADOR"}], "where": ["REPRESEN.CODREP = '${sCodRep}' "] }`);
      if (jsonStr.length > 0) {
        $('#txtCoordenador').val(`[${jsonStr[0].CODIGO}] - ${jsonStr[0].NOME}`);
        $('#txtCoordenador').attr('data-selecionado', true);
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do coordenador.');
    }
  }

  async function preencheDadosResponsavel(sCodResponsavel) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "PESSOAL", "camposSelect": ["NOME"], "where": ["CODIGO = '${sCodResponsavel}' "] }`);
      const nome = jsonStr[0].NOME;
      $('#txtResponsavel').val(`[${sCodResponsavel}] - ${nome}`);
      $('#txtResponsavel').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do responsável.');
    }
  }

  async function preencheDadosFormaContato(sCodFormaContato) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO_CONTATO", "camposSelect": ["DESCRICAO"], "where": ["CODIGO = '${sCodFormaContato}' "] }`);
      const nome = jsonStr[0].DESCRICAO;
      $('#txtFormaContato').val(`[${sCodFormaContato}] - ${nome}`);
      $('#txtFormaContato').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados da forma de contato.');
    }
  }

  async function preencheDadosCliente(sCodCli) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "ENTIDADE", "camposSelect": ["nome","cnpj"], "where": ["codcli = '${sCodCli}' "] }`);
      const nome = jsonStr[0].NOME;
      const cnpj = jsonStr[0].CNPJ;
      insereValor('#txtCliente', sCodCli, nome)
      $('#txtCNPJ').val(cnpj);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do cliente.');
    }
  }

  async function preencheDadosTabelaPreco(sTabela) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "REGIAO", "camposSelect": ["DESCRICAO"], "where": ["REGIAO = '${sTabela}' "] }`);
      const tabela = jsonStr[0].DESCRICAO;
      $('#txtTabela').val(`[${sTabela}] - ${tabela}`);
      $('#txtTabela').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados da tabela.');
    }
  }

  function adicionaItensPedido(itens, tabelaCompleta = false) {
    const tabela = tabelaCompleta ? '#tabelaItensCompletos' : '#tabelaItensMesa';
    $(tabela).DataTable().row.add(itens).draw(false);
    const $scrollBody = $($(tabela).DataTable().table().node()).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  }

  function adicionaLinhaTabela(dados, tabela) {
    $(tabela).DataTable().row.add(dados).draw(false);
  }

  function preencheItens(itens) {
    itens.forEach((item) => {
      adicionaItensPedido(item);
      if (item.CORES.length > 0) {
        item.CORES.forEach((cor) => {
          adicionaItensPedido(cor, true);
        });
      }
    });
  }

  function preencheDesistencia(itens) {
    itens.forEach((item) => {
      adicionaLinhaTabela(item, '#tabelaDesistenciaItem');
    });
  }

  async function carregaSaldoCreditoCliente(codcli) {
    try {
      const pesquisaParam = {
        tabela: 'RECEBER',
        camposSelect: ['sum(VALOR) VALOR'],
        where: [`STATUS = 'ANTE' AND CODCLI = '${codcli}'`]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      $('#credito_cliente_saldo').html(jsonStr[0].VALOR);

    } catch (error) {
      console.error(error)
    }
  }

  async function carregaDadosInformativos(codcli) {
    try {
      const url = '/sisplan/pedidob2b/v1/informativos?';

      const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');

      const json = await response.json();
      const valorInformativos = {
        titulosAVencer: json.titulosAVencer ? json.titulosAVencer.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        titulosVencidos: json.titulosVencidos ? json.titulosVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoGrupoAVencer: json.creditoGrupoAVencer ? json.creditoGrupoAVencer.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoGrupoVencidos: json.creditoGrupoVencidos ? json.creditoGrupoVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoEmAberto: json.creditoEmAberto ? json.creditoEmAberto.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        chequesAVencer: json.chequesAVencer ? json.chequesAVencer.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        chequesVencidos: json.chequesVencidos ? json.chequesVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        pendenteAFaturar: json.pendenteAFaturar ? TruncaDecimaisNova(2, json.pendenteAFaturar.reduce((total, titulo) => total + titulo.saldo, 0)) : 0,
      }
      const credito = parseFloat($('#txtLimiteCreditoCli').val());
      const creditoDisp = TruncaDecimaisNova(2, credito + valorInformativos.creditoEmAberto - (valorInformativos.titulosAVencer + valorInformativos.titulosVencidos + valorInformativos.creditoGrupoAVencer + valorInformativos.creditoGrupoVencidos + valorInformativos.pendenteAFaturar + valorInformativos.chequesVencidos + valorInformativos.chequesAVencer))
      const creditoGrupoDisp = TruncaDecimaisNova(2, parseFloat($('#txtLimiteCreditoConsignado').val()) - valorInformativos.creditoGrupoVencidos)
      $('#txt_titulos_vencer').html(formataEmReais(valorInformativos.titulosAVencer));
      $('#txt_titulos_vencidos').html(formataEmReais(valorInformativos.titulosVencidos));
      $('#txt_titulosGrupo_vencer').html(formataEmReais(valorInformativos.creditoGrupoAVencer));
      $('#txt_titulosGrupo_vencidos').html(formataEmReais(valorInformativos.creditoGrupoVencidos));
      $('#txt_credito_antecipacao').html(formataEmReais(valorInformativos.creditoEmAberto));
      $('#txt_cheques_vencer').html(formataEmReais(valorInformativos.chequesAVencer));
      $('#txt_cheques_vencidos').html(formataEmReais(valorInformativos.chequesVencidos));
      $('#txt_pedidos_pendentes').html(formataEmReais(valorInformativos.pendenteAFaturar));
      $('#txtLimiteCreditoCliDispDisp').val(creditoDisp);
      $('#txtLimiteCreditoConsignadoDisp').val(creditoGrupoDisp);

      $('.collapseInformativos').trigger('click');


    } catch (error) {
      console.error(error)
    }
  }

  $('.collapsePedidos').on('click', function () {
    if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
      $($(this).find('i')[0]).removeClass('fa-angle-down');
      $($(this).find('i')[0]).addClass('fa-angle-right');
    } else {
      $($(this).find('i')[0]).removeClass('fa-angle-right');
      $($(this).find('i')[0]).addClass('fa-angle-down');
    }
  });

  $('.collapseEnderecoEntregas').on('click', function () {
    if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
      $($(this).find('i')[0]).removeClass('fa-angle-down');
      $($(this).find('i')[0]).addClass('fa-angle-right');
    } else {
      $($(this).find('i')[0]).removeClass('fa-angle-right');
      $($(this).find('i')[0]).addClass('fa-angle-down');
    }
  });

  $('.collapseInformativos').on('click', function () {
    if ($('.mostrarMaisInformativo').html().includes('Mostrar Mais')) {
      $('.mostrarMaisInformativo').html('Mostrar Menos <i class="fas fa-angle-up"></i>')
    } else {
      $('.mostrarMaisInformativo').html('Mostrar Mais <i class="fas fa-angle-down"></i>')
    }
  });

  // $('#btn-mostrar-informativos').on('click', function () {
  //   if ($('.mostrarMaisInformativo').html().include('Mostrar Menos')) {
  //     $('.mostrarMaisInformativo').html('Mostrar Menos <i class="fas fa-angle-up"></i>')
  //   } else {
  //     $('.mostrarMaisInformativo').html('Mostrar Mais <i class="fas fa-angle-down"></i>')
  //   }
  // })

  async function carregaDadosClientes() {
    setTimeout(async () => {
      const url = '/sisplan/funcoes/v1/pesquisa?';
      const sCodCli = pegaChave('#txtCliente');

      if ((!sCodCli) && (sCodCli == '')) {
        return;
      }

      try {
        const response = await requisicao('GET', url, encodeURIComponent(
          `JSON={ 
            "tabela":"entidade", 
            "camposSelect":["ENTIDADE.CLASSIFICA, ENTIDADE.CREDITO, ENTIDADE.BAIRRO, ENTIDADE.CEP, ENTIDADE.ENDERECO, ENTIDADE.TELEFONE, ENTIDADE.COD_PAIS, ENTIDADE.NUMERO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
            "leftJoin": [
              {"tabela" : "receber", "condicao" : "entidade.codcli = receber.codcli AND RECEBER.STATUS = 'DUPL' AND receber.HISTORICO IN (SELECT HISTCP1.HISTORICO FROM HISTCP_001 HISTCP1 WHERE HISTCP1.LIMITE_CREDITO = 'S')"},
              {"tabela" : "histcp", "condicao" : "entidade.historico = histcp.historico"}
            ],
            "where": ["ENTIDADE.CODCLI = '${sCodCli}'"], 
            "groupBy": ["ENTIDADE.CLASSIFICA, ENTIDADE.CREDITO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO, ENTIDADE.BAIRRO, ENTIDADE.CEP, ENTIDADE.ENDERECO, ENTIDADE.TELEFONE, ENTIDADE.COD_PAIS, ENTIDADE.NUMERO"]
          }`,
        ), null);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $('#txtTelefoneInfoCliente').val(jsonStr.RESULT[0][0].TELEFONE);
        $('#txtCEPClienteInfo').val(jsonStr.RESULT[0][0].CEP);
        $('#txtBairroInfo').val(jsonStr.RESULT[0][0].BAIRRO);
        $('#txtEnderecoInfo').val(jsonStr.RESULT[0][0].ENDERECO);
        $('#txtCidadeEstadoInfo').val(await BuscaCep(jsonStr.RESULT[0][0].CEP));
        $('#txtClassificacaoCliente').val(jsonStr.RESULT[0][0].CLASSIFICA);


        carregaLimiteCredito(jsonStr.RESULT[0][0]);
        carregaSaldoCreditoCliente(sCodCli);

        if (parametrosPedido[0].VALOR == 1) {
          // await carregaDuplicatas(sCodCli, 'S');
        }
        await carregaDadosInformativos(sCodCli);

      } catch (error) {
        console.error(error);
        $('#txtLimiteCreditoCli').val(0);
        $('#txtLimiteCreditoConsignado').val(0);
      }
    }, 1000)
  }

  async function carregaLimiteCredito(dados) {
    if (!dados) {
      $('#txtLimiteCreditoCli').val(0);
      $('#txtLimiteCreditoConsignado').val(0);
      return;
    }

    let credConsig = dados.CREDITO_GRUPO == 'S' ? dados.CRED_CONSIGNADO - dados.ABERTO : dados.CRED_CONSIGNADO;

    // credConsig = ((dados.CREDITO != 0) && ((dados.CREDITO - dados.ABERTO) < credConsig)) ? dados.CREDITO - dados.ABERTO : credConsig;
    // credConsig = (dados.CREDITO == 0) ? dados.CREDITO : credConsig;

    if (dados.CREDITO == 0) {
      $('#txtLimiteCreditoCli').val(0);
      if (dados.CRED_CONSIGNADO == 0) {
        $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
        return;
      }
      $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));

      return;
    }
    $('#txtLimiteCreditoCli').val(parseFloat(dados.CREDITO).toFixed(2));

    if (dados.CRED_CONSIGNADO == 0) {
      $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
    } else {
      // $('#txtLimiteCreditoConsignadoDisp').val(parseFloat(dados.CRED_CONSIGNADO - dados.ABERTO).toFixed(2));
      $('#txtLimiteCreditoConsignado').val(parseFloat(dados.CRED_CONSIGNADO).toFixed(2));
    }
  }

  function retornaWhere(campo, valor) {
    const tipoConsulta = localStorage.getItem('@pedido.rgPesquisaTipo') ?? '1';

    const valorSeparado = valor.split(' ');
    const efetuaConsulta = {
      0: () => `${campo} LIKE ('${valor}[PERCENTUAL]')`,
      1: () => `(${valorSeparado.map((valor, i) => `${campo} LIKE ('[PERCENTUAL]${valorSeparado[i]}[PERCENTUAL]')`).toString().replaceAll(',', ' AND ')})`,
      2: () => `${campo} LIKE ('[PERCENTUAL]${valor}[PERCENTUAL]') `,
      3: () => `${campo} = ('${valor}') `,
    };
    return efetuaConsulta[tipoConsulta]();
  }

  async function montaSelectItens(bPesquisandoProduto) {
    const CampoConsulta = $('#txtCampoConsulta').val();
    const TabelaDePreco = pegaChave('#txtTabela');
    const tabelaEstoque = bPesquisandoProduto ? '"PRODUTO"' : '"MATERIAL"';
    let ligacaoTabelaPreco = '';
    const ligacaoGrupoMat = '';

    if (bPesquisandoProduto) {
      ligacaoTabelaPreco = ` {"tabela": "TABPRECO", "condicao": "TABPRECO.CODIGO = PRODUTO.CODIGO AND REGIAO = '${TabelaDePreco}'"}`;
    } else {
      ligacaoTabelaPreco = ` {"tabela": "TABPRECO", "condicao": " TABPRECO.CODIGO = MATERIAL.CODIGO AND REGIAO = '${TabelaDePreco}'"}`;
    }
    const camposSelect = bPesquisandoProduto ? '["PRODUTO.CODIGO, PRODUTO.DESCRICAO, TABPRECO.PRECO_00", "\'P\' TIPO"]'
      : '["MATERIAL.CODIGO, MATERIAL.DESCRICAO, MATERIAL.UNIDADE, TABPRECO.PRECO_00, MATERIAL.GRAMATURA, MATERIAL.LARGURA", "\'M\' TIPO"]';

    const camposWhereServerSide = bPesquisandoProduto ? '["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2"]'
      : '["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MATERIAL.CODIGO2"]';

    let Where = '';
    let orderby;

    if (bPesquisandoProduto) {
      Where += ' PRODUTO.ATIVO = \'S\'';
    } else {
      Where += ' MATERIAL.ATIVO = \'S\'';
    }

    if (CampoConsulta != '') {
      if (bPesquisandoProduto) {
        switch ($('#selectFiltros').val()) {
          case 'CODIGO':
            Where += ` ${retornaWhere('PRODUTO.CODIGO', CampoConsulta)}`;
            orderby = 'AND PRODUTO.CODIGO';
            break;
          case 'CODIGO2':
            Where += ` AND ${retornaWhere('PRODUTO.CODIGO2', CampoConsulta.toUpperCase())}`;
            orderby = 'PRODUTO.CODIGO2';
            break;
          case 'DESCRICAO':
            Where += ` AND ${retornaWhere('UPPER(PRODUTO.DESCRICAO)', CampoConsulta.toUpperCase())}`;
            orderby = 'PRODUTO.DESCRICAO';
            break;
          default:
            break;
        }
      } else {
        switch ($('#selectFiltros').val()) {
          case 'CODIGO':
            Where += ` AND ${retornaWhere('MATERIAL.CODIGO', CampoConsulta)}`;
            orderby = ' MATERIAL.CODIGO';
            break;
          case 'CODIGO2':
            Where += ` AND ${retornaWhere('MATERIAL.CODIGO2', CampoConsulta)}`;
            orderby = 'MATERIAL.CODIGO2';
            break;
          case 'DESCRICAO':
            Where += ` AND ${retornaWhere('UPPER(MATERIAL.DESCRICAO)', CampoConsulta.toUpperCase())}`;
            orderby = 'MATERIAL.DESCRICAO';
            break;
          default:
            break;
        }
      }
    } else if (bPesquisandoProduto) {
      switch ($('#selectFiltros').val()) {
        case 'CODIGO':
          orderby = 'PRODUTO.CODIGO';
          break;
        case 'CODIGO2':
          orderby = 'PRODUTO.CODIGO2';
          break;
        case 'DESCRICAO':
          orderby = 'PRODUTO.DESCRICAO';
          break;
      }
    } else {
      switch ($('#selectFiltros').val()) {
        case 'CODIGO':
          orderby = 'MATERIAL.CODIGO';
          break;
        case 'CODIGO2':
          orderby = 'MATERIAL.CODIGO2';
          break;
        case 'DESCRICAO':
          orderby = 'MATERIAL.DESCRICAO';
        default:
          break;
      }
    }

    const ajaxData = {
      EMPRESA: getCookie('empresa'),
      JSON: encodeURIComponent(`{"tabela":${tabelaEstoque}, "camposWhereServerSide": ${camposWhereServerSide}, "camposSelect": ${camposSelect}, "leftJoin": [${ligacaoTabelaPreco}], "where": ["${Where}"], "orderby": ["${orderby}"]}`),
      CLIENTE: 'N',
    };

    return ajaxData;
  }

  async function RotinaCliqueFinalizaPedido() {
    $('#btnItens').prop('disabled', false);
    $('#btnInfo').prop('disabled', false);
    $('#btnFinalizaPedido').prop('disabled', true);
    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_finalizaPedido)).addClass('active');
    fs_finalizaPedido.show();
    fs_produtos.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_produtos.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          display: 'none',
          position: 'relative',
        });

        fs_finalizaPedido.css({
          opacity,
        });
      },
      duration: 100,
    });

    $('#painelValorParcela').removeClass('col-sm-6');
    $('#painelValorParcela').addClass('col-sm-4');
    $('#PainelDesconto').removeClass('col-sm-6');
    $('#PainelDesconto').addClass('col-sm-4');
    $('#painelValorLiquido').removeClass('col-sm-6');
    $('#painelValorLiquido').addClass('col-sm-4');
  }

  function RotinaCliqueItens() {
    $('#btnItens').prop('disabled', true);
    $('#btnInfo').prop('disabled', false);
    $('#btnFinalizaPedido').prop('disabled', false);

    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_produtos)).addClass('active');
    fs_produtos.show();
    fs_info.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_finalizaPedido.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          display: 'none',
          position: 'relative',
        });

        fs_produtos.css({
          opacity,
        });
      },
      duration: 100,
    });

    $('#tabelaItensMesa').DataTable().columns.adjust().draw(false);
    atualizaTotaisPedido();
  }

  function RotinaCliqueInfo() {
    $('#btnItens').prop('disabled', false);

    if (existePedidosGravadosNoAtendimento) {
      $('#btnItens').prop('disabled', true);
    } else {
      $('#btnItens').prop('disabled', false);
    }
    $('#btnInfo').prop('disabled', true);
    $('#btnFinalizaPedido').prop('disabled', false);

    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_info)).addClass('active');
    fs_info.show();
    fs_finalizaPedido.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_produtos.css({
          display: 'none',
          position: 'relative',
        });

        fs_finalizaPedido.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          opacity,
        });
      },
      duration: 100,
    });
    $('#txtResponsavel').focus();
  }


  async function consultaDupAberto(codcli, todasEmpresas) {
    let data = new Date();
    let vAVencer = 0;
    let vVencido = 0;
    let vAnteci = 0;
    let vCheqD = 0;
    let vAberto = 0;

    data = `${data.getUTCFullYear()}-${String(
      data.getUTCMonth() + 1
    ).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`;

    const jsonStr = await buscaDuplicatasEmAberto(codcli, todasEmpresas);

    if (!jsonStr || jsonStr.length == 0) {
      return;
    }

    $("#tabela-duplicatas").DataTable().rows().remove().draw(false);

    $("#tabela-duplicatas").DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      scrollY: "300px",
      autowidth: true,
    });

    for (let i = 0; i < jsonStr.length; i++) {
      $("#tabela-duplicatas")
        .DataTable()
        .row.add([
          jsonStr[i].NUMERO,
          `${jsonStr[i].DT_EMISSAO.split("-")[2]}/${jsonStr[i].DT_EMISSAO.split("-")[1]
          }/${jsonStr[i].DT_EMISSAO.split("-")[0]}`,
          `${jsonStr[i].DT_VENCTO.split("-")[2]}/${jsonStr[i].DT_VENCTO.split("-")[1]
          }/${jsonStr[i].DT_VENCTO.split("-")[0]}`,
          jsonStr[i].STATUS,
          jsonStr[i].SALDO,
          jsonStr[i].EMP.replace("_", ""),
        ])
        .draw(false);
      if ((jsonStr[i].DT_VENCTO <= data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
        vVencido = parseFloat(vVencido) + parseFloat(jsonStr[i].SALDO);
      } else if ((jsonStr[i].DT_VENCTO > data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
        vAVencer = parseFloat(vAVencer) + parseFloat(jsonStr[i].SALDO);
      } else if (['ANTE'].includes(jsonStr[i].STATUS)) {
        vAnteci = parseFloat(vAnteci) + parseFloat(jsonStr[i].SALDO);
      } else if (['CHDE'].includes(jsonStr[i].STATUS)) {
        vCheqD = parseFloat(vCheqD) + parseFloat(jsonStr[i].SALDO);
      }
    }

    vAberto = parseFloat(vVencido) + parseFloat(vAVencer) + parseFloat(vCheqD) - parseFloat(vAnteci);
    $("#txtValDupVencer").html(vAVencer.toFixed(2));
    $("#txtValDupVencida").html(vVencido.toFixed(2));
    $("#txtValAntec").html(vAnteci.toFixed(2));
    $("#txtValChequeDevol").html(vCheqD.toFixed(2));
    $("#txtValTotAberto").html(vAberto.toFixed(2));
    $("#txtValDupVencida").css("color", "red");
    $("#txtValAntec").css("color", "green");
    $("#txtValChequeDevol").css("color", "purple");

    setTimeout(() => {
      $("#tabela-duplicatas").DataTable().columns.adjust().draw(false);
    }, 200);
  };

  function retornaDiferencaDatasPendentes() {
    if (pedido.datasPendentes.length > 0) {
      const soma = pedido.datasPendentes.reduce((acumulador, data) => {
        const diferenca = Math.abs(new Date(formatarData(data.fim))) - Math.abs(new Date(formatarData(data.inicio)));
        return acumulador + diferenca;
      }, 0);

      return soma
    }

    return 0;

  }

  function mostraContador(dataInicioPedido) {
    const dataAtual = new Date();
    const dataInicio = new Date(dataInicioPedido);
    const somaPendentes = retornaDiferencaDatasPendentes();
    const diffEmMilissegundos = Math.abs(dataAtual - dataInicio) - somaPendentes;
    const diffEmSegundos = Math.floor(diffEmMilissegundos / 1000);

    iniciarContador(diffEmSegundos);
  }

  function atualizarRelogio(tempoTotal) {
    const segundos = tempoTotal % 60;
    const minutos = Math.floor(tempoTotal / 60) % 60;
    const horas = Math.floor(tempoTotal / 3600);
    const segundosStr = segundos.toString().padStart(2, '0');
    const minutosStr = minutos.toString().padStart(2, '0');
    const horasStr = horas.toString().padStart(2, '0');

    $('#txtContador').val(`${horasStr}:${minutosStr}:${segundosStr}`);
  }

  function iniciarContador(tempoTotal) {
    const intervalo = setInterval(() => {
      tempoTotal++;
      atualizarRelogio(tempoTotal);
    }, 1000);
  }

  async function BuscaCep(cep) {
    try {
      const response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"CADCEP", "camposSelect":["CIDADE.NOME CIDADE", "CIDADE.COD_UF UF"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": ["CADCEP.cep = '${cep}'"]}`,
        null,
      );
      if (!response) {
        var cidade = '';
        var uf = '';
      } else {
        const jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay('hide');
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        return `${jsonStr.RESULT[0][0].CIDADE} / ${jsonStr.RESULT[0][0].UF}`;
      }
    } catch (error) {
      var cidade = '';
      var uf = '';
    }
    return [cidade, uf];
  }

  async function retornaBotaoOpcoes() {
    return (/* html */`
      <div style="text-align:center;"> 
        <div class="dropdown"> 
          <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          </button> 
          <div class="dropdown-menu"> 
            <!-- <a class="dropdown-item btnInfoAdc" href="">Informações adicionais</a> -->
            <!-- <div class="dropdown-divider"></div> -->
            <a class="dropdown-item btnDesistir">Desistir</a> 
            <div class="dropdown-divider"></div>
            <a class="dropdown-item btn-imprimir-estoque">Imprimir Estoque</a> 
            <!-- <div class="dropdown-divider"></div> -->
            <!-- <a class="dropdown-item btn-imprimir-ft">Imprimir FT</a>  -->
            <!-- <div class="dropdown-divider"></div> -->
          </div>
        </div>
      </div>
    `);
  }

  function retornaBotaoOpcoesSelecionarCor() {
    return (/* html */`
        <div style="text-align:center;"> 
          <button class="btn btn-info btn-sm btnOpcoesCorSelecionada" type="button" aria-haspopup="true" aria-expanded="false">
            Opções
          </button> 
        </div>
    `);
  }



  function atualizaTotaisPedido() {
    const data = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const totalItensMesa = $('#tabelaItensMesa').DataTable().rows().count();
    const totalCarrinho = $('#tabelaItensCompletos').DataTable().rows().count();
    const itensFechados = data.filter((item) => item.SITUACAO_CODIGO == 'F').length;
    const itensAtendidos = data.filter((item) => item.SITUACAO_CODIGO != 'A').length ?? 0;
    const itensDesistidos = data.filter((item) => item.SITUACAO_CODIGO == 'D').length;
    const subtotal_Pedido = $('#tabelaItensCompletos').DataTable().column(7, {}).data().sum();
    const descontos = $('#tabelaItensCompletos').DataTable().column(3, {}).data().sum();
    const credito_cliente_saldo = isNaN(Number($('#credito_cliente_saldo').html())) ? 0 : Number($('#credito_cliente_saldo').html());

    $('#comparativoVenda').html(itensFechados);
    $('#comparativoAtendido').html(`${itensAtendidos ?? 0}/${totalItensMesa}`);
    $('#comparativoAproveitamento').html(TruncaDecimaisNova(2, (100 / totalItensMesa) * itensFechados));
    $('#total_itensQuantidades').html(totalCarrinho);
    $('#total_itensCarrinhos').html(totalCarrinho);
    $('#subtotal_Pedido').html(formataEmReais(subtotal_Pedido));
    $('#total_desc').html(formataEmReais(descontos));
    $('#total_orig').html(formataEmReais(subtotal_Pedido));
    $('#saldo_geral').html(formataEmReais(credito_cliente_saldo - Number(subtotal_Pedido)));
  }

  function separaItensPorDeposito(depositos, itens, tipos) {
    depositos.forEach(deposito => {
      const item = itens.filter(item => item.deposito === deposito).map(item => item);
      tipos.pronta_entrega[deposito] = {
        ...tipos.pronta_entrega[deposito],
        itens: item.filter((item) => !depositosMaisMix.includes(item.deposito) && !item.ordem_compra && item.itemBase == '')
      }
      tipos.programado[deposito] = {
        ...tipos.programado[deposito],
        itens: item.filter((item) => item.ordem_compra)
      }
      tipos.producao[deposito] = {
        ...tipos.producao[deposito],
        itens: item.filter((item) => item.itemBase != '')
      }
      tipos.mais_mix[deposito] = {
        ...tipos.mais_mix[deposito],
        itens: item.filter((item) => depositosMaisMix.includes(item.deposito))
      }
    });
  }

  function separaItensPorTipo() {
    var tipos = {
      programado: pedido.tiposPedidos.programado,
      producao: pedido.tiposPedidos.producao,
      pronta_entrega: pedido.tiposPedidos.pronta_entrega,
      mais_mix: pedido.tiposPedidos.mais_mix,
    }
    const itens = $('#tabelaItensCompletos').DataTable().rows().data()
      .toArray()
      .map((item) => ({
        codigo: item.CODIGO_ITEM,
        cor: item.COR,
        tam: 0,
        qtde: item.QTDE,
        qtde_orig: item.QTDE,
        preco: item.PRECO,
        preco_orig: item.PRECO_ORIG,
        qtde_orig: item.QTDE_ORIG,
        desc_item: item.VALOR_DESC,
        perc_comissao: item.PERC_COMISSAO,
        preco_com: item.PRECO_COM,
        tipo: 'M',
        deposito: item.ESTOQUE,
        ordem: 1,
        ordem_compra: item.ORDEM_COMPRA,
        itemBase: item.CODIGO_BASE,
        comando: item.CODIGO_ITEM
      }));

    const depositos = [...new Set(itens.map(item => item.deposito))];

    separaItensPorDeposito(depositos, itens, tipos);

    return tipos
  }

  async function selecionaEmpresaDemo() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_DEMO'],
      where: [`EMP_ID = '${getCookie('emp_id')}'`],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr;
  }

  // async function adicionaEnderecoEnt() {
  //   const codcli = pedido.cliente.codCli;

  //   const pesquisaParam = {
  //     tabela: 'ENTIDADE',
  //     camposSelect: ['CEP_ENT', 'END_ENT', 'NUM_ENT', 'COMP_ENT', 'BAIRRO_ENT'],
  //     where: [`CODCLI = '${codcli}'`],
  //   };
  //   const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  //   jsonStr.map((emp) => {
  //     $(`#selectEndEntrega-${tipo}-${deposito}`).append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, empDemo ? empDemo[0].EMP_DEMO : emp.EMP_PAT == getCookie('empresa')));
  //   });
  //   $(`#selectEndEntrega-${tipo}-${deposito}`).val(empDemo[0].EMP_DEMO.replace('_', '')).change();
  // }

  async function adicionaEmpresas(tipo, deposito) {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    empDemo = await selecionaEmpresaDemo();
    jsonStr.map((emp) => {
      $(`#selectEmpFaturamento-${tipo}-${deposito}`).append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, empDemo ? empDemo[0].EMP_DEMO : emp.EMP_PAT == getCookie('empresa')));
    });
    $(`#selectEmpFaturamento-${tipo}-${deposito}`).val(empDemo[0].EMP_DEMO.replace('_', '')).change();
  }

  function desabilitaCamposFinalizaPedido(tipo, deposito) {
    $(`#selectEmpFaturamento-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtGrupoPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtStatusPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtTransportadora-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtTipoPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtOperacaoFiscal-${tipo}-${deposito}`).attr('disabled', true);
    $(`#textDescricaoPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#selectFrete-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtFrete-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtMoeda-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtEntradaPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtSaldoPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtCondEspecial-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtDtVencimentoParcela-${tipo}-${deposito}`).attr('disabled', true);
    $(`#btnGravarPedido-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtCondPagamento-${tipo}-${deposito}`).attr('disabled', true);
    $(`#txtDesigner-${tipo}-${deposito}`).attr('disabled', true);

    $(`#finalizarPedido-${tipo}-${deposito} .collapsePedidos`).trigger('click');
  }

  async function verificaPedidosGravados(tipo, deposito) {
    const pedidoGravado = await retornaJsonPesquisaPadrao(`{"tabela": "PEDIDO", "camposSelect": ["NUMERO"], "where": ["NUMERO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero}'"] }`);
    existePedidosGravadosNoAtendimento = pedidoGravado.length > 0
    return pedidoGravado.length > 0;
  }

  async function verificaAtendimentoGravados() {
    const atendimentoGravado = await retornaJsonPesquisaPadrao(`{"tabela": "ATENDIMENTOSB2B", "camposSelect": ["NUMERO_ATEND"], "where": ["NUMERO_ATEND = '${numeroAtendimentoPedido}' AND STATUS = 'F'"] }`);
    return atendimentoGravado.length > 0;
  }

  async function carregaInformacaoPedidoGravado(tipo, deposito) {
    try {
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].grupo != '') {
        const grupo = await retornaJsonPesquisaPadrao(`{"tabela": "GRUPO_PED", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].grupo}'"] }`);
        insereValor(`#txtGrupoPedido-${tipo}-${deposito}`, grupo[0].CODIGO, grupo[0].DESCRICAO);
      }

      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].status != '') {
        const status = await retornaJsonPesquisaPadrao(`{"tabela": "SITPROD", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].status}'"] }`);
        insereValor(`#txtStatusPedido-${tipo}-${deposito}`, status[0].CODIGO, status[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].tab_trans != '') {
        const transportadora = await retornaJsonPesquisaPadrao(`{"tabela": "TABTRAN", "camposSelect": ["CODIGO, NOME"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].tab_trans}'"] }`);
        insereValor(`#txtTransportadora-${tipo}-${deposito}`, transportadora[0].CODIGO, transportadora[0].NOME);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].id_tipo != '') {
        const tipoPedido = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO", "camposSelect": ["ID_TIPO, DESCRICAO"], "where": ["ID_TIPO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].id_tipo}'"] }`);
        insereValor(`#txtTipoPedido-${tipo}-${deposito}`, tipoPedido[0].ID_TIPO, tipoPedido[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].operacao != '') {
        const operacao = await retornaJsonPesquisaPadrao(`{"tabela": "OPER_FISCAL", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].operacao}'"] }`);
        insereValor(`#txtOperacaoFiscal-${tipo}-${deposito}`, operacao[0].CODIGO, operacao[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].moeda != '') {
        const moeda = await retornaJsonPesquisaPadrao(`{"tabela": "MOEDA", "camposSelect": ["CODMOE, DESCRICAO"], "where": ["CODMOE = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].moeda}'"] }`);
        insereValor(`#txtMoeda-${tipo}-${deposito}`, moeda[0].CODMOE, moeda[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].cond_pagto != '') {
        const condPagto = await retornaJsonPesquisaPadrao(`{"tabela": "CONDICAO", "camposSelect": ["CODCOND, DESCRICAO_AUX DESCRICAO"], "where": ["CODCOND = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].cond_pagto}'"] }`);
        insereValor(`#txtCondPagamento-${tipo}-${deposito}`, condPagto[0].CODCOND, condPagto[0].DESCRICAO);
      }

      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].designer != '') {
        const designer = await retornaJsonPesquisaPadrao(`{"tabela": "PED_COM", "camposSelect": ["PED_COM.CODREP, REPRESEN.NOME"], "leftJoin": [{"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = PED_COM.CODREP"}],  "where": ["NUMERO = '${pedido.tiposPedidos[tipo.toLowerCase()][deposito].pedido}'"] }`);
        insereValor(`#txtDesigner-${tipo}-${deposito}`, designer[0].CODREP, designer[0].NOME);
      }

      $(`#selectEmpFaturamento-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].emp_fat);
      $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].entrega);
      $(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].dt_fatura);
      $(`#txtDtVencimentoParcela-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].dt_vencimentoParcela);
      $(`#textDescricaoPedido-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].obs);
      $(`#selectFrete-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].cif);
      $(`#txtFrete-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].frete);

      const valorPedido = $.map(pedido.tiposPedidos[tipo.toLowerCase()][deposito].itens, (obj) => (obj.preco * obj.qtde));
      $(`#txtValorPedido-${tipo}-${deposito}`).val(valorPedido[0]);
      $(`#txtEntradaPedido-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].val_entrada);

      $('.collapsePedidos').on('click', function () {
        if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
          $($(this).find('i')[0]).removeClass('fa-angle-down');
          $($(this).find('i')[0]).addClass('fa-angle-right');
        } else {
          $($(this).find('i')[0]).removeClass('fa-angle-right');
          $($(this).find('i')[0]).addClass('fa-angle-down');
        }
      });

      if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].statusPedido == 'F') {
        if (await verificaPedidosGravados(tipo, deposito)) {
          desabilitaCamposFinalizaPedido(tipo, deposito);
        }
      }
    } catch (error) {
      console.error(error);
    }
  }



  async function separaPedidosPorItem() {
    $('#collapsePedidos').html(' ');
    const depositos = Object.keys(pedido.tiposPedidos.programado);

    await Promise.all(depositos.map(async (deposito) => {
      setTimeout(() => { }, 5000)
      if (pedido.tiposPedidos.programado[deposito].itens.length > 0) {
        await geraCardPedidos(pedido.tiposPedidos.programado[deposito], 'PROGRAMADO', deposito);
        if (pedido.tiposPedidos.programado[deposito].statusPedido == 'F') {
          await carregaInformacaoPedidoGravado('PROGRAMADO', deposito);
        }
      }
      setTimeout(() => { }, 5000)
      if (pedido.tiposPedidos.producao[deposito].itens.length > 0) {
        await geraCardPedidos(pedido.tiposPedidos.producao[deposito], 'PRODUCAO', deposito);
        if (pedido.tiposPedidos.producao[deposito].statusPedido == 'F') {
          await carregaInformacaoPedidoGravado('PRODUCAO', deposito);
        }
      }
      setTimeout(() => { }, 5000)
      if (pedido.tiposPedidos.pronta_entrega[deposito].itens.length > 0) {
        await geraCardPedidos(pedido.tiposPedidos.pronta_entrega[deposito], 'PRONTA_ENTREGA', deposito);
        if (pedido.tiposPedidos.pronta_entrega[deposito].statusPedido == 'F') {
          await carregaInformacaoPedidoGravado('PRONTA_ENTREGA', deposito);
        }
      }
      setTimeout(() => { }, 5000)
      if (pedido.tiposPedidos.mais_mix[deposito].itens.length > 0) {
        await geraCardPedidos(pedido.tiposPedidos.mais_mix[deposito], 'MAIS_MIX', deposito);
        if (pedido.tiposPedidos.mais_mix[deposito].statusPedido == 'F') {
          await carregaInformacaoPedidoGravado('MAIS_MIX', deposito);

        }
      }
    }));
  }

  function formatarData(data) {
    const partes = data.split('T');
    const dataPartes = partes[0].split('-');
    const horaPartes = partes[1].split(':');

    const ano = dataPartes[0];
    const mes = dataPartes[1];
    const dia = dataPartes[2];
    const hora = horaPartes[0].padStart(2, '0');
    const minuto = horaPartes[1].padStart(2, '0');
    const segundo = horaPartes[2];

    return `${ano}-${mes}-${dia}T${hora}:${minuto}:${segundo}`;
  }

  $('#btnDeixarPendente').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const dataInicio = formataDateTimeBackEnd(pedido.dtAbriu);
      const dataFim = formataDateTimeBackEnd(formataDataCompleta(new Date()));
      const depositos = Object.keys(pedido.tiposPedidos.programado);

      pedido.datasPendentes.push({ inicio: dataInicio, fim: dataFim });
      pedido.statusPedido = 'P';
      pedido.tempo = $('#txtContador').val();
      salvarArquivoPedido();

      await Promise.all(depositos.map(async (deposito) => {

        if (pedido.tiposPedidos.producao[deposito].numero) {
          if (pedido.tiposPedidos.producao[deposito].numero != '') {
            await gravaAtendimentoPendente(pedido.tiposPedidos.producao[deposito].numero);
          }
        }
        if (pedido.tiposPedidos.programado[deposito].numero) {
          if (pedido.tiposPedidos.programado[deposito].numero != '') {
            await gravaAtendimentoPendente(pedido.tiposPedidos.programado[deposito].numero);
          }
        }
        if (pedido.tiposPedidos.pronta_entrega[deposito].numero) {
          if (pedido.tiposPedidos.pronta_entrega[deposito].numero != '') {
            await gravaAtendimentoPendente(pedido.tiposPedidos.pronta_entrega[deposito].numero);
          }
        }
        if (pedido.tiposPedidos.mais_mix[deposito].numero) {
          if (pedido.tiposPedidos.mais_mix[deposito].numero != '') {
            await gravaAtendimentoPendente(pedido.tiposPedidos.mais_mix[deposito].numero);
          }
        }
      }));
      toastr.success(
        `Atendimento gravado como pendente!`,
        'Confirmação',
        {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 2000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/pedidosb2b`;
          },
        },
      ).css({
        'margin-top': '20%',
        width: '500px',
        'max-width': '500px',
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaValidacaoComercial(item) {
    const desconto = await Promise.all(item.itens.map(async (it) => {
      const [json] = await retornaJsonPesquisaPadrao(`{ "tabela": "tabpreco", "camposSelect": ["DESC_MAX"], "where": ["CODIGO = '${it.codigo}' "] } `);
      const perc_desc = TruncaDecimaisNova(2, (parseFloat(it.desc_item / parseFloat(it.preco_orig))) * 100);

      if (json) {
        return {
          desc_max: json.DESC_MAX,
          perc_desc
        }
      } else {
        return {
          desc_max: 0,
          perc_desc: 0
        }
      }
    }));
    const passouLimiteMaximo = desconto.filter((a) => a.desc_max < a.perc_desc).length > 0

    return passouLimiteMaximo;
  }

  async function retornaPedidoComEntrada(codcli) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "PEDIDO", "camposSelect": ["VAL_ENTRADA"], "where": ["VAL_ENTRADA > 0 AND CODCLI = '${codcli}' "] } `);
    return json.length > 0;
  }

  async function retornaMoedaBoleto(moeda) {
    if (moeda == '') {
      return false
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MOEDA", "camposSelect": ["FORMA_PAGTO"], "where": ["CODMOE = '${moeda}' "] } `);

    return json[0].FORMA_PAGTO == 15;
  }

  async function retornaValidacaoMoeda(hist) {
    if (hist == '') {
      return false
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "HISTCP", "camposSelect": ["CREDITO_GRUPO, LIMITE_CREDITO"], "where": ["HISTORICO = '${hist}' "] } `);

    if (!json) {
      return {
        creditoGrupo: false,
        limiteCredito: false,
      }
    }
    return {
      creditoGrupo: json[0].CREDITO_GRUPO == 'S',
      limiteCredito: json[0].LIMITE_CREDITO == 'S',
    };
  }

  async function retornaHistoricoMoeda(moeda) {
    if (moeda == '') {
      return '';
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MOEDA", "camposSelect": ["HISTORICO"], "where": ["CODMOE = '${moeda}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].HISTORICO;
  }
  async function retornaInformacaoMoeda(moeda, empresa) {
    if (moeda == '') {
      return '';
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MOEDA", "camposSelect": ["MOEDA.CLASSE", "MOEDA.CODSIT", "MOEDA.BANCO", "MOEDA_CONTA.CONTA"], "leftJoin": [{"tabela": "MOEDA_CONTA", "condicao": "MOEDA.CODMOE = MOEDA_CONTA.MOEDA"}],"where": ["MOEDA.CODMOE = '${moeda}' ", "MOEDA_CONTA.EMPRESA = '${empresa}'"] } `);

    if (json.length == 0) {
      return {
        CLASSE: '',
        CODSIT: '',
        BANCO: '',
        CONTA: ''
      };
    }
    return json[0];
  }

  async function retornaDescAuxCondicao(codcond) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "CONDICAO", "camposSelect": ["DESCRICAO_AUX"],"where": ["CODCOND = '${codcond}' "] } `);

    if (json.length == 0) {
      return {
        DESCRICAO_AUX: '',
      };
    }
    return json[0];
  }

  async function retornaUsuarioTemParcelaAtrasada(codcli) {
    const pesquisa = {
      camposSelect: ["SUM(VALOR2) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`,
        `((VALOR2[SOMA]JUROS) > (VALOR_PAGO[SOMA]DESCONTO[SOMA]VAL_DEV ))`,
        `(SITUACAO <> 'P')`,
        `DT_VENCTO < CURRENT_DATE`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

    return jsonStr[0].VALOR > 0;
  }

  async function retornaValidacaoFinanceiro(tipo, deposito) {
    const url = '/sisplan/pedidob2b/v1/informativos?';
    const codcli = pegaChave('#txtCliente');
    const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');
    const json = await response.json();
    const pedidosComEntradaAberta = tipo === 'PRODUCAO';

    const valorEntrada = StringToFloatDef($(`#txtEntradaPedido-${tipo}-${deposito}`).val(), 0);
    const valorPedido = StringToFloatDef($(`#txtValorPedido-${tipo}-${deposito}`).val(), 0);
    const percEntrada = TruncaDecimaisNova(2, (valorEntrada / valorPedido) * 100);

    const limiteCreditoDisponivel = StringToFloatDef($('#txtLimiteCreditoCliDispDisp').val(), 0)
    const limiteCreditoGrupoDisponivel = StringToFloatDef($('#txtLimiteCreditoConsignadoDisp').val(), 0)

    const moeda = pegaChave(`#txtMoeda-${tipo}-${deposito}`);
    const hist = await retornaHistoricoMoeda(moeda);
    const validacaoMoeda = await retornaValidacaoMoeda(hist);
    const titulosVencidos = json.titulosVencidos ? json.titulosVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0;
    const creditoGrupoVencidos = json.creditoGrupoVencidos ? json.creditoGrupoVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0;
    const validaUsuarioDupAtrasada = await retornaUsuarioTemParcelaAtrasada(codcli);

    if (validaUsuarioDupAtrasada) {
      return true
    }

    if ((validacaoMoeda.limiteCredito) || (validacaoMoeda.creditoGrupo)) {
      // CLIENTE COM DUPLICATAS VENCIDAS.
      if ((validacaoMoeda.limiteCredito) && (validacaoMoeda.creditoGrupo)) {
        if ((valorPedido > limiteCreditoDisponivel) && (valorPedido > limiteCreditoGrupoDisponivel)) {
          return true
        }
      }

      if (validacaoMoeda.limiteCredito) {

        if (valorPedido > limiteCreditoDisponivel) {
          return true
        }

        if (titulosVencidos > 0) {
          return true;
        }

        if (limiteCreditoDisponivel <= 0) {
          return true;
        }

        if ((await retornaMoedaBoleto(moeda)) && (limiteCreditoDisponivel <= 0)) {
          return true;
        }
      }

      if (validacaoMoeda.creditoGrupo) {
        if (valorPedido > limiteCreditoGrupoDisponivel) {
          return true;
        }

        if (limiteCreditoGrupoDisponivel <= 0) {
          return true;
        }
        if (creditoGrupoVencidos > 0) {
          return true;
        }
      }

      if ((validacaoMoeda.creditoGrupo) && (validacaoMoeda.limiteCredito)) {
        if (creditoGrupoVencidos > 0) {
          return true;
        }
        if ((limiteCreditoDisponivel <= 0) && (limiteCreditoGrupoDisponivel <= 0)) {
          return true;
        }
      }
    }
    // PEDIDOS QUE TIVER QUALQUER VALOR DE ENTRADA INFORMADO

    if (pedidosComEntradaAberta) {
      const valoresPadroes = await carregaValoresPadroesLista('B2B_PRODUCAO');
      if (valoresPadroes.VALIDA_PERCENTUAL == 'N') {
        return false;
      }

      if (percEntrada < 20) {
        return true;
      }
    }

    return false;
  }

  async function validaStatusPedido(item, tipo, deposito) {
    // cada tipo de venda tem suas particularidades por isso esses if feio.
    const valorEntrada = StringToFloatDef($(`#txtEntradaPedido-${tipo}-${deposito}`).val(), 0);
    const valorPedido = StringToFloatDef($(`#txtValorPedido-${tipo}-${deposito}`).val(), 0);
    const percEntrada = TruncaDecimaisNova(2, (valorEntrada / valorPedido) * 100);

    const validacaoComercial = await retornaValidacaoComercial(item);
    const validacaoFinanceiro = await retornaValidacaoFinanceiro(tipo, deposito);

    if (validacaoComercial) {
      $(`#txtStatusPedido-${tipo}-${deposito}`).val('[35] - AGUARDANDO LIB. COMERCIAL');
      $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
    } else {
      if (validacaoFinanceiro) {
        $(`#txtStatusPedido-${tipo}-${deposito}`).val('[36] - AGUARDANDO LIB. FINANCEIRO');
        $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
      } else {
        if (tipo == 'PRONTA_ENTREGA') {
          $(`#txtStatusPedido-${tipo}-${deposito}`).val('[40] - LIBERADO PARA EXPEDIÇÃO');
          $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
        }
        if (tipo == 'PROGRAMADO') {
          $(`#txtStatusPedido-${tipo}-${deposito}`).val('[73] - AGUARDANDO PRODUTO O.C');
          $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
        }
        if (tipo == 'MAIS_MIX') {
          $(`#txtStatusPedido-${tipo}-${deposito}`).val('[75] - AGUARDANDO PRODUTO MAIS MIX');
          $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
        }
        if (tipo == 'PRODUCAO') {
          if (percEntrada >= 20) {
            $(`#txtStatusPedido-${tipo}-${deposito}`).val('[37] - LIBERADO PRODUÇÃO');
            $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
            $(`#txtStatusPedido-${tipo}-${deposito}`).attr('disabled', true);
          } else {
            $(`#txtStatusPedido-${tipo}-${deposito}`).val('[55] - AGUARDANDO PAGAMENTO');
            $(`#txtStatusPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
            $(`#txtStatusPedido-${tipo}-${deposito}`).attr('disabled', true);
          }
        }
      }
    }
  }

  async function retornaCodigoFornecedorDeposito(deposito) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "DEPOSITO", "camposSelect": ["DEPOSITO.CODCLI", "ENTIDADE.CLASSE", "ENTIDADE.DIAS DIAS", "ENTIDADE.MOEDA", "ENTIDADE.CONDICAO", "ENTIDADE.TRANSPORTE" ], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = DEPOSITO.CODCLI"}], "where": ["DEPOSITO.CODIGO = '${deposito}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0];
  }

  async function retornaPrecoCompraItem(item) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MAT_ITEN", "camposSelect": ["PRECO_OC"], "where": ["CODIGO = '${item.codigo}' AND COR = '${item.cor}' AND DEPOSITO = '${item.deposito}'"] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].PRECO_OC;
  }

  async function montaOrdemCompra(pedidos) {
    const valoresPadroes = await carregaValoresPadroesLista('B2B_MAIS_MIX');
    const valoresFornecedor = await retornaCodigoFornecedorDeposito(pedidos.deposito);
    async function retornaItensCompra(codigoForn) {
      const itens = [];

      await Promise.all(pedidos.itens.map(async (item, i) => {
        const precoCompra = await retornaPrecoCompraItem(item)
        const itemMesa = $('#tabelaItensMesa').DataTable().rows().data().toArray().filter((itemMesa) => itemMesa.CODIGO === item.codigo)[0];

        itens.push({
          CODIGO: item.codigo,
          DESCRICAO: itemMesa.DESCRICAO,
          COR: item.cor,
          DEPOSITO: item.deposito,
          QTDE: item.qtde,
          PRECO: precoCompra,
          DESCONTO: item.desc_item,
          CODIGO_FORN: codigoForn,
          UNIDADE: itemMesa.UNIDADE,
          DT_ENTREGA: pedidos.dt_fatura,
          TP_ITEM: item.tipo,
          SITUACAO: valoresPadroes.SITUACAO,
          VALOR: TruncaDecimaisNova(2, precoCompra * item.qtde),
          C_CUSTO: valoresPadroes.C_CUSTO,
          ORDEM: i
        })
      }));
      return itens
    }

    const compra = {
      NUMERO: await RetornaProximo('COMPRA', 'COMPRA', 'NUMERO', 6),
      CODFOR: valoresFornecedor.CODCLI,
      ADQUIRENTE: pedidos.codcli,
      CLASSE: valoresFornecedor.CLASSE,
      CODTRAN: valoresFornecedor.TRANSPORTE,
      COLECAO: valoresPadroes.COLECAO,
      CONDICAO: valoresFornecedor.CONDICAO,
      DOCTO: pedidos.numero,
      DT_EMISSAO: pedidos.dt_emissao,
      DT_COTACAO: pedidos.dt_emissao,
      DT_ENTREGA: retornaDataPraFrente(new Date(pedidos.dt_emissao), Number(valoresFornecedor.DIAS)),
      DT_ENTREGA_ORIG: retornaDataPraFrente(new Date(pedidos.dt_emissao), Number(valoresFornecedor.DIAS)),
      EMPRESA: valoresPadroes.EMPRESA,
      FRETE: valoresPadroes.FRETE,
      MOEDA: valoresFornecedor.MOEDA,
      MOTIVO: valoresPadroes.MOTIVO,
      OBS: valoresPadroes.OBS,
      TELA: valoresPadroes.TELA,
      USUARIO: sessionStorage.getItem('usuario'),
      VAL_COTACAO: valoresPadroes.VAL_COTACAO,
      LIBERADO: valoresPadroes.LIBERADO,
      // - LIBERADO: pedidos.status != '35' && pedidos.status != '36' ? 'L' : 'B',
      EMP_ID: 1,
      DEPOSITO: pedidos.deposito,
      HISTORICO: pedidos.historico,
      OPERACAO: pedidos.operacao,
      ITENS: await retornaItensCompra(valoresFornecedor.CODCLI),
    }

    return compra;
  }

  async function gravaOrdemCompra(compra) {

    const response = await requisicao('POST', '/sisplan/ordem_compra/v1/ordem_compra?', '', JSON.stringify(compra), 90000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.mensagem);
      return;
    }

    return jsonStr.numero
  }

  async function retornaDiasEntidadeVinculada(deposito) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "ENTIDADE", "camposSelect": ["ENTIDADE.DIAS"], 
      "leftJoin": [{"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODCLI  = ENTIDADE.CODCLI"}],
      "where": ["DEPOSITO.CODIGO = '${deposito}' "] } `);

    if (json.length == 0) {
      return 0;
    }
    return json[0].DIAS;
  }

  async function gravaValores(item, tipo, deposito) {
    const diasEntidadeDeposito = await retornaDiasEntidadeVinculada(deposito)

    if (tipo == 'PRONTA_ENTREGA') {
      $(`#txtTipoPedido-${tipo}-${deposito}`).val('[32] - ATACADO PRONTA ENTREGA');
      $(`#txtTipoPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
    }
    if (tipo == 'PROGRAMADO') {
      $(`#txtTipoPedido-${tipo}-${deposito}`).val('[33] - ATACADO PROGRAMADO');
      $(`#txtTipoPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
    }
    if (tipo == 'PRODUCAO') {
      $(`#txtTipoPedido-${tipo}-${deposito}`).val('[34] - ATACADO PRODUÇÃO');
      $(`#txtTipoPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
    }
    if (tipo == 'MAIS_MIX') {
      $(`#txtTipoPedido-${tipo}-${deposito}`).val('[45] - ATACADO MAIS MIX');
      $(`#txtTipoPedido-${tipo}-${deposito}`).attr('data-selecionado', true);
    }

    let tipoPedido = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO", "camposSelect": ["ID_TIPO, DESCRICAO, PED_BENEFICIAR"], "where": ["ID_TIPO = '${pegaChave(`#txtTipoPedido-${tipo}-${deposito}`)}'"] }`);
    //Adicionado propriedade para ativar o Designer quando o tipo de pedido tiver PED_BENEFICIAR = 'S'
    if (tipoPedido[0].PED_BENEFICIAR == 'S') {
      $(`#txtDesigner-${tipo}-${deposito}`).attr('disabled', false);
      $(`#btn-Designer-${tipo}-${deposito}`).attr('disabled', false);
      $(`#btn-limpa-Designer-${tipo}-${deposito}`).attr('disabled', false);
    }


    await adicionaEmpresas(tipo, deposito);

    $(`#txtGrupoPedido-${tipo}-${deposito}`).val();
    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val();
    $(`#txtEntradaPedido-${tipo}-${deposito}`).val();
    $(`#selectFrete-${tipo}-${deposito}`).val();
    $(`#txtTransportadora-${tipo}-${deposito}`).val();
    $(`#txtOperacaoFiscal-${tipo}-${deposito}`).val();
    $(`#textDescricaoPedido-${tipo}-${deposito}`).val();
    $('#txtValorTotalPedidos').html(formataEmReais($('#tabelaItensCompletos').DataTable().column(7, {}).data().sum()));

    $('.maskDecimais').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2,
    });
    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == '') {
        $(this).val('0.00');
      }
    });

    if (diasEntidadeDeposito > 0) {
      setarDataAtual(`txtDtFaturaFinalizaPedido-${tipo}-${deposito}`, false, diasEntidadeDeposito);
    } else {
      if (tipo == 'PROGRAMADO') {
        const json = await retornaJsonPesquisaPadrao(`{"tabela": "COMPRA", "camposSelect": ["DT_ENTREGA"], "where": ["NUMERO = '${item.itens[0].ESTOQUE ? item.itens[0].ESTOQUE : item.itens[0].deposito}'"] }`);
        const dataRecebida = new Date(json[0].DT_ENTREGA);
        dataRecebida.setUTCHours(0);
        const deslocamentoFusoHorario = dataRecebida.getTimezoneOffset();
        dataRecebida.setMinutes(dataRecebida.getMinutes() + deslocamentoFusoHorario);
        setarDataPraFrente(`txtDtFaturaFinalizaPedido-${tipo}-${deposito}`, dataRecebida, 5);
      } else if (tipo == 'PRONTA_ENTREGA') {
        setarDataAtual(`txtDtFaturaFinalizaPedido-${tipo}-${deposito}`, false, 2);
      } else if (tipo == 'PRODUCAO') {
        setarDataAtual(`txtDtFaturaFinalizaPedido-${tipo}-${deposito}`, false, 7);
      } else if (tipo == 'MAIS_MIX') {
        setarDataAtual(`txtDtFaturaFinalizaPedido-${tipo}-${deposito}`, false, 5);
      }
    }

    setarDataAtual(`txtDtVencimentoParcela-${tipo}-${deposito}`, false, 0);

    const valorPedido = $.map(item.itens, (obj) => (obj.preco * obj.qtde)).reduce((accumulator, currentValue) => accumulator + currentValue, 0);

    $(`#txtValorPedido-${tipo}-${deposito}`).val(TruncaDecimaisNova(2, valorPedido));
    parseFloat($(`#txtEntradaPedido-${tipo}-${deposito}`).val())
    if ($(`#txtEntradaPedido-${tipo}-${deposito}`).val() != '') {
      $(`#txtSaldoPedido-${tipo}-${deposito}`).val(TruncaDecimaisNova(2, valorPedido - parseFloat($(`#txtEntradaPedido-${tipo}-${deposito}`).val())));
    } else {
      $(`#txtSaldoPedido-${tipo}-${deposito}`).val(TruncaDecimaisNova(2, valorPedido));
    }

    if ((!pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero) || (pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero == '')) {
      pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero = await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5);

      pedido.tiposPedidos[tipo.toLowerCase()][deposito] = {
        ...pedido.tiposPedidos[tipo.toLowerCase()][deposito],
        numero: pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero,
      };

      await montaJsonPedido();
      await salvarArquivoPedido();
    }
  }

  async function geraCardPedidos(item, tipo, deposito) {
    try {
      await cardPedidos(tipo, deposito);
      await gravaValores(item, tipo, deposito);
    } catch (error) {
      console.error(error);
    }
  }

  async function cardPedidos(tipo, deposito) {
    $('#collapsePedidos').append(/* html */`
          <div class="card card-header collapseHeader" role="tab" id="finalizarPedido-${tipo}-${deposito}">
            <a style="width:100%;" class="collapsePedidos" data-toggle="collapse" data-parent="#collapsePedido-${tipo}-${deposito}" href="#collapsePedido-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
              <div class="row">
                <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                  <i class="fas fa-angle-down"></i>
                </div>
                <div class="col-11">
                  <h4 class="title-page">
                    Pedido ${tipo === 'PRODUCAO' ? 'Produção' : tipo === 'PRONTA_ENTREGA' ? 'Pronta Entrega' : tipo === 'PROGRAMADO' ? 'Programado' : 'Mais Mix'}
                  </h4>
                </div>
              </div>
            </a>
          </div>
          <div class="collapse show" id="collapsePedido-${tipo}-${deposito}">
            <div class="card card-body">
              <div class="row mt-3">
                <div class="col-lg-4 col-12" id="divTipoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtTipoPedido-${tipo}-${deposito}">Tipo de Pedido</label>
                  <div class="input-group">
                    <input type="text" disabled="true" data-selecionado="false" class="input-default focus form-control txtTipoPedido" id="txtTipoPedido-${tipo}-${deposito}" name="txtTipoPedido-${tipo}-${deposito}" placeholder="Tipo de Pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger btn-TipoPedido" disabled="true" id="btn-TipoPedido-${tipo}-${deposito}" name="btn-TipoPedido-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger btn-limpa-TipoPedido" disabled="true" id="btn-limpa-TipoPedido-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-12" id="divGrupoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtGrupoPedido-${tipo}-${deposito}">Grupo Pedido
                    </label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtGrupoPedido-${tipo}-${deposito}" name="txtGrupoPedido-${tipo}-${deposito}" placeholder="Grupo Pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoPedido-${tipo}-${deposito}" name="btn-GrupoPedido-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoPedido-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4 col-12 d-none" id="divStatusPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtStatusPedido-${tipo}-${deposito}">Status Pedido</label>
                  <div class="input-group">
                    <input disabled="true" type="text" data-selecionado="false" class="input-default focus form-control" id="txtStatusPedido-${tipo}-${deposito}" name="txtStatusPedido-${tipo}-${deposito}" placeholder="Status Pedido">
                    <div class="input-group-append">
                      <button disabled="true" class="btn bg-danger" id="btn-StatusPedido-${tipo}-${deposito}" name="btn-StatusPedido-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button disabled="true" class="btn bg-danger" id="btn-limpa-StatusPedido-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-12" id="divOperacaoFiscal">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtOperacaoFiscal-${tipo}-${deposito}">Operação Fiscal
                  </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtOperacaoFiscal-${tipo}-${deposito}" name="txtOperacaoFiscal-${tipo}-${deposito}" placeholder="Operação Fiscal">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-OperacaoFiscal-${tipo}-${deposito}" name="btn-OperacaoFiscal-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-OperacaoFiscal-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="row mt-2">
                <div class="col-lg-4 col-12 form-group mb-0">
                  <label class="mb-0">Emp. Faturamento</label>
                  <div class="input-group mb-0">
                    <select class="form-control select2 select2-danger focus selectEmpFaturamento" id="selectEmpFaturamento-${tipo}-${deposito}" name="selectEmpFaturamento-${tipo}-${deposito}" data-dropdown-css-class="select2-danger">
                    </select>
                  </div>
                </div>

                <div class="col-lg-4 col-12 form-group mb-0">
                  <label class="mb-0" data-error="wrong" data-success="left" for="selectFrete-${tipo}-${deposito}">Frete por Conta</label>
                  <select style="width:100%;" class="form-control select2 select2-danger focus custom-select focus mb-0" data-dropdown-css-class="select2-danger" id="selectFrete-${tipo}-${deposito}">
                    <option value="">Selecione um transportador</option>
                    <option value="0">0 - Contratação do Frete por conta do Remetente(CIF)</option>
                    <option value="1">1 - Contratação do Frete por conta do Destinatário(FOB)</option>
                    <option value="2">2 - Contratação do Frete por conta de Terceiros </option>
                    <option value="3">3 - Transporte Próprio por conta do Remetente</option>
                    <option value="4">4 - Transporte Próprio por conta do Destinatário </option>
                    <option selected value="9">9 - Sem Ocorrência de Transporte</option>
                  </select>
                </div>

                <div class="col-lg-4 col-12" id="divTransportadora">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtTransportadora-${tipo}-${deposito}">Transportadora</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTransportadora-${tipo}-${deposito}" name="txtTransportadora-${tipo}-${deposito}" placeholder="Transportadora">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Transportadora-${tipo}-${deposito}" name="btn-Transportadora-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Transportadora-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row mt-2 mb-0">
                <div class="col-lg-2 col-4" id="tourValorPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtValorPedido-${tipo}-${deposito}">Valor Pedido
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" disabled="true" id="txtValorPedido-${tipo}-${deposito}" aria-describedby="codError" name="txtValorPedido-${tipo}-${deposito}" placeholder="Valor Pedido">
                </div>

                <div class="col-lg-2 col-4" id="tourSaldoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtSaldoPedido-${tipo}-${deposito}">Saldo
                  </label>
                  <input disabled="true" type="text" class="input-default focus form-control maskDecimais" id="txtSaldoPedido-${tipo}-${deposito}" aria-describedby="codError" name="txtSaldoPedido-${tipo}-${deposito}" placeholder="Saldo">
                </div>

                <div class="col-lg-4 col-4" id="tourEntradaPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtEntradaPedido-${tipo}-${deposito}">Valor Entrada
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" id="txtEntradaPedido-${tipo}-${deposito}" aria-describedby="codError" name="txtEntradaPedido-${tipo}-${deposito}" placeholder="Valor Entrada">
                </div>


                <div class="col-lg-2 col-6" id="tourFrete">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtFrete-${tipo}-${deposito}">Valor Frete
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" id="txtFrete-${tipo}-${deposito}" aria-describedby="codError" name="txtFrete-${tipo}-${deposito}" placeholder="Valor Frete">
                </div>

                <div class="col-lg-2 col-6" id="tourDesigner">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtDesigner-${tipo}-${deposito}">Designer</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDesigner-${tipo}-${deposito}" name="txtDesigner-${tipo}-${deposito}" placeholder="Designer" disabled>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Designer-${tipo}-${deposito}" name="btn-Designer-${tipo}-${deposito}" data-button="absolute" type="button" disabled><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Designer-${tipo}-${deposito}" type="button" disabled><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
            
              <div class="row mt-2">
                <div class="col-lg-3 col-6" id="divMoeda">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtMoeda-${tipo}-${deposito}">Moeda</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control txtMoeda" id="txtMoeda-${tipo}-${deposito}" name="txtMoeda-${tipo}-${deposito}" placeholder="Moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Moeda-${tipo}-${deposito}" name="btn-Moeda-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Moeda-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-3 col-6" id="divCondPagamento">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtCondPagamento-${tipo}-${deposito}">Condição Pagamento
                  </label>
                  <div class="input-group">
                    <input disabled="true" type="text" data-selecionado="false" class="input-default focus form-control" id="txtCondPagamento-${tipo}-${deposito}" name="txtCondPagamento-${tipo}-${deposito}" placeholder="Condição Pagamento">
                    <div class="input-group-append">
                      <button class="btn bg-danger" disabled="true" id="btn-CondPagamento-${tipo}-${deposito}" name="btn-CondPagamento-${tipo}-${deposito}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" disabled="true" id="btn-limpa-CondPagamento-${tipo}-${deposito}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-2 col-4 form-group d-none" id="tourCondEspecial">
                <label data-error="wrong" class="mb-0" data-success="right" for="txtCondEspecial-${tipo}-${deposito}">
                  </label>
                  <input type="text" class="input-default focus form-control" id="txtCondEspecial-${tipo}-${deposito}" aria-describedby="codError" name="txtCondEspecial-${tipo}-${deposito}" placeholder="Cond. Especial">
                </div>
                
                <div class="col-lg-2 col-4">
                  <label data-error="wrong" data-success="right" for="txtDtVencimentoParcela-${tipo}-${deposito}" style="margin-bottom: 0px;">Data Venc. Parcela</label>
                  <input type="date" class="input-default" id="txtDtVencimentoParcela-${tipo}-${deposito}" name="txtDtVencimentoParcela-${tipo}-${deposito}">
                </div>
                <div class="col-lg-2 col-4">
                  <label data-error="wrong" data-success="right" for="txtDtFaturaFinalizaPedido-${tipo}-${deposito}" style="margin-bottom: 0px;">Prev. Fatura</label>
                  <input disabled type="date" class="input-default" id="txtDtFaturaFinalizaPedido-${tipo}-${deposito}" name="txtDtFaturaFinalizaPedido-${tipo}-${deposito}">
                </div>
                <div class="col-lg-2 col-4">
                  <label data-error="wrong" data-success="right" for="txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}" style="margin-bottom: 0px;">Entrega</label>
                  <input type="date" class="input-default" id="txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}" name="txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}">
                </div>
              </div>

              <div class="row mt-2">
                <div class="col-12">
                  <label class="mb-0" for="textDescricaoPedido-${tipo}-${deposito}">Observação</label>
                  <textarea name="" class="input-default focus form-control" id="textDescricaoPedido-${tipo}-${deposito}" cols="30" rows="3" placeholder="Descrição Pedido"></textarea>
                </div>
              </div>

              <div class="card card-header collapseHeader mt-2" role="tab" id="enderecoEntregaPedido-${tipo}-${deposito}">
                <a style="width:100%;" class="collapseEnderecoEntregas" data-toggle="collapse" data-parent="#collapseEnderecoEntrega-${tipo}-${deposito}" href="#collapseEnderecoEntrega-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                  <div class="row">
                    <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                      <i class="fas fa-angle-right"></i>
                    </div>
                    <div class="col-11">
                      <h4 class="title-page">
                        Endereço Entrega Cliente
                      </h4>
                    </div>
                  </div>
                </a>
              </div>
              <div class="collapse" id="collapseEnderecoEntrega-${tipo}-${deposito}">
                <div class="card card-body">
                  <div>
                    <div class="card card-header d-flex collapseHeader mt-2" style="flex-direction: row; align-items: center; grid-gap: 10px" role="tab" id="enderecoEntregaEntidade-${tipo}-${deposito}">
                      <a class="collapseEnderecoEntidades" data-toggle="collapse" data-parent="#collapseEnderecoEntidade-${tipo}-${deposito}" href="#collapseEnderecoEntidade-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                          <i class="fas fa-angle-right"></i>   
                        </div>
                      </a>
                      <input type="radio" id="radioEndEntidade-${tipo}-${deposito}" class="pointer" name="radioEndereco">
                      <a class="collapseEnderecoEntidades" data-toggle="collapse" data-parent="#collapseEnderecoEntidade-${tipo}-${deposito}" href="#collapseEnderecoEntidade-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <h4 class="title-page">
                          <label class="container ml-2 mr-0 pl-0" for="radioEndEntidade-${tipo}-${deposito}">Endereço da Entidade</label>
                        </h4>
                      </a>
                    </div>

                    <!-- <div class="col-lg-12  col-12 mb-2">
                    </div> -->

                    <div class="collapse" id="collapseEnderecoEntidade-${tipo}-${deposito}">
                       <div class="card card-body">
                      <div class="row ml-4">
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtEnderecoEntidade-${tipo}-${deposito}">Endereço</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEnderecoEntidade-${tipo}-${deposito}" name="txtEnderecoEntidade-${tipo}-${deposito}" disabled>
                            <input type="text" class="input-default focus form-control" id="txtNumeroEntidade-${tipo}-${deposito}" name="txtNumeroEntidade-${tipo}-${deposito}" hidden>
                            <input type="text" class="input-default focus form-control" id="txtComplementoEntidade-${tipo}-${deposito}" name="txtComplementoEntidade-${tipo}-${deposito}" hidden>
                          </div>
                        </div>
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtBairroEntidade-${tipo}-${deposito}">Bairro</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtBairroEntidade-${tipo}-${deposito}" name="txtBairroEntidade-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCepEntidade-${tipo}-${deposito}">Cep</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCepEntidade-${tipo}-${deposito}" name="txtCepEntidade-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCidadeEstadoEntidade-${tipo}-${deposito}">Cidade/Estado</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCidadeEstadoEntidade-${tipo}-${deposito}" name="txtCidadeEstadoEntidade-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div>
                    <div class="card card-header d-flex collapseHeader mt-2" style="flex-direction: row; align-items: center; grid-gap: 10px" role="tab" id="enderecoEntregaEntidade-${tipo}-${deposito}">
                      <a class="collapseEnderecoEntregaEntidades" data-toggle="collapse" data-parent="#collapseEnderecoEntregaEntidade-${tipo}-${deposito}" href="#collapseEnderecoEntregaEntidade-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                          <i class="fas fa-angle-right"></i>   
                        </div>
                      </a>
                      <input type="radio" id="radioEntregaEntidade-${tipo}-${deposito}" class="pointer" name="radioEndereco">
                      <a class="collapseEnderecoEntregaEntidades" data-toggle="collapse" data-parent="#collapseEnderecoEntregaEntidade-${tipo}-${deposito}" href="#collapseEnderecoEntregaEntidade-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <h4 class="title-page">
                          <label class="container ml-2 mr-0 pl-0" for="radioEntregaEntidade-${tipo}-${deposito}">Endereço de Entrega</label>
                        </h4>
                      </a>
                    </div>
                    
                    <div class="collapse" id="collapseEnderecoEntregaEntidade-${tipo}-${deposito}">
                      <div class="row ml-4">
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtEnderecoEntrega">Endereço</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEnderecoEntrega-${tipo}-${deposito}" name="txtEnderecoEntrega-${tipo}-${deposito}" disabled>
                            <input type="text" class="input-default focus form-control" id="txtNumeroEntrega-${tipo}-${deposito}" name="txtNumeroEntrega-${tipo}-${deposito}" hidden>
                            <input type="text" class="input-default focus form-control" id="txtComplementoEntrega-${tipo}-${deposito}" name="txtComplementoEntrega-${tipo}-${deposito}" hidden>
                          </div>
                        </div>
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtBairroEntrega">Bairro</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtBairroEntrega-${tipo}-${deposito}" name="txtBairroEntrega-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCepEntrega">Cep</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCepEntrega-${tipo}-${deposito}" name="txtCepEntrega-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCidadeEstadoEntrega">Cidade/Estado</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCidadeEstadoEntrega-${tipo}-${deposito}" name="txtCidadeEstadoEntrega-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div>
                    <div class="card card-header d-flex collapseHeader mt-2" style="flex-direction: row; align-items: center; grid-gap: 10px" role="tab" id="enderecoEntregaCobranca-${tipo}-${deposito}">
                      <a class="collapseEnderecoEntregaCobrancas" data-toggle="collapse" data-parent="#collapseEnderecoEntregaCobranca-${tipo}-${deposito}" href="#collapseEnderecoEntregaCobranca-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                          <i class="fas fa-angle-right"></i>   
                        </div>
                      </a>
                      <input type="radio" id="radioCobrancaEntidade-${tipo}-${deposito}" class="pointer" name="radioEndereco">
                      <a class="collapseEnderecoEntregaCobrancas" data-toggle="collapse" data-parent="#collapseEnderecoEntregaCobranca-${tipo}-${deposito}" href="#collapseEnderecoEntregaCobranca-${tipo}-${deposito}" aria-expanded="true" aria-controls="collapseOne1">
                        <h4 class="title-page">
                          <label class="container ml-2 mr-0 pl-0" for="radioCobrancaEntidade-${tipo}-${deposito}">Endereço de Cobrança</label>
                        </h4>
                      </a>
                    </div>
                    
                    <div class="collapse" id="collapseEnderecoEntregaCobranca-${tipo}-${deposito}">
                      <div class="row ml-4">
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtEnderecoCobranca">Endereço</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEnderecoCobranca-${tipo}-${deposito}" name="txtEnderecoCobranca-${tipo}-${deposito}" disabled>
                            <input type="text" class="input-default focus form-control" id="txtNumeroCobranca-${tipo}-${deposito}" name="txtNumeroCobranca-${tipo}-${deposito}" hidden>
                            <input type="text" class="input-default focus form-control" id="txtComplementoCobranca-${tipo}-${deposito}" name="txtComplementoCobranca-${tipo}-${deposito}" hidden>
                          </div>
                        </div>
                        <div class="col-lg-12  col-12 form-group">
                          <label for="txtBairroCobranca">Bairro</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtBairroCobranca-${tipo}-${deposito}" name="txtBairroCobranca-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCepCobranca">Cep</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCepCobranca-${tipo}-${deposito}" name="txtCepCobranca-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                        <div class="col-lg-6  col-12 form-group">
                          <label for="txtCidadeEstadoCobranca">Cidade/Estado</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCidadeEstadoCobranca-${tipo}-${deposito}" name="txtCidadeEstadoCobranca-${tipo}-${deposito}" disabled>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <hr>
                  <!-- <div>
                    <div class="col-lg-12  col-12 mb-2">
                      <input type="radio" id="radioPersonalizadoEntidade-${tipo}-${deposito}" name="radioEndereco">
                      <label class="container ml-2 mr-0 pl-0" for="radioPersonalizadoEntidade-${tipo}-${deposito}">Endereço de Personalizado</label>
                    </div>
                    <div class="row ml-4">
                      <div class="col-lg-11  col-11 form-group">
                        <label for="txtEnderecoPersonalizado">Endereço</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtEnderecoPersonalizado-${tipo}-${deposito}" name="txtEnderecoPersonalizado-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-1  col-1 form-group">
                        <label for="txtNumeroPersonalizado">&nbsp;</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtNumeroPersonalizado-${tipo}-${deposito}" name="txtNumeroPersonalizado-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-12  col-12 form-group">
                        <label for="txtComplementoPersonalizado">Complemento</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtComplementoPersonalizado-${tipo}-${deposito}" name="txtComplementoPersonalizado-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-12  col-12 form-group">
                        <label for="txtBairroPersonalizado">Bairro</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtBairroPersonalizado-${tipo}-${deposito}" name="txtBairroPersonalizado-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-6  col-6 form-group">
                        <label data-error="wrong" data-success="right" for="txtCEPPersonalizado">Cep</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCEPPersonalizado-${tipo}-${deposito}" name="txtCEPPersonalizado-${tipo}-${deposito}" placeholder="CEP">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-CEPPersonalizado" name="btn-CEPPersonalizado" data-button="absolute" type="button">
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button class="btn bg-danger" id="btn-limpa-CEPPersonalizado" type="button">
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6  col-12 form-group">
                        <label for="txtCidadeEstadoPersonalizado">Cidade/Estado</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCidadeEstadoPersonalizado-${tipo}-${deposito}" name="txtCidadeEstadoPersonalizado-${tipo}-${deposito}" disabled>
                        </div>
                      </div>
                    </div>
                  </div> -->
                  <div>
                    <div class="row ml-4">
                      <div class="col-lg-1  col-1 form-group">
                        <label for="txtDDD">DDD</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtDDD-${tipo}-${deposito}" name="txtDDD-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-5  col-5 form-group">
                        <label for="txtTelefone">Telefone</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtTelefone-${tipo}-${deposito}" name="txtTelefone-${tipo}-${deposito}">
                        </div>
                      </div>
                      <div class="col-lg-6  col-6 form-group">
                        <label for="txtInscricao">Inscrição/RG</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtInscricao-${tipo}-${deposito}" name="txtInscricao-${tipo}-${deposito}" disabled>
                        </div>
                      </div>
                      <div class="col-lg-12  col-12 form-group">
                        <label for="txtRecebedor">Recebedor</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtRecebedor-${tipo}-${deposito}" name="txtRecebedor-${tipo}-${deposito}">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mt-2">
                <div class="col-12 d-flex justify-content-end">
                  <button id="btnAbrirItensPedido-${tipo}-${deposito}" type="button" class="btn btn-lg btn-sisp btn-success mr-2">Itens</button>
                  <button id="btnGravarPedido-${tipo}-${deposito}" type="button" class="btn btn-lg btn-sisp btn-success btnGravarPedido">Confirmar</button>
                </div>
              </div>
          </div>
        `);

    $(".focus").bind("keypress", function (e) {
      if (e.keyCode == 13) {
        var inps = $(".focus:not('.d-none')"); //$("input, select, textarea"); //add select too
        for (var x = 0; x < inps.length; x++) {
          if (inps[x] == this) {
            while ((inps[x + 1] !== undefined) && ((inps[x]).id == (inps[x + 1]).id)) {
              x++;
            }
            if (($(inps[x + 1]).prop('disabled') && ((x + 1) < inps.length))) {
              x++;
              if ((x + 1) < inps.length) {

                $(inps[x + 1]).focus();
              } else {
                $(inps[0]).focus();
              }
            } else {
              if ((x + 1) < inps.length) {
                $(inps[x + 1]).focus();
              } else { $(inps[0]).focus(); }
            }
          }
        }
        e.preventDefault();
      }
    });

    $(`#btn-limpa-TipoPedido-${tipo}-${deposito}`).on('click', () => { $(`#txtTipoPedido-${tipo}-${deposito}`).val(''); });
    $(`#btn-TipoPedido-${tipo}-${deposito}`).pesquisa(`#txtTipoPedido-${tipo}-${deposito}`, 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda', 'TIPO');
    $(`#txtTipoPedido-${tipo}-${deposito}`).autocompleta(1, 'JSON={ "tabela":"TIPO", "camposSelect":["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null}');

    $(`#btn-limpa-Transportadora-${tipo}-${deposito}`).on('click', () => { $(`#txtTransportadora-${tipo}-${deposito}`).val(''); });
    $(`#btn-Transportadora-${tipo}-${deposito}`).pesquisa(`#txtTransportadora-${tipo}-${deposito}`, 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora', 'tabtran');
    $(`#txtTransportadora-${tipo}-${deposito}`).autocompleta(1, 'JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}');

    const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
    $(`#txtOperacaoFiscal-${tipo}-${deposito}`).autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal}}`);
    $(`#btn-OperacaoFiscal-${tipo}-${deposito}`).pesquisa(`#txtOperacaoFiscal-${tipo}-${deposito}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operação', 'OPER_FISCAL');
    $(`#btn-limpa-OperacaoFiscal-${tipo}-${deposito}`).on('click', () => { $(`#txtOperacaoFiscal-${tipo}-${deposito}`).val(''); });

    $(`#txtGrupoPedido-${tipo}-${deposito}`).autocompleta(1, 'JSON={ "tabela":"GRUPO_PED", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}');
    $(`#btn-GrupoPedido-${tipo}-${deposito}`).pesquisa(`#txtGrupoPedido-${tipo}-${deposito}`, 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo Ped', 'GRUPO_PED');
    $(`#btn-limpa-GrupoPedido-${tipo}-${deposito}`).on('click', () => { $(`#txtGrupoPedido-${tipo}-${deposito}`).val(''); });

    $(`#txtStatusPedido-${tipo}-${deposito}`).autocompleta(1, 'JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}');
    $(`#btn-StatusPedido-${tipo}-${deposito}`).pesquisa(`#txtStatusPedido-${tipo}-${deposito}`, 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $(`#btn-limpa-StatusPedido-${tipo}-${deposito}`).on('click', () => { $(`#txtStatusPedido-${tipo}-${deposito}`).val(''); });

    $(`#txtMoeda-${tipo}-${deposito}`).autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["MOEDA.CODMOE CHAVE, MOEDA.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}],  "where": ["ENT_MOEDA.CODCLI = '${pegaChave('#txtCliente')}'"]}`);
    $(`#btn-Moeda-${tipo}-${deposito}`).pesquisa(`#txtMoeda-${tipo}-${deposito}`, 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MOEDA", "camposSelect":[ "MOEDA.CODMOE", "MOEDA.DESCRICAO" ], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}],  "where": ["ENT_MOEDA.CODCLI = '${pegaChave('#txtCliente')}' "]}`, 'Pesquisa Moeda', 'moeda');
    $(`#btn-limpa-Moeda-${tipo}-${deposito}`).on('click', () => {
      limpaValor(`#txtMoeda-${tipo}-${deposito}`);
      limpaValor(`#txtCondPagamento-${tipo}-${deposito}`);
    });

    $(`#btn-limpa-Designer-${tipo}-${deposito}`).on('click', () => { $(`#txtDesigner-${tipo}-${deposito}`).val(''); });
    $(`#btn-Designer-${tipo}-${deposito}`).pesquisa(`#txtDesigner-${tipo}-${deposito}`, 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Designer', 'REPRESEN');
    $(`#txtDesigner-${tipo}-${deposito}`).autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);

    $(`#txtEntradaPedido-${tipo}-${deposito}`).on('blur', async function () {
      const valorPedido = $(`#txtValorPedido-${tipo}-${deposito}`).val();
      const saldoPedido = TruncaDecimaisNova(2, parseFloat(valorPedido) - parseFloat($(`#txtEntradaPedido-${tipo}-${deposito}`).val()));

      $(`#txtSaldoPedido-${tipo}-${deposito}`).val(isNaN(saldoPedido) ? 0 : saldoPedido);
    })

    async function SaidaMoeda(moeda, deposito) {
      const json = await retornaJsonPesquisaPadrao(`{ "tabela": "COND_MOEDA", "camposSelect": [ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO_AUX DESCRICAO" ],"innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }],"where": ["COND_MOEDA.MOEDA = '${moeda}'"]}`);

      if (json.length == 0) {
        return '';
      }
      if (json.length == 1) {
        insereValor(`#txtCondPagamento-${tipo}-${deposito}`, json[0].CODCOND, json[0].DESCRICAO);
        return;
      }
      $(`#btn-CondPagamento-${tipo}-${deposito}`).trigger('click');
      return;
    }

    async function criaModalCondicoes(txtCod, moeda) {
      const pesquisaParam = {
        tabela: 'COND_MOEDA',
        camposSelect: [
          "COND_MOEDA.CODCOND",
          "CONDICAO.DESCRICAO",
          "CONDICAO.NRPAR NUMERO_PARCELAS",
          `ROUND(${parseFloat($(`#txtValorPedido-${tipo}-${deposito}`).val())} / CONDICAO.NRPAR, 2) VALOR_PARCELA`,
          "COND_MOEDA.VALOR_MINIMO",
        ],
        innerJoin: [
          { tabela: 'CONDICAO', condicao: 'COND_MOEDA.CODCOND = CONDICAO.CODCOND' },
        ],
        where: [`COND_MOEDA.MOEDA = '${moeda}'`],
        orderby: ['CONDICAO.NRPAR']
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));


      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $("#condicaoModalBody").html('<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="condicaoModalTable" ></table>');
      //cria a tabela usando os dados e colunas
      var table = $('#condicaoModalTable').DataTable({
        destroy: true,
        keys: true,
        lengthChange: false,
        filter: false,
        autoWidth: true,
        order: [],
        "data": jsonStr,
        "columns": dataSetCols,
      });

      $('#txtMoedaSelecionada').html($(`#txtMoeda-${tipo}-${deposito}`).val());
      $('#txtSaldoPedido').html(formataEmReais(parseFloat($(`#txtValorPedido-${tipo}-${deposito}`).val())));


      table.rows().every(function () {
        var data = this.data();
        const pintaVermelho = data.VALOR_MINIMO > data.VALOR_PARCELA; // Supondo que a coluna de valor seja a segunda (índice 1)

        if (pintaVermelho) {
          $(this.node()).css('color', '#c43434'); // Muda a cor da linha para vermelho
          $(this.node()).addClass('disabled')
        } else {
          $(this.node()).css('color', 'var(--textDesconto)'); // Muda a cor do texto pra verde
        }
      });


      // desenha a seleção do registro clicaco
      $('#condicaoModalTable tbody').on('click', 'tr', function (e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) {
          return;
        }

        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
        } else {
          table.$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          const data = $('#condicaoModalTable').DataTable().row('.selected').data();


          $('#txtSaldoMinimoCondicao').html(formataEmReais(data.VALOR_MINIMO ? data.VALOR_MINIMO : 0));
        }
      });

      // duplo click faz escolher o registro e fechar a pesquisa
      $('#condicaoModalTable tbody').on('dblclick', 'tr', function (e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) {
          msgAlerta('Parcela precisa ser maior que o valor mínimo!')
          return;
        }
        document.firstElementChild.style.zoom = "reset";
        table.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        $("#condicaoModalSelecionar").click();
      });

      // botão selecionar
      $("#condicaoModalSelecionar").unbind('click');
      $("#condicaoModalSelecionar").click(function () {
        var data = $('#condicaoModalTable').DataTable().row('.selected').data();
        if (data && data['CODCOND'].toString() && data['DESCRICAO'].toString()) {
          insereValor(txtCod, data['CODCOND'].toString(), data['DESCRICAO'].toString());
          $("#condicaoModal").modal("hide");
        }
      });
      $('#condicaoModal').modal('show')
    }

    async function criaModalItensPedido() {
      const itens = {
        Itens: pedido.tiposPedidos[tipo.toLowerCase()][deposito].itens.map((item) => ({
          Codigo: item.codigo,
          Cor: item.cor,
          Estoque: item.deposito,
          Ordem_Compra: item.ordem_compra,
          Preco: item.preco,
          Quantidade: item.qtde,
          Total: TruncaDecimaisNova(2, (item.preco * item.qtde) - parseFloat(item.desc_item)),
          Desc_Item: parseFloat(item.desc_item),
        })),
      };

      const json = await retornaItensCarrinho(itens);

      $("#itensPedidoModalBody").html(`<table style="width:100%" width="100%" cellpadding="0" cellspacing="0" border="0" class="table table-select table-hover table-sm table-condensed" id="itensPedidoModalTable"></table>`);
      //cria a tabela usando os dados e colunas
      var table = $('#itensPedidoModalTable').DataTable({
        destroy: true,
        keys: true,
        lengthChange: false,
        filter: false,
        autoWidth: true,
        order: [],
        "data": json.itens,
        "columns": dataSetColsItensPedido,
      });

      $('#itensPedidoModal').modal('show')
    }

    $('#itensPedidoModalFechar').on('click', function () {
      $('#itensPedidoModal').modal('hide')
    })

    $(`#txtMoeda-${tipo}-${deposito}`).on('blur', async function () {
      const moeda = $(this).attr('data-chave') ?? '';
      $(`#txtCondPagamento-${tipo}-${deposito}`).val('');
      $(`#btn-CondPagamento-${tipo}-${deposito}`).off();
      $(`#btn-CondPagamento-${tipo}-${deposito}`).unbind('pesquisa');

      $(`#btn-CondPagamento-${tipo}-${deposito}`).on('click', async function () {
        await criaModalCondicoes(`#txtCondPagamento-${tipo}-${deposito}`, moeda);
      });

      $(`#btn-limpa-CondPagamento-${tipo}-${deposito}`).on('click', () => {
        limpaValor(`#txtCondPagamento-${tipo}-${deposito}`)
      });

      $(`#txtCondPagamento-${tipo}-${deposito}`).prop('disabled', false);
      $(`#btn-CondPagamento-${tipo}-${deposito}`).prop('disabled', false);
      $(`#btn-limpa-CondPagamento-${tipo}-${deposito}`).prop('disabled', false);

      if ((moeda) || (moeda != '')) {
        await SaidaMoeda(moeda, deposito);
      }

      await validaStatusPedido(pedido.tiposPedidos[tipo.toLowerCase()][deposito], tipo, deposito);
    });

    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).on('blur', async function () {
      const parametroDataEntrega = await CopiaParametro('PEDIDOB2B', 8);
      if (parametroDataEntrega == 1) {
        const dataEntrega = $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val();
        const dataFatura = $(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`).val();
        if (dataEntrega !== '' && dataEntrega <= dataFatura) {
          msgAlerta('Campo Entrega não pode ser menor ou igual à data prevista de faturamento!');
          $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val('');
          return false;
        }
      }
    });

    async function preencheEnderecosEntrega() {
      try {
        const url = '/sisplan/pedidob2b/v1/dadosentregacliente?';
        const filtros = `CODCLI=${pedido.cliente.codCli}`
        const response = await requisicao('GET', url, filtros);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        const complemento = jsonStr[0].COMPLEMENTO != '' ? `- ${jsonStr[0].COMPLEMENTO}` : '';
        $(`#txtEnderecoEntidade-${tipo}-${deposito}`).val(`${jsonStr[0].ENDERECO}, ${jsonStr[0].NUMERO} ${complemento}`);
        $(`#txtComplementoEntidade-${tipo}-${deposito}`).val(jsonStr[0].COMPLEMENTO);
        $(`#txtNumeroEntidade-${tipo}-${deposito}`).val(jsonStr[0].NUMERO);
        $(`#txtBairroEntidade-${tipo}-${deposito}`).val(jsonStr[0].BAIRRO);
        $(`#txtCepEntidade-${tipo}-${deposito}`).val(jsonStr[0].CEP);
        $(`#txtCidadeEstadoEntidade-${tipo}-${deposito}`).val(jsonStr[0].CIDADE_NOME + ' / ' + jsonStr[0].COD_UF);

        const complementoEntrega = jsonStr[0].COMP_ENT != '' ? `- ${jsonStr[0].COMP_ENT}` : '';
        $(`#txtEnderecoEntrega-${tipo}-${deposito}`).val(`${jsonStr[0].END_ENT}, ${jsonStr[0].NUM_ENT} ${complementoEntrega}`);
        $(`#txtComplementoEntrega-${tipo}-${deposito}`).val(jsonStr[0].COMP_ENT);
        $(`#txtNumeroEntrega-${tipo}-${deposito}`).val(jsonStr[0].NUM_ENT);
        $(`#txtBairroEntrega-${tipo}-${deposito}`).val(jsonStr[0].BAIRRO_ENT);
        $(`#txtCepEntrega-${tipo}-${deposito}`).val(jsonStr[0].CEP_ENT);
        $(`#txtCidadeEstadoEntrega-${tipo}-${deposito}`).val(jsonStr[0].CIDADE_NOME_ENT + ' / ' + jsonStr[0].COD_UF_ENT);

        const complementoCobranca = jsonStr[0].COMP_COB != '' ? `- ${jsonStr[0].COMP_COB}` : '';
        $(`#txtEnderecoCobranca-${tipo}-${deposito}`).val(`${jsonStr[0].END_COB}, ${jsonStr[0].NUM_COB} ${complementoCobranca}`);
        $(`#txtComplementoCobranca-${tipo}-${deposito}`).val(jsonStr[0].COMP_COB);
        $(`#txtNumeroCobranca-${tipo}-${deposito}`).val(jsonStr[0].NUM_COB);
        $(`#txtBairroCobranca-${tipo}-${deposito}`).val(jsonStr[0].BAIRRO_COB);
        $(`#txtCepCobranca-${tipo}-${deposito}`).val(jsonStr[0].CEP_COB);
        $(`#txtCidadeEstadoCobranca-${tipo}-${deposito}`).val(jsonStr[0].CIDADE_NOME_COB + ' / ' + jsonStr[0].COD_UF_COB);

        // $(`#txtEnderecoPersonalizado-${tipo}-${deposito}`).val(jsonStr[0].CLI_END);
        // $(`#txtNumeroPersonalizado-${tipo}-${deposito}`).val(jsonStr[0].CLI_NUM);
        // $(`#txtBairroPersonalizado-${tipo}-${deposito}`).val(jsonStr[0].CLI_BAIRRO);
        // $(`#txtComplementoPersonalizado-${tipo}-${deposito}`).val(jsonStr[0].CLI_COMPL);
        // $(`#txtCEPPersonalizado-${tipo}-${deposito}`).val('');
        // if (jsonStr[0].CLI_CEP != '') {
        //   insereValor(`#txtCEPPersonalizado-${tipo}-${deposito}`, jsonStr[0].CLI_CEP, jsonStr[0].CIDADE_NOME_PED);
        // }
        // $(`#txtCidadeEstadoPersonalizado-${tipo}-${deposito}`).val(jsonStr[0].CIDADE_NOME_PED + ' / ' + jsonStr[0].COD_UF_PED);

        $(`#txtDDD-${tipo}-${deposito}`).val(jsonStr[0].CLI_DDD);
        $(`#txtTelefone-${tipo}-${deposito}`).val(jsonStr[0].CLI_FONE);
        $(`#txtInscricao-${tipo}-${deposito}`).val(jsonStr[0].INSCRICAO);
        $(`#txtRecebedor-${tipo}-${deposito}`).val(jsonStr[0].CLI_RECEBEDOR);

        if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].itens.length > 0) {
          if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].tipoEndereco) {
            if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].tipoEndereco == 'entidade') {
              $(`#radioEndEntidade-${tipo}-${deposito}`).prop('checked', true);
            }
            if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].tipoEndereco == 'entrega_entidade') {
              $(`#radioEntregaEntidade-${tipo}-${deposito}`).prop('checked', true);
            }
            if (pedido.tiposPedidos[tipo.toLowerCase()][deposito].tipoEndereco == 'cobranca') {
              $(`#radioCobrancaEntidade-${tipo}-${deposito}`).prop('checked', true);
            }
            $(`#txtDDD-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].cli_ddd);
            $(`#txtTelefone-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].cli_fone);
            // $(`#txtInscricao-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].INSCRICAO);
            $(`#txtRecebedor-${tipo}-${deposito}`).val(pedido.tiposPedidos[tipo.toLowerCase()][deposito].cli_recebedor);
            $(`#txtTelefone-${tipo}-${deposito}`).prop(`disabled`, true);
            $(`#txtDDD-${tipo}-${deposito}`).prop(`disabled`, true);
            $(`#txtRecebedor-${tipo}-${deposito}`).prop(`disabled`, true);
          }
        }
      } catch (error) {
        msgErro('Erro na rotina buscaDadosEntrega: ' + error.message);
      }
    }

    await preencheEnderecosEntrega();

    function retornaDadosEntregaCliente() {
      const retorno = {
        cli_cep: '',
        cli_end: '',
        cli_num: '',
        cli_compl: '',
        cli_bairro: '',
        cli_ddd: pegaValor(`#txtDDD-${tipo}-${deposito}`),
        cli_fone: pegaValor(`#txtTelefone-${tipo}-${deposito}`),
        cli_recebedor: pegaValor(`#txtRecebedor-${tipo}-${deposito}`),
        tipoEndereco: ''
      };

      if (isChecked(`#radioEndEntidade-${tipo}-${deposito}`)) {
        retorno.cli_end = pegaValor(`#txtEnderecoEntidade-${tipo}-${deposito}`);
        retorno.cli_compl = pegaValor(`#txtComplementoEntidade-${tipo}-${deposito}`);
        retorno.cli_num = pegaValor(`#txtNumeroEntidade-${tipo}-${deposito}`);
        retorno.cli_bairro = pegaValor(`#txtBairroEntidade-${tipo}-${deposito}`);
        retorno.cli_cep = pegaValor(`#txtCepEntidade-${tipo}-${deposito}`);
        retorno.tipoEndereco = 'entidade';
      } else if (isChecked(`#radioEntregaEntidade-${tipo}-${deposito}`)) {
        retorno.cli_end = pegaValor(`#txtEnderecoEntrega-${tipo}-${deposito}`);
        retorno.cli_compl = pegaValor(`#txtComplementoEntrega-${tipo}-${deposito}`);
        retorno.cli_num = pegaValor(`#txtNumeroEntrega-${tipo}-${deposito}`);
        retorno.cli_bairro = pegaValor(`#txtBairroEntrega-${tipo}-${deposito}`);
        retorno.cli_cep = pegaValor(`#txtCepEntrega-${tipo}-${deposito}`);
        retorno.tipoEndereco = 'entrega_entidade';
      } else if (isChecked(`#radioCobrancaEntidade-${tipo}-${deposito}`)) {
        retorno.cli_end = pegaValor(`#txtEnderecoCobranca-${tipo}-${deposito}`);
        retorno.cli_compl = pegaValor(`#txtComplementoCobranca-${tipo}-${deposito}`);
        retorno.cli_num = pegaValor(`#txtNumeroCobranca-${tipo}-${deposito}`);
        retorno.cli_bairro = pegaValor(`#txtBairroCobranca-${tipo}-${deposito}`);
        retorno.cli_cep = pegaValor(`#txtCepCobranca-${tipo}-${deposito}`);
        retorno.tipoEndereco = 'cobranca';
      }

      return retorno;
    }

    function validaEnderecoPreenchido() {
      if ((!isChecked(`#radioCobrancaEntidade-${tipo}-${deposito}`)) && (!isChecked(`#radioEntregaEntidade-${tipo}-${deposito}`)) && (!isChecked(`#radioEndEntidade-${tipo}-${deposito}`))) {
        return false
      }
      return true
    }

    async function validaCamposPreenchidos(tipo, deposito) {
      if (pegaChave(`#txtTransportadora-${tipo}-${deposito}`) == '') {
        msgAlerta('Campo Transportadora não preenchido!');
        return false;
      }
      // if ($(`#txtGrupoPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Grupo Pedido não preenchido!');
      //   return false;
      // }
      if ($(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`).val() == '') {
        msgAlerta('Campo de Fatura Prevista não preenchido!');
        return false;
      }


      // if ($(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo de Entrega Prevista não preenchido!');
      //   return false;
      // }
      // if ($(`#txtFrete-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Frete não preenchido!');
      //   return false;
      // }

      if ($(`#selectEmpFaturamento-${tipo}-${deposito}`).val() == '') {
        msgAlerta('Campo Empresa Faturamento não preenchido!');
        return false;
      }
      // if ($(`#txtTipoPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Tipo do Pedido não preenchido!');
      //   return false;
      // }
      // if ($(`#txtStatusPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Status do Pedido não preenchido!');
      //   return false;
      // }
      // if ($(`#txtEntradaPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Entrada não preenchido!');
      //   return false;
      // }
      // if ($(`#txtSaldoPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Saldo não preenchido!');
      //   return false;
      // }
      // if ($(`#txtValorPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Valor Pedido não preenchido!');
      //   return false;
      // }

      if ($(`#txtMoeda-${tipo}-${deposito}`).val() == '') {
        msgAlerta('Campo Moeda não preenchido!');
        return false;
      }
      if ($(`#txtCondPagamento-${tipo}-${deposito}`).val() == '') {
        msgAlerta('Campo Condição de Pagamento não preenchido!');
        return false;
      }

      let tipoPedido = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO", "camposSelect": ["ID_TIPO, DESCRICAO, PED_BENEFICIAR"], "where": ["ID_TIPO = '${pegaChave(`#txtTipoPedido-${tipo}-${deposito}`)}'"] }`);

      //Verifica se da tabela TIPO é PED_BENEFICIAR = 'S'
      if (tipoPedido[0].PED_BENEFICIAR == 'S') {
        if ($(`#txtDesigner-${tipo}-${deposito}`).val() == '') {
          msgAlerta('Campo Designer não preenchido.');
          return false;
        }
      }

      if (!validaEnderecoPreenchido()) {
        msgAlerta('Nenhum endereço de entrega preenchido!');
        $(`#enderecoEntregaPedido-${tipo}-${deposito} .collapseEnderecoEntregas`).trigger('click')
        return false;
      }

      // if ($(`#txtCondEspecial-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Condição especial não preenchido!')
      //   return false;
      // }
      // if ($(`#txtOperacaoFiscal-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Operação fiscal não preenchido!')
      //   return false;
      // }
      // if ($(`#textDescricaoPedido-${tipo}-${deposito}`).val() == '') {
      //   msgAlerta('Campo Descrição não preenchido!')
      //   return false;
      // }

      const parametroDataEntrega = await CopiaParametro('PEDIDOB2B', 8);
      if (parametroDataEntrega == 1) {
        const dataEntrega = $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val();
        const dataFatura = $(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`).val();
        if (dataEntrega !== '' && dataEntrega <= dataFatura) {
          msgAlerta('Campo Entrega não pode ser menor ou igual à data prevista de faturamento!');
          $(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`).val('');
          return false;
        }
      }

      return true;
    }

    async function retornaCondPagto(tipo, deposito) {
      function diferencaDias(data1, data2) {
        const diferenca = Math.abs(data1.getTime() - data2.getTime());
        const result = Math.ceil(diferenca / (1000 * 60 * 60 * 24));
        return result;
      };

      let array_cond = []
      let dias;
      const codCond = pegaChave(`#txtCondPagamento-${tipo}-${deposito}`)
      const infoCond = await buscaValor('CONDICAO', ['PRAZOINI', 'NRPAR', 'NRDIA'], 'CODCOND', codCond);
      const numeroDias = infoCond.PRAZOINI - infoCond.NRDIA;
      const valor = TruncaDecimaisNova(2, parseFloat($(`#txtValorPedido-${tipo}-${deposito}`).val()) / infoCond.NRPAR);
      const dtVencto = pegaValor(`#txtDtVencimentoParcela-${tipo}-${deposito}`).split('-');
      // const dtVencto = $(`#txtDtVencimentoParcela-${tipo}-${deposito}`).val()
      let vencto = new Date(dtVencto[0], dtVencto[1] - 1, parseInt(dtVencto[2]) + numeroDias, 23, 59, 59);

      for (let i = 0; i < infoCond.NRPAR; i++) {
        const data = retornaDataPraFrente(new Date(vencto), infoCond.NRDIA * (i + 1));
        dias = diferencaDias(new Date(data), new Date())
        array_cond.push({
          dias,
          dt_vencto: data,
          moeda: pegaChave(`#txtMoeda-${tipo}-${deposito}`),
          codcond: codCond,
          valor: valor,
          tipo: 'P',
          numero: pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero,
          ordem: i + 1,
        })

      }
      return array_cond
    }

    async function pegaValoresPedido(tipo, deposito) {
      const infoMoeda = await retornaInformacaoMoeda(pegaChave(`#txtMoeda-${tipo}-${deposito}`), pegaValor(`#selectEmpFaturamento-${tipo}-${deposito}`))
      const codcond = pegaChave(`#txtCondPagamento-${tipo}-${deposito}`)
      const descricaoAuxCondicao = await retornaDescAuxCondicao(codcond);
      const dadosEntregaCliente = retornaDadosEntregaCliente();

      let numero = pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero;
      if ((!numero) || (numero == '')) {
        numero = pedido.tiposPedidos[tipo.toLowerCase()][deposito].numero = await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5);
      }

      // let pgto = descricaoAuxCondicao;
      // if (pegaDescricao(`#txtCondPagamento-${tipo}-${deposito}`).includes('DIAS') || pegaDescricao(`#txtCondPagamento-${tipo}-${deposito}`).includes('VISTA')) {
      //   pgto = pegaChave(`#txtCondPagamento-${tipo}-${deposito}`);
      // } else {
      // descricaoAuxCondicao.forEach((parcela) => { if (parcela == 0) { pgto += parcela + '  ' } else { if (parcela.length >= 3) { pgto += parcela } else { pgto += parcela + ' ' } } });
      // }

      const pedidos = {
        numero: numero,
        codcli: pedido.cliente.codCli,
        cli_cep: dadosEntregaCliente.cli_cep,
        cli_end: dadosEntregaCliente.cli_end,
        cli_num: dadosEntregaCliente.cli_num,
        cli_compl: dadosEntregaCliente.cli_compl,
        cli_bairro: dadosEntregaCliente.cli_bairro,
        cli_ddd: dadosEntregaCliente.cli_ddd,
        cli_fone: dadosEntregaCliente.cli_fone,
        cli_recebedor: dadosEntregaCliente.cli_recebedor,
        tipoEndereco: dadosEntregaCliente.tipoEndereco,
        responsavel: pedido.responsavel,
        codrep: pedido.vendedor,
        coordenador: pedido.coordenador,
        designer: pedido.designer,
        id_contato: pedido.formaContato,
        periodo: '00',
        periodoprod: '00',
        colecao: '00',
        tela: 'VenPedSimples4',
        cond_pagto: pegaChave(`#txtCondPagamento-${tipo}-${deposito}`),
        pgto: descricaoAuxCondicao.DESCRICAO_AUX,
        tipo: 'P',
        redesp_cif: 'P',
        qualidade: '1',
        bloqueio: await retornaValidacaoComercial(pedido.tiposPedidos[tipo.toLowerCase()][deposito]) ? '0' : '1',
        financeiro: await retornaValidacaoFinanceiro(tipo, deposito) ? '0' : '1',
        tab_pre: pedido.tabela,
        emp_id: getCookie('emp_id'),
        historico: await retornaHistoricoMoeda(pegaChave(`#txtMoeda-${tipo}-${deposito}`)),
        deposito: tipo == 'PROGRAMADO' ? '9901' : deposito,
        dt_emissao: pedido.data,
        dtdigita: formataDateTimeBackEnd(pedido.dataInicio),
        dt_inicio: pedido.dataInicio,
        emp_fat: pegaValor(`#selectEmpFaturamento-${tipo}-${deposito}`),
        grupo: pegaChave(`#txtGrupoPedido-${tipo}-${deposito}`),
        status: pegaChave(`#txtStatusPedido-${tipo}-${deposito}`),
        tab_trans: pegaChave(`#txtTransportadora-${tipo}-${deposito}`),
        dt_fatura: pegaValor(`#txtDtFaturaFinalizaPedido-${tipo}-${deposito}`),
        dt_vencimentoParcela: pegaValor(`#txtDtVencimentoParcela-${tipo}-${deposito}`),
        id_tipo: pegaChave(`#txtTipoPedido-${tipo}-${deposito}`),
        operacao: pegaChave(`#txtOperacaoFiscal-${tipo}-${deposito}`),
        obs: pegaValor(`#textDescricaoPedido-${tipo}-${deposito}`),
        cif: pegaValor(`#selectFrete-${tipo}-${deposito}`),
        frete: pegaValor(`#txtFrete-${tipo}-${deposito}`),
        dt_saida: pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`) == '' ? retornaDataMenosDias(new Date(), 1) : pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`),
        entrega: pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`) == '' ? retornaDataMenosDias(new Date(), 1) : pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`),
        dt_orig_entrega: pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`) == '' ? retornaDataMenosDias(new Date(), 1) : pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}-${deposito}`),
        moeda: pegaChave(`#txtMoeda-${tipo}-${deposito}`),
        conta: infoMoeda.CONTA,
        banco: infoMoeda.BANCO,
        sit_dup: infoMoeda.CODSIT,
        classe_ger: infoMoeda.CLASSE,
        val_entrada: $(`#txtEntradaPedido-${tipo}-${deposito}`).val() == '' ? 0 : parseFloat($(`#txtEntradaPedido-${tipo}-${deposito}`).val()),
        cond_pagtos: await retornaCondPagto(tipo, deposito),
        itens: pedido.tiposPedidos[tipo.toLowerCase()][deposito].itens.map((item) => { return { ...item, deposito: tipo == 'PROGRAMADO' ? '9901' : deposito, ped_cli: tipo == 'PROGRAMADO' ? deposito : '' } }),
        tipo_venda: 'A',
        codusuario: sessionStorage.getItem('cod_usuario'),
        desconto: 0,
        numatendimento: $('#txt_atendimento_atual').html(),
        ped_cli: tipo == 'PROGRAMADO' ? deposito : '',
        comprador: 'SISPLAN_WEB_B2B',
        designer: pegaChave(`#txtDesigner-${tipo}-${deposito}`),
      };

      return pedidos;
    }

    $(`#btnAbrirItensPedido-${tipo}-${deposito}`).on('click', async () => {
      await criaModalItensPedido();
    })

    $(`#btnGravarPedido-${tipo}-${deposito}`).on('click', async () => {
      try {
        $.LoadingOverlay('show');
        const url = '/sisplan/pedidob2b/v1/pedidob2b?';
        if (!await validaCamposPreenchidos(tipo, deposito)) {
          return;
        }

        await validaStatusPedido(pedido.tiposPedidos[tipo.toLowerCase()][deposito], tipo, deposito);

        let pedidos = await pegaValoresPedido(tipo, deposito);

        if ((pedidos.id_tipo == '45') && (depositosMaisMix.includes(pedidos.deposito)) && (tipo == 'MAIS_MIX')) {
          const ordemCompra = await montaOrdemCompra(pedidos);
          const numeroOrdemCompraMaisMix = await gravaOrdemCompra(ordemCompra)
          pedidos = {
            ...pedidos,
            ped_cli: numeroOrdemCompraMaisMix,
          }
        }

        pedido.tiposPedidos[tipo.toLowerCase()][deposito] = {
          ...pedido.tiposPedidos[tipo.toLowerCase()][deposito],
          ...pedidos,
        };

        salvarBackupPedido(pedido.tiposPedidos[tipo.toLowerCase()][deposito])

        const response = await requisicao('POST', url, '', JSON.stringify(pedidos));

        if (!response) {
          msgErro('Erro ao gravar o pedido');
          return;
        }

        if (response.status != 200) {
          msgErro('Erro ao gravar o pedido');
          return;
        }

        pedido.tiposPedidos[tipo.toLowerCase()][deposito] = {
          ...pedidos,
          statusPedido: 'F',
        };

        toastr.success(
          `Pedido ${tipo === 'PRODUCAO' ? 'Produção' : tipo === 'PRONTA_ENTREGA' ? 'Pronta Entrega' : tipo === 'PROGRAMADO' ? 'Programado' : 'Mais Mix'} gravado com sucesso!`,
          'Confirmação',
          {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning',
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 2000,
            fadeOut: 1000,
            onHidden() {
              $('#btnItens').attr('disabled', true);
            },
          },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
        await montaJsonPedido();
        await salvarArquivoPedido();
        desabilitaCamposFinalizaPedido(tipo, deposito);
      } catch (error) {
        console.error(error);
      } finally {
        $.LoadingOverlay('hide');
      }
    });
  }

  const whereCliente = permiteConsultarClienteBloqueado == 0 ? [`CODREP = '${pegaChave('#txtVendedor')}' AND ATIVO = 'S'`] : `CODREP = '${pegaChave('#txtVendedor')}' AND ATIVO = 'S' AND BLOQUEIO = 'N'`

  const selectTxtCliente = {
    tabela: 'ENTIDADE',
    camposSelect: ['CODCLI CHAVE', "NOME ||' - '|| CNPJ DESCRICAO", 'CNPJ'],
    where: whereCliente,
  };

  const selectBtnCliente = {
    tabela: 'ENTIDADE',
    camposSelect: ['CODCLI', 'NOME', 'FANTASIA', 'CNPJ'],
    where: whereCliente,
  };

  $('#rodape').addClass('d-none');
  $('#btn-Vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ativo = \'S\'"] }', 'Pesquisa Representante', 'represen');
  $('#txtVendedor').autocompleta(1, 'JSON={ "tabela": "represen", "camposSelect": ["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = \'S\'"] }');
  $('#txtTabela').autocompleta(1, 'JSON={ "tabela": "regiao", "camposSelect": ["regiao chave", "descricao"], "where": null }');
  $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)} `, ['#txtCNPJ'], ['CNPJ'], ['CNPJ'], carregaDadosClientes);
  $('#txtResponsavel').autocompleta(1, 'JSON={ "tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null }');
  $('#txtFormaContato').autocompleta(1, `JSON={ "tabela": "TIPO_CONTATO", "camposSelect": ["codigo chave", "descricao descricao"], "where": ["TIPO = 'F' "] }`);
  $('#txtTpVenda').autocompleta(1, 'JSON={ "tabela": "TIPO", "camposSelect": ["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null }');
  $('#txtDesistencia').autocompleta(1, `JSON={ "tabela": "MENSAGEM", "camposSelect": ["CODMEN CHAVE, DESCRICAO DESCRICAO"], "where": ["TIPO = '20' "] }`);

  $('#txtCodigo').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], SaidaItem);

  $('#btn-FormaContato').pesquisa('#txtFormaContato', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "TIPO_CONTATO", "camposSelect": ["codigo", "descricao"], "where": ["TIPO = 'F' "]}`, 'Pesquisa CST PIS', 'TIPO_CONTATO');
  $('#btn-Responsavel').pesquisa('#txtResponsavel', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "PESSOAL", "camposSelect": ["CODIGO", "NOME"] }', 'Pesquisa Funcionário', 'PESSOAL');
  $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], JSON.stringify(selectBtnCliente), 'Pesquisa Cliente', carregaDadosClientes);
  $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao', '');
  $('#btn-TpVenda').pesquisa('#txtTpVenda', 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda', 'TIPO');
  $('#btn-Desistencia').pesquisa('#txtDesistencia', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO" ], "where": ["TIPO = '20' "]}`, 'Pesquisa Desistência', 'TIPO');

  $('#btn-limpa-cliente').on('click', () => {
    $('#txtCliente').val('');
    $('#txtCNPJ').val('');
    $('#txtLimiteCreditoCli').val(0);
    $('#txtLimiteCreditoConsignado').val(0);
    $('#txtCashbackCli').val('');
  });
  $('#btn-limpa-FormaContato').on('click', () => { $('#txtFormaContato').val(''); });
  $('#btn-limpa-vendedor').on('click', () => { $('#txtVendedor').val(''); });
  $('#btn-limpa-tabela').on('click', () => { $('#txtTabela').val(''); });
  $('#btn-limpa-Responsavel').on('click', () => { $('#txtResponsavel').val(''); });
  $('#btn-limpa-TpVenda').on('click', () => { $('#txtTpVenda').val(''); });
  $('#btn-limpa-Desistencia').on('click', () => { $('#txtDesistencia').val(''); });

  const tabelaItensMesa = $('#tabelaItensMesa').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '150px',
    // "data": keys,
    columns: dataSetColsItensMesa,
    columnDefs: [{
      targets: [4, 5, 6, 7, 8, 9, 10],
      visible: false,
    },
    {
      targets: [2],
      width: '250px',
    },
    ],
  });

  $('#tabelaCorAdicionarItem').DataTable({
    destroy: true,
    lengthChange: false,
    info: false,
    order: false,
    paging: false,
    filter: false,
    autoWidth: true,
    columns: dataSetColsCoresSelecionadas,
    colReorder: true,
    columnDefs: [{
      targets: [5, 6, 7, 8, 9, 10, 12, 13, 14, 15],
      visible: false,
    }],
  });

  const tabelaItensCompletos = $('#tabelaItensCompletos').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    columns: dataSetColsCoresItensCompletos,
  });


  $('#tabelaItensCompletos').addClass('d-none');

  const tabelaDesistenciaItem = $('#tabelaDesistenciaItem').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    autoWidth: true,
    columns: dataSetColsDesistenciaItem,
  });

  const tabelaCarrinho = $('#tabelaCarrinho').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    autoWidth: true,
    columns: dataSetColsCarrinho,
  });

  const tabelaInformativo = $('#tabelaInformativo').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    autoWidth: true,
    columns: dataSetColsInformativo,
  });

  async function verificaMaterialBase(codigo) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "CADMATTI", "camposSelect": ["CODIGO"], "where": ["CODIGO2 = '${codigo}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].CODIGO;
  }

  $('#tabelaCor tbody').on('click', 'td', function () {
    const table = $('#tabelaCor').DataTable();
    const data = table.row($(this).parents('tr')).data();
    const columnIndex = table.column(this).index();
    const columnName = table.row($(this).parents('tr')).init().columns[columnIndex].data;

    if (columnIndex > 4) {
      if ($(this).hasClass('selectedEstoque')) {
        $(this).removeClass('selectedEstoque');
        if (!$(this).parents('tr').children().hasClass('selectedEstoque')) {
          $(this).parents('tr').removeClass('selected');
        }
        table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
        if (columnName.split('_')[0] == 'COMPRA') {
          estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.ESTOQUE_SELECIONADO != columnName);
        } else {
          estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.ESTOQUE_SELECIONADO != columnName.split('_')[1]);
        }
      } else {
        $(this).parents('tr').addClass('selected');
        $(this).addClass('selectedEstoque');
        if (columnName.split('_')[0] == 'COMPRA') {
          estoquesSelecionados.push({ ...data, ESTOQUE_SELECIONADO: columnName })
        } else {
          estoquesSelecionados.push({ ...data, ESTOQUE_SELECIONADO: columnName.split('_')[1] })
        }
      }
    } else if ($(this).parents('tr').hasClass('selected')) {
      $(this).parents('tr').removeClass('selected');
      $(this).parents('tr').children().each(function () {
        if ($(this).hasClass('selectedEstoque')) {
          $(this).removeClass('selectedEstoque');
          if (data.COR) {
            estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.COR != data.COR);
          } else {
            estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.cor != data.cor);
          }
          table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
        }
      });
    } else {
      $(this).parents('tr').addClass('selected');
      table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
      if (data.COR) {
        estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.COR != data.COR);
      } else {
        estoquesSelecionados = estoquesSelecionados.filter(estoque => estoque.cor != data.cor);
      }
    }
  });

  async function carregaInformativos(tipo) {
    const url = '/sisplan/pedidob2b/v1/informativos?';
    const codcli = pegaChave('#txtCliente');

    if ($.fn.DataTable.isDataTable('#tabelaInformativo')) {
      $('#tabelaInformativo').DataTable().rows().remove().draw(false);
    }

    const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');

    const json = await response.json();

    if (json) {

      if (json[tipo]) {
        json[tipo].forEach((itens) => {
          $('#tabelaInformativo').DataTable().row.add(itens).draw(false);
        })
      }
    }
    $('#modal-informativo').modal('show');
    setTimeout(() => {
      $('#tabelaInformativo').DataTable().columns.adjust().draw(false);
    }, 500);
  }

  $('#btn-fecharInformativo').on('click', function () {
    $('#modal-informativo').modal('hide');
  })

  $('#btn-VerInformativoTitulosVencer').on('click', function () {
    carregaInformativos('titulosAVencer');
  })

  $('#btn-VerInformativoTitulosVencidos').on('click', function () {
    carregaInformativos('titulosVencidos');
  })

  $('#btn-VerInformativoGrupoVencer').on('click', function () {
    carregaInformativos('creditoGrupoAVencer');
  })

  $('#btn-VerInformativoGrupoVencidos').on('click', function () {
    carregaInformativos('creditoGrupoVencidos');
  })

  $('#btn-VerInformativoChequesVencer').on('click', function () {
    carregaInformativos('chequesAVencer');
  })

  $('#btn-VerInformativoChequesVencidos').on('click', function () {
    carregaInformativos('chequesVencidos');
  })

  $('#btn-VerInformativoCreditoAntecipacao').on('click', function () {
    carregaInformativos('creditoAEmberto');
  })

  $('#btn-VerInformativoPedidosPendentes').on('click', function () {
    carregaInformativos('pendenteAFaturar');
  })

  async function preencheCampoTipoVenda(cores, codigoBase) {

    $('#txtTpVenda').prop('disabled', true);
    $('#btn-TpVenda').prop('disabled', true);
    $('#btn-limpa-TpVenda').prop('disabled', true);
    // $('#txtTpVenda').attr('disabled', true);
    // $('#btn-TpVenda').attr('disabled', true);
    // $('#btn-limpa-TpVenda').attr('disabled', true);

    if (codigoBase != '') {
      $('#txtTpVenda').val('[34] - ATACADO PRODUÇÃO');
      $('#txtTpVenda').attr('data-selecionado', true);
      setarDataAtual('txtDtEntregaPrev', false, 7);
      return;
    }

    await Promise.all(cores.map(async (cor) => {
      if (cor.ESTOQUE_SELECIONADO.includes('COMPRA')) {
        $('#txtTpVenda').val('[33] - ATACADO PROGRAMADO');
        $('#txtTpVenda').attr('data-selecionado', true);
        const json = await retornaJsonPesquisaPadrao(`{ "tabela": "COMPRA", "camposSelect": ["DT_ENTREGA"], "where": ["NUMERO = '${cor[`CODIGO_${cor.ESTOQUE_SELECIONADO}`]}'"] } `);
        const dataRecebida = new Date(json[0].DT_ENTREGA);
        dataRecebida.setUTCHours(0);
        const deslocamentoFusoHorario = dataRecebida.getTimezoneOffset();
        dataRecebida.setMinutes(dataRecebida.getMinutes() + deslocamentoFusoHorario);
        setarDataPraFrente('txtDtEntregaPrev', dataRecebida, 5);
        return;
      }

      if (depositosMaisMix.includes(cor.ESTOQUE_SELECIONADO)) {
        $('#txtTpVenda').val('[45] - ATACADO - MAIS MIX');
        $('#txtTpVenda').attr('data-selecionado', true);
        return;
      }

      $('#txtTpVenda').val('[32] - ATACADO PRONTA ENTREGA');
      $('#txtTpVenda').attr('data-selecionado', true);

      setarDataAtual('txtDtEntregaPrev', false, 2);
    }));



    // isso tem que achar uma forma melhor pra controlar pois é uma regra exclusiva pra EXC pois foi desenvolvido inicialmente para eles.
    // 32 – ATACADO PRONTA ENTREGA - DATA DEVE SER A ATUAL + 2 DIAS
    // 33 – ATACADO PROGRAMADO - DATA DEVE SER A DATA ENTREGA DA OC + 5 DIAS
    // 34 – ATACADO PRODUÇÃO - DATA DEVE SER ATUAL + 7 DIAS
  }

  $('#btnFinalizarAtendimento').on('click', async () => {
    const avaliacaoObs = $('#avaliacao').val();
    if (avaliacaoObs.length < 15) {
      msgAlerta('Autoavaliação precisa ter no mínimo 15 caracteres');
      return;
    }

    if (!await finalizaAtendimento()) {
      msgErro('Erro ao finalizar o atendimento!');
      return;
    }

    const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
    await deletaDadosNaoSalvos(`${hostname}.txt`);

    toastr.success(
      'Atendimento Finalizado com Sucesso!',
      'Confirmação',
      {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning',
        },
        positionClass: 'toast-top-center',
        progressBar: true,
        timeOut: 2000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/pedidosb2b`;
          window.parent.$('#abrirTelaCheia').trigger('click')
        },
      },
    ).css({
      'margin-top': '20%',
      width: '500px',
      'max-width': '500px',
    });
  });

  $('#btnFinalizarPedido').on('click', async () => {
    $('#modalAutoAvaliacao').modal('show');
  });

  async function retornaInformacaoCores(cores) {
    const url = '/sisplan/pedidob2b/v1/infocorselecionada?';
    const response = await requisicao('POST', url, `CODIGOBASE=${cores.CodigoBase}`, JSON.stringify(cores));

    if (!response) {
      msgAlerta('Erro ao buscar informação dos itens!');
      return;
    }

    if (response.status != 200) {
      msgAlerta(response.mensagem);
      return;
    }

    const json = await response.json();

    return json;
  }

  async function abreModalAdicionarItens(coresSelecionadas) {

    $('#modalAdicionarItem').modal('show');
    const item = tabelaItensMesa.row('.selected').data();
    const comissao = await retornaJsonPesquisaPadrao(`{ "tabela": "represen", "camposSelect": ["COMISSAO"], "where": ["CODREP = '${pegaChave('#txtVendedor')}' "] } `);
    const jsonStr = await retornaJsonPesquisaPadrao(`{ "tabela": "tabpreco", "camposSelect": ["DESC_MAX"], "where": ["CODIGO = '${item.CODIGO}' "] } `);
    const materialBase = await verificaMaterialBase(item.CODIGO);
    await preencheCampoTipoVenda(coresSelecionadas, materialBase);
    $('#txtPercComissaoItens').val(`${comissao[0].COMISSAO}% `);
    $('#itemCodigoDescricao').html(`${item.CODIGO} - ${item.DESCRICAO} `);
    $('#itemDescMaximo').html(`${jsonStr.length > 0 && jsonStr[0].DESC_MAX ? `${jsonStr[0].DESC_MAX}%` : 'Não Possui'} `);
    const descMax = jsonStr.length > 0 && jsonStr[0].DESC_MAX ? jsonStr[0].DESC_MAX / 100 : 0;
    if ($.fn.DataTable.isDataTable('#tabelaCorAdicionarItem')) {
      $('#tabelaCorAdicionarItem').DataTable().rows().remove().draw(false);
    }
    const selecionadas = {
      Codigo: item.CODIGO,
      CodigoBase: materialBase,
      TabelaPreco: pegaChave('#txtTabela'),
      ItensSelecionados: coresSelecionadas.map((selecionada) => {
        return {
          COR: materialBase != '' ? selecionada.cor : selecionada.COR,
          ESTOQUE_SELECIONADO: selecionada.ESTOQUE_SELECIONADO.startsWith('COMPRA_') ? selecionada[`CODIGO_${selecionada.ESTOQUE_SELECIONADO}`] : selecionada.ESTOQUE_SELECIONADO,
          quantidadeEstoque: !selecionada.ESTOQUE_SELECIONADO.startsWith('COMPRA_') ? selecionada[`EST_${selecionada.ESTOQUE_SELECIONADO}`] : selecionada[selecionada['ESTOQUE_SELECIONADO']],
          ORDEM_COMPRA: selecionada.ESTOQUE_SELECIONADO.startsWith('COMPRA_'),
        }
      }),
    };

    const cores = await retornaInformacaoCores(selecionadas);
    await Promise.all(cores.itensSelecionados.map(async (itemCor) => {
      const valorDescMax = TruncaDecimaisNova(2, descMax != 0 ? itemCor.preco * descMax : 0);
      let valorEstoqueCompra = 0
      if (materialBase != '') {
        quantidadeEstoqueBase.push({
          qtde: itemCor.quantidadeEstoque,
          estoque: itemCor.estoque_Selecionado
        })
      }
      // quantidadeEstoqueBase = materialBase != '' ?  TruncaDecimaisNova(4, itemCor.quantidadeEstoque) : []
      if (cores.codigoBase != '') {
        $('#txtQuantidadeOrig').val(TruncaDecimaisNova(4, itemCor.quantidadeEstoque))
      }

      valorEstoqueCompra = itemCor.quantidadeEstoque

      // if (itemCor.ordem_Compra) {
      //   const pesquisaOrdemCompra = {
      //     tabela: 'CO_ITEN',
      //     camposSelect: [
      //       '(QTDE_B) BAIXADA',
      //     ],
      //     where: [`NUMERO = '${itemCor.estoque_Selecionado}' AND COR = '${itemCor.cor}'`],
      //   };
      //   const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaOrdemCompra))

      //   if (json) {
      //     if (json.length > 0) {
      //       valorEstoqueCompra = valorEstoqueCompra - json[0].BAIXADA
      //     }
      //   }
      // }

      adicionaCorTabelaCarrinho({
        COR: itemCor.cor,
        DESC_COR: itemCor.descricao,
        QTDE: '<input type="text" class="input-default focus form-control txtQuantidadeCor" value="1" style="max-width: 100px;" /> ',
        PRECO: itemCor.preco,
        VALOR_TOTAL: 0,
        QUANTIDADE_SELECIONADA: 0,
        QUANTIDADE_ESTOQUE: TruncaDecimaisNova(4, valorEstoqueCompra),
        ORDEM_COMPRA: itemCor.ordem_Compra,
        CODIGO_BASE: cores.codigoBase,
        CODIGO_ITEM: cores.codigo,
        ESTOQUE_SELECIONADO: itemCor.estoque_Selecionado,
        PRECO_MIN: TruncaDecimaisNova(2, itemCor.preco - valorDescMax),
        VALOR_DESCONTO: 0,
        PERC_DESCONTO: 0,
        PRECO_ORIG: itemCor.preco,
        QTDE_ORIG: itemCor.quantidadeEstoque,
        OPCOES: retornaBotaoOpcoesSelecionarCor(),
      });
    }));

    $('#modalOpcoesCorSelecionada').on('show.bs.modal', () => {
      setTimeout(() => {
        $('#txtPrecoItemNovo').focus();
      }, 500);
    });

    $('#tabelaCorAdicionarItem tbody').on('click', 'td>div .btnOpcoesCorSelecionada', async function () {
      try {
        const data = $('#tabelaCorAdicionarItem').DataTable().row($(this).parents('tr')).data();

        corSelecionada = this;
        $('#txtPrecoItem').val(data.PRECO);
        $('#txtPrecoItemNovo').val(data.PRECO);
        $('#txtPercDescontoItem').val(data.PERC_DESCONTO);
        $('#txtValorDescontoItem').val(data.VALOR_DESCONTO);
        $('#txtQuantidadeItemOp').val(data.QUANTIDADE_SELECIONADA);

        if (permiteAlterarPreco == 0) {
          $('#txtPrecoItemNovo').prop('disabled', true)
        }

        $('#txtQuantidadeItemOp').trigger('blur');
        $('#modalOpcoesCorSelecionada').modal('show');
      } catch (error) {
        console.error(error);
      }
    });

    $('#btnConfirmarOpcoes').on('click', function () {
      const data = $('#tabelaCorAdicionarItem').DataTable().row($(corSelecionada).parents('tr')).data();
      const preco = StringToFloatDef($('#txtPrecoItemNovo').val(), 0);
      const perc_desconto = StringToFloatDef($('#txtPercDescontoItem').val(), 0);
      const valor_desconto = StringToFloatDef($('#txtValorDescontoItem').val(), 0);
      const quantidade = StringToFloatDef($('#txtQuantidadeItemOp').val(), 1);

      if (preco <= 0) {
        msgAlerta('Preço precisa ser maior que 0!');
        return
      }

      if (data.CODIGO_BASE != '') {
        if (quantidade > (parseFloat($(data.QTDE).val()) + data.QUANTIDADE_ESTOQUE)) {
          msgAlerta(`Quantidade insuficiente no estoque.`);
          $('.txtQuantidadeCor').val(0);
          $('#txtQtdeCoresTotal').val(0);
          $('#txtQuantidadeItemOp').val(0);
          return;
        }
      }

      $('#tabelaCorAdicionarItem').DataTable().row($(corSelecionada).parents('tr')).data({
        ...data,
        QUANTIDADE_SELECIONADA: quantidade,
        PRECO: preco,
        QTDE: `<input type="text" value="${quantidade}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `,
        VALOR_TOTAL: TruncaDecimaisNova(2, preco * parseFloat(quantidade)),
        PERC_DESCONTO: perc_desconto,
        VALOR_DESCONTO: valor_desconto,
      }).draw(false);

      $('.txtQuantidadeCor').unbind('blur');
      $('.txtQuantidadeCor').on('blur', function () {
        SaidaCampoQuantidade(this);
      });

      CalculaValorTotalItens();

      $($('.txtQuantidadeCor')[0]).trigger('blur')
      $('#modalOpcoesCorSelecionada').modal('hide');
    });

    $('#txtValorDescontoItem').on('blur', () => {
      const preco = StringToFloatDef($('#txtPrecoItem').val(), 0);
      const valorDesconto = StringToFloatDef($('#txtValorDescontoItem').val(), 0);
      const totalItens = $('#txtTotalItemOpcoes').val();
      const percDesconto = 100 - ((preco - valorDesconto) / preco) * 100;
      $('#txtPercDescontoItem').val(TruncaDecimaisNova(2, percDesconto));

      if (valorDesconto > 0) {
        if (valorDesconto >= preco) {
          msgAlerta('Desconto não pode ser igual ou maior o valor do item!');
          return;
        }
      }
      $('#txtQuantidadeItemOp').trigger('blur');
    });

    $('#txtPrecoItemNovo').on('blur', () => {
      const preco = StringToFloatDef($('#txtPrecoItem').val(), 0);
      const precoNovo = StringToFloatDef($('#txtPrecoItemNovo').val(), 0);
      if (!(permiteAlterarPreco == 2)) {
        if (preco < precoNovo) {
          msgAlerta('Preço novo não pode ser maior que o preço original!');
          return;
        }
        $('#txtValorDescontoItem').val(TruncaDecimaisNova(2, preco - precoNovo));
        $('#txtValorDescontoItem').trigger('blur');
      }

    });

    $('#txtPercDescontoItem').on('blur', () => {
      const preco = StringToFloatDef($('#txtPrecoItem').val(), 0);
      const percDesconto = StringToFloatDef($('#txtPercDescontoItem').val(), 0) / 100;
      const valorDesconto = TruncaDecimaisNova(2, preco * percDesconto);
      $('#txtValorDescontoItem').val(valorDesconto);

      if (valorDesconto > 0) {
        if (valorDesconto >= preco) {
          msgAlerta('Desconto não pode ser igual ou maior o valor do item!');
          return;
        }
      }

      $('#txtQuantidadeItemOp').trigger('blur');
    });

    $('#txtQuantidadeItemOp').on('blur', () => {
      const quantidade = StringToFloatDef($('#txtQuantidadeItemOp').val(), 0);
      const desconto = StringToFloatDef($('#txtValorDescontoItem').val(), 0);
      const preco = StringToFloatDef($('#txtPrecoItem').val(), 0);

      $('#txtTotalItemOpcoes').val(TruncaDecimaisNova(2, ((preco - desconto) * quantidade)));
    });

    $('.txtQuantidadeCor').inputmask('numeric', {
      min: 0,
      positionCaretOnClick: 'select',
      digits: 2,
    }).on('focus', function () {
      const that = $(this);
      setTimeout(() => {
        that.select();
      }, 1);
    });
    $('#txtQuantidadeItemOp').inputmask('numeric', {
      min: 0,
      positionCaretOnClick: 'select',
      digits: 2,
    }).on('focus', function () {
      const that = $(this);
      setTimeout(() => {
        that.select();
      }, 1);
    });

    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').on('blur', function () {
      SaidaCampoQuantidade(this);
    });
  }

  $('#txtQtdeCoresTotal').on('blur', () => {
    const quantidade = StringToFloatDef($('#txtQtdeCoresTotal').val(), 0);

    if (quantidade < 0) {
      msgAlerta('Quantidade não pode ser negativa!');
      return;
    }

    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').each((i, t) => {
      $($('.txtQuantidadeCor')[i]).val(Number(quantidade));
      SaidaCampoQuantidade($($('.txtQuantidadeCor')[i]))
    });
  });

  function calcularDiferencas(dataBase, corEspecifica, quantidadeEspecifica) {
    let resultados = {
      porCor: {},
      totalPorEstoque: {}
    };

    dataBase.forEach(item => {
      let chaveUnica = `${item.COR}_${item.ESTOQUE_SELECIONADO}`;

      // Inicializar as entradas no objeto resultados se necessário
      if (!resultados.porCor[chaveUnica]) {
        resultados.porCor[chaveUnica] = {
          quantidadeSelecionada: 0,
          diferenca: 0
        };
      }
      if (!resultados.totalPorEstoque[item.ESTOQUE_SELECIONADO]) {
        resultados.totalPorEstoque[item.ESTOQUE_SELECIONADO] = 0;
      }

      // Calcular as quantidades e diferenças
      if (item.COR === corEspecifica) {
        let diferenca = quantidadeEspecifica - item.QUANTIDADE_SELECIONADA;
        resultados.porCor[chaveUnica].quantidadeSelecionada = quantidadeEspecifica;
        resultados.porCor[chaveUnica].diferenca = diferenca;
      } else {
        resultados.porCor[chaveUnica].quantidadeSelecionada = item.QUANTIDADE_SELECIONADA;
        resultados.porCor[chaveUnica].diferenca = 0;
      }

      // Somar ao total por estoque
      resultados.totalPorEstoque[item.ESTOQUE_SELECIONADO] += resultados.porCor[chaveUnica].quantidadeSelecionada;
    });

    return resultados;
  }


  function SaidaCampoQuantidade(item) {

    function AtualizaQuantidadeMaterialBase() {
      const dataBase = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
      const qtdeAlterada = Number($(item).val());
      const diferencaQuantidades = calcularDiferencas(dataBase, data.COR, qtdeAlterada);

      dataBase.forEach((cor, i) => {
        const chaveUnica = `${cor.COR}_${cor.ESTOQUE_SELECIONADO}`;
        if (data.ESTOQUE_SELECIONADO == cor.ESTOQUE_SELECIONADO) {

          if (data.COR == cor.COR) {
            $('#tabelaCorAdicionarItem').DataTable().row([i]).data({
              ...cor,
              QTDE: `<input type="text" value="${diferencaQuantidades.porCor[chaveUnica].quantidadeSelecionada}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `,
              QUANTIDADE_ESTOQUE: TruncaDecimaisNova(2, data.QTDE_ORIG - diferencaQuantidades.totalPorEstoque[cor.ESTOQUE_SELECIONADO]),
              QUANTIDADE_SELECIONADA: TruncaDecimaisNova(2, diferencaQuantidades.porCor[chaveUnica].quantidadeSelecionada),
              VALOR_TOTAL: TruncaDecimaisNova(2, cor.PRECO * diferencaQuantidades.porCor[chaveUnica].quantidadeSelecionada)
            }).draw(false);
          } else {
            $('#tabelaCorAdicionarItem').DataTable().row([i]).data({
              ...cor,
              QUANTIDADE_ESTOQUE: TruncaDecimaisNova(2, data.QTDE_ORIG - diferencaQuantidades.totalPorEstoque[cor.ESTOQUE_SELECIONADO]),
              QUANTIDADE_SELECIONADA: TruncaDecimaisNova(2, diferencaQuantidades.porCor[chaveUnica].quantidadeSelecionada),
              VALOR_TOTAL: TruncaDecimaisNova(2, cor.PRECO * StringToFloatDef($($('.txtQuantidadeCor')[i]).val(), 0))
            }).draw(false);
          }
        }
      })
    }

    function AtualizaQuantidadeMaterial() {
      data.QTDE = `<input type="text" value="${quantidade}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `;
      data.VALOR_TOTAL = TruncaDecimaisNova(2, data.PRECO * parseFloat(quantidade));
      data.QUANTIDADE_SELECIONADA = quantidade;

      $('#tabelaCorAdicionarItem').DataTable().row($(item).parents('tr')).data(data).draw(false);
    }

    var data = $('#tabelaCorAdicionarItem').DataTable().row($(item).parents('tr')).data();
    var quantidade = StringToFloatDef($(item).val(), 0);
    var total = 0;

    $('.txtQuantidadeCor').each((i, t) => {
      total += parseFloat(t.value == '' ? 0 : t.value);
    });

    if (data.CODIGO_BASE != '') {
      if (quantidade > (parseFloat($(data.QTDE).val()) + data.QUANTIDADE_ESTOQUE)) {
        msgAlerta(`Quantidade insuficiente no estoque.`);
        $('.txtQuantidadeCor').val(0);
        $('#txtQtdeCoresTotal').val(0);
        return;
      }
    }
    if (data.CODIGO_BASE != '') {
      AtualizaQuantidadeMaterialBase();
    } else {
      AtualizaQuantidadeMaterial();
    }

    if (parseFloat($('#infoprodMedia').val()) == 0) {
      $('#txtVolumePrevItens').val(0);
    } else {
      $('#txtVolumePrevItens').val(Number(TruncaDecimaisNova(2, total / parseFloat($('#infoprodMedia').val()))).toFixed(2));
    }

    CalculaValorTotalItens();

    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').on('blur', function () {
      SaidaCampoQuantidade(this);
    });

    $('.txtQuantidadeCor').inputmask('numeric', {
      min: 0,
      positionCaretOnClick: 'select',
    }).on('focus', function () {
      const that = $(this);
      setTimeout(() => {
        that.select();
      }, 1);
    });
  }

  $('#txtDescontoItens').on('blur', () => {
    const valorDesconto = StringToFloatDef($('#txtDescontoItens').val(), 0);
    const totalItens = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray()[0].PRECO_ORIG;
    const percDesconto = 100 - ((totalItens - valorDesconto) / totalItens) * 100;

    $('#txtPercDescontoItens').val(TruncaDecimaisNova(2, percDesconto));

    RecalculaPrecoItensDesc();
  });

  $('#txtPercDescontoItens').on('blur', () => {
    const percDesconto = StringToFloatDef($('#txtPercDescontoItens').val(), 0) / 100;
    const total = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray()[0].PRECO_ORIG;

    $('#txtDescontoItens').val(TruncaDecimaisNova(2, total * percDesconto));

    RecalculaPrecoItensDesc();
  });

  function RecalculaPrecoItensDesc() {
    const data = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
    const preco = data[0].PRECO_ORIG;
    const valor_desconto = StringToFloatDef($('#txtDescontoItens').val(), 0);
    const perc_desconto = StringToFloatDef($('#txtPercDescontoItens').val(), 0);

    if (preco <= 0) {
      msgAlerta('Preço precisa ser maior que 0!');
      return
    }


    data.forEach((cor, i) => {

      $('#tabelaCorAdicionarItem').DataTable().row([i]).data({
        ...cor,
        QTDE: `<input type="text" value="${$($('.txtQuantidadeCor')[i]).val()}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `,
        QUANTIDADE_SELECIONADA: TruncaDecimaisNova(2, $($('.txtQuantidadeCor')[i]).val()),
        PRECO: TruncaDecimaisNova(2, preco - valor_desconto),
        PERC_DESCONTO: perc_desconto,
        VALOR_DESCONTO: valor_desconto,
        VALOR_TOTAL: TruncaDecimaisNova(2, (preco - valor_desconto) * parseFloat($($('.txtQuantidadeCor')[i]).val())),
      }).draw(false);
    })


    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').on('blur', function () {
      SaidaCampoQuantidade(this);
    });

    CalculaValorTotalItens();


  }

  function CalculaValorTotalItens() {
    const total = $('#tabelaCorAdicionarItem').DataTable().column(5, {}).data().sum();
    const totalDescontoItens = StringToFloatDef($('#tabelaCorAdicionarItem').DataTable().column(12, {}).data().sum(), 0);
    const comissao = TruncaDecimaisNova(2, total * (StringToFloatDef($('#txtPercComissaoItens').val().split('%')[0], 0) / 100));

    $('#txtTotalItens').val(TruncaDecimaisNova(2, total).toFixed(2));
    $('#txtComissaoItens').val(comissao);
  }

  async function removeCorExistente(data) {
    const itens = $('#tabelaItensCompletos').DataTable();
    const rows = itens.rows().eq(0);
    for (let i = rows.length - 1; i >= 0; i--) {
      const index = rows[i];
      const rowData = itens.row(index).data();

      data.forEach((cor) => {
        if (rowData && rowData.COR === cor.COR) {
          itens.row(index).remove().draw();
        }
      });
    }

    $('#btnGravarItemPedido').trigger('click');
  }

  function adicionaCorTabelaCarrinho(itens) {
    $('#tabelaCorAdicionarItem').DataTable().row.add(itens).draw(false);
    const $scrollBody = $($('#tabelaCorAdicionarItem').DataTable().table().node()).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  }

  $('#btnGravarItemPedido').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const itensExistentes = [];
      const data = tabelaItensMesa.row('.selected').data();
      const dataCorAdd = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
      const dataItensCompletos = $('#tabelaItensCompletos').DataTable().rows().data().toArray();

      const semEstoque = dataCorAdd.filter((estoque) => estoque.QUANTIDADE_ESTOQUE < estoque.QUANTIDADE_SELECIONADA && estoque.CODIGO_BASE == '');
      const codigosSemEstoque = semEstoque.map((cor) => cor.COR).toString();

      dataCorAdd.forEach((cor) => {
        if (dataItensCompletos.filter((item) => item.COR == cor.COR && item.CODIGO_ITEM == cor.CODIGO_ITEM).length > 0) {
          itensExistentes.push(cor);
        }
      });

      if (itensExistentes.length > 0) {
        msgAlerta('Cor já existe na tabela, deseja substituir a quantidade?', async () => {
          await removeCorExistente(dataCorAdd);
        });
      }

      if (semEstoque.length > 0) {
        msgAlerta(`Quantidade insuficiente nas cores: ${codigosSemEstoque}. Selecione outro estoque ou diminua a quantidade.`);
        return;
      }

      await gravaCorItemMesa();
      tabelaItensMesa.row('.selected').data({ ...data, SITUACAO: '<div class="situacaoIcon"> <i class="fas fa-smile"></i></div> ', SITUACAO_CODIGO: 'F' });

      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
      atualizaTotaisPedido();
      $('#modalAdicionarItem').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaPrecoComissaoItem() {
    const codigo = $('#tabelaItensMesa').DataTable().row('.selected').data().CODIGO
    const pesquisa = {
      tabela: 'TABPRECO',
      camposSelect: [
        'REGIAO',
        'CODIGO',
        'DESC_PRODUTO',
        'PRECO_00 AS A',
        'COMISSAO AS A1',
        'PRECO_84 AS B',
        'COMISSAO_G AS B1',
        'PRECO_91 AS C',
        'COMISSAO_D AS C1'
      ],
      where: [`REGIAO = '${pegaChave('#txtTabela')}' AND CODIGO = '${codigo}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (jsonStr.length == 0) {
      return ''
    }

    return jsonStr[0]

  }

  async function gravaCorItemMesa() {
    try {
      const comissao = await retornaPrecoComissaoItem();
      let valorComissao = $('#txtComissaoItens').val()
      let percComissao = $('#txtPercComissaoItens').val().replaceAll('% ', '')
      const data = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
      const dataCor = $('#tabelaCor').DataTable().rows().data().toArray()

      data.forEach((cor) => {
        let valorDesconto = cor.VALOR_DESCONTO;

        if ((cor.PRECO < cor.PRECO_ORIG) && (valorDesconto === 0)) {
          valorDesconto = TruncaDecimaisNova(2, cor.PRECO_ORIG - cor.PRECO)
        }

        if (comissao) {
          const valorDescontado = TruncaDecimaisNova(2, cor.PRECO_ORIG - valorDesconto)

          if (valorDescontado <= comissao.A) {
            valorComissao = (valorDescontado * (comissao.A1 / 100) * cor.QUANTIDADE_SELECIONADA)
            percComissao = comissao.A1
            if (valorDescontado <= comissao.B) {
              valorComissao = (valorDescontado * (comissao.B1 / 100) * cor.QUANTIDADE_SELECIONADA)
              percComissao = comissao.B1
              if (valorDescontado <= comissao.C) {
                valorComissao = (valorDescontado * (comissao.C1 / 100) * cor.QUANTIDADE_SELECIONADA)
                percComissao = comissao.C1
              }
            }
          }
        }
        adicionaItensPedido({
          COR: cor.COR,
          VALOR_TOTAL: cor.VALOR_TOTAL,
          QTDE: cor.QUANTIDADE_SELECIONADA,
          PRECO: cor.PRECO,
          PRECO_ORIG: cor.PRECO_ORIG,
          QTDE_ORIG: cor.QTDE_ORIG,
          VALOR_DESC: valorDesconto,
          PERC_DESC: cor.PERC_DESCONTO,
          PRECO_COM: TruncaDecimaisNova(2, valorComissao),
          PERC_COMISSAO: TruncaDecimaisNova(2, percComissao),
          ESTOQUE: cor.ESTOQUE_SELECIONADO,
          CODIGO_BASE: cor.CODIGO_BASE,
          ORDEM_COMPRA: cor.ORDEM_COMPRA,
          CODIGO_ITEM: cor.CODIGO_ITEM,
        }, true);

        if (cor.CODIGO_BASE != '') {
          dataCor.forEach((dcor, i) => {
            $('#tabelaCor').DataTable().row([i]).data({
              ...dcor,
              [`EST_${cor.ESTOQUE_SELECIONADO}`]: TruncaDecimaisNova(2, cor.QTDE_ORIG - cor.QUANTIDADE_SELECIONADA)
            })
          })
        }
        $('#tabelaCor .selected').removeClass('selected');
        $('#tabelaCor .selectedEstoque').removeClass('selectedEstoque');
        estoquesSelecionados = []
      });
    } catch (error) {
      console.error(error);
    }
  }

  $('#modalAdicionarItem').on('show.bs.modal', () => {
    $('#txtTotalItens').val('0.00');
    $('#txtPercComissaoItens').val('0');
    $('#txtComissaoItens').val('0%');
    $('#txtDescontoItens').val('0.00');
    $('#txtQtdeCoresTotal').val('0');
    $('#txtPercDescontoItens').val('0%');
    $('#txtVolumePrevItens').val('0');
    limpaValor('#txtTpVenda');
  });

  $('#modalDesistir').on('show.bs.modal', () => {
    $('#tabelaDesistenciaItem').DataTable().rows().remove().draw(false);
    setTimeout(() => {
      $('#tabelaDesistenciaItem').DataTable().columns.adjust().draw(false);
    }, 500);
  });

  // window.addEventListener('beforeunload', (event) => {
  //   if (pedido.status != 'P') {
  //     const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
  //     deletaDadosNaoSalvos(`${hostname}.txt`);
  //   }
  // });

  $('#btnGravarCor').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const data = estoquesSelecionados;
      const estoqueVazio = data.filter((cor) => cor.ESTOQUE_SELECIONADO != '').length != data.length;
      const estoqueZerado = data.filter((estoque) => estoque[`EST_${estoque.ESTOQUE_SELECIONADO}`] == 0).length > 0;

      if (estoqueVazio) {
        msgAlerta('Cores com estoques não selecionados. Selecione o estoque clicando na coluna dele.');
        return;
      }

      if (estoqueZerado) {
        msgAlerta('Cores com estoques zerados. Selecione um estoque com quantidade.');
        return;
      }

      if (data.length == 0) {
        msgAlerta('Nenhuma cor selecionada!');
        return;
      }

      await abreModalAdicionarItens(data);
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'tr', async function () {
    try {
      $.LoadingOverlay('show');
      tabelaItensMesa.$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
      const data = tabelaItensMesa.row('.selected').data();
      const dados = [data.UNIDADE, data.GRAMATURA, data.PRECO, data.LARGURA, data.CODIGO];
      await preencheCamposInformacaoItem(dados);
      const codigoProdutoBase = await verificaMaterialBase(data.CODIGO);

      if (codigoProdutoBase) {
        await preencheTabelaCorItemBaseDigital(data.CODIGO, codigoProdutoBase);
      } else {
        await preencheTabelaCorItemNormal(data.CODIGO);
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaCoresItem(codigo, codigoBase) {
    const url = '/sisplan/pedidob2b/v1/coresitem?';
    const response = await requisicao('GET', url, `CODIGO=${codigo}&MATERIALBASE=${codigoBase}`, null);

    if (!response) {
      msgErro('Erro ao retornar estoque do item!');
      return;
    }
    if (response.status != 200) {
      msgErro('Erro ao retornar estoque do item!');
      return;
    }

    const jsonStr = await response.text();
    const json = JSON.parse(jsonStr.replaceAll('\r\n', ''));

    return json
  }


  async function retornaFantasiaDeposito(deposito) {
    if (deposito == '') {
      return '';
    }

    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "DEPOSITO", "camposSelect": ["FANTASIA"], "where": ["CODIGO = '${deposito}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].FANTASIA;
  }


  async function preencheTabelaCorItemBaseDigital(codigo, codigoBase) {
    const json = await retornaCoresItem(codigo, codigoBase);
    const dataItensCompletos = $('#tabelaItensCompletos').DataTable().rows().data().toArray().filter((comp) => comp.CODIGO_ITEM == codigo)[0] ?? [];

    const dataSetCols = [];
    estoquesSelecionados = []
    if (json.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaCor')) {
        $('#tabelaCor').DataTable().rows().remove().draw(false);
        $('#tabelaCor').DataTable().destroy();
        $('#tabelaCor thead tr').html(' ');
      }
      $('#btnGravarCor').addClass('d-none');

      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }

    if ($.fn.DataTable.isDataTable('#tabelaCor')) {
      $('#tabelaCor').DataTable().rows().remove().draw(false);
      $('#tabelaCor').DataTable().destroy();
      $('#tabelaCor thead tr').html(' ');
    }

    $('#btnGravarCor').removeClass('d-none');
    var cor = await buscaFoto(codigo, true);
    let novoObjeto = [];

    $.each(json, (index, objeto) => {
      if (objeto.estoques != null) {

        const depositos = objeto.estoques.reduce((resultado, estoque) => {
          resultado[`EST_${estoque.deposito}`] = TruncaDecimaisNova(4, dataItensCompletos.length == 0 ? estoque.quantidade : estoque.quantidade - dataItensCompletos.QTDE);
          return resultado;
        }, {});

        if (objeto.imagem == "000000000") {
          objeto.imagem = `<div class="corBase64" style="background-image: url('${cor}'); background-size: cover; width: 60px; height: 25px;"></div>`
        }
        objeto = $.extend(objeto, depositos);
        delete objeto.estoques;

        novoObjeto.push(objeto);
      }
    });

    if (novoObjeto.length == 0) {
      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }


    await Promise.all(Object.keys(novoObjeto[0]).map(async (k) => {
      k = { data: k, title: k.toUpperCase() }

      if (k.title.includes('EST_')) {

        const deposito = k.title.split('_')[1]
        const fantasia = await retornaFantasiaDeposito(deposito)
        k.title = fantasia == '' ? k.data : fantasia;
        k.title = k.title.replaceAll(' ', '_');
      }
      dataSetCols.push({
        'title': k.title,
        'data': k.data
      });
      // }
    }));

    $('#tabelaCor').DataTable({
      destroy: true,
      lengthChange: false,
      info: false,
      order: false,
      paging: false,
      scrollX: '250px',
      scrollY: '150px',
      autoWidth: true,
      colReorder: true,
      data: json,
      columns: dataSetCols,
      columnDefs: [{
        targets: [4],
        visible: false,
      }],
    });
    $($($('#tabelaCor_wrapper')[0]).children()[0]).css({ 'flex-direction': 'row-reverse' });
    $($($($('#tabelaCor_wrapper')[0]).children()[0]).children()[1]).addClass('d-flex justify-content-start');

    $('.corBase64').on('click', function () {
      $('.corMaterialPreview').attr('style', `background-image${$(this).attr('style').split('background-image')[1]}; background-size: cover; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
      $('#imagemodal').modal('show');
    });

    $('#imagemodal').on('hidden.bs.modal', () => {
      $('.corMaterialPreview').attr('style', '');

      $('.imagepreview').attr('src', '');
      $('.corBase64').on('click', function () {
        $('.corMaterialPreview').attr('style', `background-image${$(this).attr('style').split('background-image')[1]}; background-size: cover; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
        $('#imagemodal').modal('show');
      });
    })
  }

  async function preencheTabelaCorItemNormal(codigo) {
    const json = await retornaCoresItem(codigo, '');
    const depositosEmpresa = await buscaDepositoEmpresaUsuario(getCookie('cod_usuario'))
    estoquesSelecionados = [];
    let dataSetCols = [];
    const dataSetColsCompra = [];

    if (json.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaCor')) {
        $('#tabelaCor').DataTable().rows().remove()
          .draw(false);
        $('#tabelaCor').DataTable().destroy();
      }
      $('#btnGravarCor').addClass('d-none');
      return;
    }
    if ($.fn.DataTable.isDataTable('#tabelaCor')) {
      $('#tabelaCor').DataTable().rows().remove()
        .draw(false);
      $('#tabelaCor').DataTable().destroy();
      $('#tabelaCor thead tr').html(' ');
    }

    let novoObjeto = [];
    let colunaInvisivelCorMesa = [4, 5, 6]

    $.each(json, (index, item) => {
      const color = item.imagem.match(/(\d{3})/g).join('-').split('-');
      const novoItem = {
        COR: item.cor,
        DESCRICAO: item.descricao,
        IMAGEM: `<div class="corRGB" style="background-color: RGB(${color[0]},${color[1]}, ${color[2]}); width: 60px; height: 25px;"></div>`,
        TOTAL_EST: 0,
        CODIGO_COMPRA_1: '',
        CODIGO_COMPRA_2: '',
        CODIGO_COMPRA_3: '',
        COMPRA_1: 0,
        COMPRA_2: 0,
        COMPRA_3: 0,
      };

      if (item.ordemCompra != null) {
        $.each(item.ordemCompra, (index, ordem) => {
          novoItem[`COMPRA_${index + 1}`] = ordem.quantidade;
          novoItem[`CODIGO_COMPRA_${index + 1}`] = ordem.deposito;
        });
      }
      if (item.estoques != null) {
        $.each(item.estoques, (index, estoque) => {
          if (depositosEmpresa.includes(estoque.deposito)) {
            novoItem[`EST_${estoque.deposito}`] = TruncaDecimaisNova(4, estoque.quantidade);
            novoItem.TOTAL_EST = TruncaDecimaisNova(4, !depositosMaisMix.includes(estoque.deposito) ? novoItem.TOTAL_EST + estoque.quantidade : novoItem.TOTAL_EST + 0);
          }
        });
      }

      if ((item.ordemCompra != null) || ((item.estoques) && (item.estoques.filter((qtde) => qtde.quantidade > 0).length > 0))) {
        novoObjeto.push(novoItem);
      }
    });

    const semCompra = novoObjeto.filter((cor) => cor.COMPRA_1 + cor.COMPRA_2 + cor.COMPRA_3 > 0).length == 0;
    const keys = Object.values(novoObjeto);

    if (keys.length == 0) {
      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }

    const compras = Object.keys(keys[0]).filter((element) => element.startsWith('COMPRA_')); // separa as posições "COMPRA_1", "COMPRA_2" e "COMPRA_3"
    const resto = Object.keys(keys[0]).filter((element) => !element.startsWith('COMPRA_')); // separa o restante do array

    if (semCompra) {
      const keysInvisiveis = Object.keys(keys[0]).length;
      colunaInvisivelCorMesa = [4, 5, 6, keysInvisiveis - 3, keysInvisiveis - 2, keysInvisiveis - 1];
    }

    const titleTable = compras ? resto.concat(compras) : resto; // junta o restante do array com as posições "COMPRA_1", "COMPRA_2" e "COMPRA_3"

    await Promise.all(titleTable.map(async (k) => {
      k = { data: k, title: k.toUpperCase() }
      if (k.title.includes('EST_')) {

        const deposito = k.title.split('_')[1]
        const fantasia = await retornaFantasiaDeposito(deposito)
        k.title = fantasia == '' ? k.data : fantasia;
        k.title = k.title.replaceAll(' ', '_');
      }

      if ((k.title.includes('COMPRA_') && (!k.title.includes('CODIGO_COMPRA_')))) {
        dataSetColsCompra.push({
          'title': k.title,
          'data': k.data
        });
      } else {
        dataSetCols.push({
          'title': k.title,
          'data': k.data
        });
      }

      // }
    }));

    dataSetCols = dataSetCols.concat(dataSetColsCompra)

    $('#tabelaCor').DataTable({
      destroy: true,
      lengthChange: false,
      info: false,
      order: false,
      paging: false,
      scrollX: '250px',
      scrollY: '150px',
      autoWidth: true,
      colReorder: true,
      data: novoObjeto,
      columns: dataSetCols,
      columnDefs: [
        {
          targets: colunaInvisivelCorMesa,
          visible: false,
        },
        {
          render(data, type, row) {
            return `<span title="Número: ${row.CODIGO_COMPRA_1}">${data}</span>`
          },
          targets: dataSetCols.length - 3,
        }, {
          render(data, type, row) {
            return `<span title="Número: ${row.CODIGO_COMPRA_2}">${data}</span>`
          },
          targets: dataSetCols.length - 2,
        }, {
          render(data, type, row) {
            return `<span title="Número: ${row.CODIGO_COMPRA_3}">${data}</span>`
          },
          targets: dataSetCols.length - 1,
        }
      ],
    });
    $($($('#tabelaCor_wrapper')[0]).children()[0]).css({ 'flex-direction': 'row-reverse' });
    $($($($('#tabelaCor_wrapper')[0]).children()[0]).children()[1]).addClass('d-flex justify-content-start');

    $('#btnGravarCor').removeClass('d-none');

    $('.corRGB').on('click', function () {
      $('.corMaterialPreview').attr('style', `${$(this).attr('style').split(';')[0]}; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
      $('#imagemodal').modal('show');
    });


    $('#imagemodal').on('hidden.bs.modal', () => {
      $('.corMaterialPreview').attr('style', '');

      $('.imagepreview').attr('src', '');
      $('.corRGB').on('click', function () {
        $('.corMaterialPreview').attr('style', `${$(this).attr('style').split(';')[0]}; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
        $('#imagemodal').modal('show');
      });
    })


    await preencheDataEntrega(novoObjeto);
  }

  async function preencheDataEntrega(cores) {

    let codigosCompra = cores.map((cor) => {
      return {
        cor: cor.COR,
        codigos_compra: [cor.CODIGO_COMPRA_1, cor.CODIGO_COMPRA_2, cor.CODIGO_COMPRA_3]
      }
    })

    const ordensCompraPreenchidas = codigosCompra.map((cores) => {
      return cores.codigos_compra.filter((codigoCompra) => codigoCompra != '')
    });

    const ordens = ordensCompraPreenchidas.filter((codigoCompra) => codigoCompra.length > 0);
    const ordensConcat = ordens.reduce((arrayConcatenado, arrayAtual) => {
      return arrayConcatenado.concat(arrayAtual);
    }, []);
    const newordens = ordensConcat.filter((valor, indice, array) => array.indexOf(valor) === indice);

    await Promise.all(newordens.map(async (numero) => {
      const { DT_ENTREGA } = await buscaValor('COMPRA', 'DT_ENTREGA', 'NUMERO', numero);
      $('#tabelaCor tbody').find('td span').toArray().map((test) => {
        if (test.title.includes(numero)) {
          test.title = (test.title + ', Entrega: ' + formataDataBonita(DT_ENTREGA))
        }
      })
    }))

  }

  $('#tabelaItensMesa tbody').on('dblclick', 'tr', function () {
    event.preventDefault();
    document.firstElementChild.style.zoom = 'reset';
    tabelaItensMesa.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    $('#btn_confirmar_item').click();
  });

  const tabelaItens = $('#tabelaItens').dataTable({
    paging: true,
    lengthChange: false,
    filter: true,
    info: true,
    order: true,
    autoWidth: true,
    destroy: true,
  });

  $('#tabelaItens tbody').on('click', 'tr', function () {
    tabelaItens.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
  });

  $('.pop').on('click', function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
  });

  $('#imagemodal').on('hidden.bs.modal', () => {
    $('.imagepreview').attr('src', '');
  })
  async function buscaFoto(codigo, buscaFotoCor = false) {
    try {
      const url = '/sisplan/funcoes/v1/fotoitem?';
      const response = await requisicao('GET', url, `codigo=${codigo}`, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (!buscaFotoCor) {
        if (response.status != 200) {
          $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
          return;
        }

        const sBase64 = jsonStr;
        if ($('#tabelaItensMesa').DataTable().rows().count() == 0) {
          $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
        } else {
          $('#infoFotoItem').attr('src', `data:image/png;base64,${sBase64.mensagem}`);
        }
      } else {
        if (response.status != 200) {
          return;
        }

        const sBase64 = jsonStr;

        return `data:image/jpg;base64,${sBase64.mensagem}`
      }
    } catch (error) {
      console.error(error);
      $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
    }
  }

  $('#tabelaItens tbody').on('dblclick', 'tr', function () {
    event.preventDefault();
    document.firstElementChild.style.zoom = 'reset';
    tabelaItens.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    $('#btn_confirmar_item').click();
  });

  $('#btn_confirmar_item').on('click', async () => {
    try {
      $.LoadingOverlay('show');

      const data = tabelaItens.api().row('.selected').data();
      await preencheCamposInformacaoItem([data[2], data[4], data[3], data[5], data[0]]);
      await RotinaSaidaCodigo(data);
      atualizaTotaisPedido();

    } finally {
      $.LoadingOverlay('hide');
      $('#modalItem').modal('hide');
    }
  });

  async function retornaDadosMaterial(codigo) {
    const pesquisaParam = {
      tabela: 'MATERIAL',
      camposSelect: [
        'MATERIAL.CODIGO',
        'MATERIAL.DESCRICAO',
        'MATERIAL.UNIDADE',
        'TABPRECO.PRECO_00 PRECO',
        'MATERIAL.GRAMATURA',
        'MATERIAL.LARGURA',
      ],
      leftJoin: [
        { tabela: 'TABPRECO', condicao: `TABPRECO.CODIGO = MATERIAL.CODIGO AND REGIAO = '${pegaChave('#txtTabela')}'` },
      ],
      where: [`MATERIAL.ATIVO = 'S' AND MATERIAL.CODIGO = '${codigo}'`],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return ''
    }

    return jsonStr[0]

  }

  async function SaidaItem() {
    $.LoadingOverlay('show');
    setTimeout(async () => {
      try {
        const codigo = pegaChave('#txtCodigo');
        const dados = await retornaDadosMaterial(codigo);

        if (dados === '') {
          msgAlerta('Material não encontrado tente pesquisar de forma manual!');
          return;
        }

        await preencheCamposInformacaoItem([dados.UNIDADE, dados.GRAMATURA, dados.PRECO, dados.LARGURA, dados.CODIGO]);
        await RotinaSaidaCodigo([dados.CODIGO, dados.DESCRICAO, dados.UNIDADE, dados.PRECO, dados.GRAMATURA, dados.LARGURA, 'M']);
        atualizaTotaisPedido();

      } finally {
        $.LoadingOverlay('hide');
        $('#modalItem').modal('hide');
        limpaValor('#txtCodigo');
        $('#txtCodigo').focus();
      }
    }, 1000);
  };

  async function preencheCamposInformacaoItem(data) {
    await buscaFoto(data[4]);
    const emp_deposito = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const emp_maisMix = depositosMaisMix.split(',').map(valor => `'${valor}'`).join(',');
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MAT_ITEN", "camposSelect": ["SUM(QTDE) QTDE, COUNT(LOTE) LOTE"], "where": ["CODIGO = '${data[4]}' AND DEPOSITO IN (${emp_deposito}) AND DEPOSITO NOT IN (${emp_maisMix}) "] } `);
    const media = json[0].QTDE / json[0].LOTE
    $('#infoprodUnidade').val(data[0]);
    $('#infoprodGramatura').val(data[1]);
    $('#infoprodpreco').val(data[2]);
    $('#infoprodLargura').val(data[3]);
    $('#infoprodMedia').val(TruncaDecimaisNova(2, isNaN(media) ? 0 : media));
  }

  $('#txtCampoConsulta').keydown(function (e) {
    if (e.which === 13) {
      e.preventDefault();
      $('#btnConsultarItens').trigger('click');
    }
  });

  $('#btnConsultarItens').on('click', async () => {
    try {
      try {
        $.LoadingOverlay('show');
        let colunas = [];
        const dataSetCols = [];
        const bPesquisandoProduto = ($('#radioMaterial').is(':checked')) == false;
        const ajaxData = await montaSelectItens(bPesquisandoProduto);

        if (bPesquisandoProduto) {
          colunas = ['CODIGO', 'DESCRICAO', 'PRECO', 'TIPO'];
        } else {
          colunas = ['CODIGO', 'DESCRICAO', 'UNIDADE', 'PRECO', 'GRAMATURA', 'LARGURA', 'TIPO'];
        }

        for (let i = 0; i < colunas.length; i++) {
          dataSetCols.push({
            title: colunas[i],
            data: i,
          });
        }

        const tabelaItens = $('#tabelaItens').DataTable({
          paging: true,
          lengthChange: false,
          filter: true,
          info: true,
          order: true,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: 'GET',
            headers: {
              Authorization: BASIC_AUTH,
            },
            data: ajaxData,
          },
          columns: dataSetCols,
        });
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados dos itens.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btn-sair').on('click', async () => {
    msgConfirmacaoCancelarB2B(
      /* html */`
        Caso confirmar você irá perder o Pedido. Deseja realmente cancelar?
        <br/>
        <label for="motivoSaida">Informe o motivo do cancelamento</label>
        <textarea name="" class="input-default focus form-control" id="motivoSaida" cols="30" rows="5"></textarea>
        <span style="color: rgb(206, 51, 51); font-size: 14px; margin-top: -4px" class="d-none informeCancelamento">Informe o motivo do cancelamento!</span>
      `,
      [
        async () => {
          await cancelaAtendimento();
        },
      ]
    );
  });

  $('#btn-codigo').on('click', () => {
    $('#modalItem').modal('show');
  });

  $('#txtVendedor').on('blur', async () => {
    const sCodRep = pegaChave('#txtVendedor');
    if (permiteConsultarClienteBloqueado == 0) {
      selectTxtCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S'`];
      selectBtnCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S'`];
    } else {
      selectTxtCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S' AND BLOQUEIO = 'N'`];
      selectBtnCliente.where = [`CODREP = '${sCodRep}' AND ATIVO = 'S' AND BLOQUEIO = 'N'`];
    }
    limpaValor('#txtCliente');
    $('#txtCliente').unbind('autocompleta');
    $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ'], carregaDadosClientes);
    $('#btn-cliente').off();
    $('#btn-cliente').unbind('pesquisa_serverside');
    $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], JSON.stringify(selectBtnCliente), 'Pesquisa Cliente', carregaDadosClientes);

    await retornaCooerdenador(sCodRep);

    if (sCodRep != '') {
      await verificaDeOndeCarregaTabelaDePreco();
    }
  });

  $('#msform').validate({
    debug: false,
    rules: {
      txtTabela: {
        required: true,
      },
      txtVendedor: {
        required: true,
      },
      txtCliente: {
        required: true,
      },
      txtResponsavel: {
        required: true,
      },
      txtFormaContato: {
        required: true,
      },
    },
    messages: {
      txtTabela: {
        required: 'Informe um tabela de preço válida.',
      },
      txtVendedor: {
        required: 'Informe um vendedor válido.',
      },
      txtCliente: {
        required: 'Informe um cliente válido.',
      },
      txtResponsavel: {
        required: 'Informe um responsável válido.',
      },
      txtFormaContato: {
        required: 'Informe uma forma de contato válida.',
      },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.input-group').append(error);
    },
    highlight(element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    },
  });

  async function validaAlgumPedidoSalvo() {
    if (existePedidosGravadosNoAtendimento) {
      $('#btnItens').prop('disabled', true);
    }
  }

  $('#btnFinalizaPedido').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const coresNaoInformadas = pedido.itens.filter((item) => item.CORES.length == 0 && item.SITUACAO_CODIGO == 'A');
      const codigosNaoInformados = coresNaoInformadas.map((codigo) => codigo.CODIGO).toString();

      if (coresNaoInformadas.length > 0) {
        msgAlerta(`Itens: ${codigosNaoInformados} ainda não foram atendidos!`);
        return;
      }

      await RotinaCliqueFinalizaPedido();
      await montaJsonPedido();
      await separaPedidosPorItem();
      await validaAlgumPedidoSalvo()
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnInfo').on('click', () => {
    RotinaCliqueInfo();
  });

  $('.somAtivo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem('@pedido.somAtivo', false);
    $('.somInativo').removeClass('d-none');
  });

  $('.somInativo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem('@pedido.somAtivo', true);
    $('.somAtivo').removeClass('d-none');
  });

  async function verificaEstoque(data) {
    const codigo = data[0];
    const codigoProdutoBase = await verificaMaterialBase(codigo);
    const cores = await retornaCoresItem(codigo, codigoProdutoBase);
    var temEstoque = false;
    cores.forEach((cor) => {
      if (cor.estoques) {
        if (cor.estoques.filter((estoque) => estoque.quantidade > 0).length > 0) {
          temEstoque = true;
        }
      }
      if (cor.ordemCompra) {
        if (cor.ordemCompra.filter((estoque) => estoque.quantidade > 0).length > 0) {
          temEstoque = true;
        }
      }
    });

    return temEstoque;

  }

  async function RotinaSaidaCodigo(data) {
    const codigo = data[0];
    const itensMesa = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const itemJaExisteNaMesa = itensMesa.filter((item) => item.CODIGO == codigo).length > 0;
    const temEstoque = await verificaEstoque(data);

    if (itemJaExisteNaMesa) {
      msgAlerta('Item já existe na mesa de atendimento!');
      return;
    }

    if ((!data[3]) || (data[3] == '')) {
      msgAlerta('Item sem preço cadastrado, impossível continuar');
      return;
    }

    if (!temEstoque) {
      msgAlerta('Item sem quantidade disponível nos estoques habilitados na empresa, impossível continuar!');
      return;
    }

    adicionaItensPedido({
      SITUACAO: '',
      CODIGO: codigo,
      DESCRICAO: data[1],
      ACOES: await retornaBotaoOpcoes(),
      PRECO: data[3],
      TIPO_ITEM: data[6],
      DATA: `${formataData(new Date())}T00:00:00Z`,
      UNIDADE: data[2],
      GRAMATURA: data[4],
      LARGURA: data[5],
      SITUACAO_CODIGO: 'A',
    });

    await montaJsonPedido();
    await salvarArquivoPedido(pedido);
  }

  async function cancelaAtendimento() {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const motivoSaida = $('#motivoSaida').val();
    const contador = $('#txtContador').val();
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);

    const atendimento = {
      Tempo: contador,
      Dt_Inicio: dataFormatada,
      Status: 'C',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: '',
      AvaliacaoNota: 0,
      AvaliacaoObs: motivoSaida,
      NumAtendimento: pedido.numeroAtendimento,
    };

    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }

    const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
    await deletaDadosNaoSalvos(`${hostname}.txt`);
    window.location.href = `${BASE_URI}/pedidosb2b`;

    return true;

  }

  async function finalizaAtendimento() {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const avaliacaoNota = Number($('.selectedReacaoAtendimento').attr('nota'));
    const avaliacaoObs = $('#avaliacao').val();
    const contador = $('#txtContador').val();
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);
    const atendimento = {
      Tempo: contador,
      Dt_Inicio: dataFormatada,
      Status: 'F',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: '',
      AvaliacaoNota: avaliacaoNota,
      AvaliacaoObs: avaliacaoObs,
      NumAtendimento: pedido.numeroAtendimento,
    };

    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }

    return true;
  }

  async function gravaAtendimentoPendente(numeroPedido) {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);
    const atendimento = {
      Tempo: '00:00:00',
      Dt_Inicio: dataFormatada,
      Status: 'P',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: numeroPedido,
      AvaliacaoNota: 1,
      NumAtendimento: numeroAtendimentoPedido,
    };
    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      msgAlerta('Erro ao gravar atendimento!');
      return;
    }

    if (response.status != 200) {
      msgAlerta('Erro ao gravar atendimento!');
      return;
    }

    await montaJsonPedido();
    await salvarArquivoPedido(pedido);
  }

  $('#btnItens').on('click', async () => {
    if (($('#msform').validate().element('#txtResponsavel'))
      && ($('#msform').validate().element('#txtVendedor'))
      && ($('#msform').validate().element('#txtCliente'))
      && ($('#msform').validate().element('#txtFormaContato'))
      && ($('#msform').validate().element('#txtTabela'))) {
      RotinaCliqueItens();

      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
    }
  });

  async function retornaItensCarrinho(itens) {
    const url = '/sisplan/pedidob2b/v1/montacarrinho?';

    const response = await requisicao('POST', url, '', JSON.stringify(itens));

    if (!response) {
      msgErro('Erro ao abrir o carrinho!');
      return;
    }

    if (response.status != 200) {
      msgErro('Erro ao abrir o carrinho!');
      return;
    }

    const json = await response.json();

    return json
  }

  async function montaCarrinho() {
    const itens = {
      Itens: $('#tabelaItensCompletos').DataTable().rows().data().toArray().map((item) => ({
        Codigo: item.CODIGO_ITEM,
        Cor: item.COR,
        Estoque: item.ESTOQUE,
        Ordem_Compra: item.ORDEM_COMPRA,
        Preco: item.PRECO,
        Quantidade: item.QTDE,
        Total: item.VALOR_TOTAL,
      })),
    };


    const json = await retornaItensCarrinho(itens);

    $('#tabelaCarrinho').DataTable().rows().remove().draw(false);
    json.itens.map((item) => {
      const row = {
        ...item,
        ordem_Compra: item.ordem_Compra ? 'Sim' : 'Não',
      };
      adicionaLinhaTabela(row, '#tabelaCarrinho');
    });
  }

  $('#btnCarrinho').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      $('#modal-carrinho').modal('show');

      await montaCarrinho();

      setTimeout(() => {
        $('#tabelaCarrinho').DataTable().columns.adjust().draw(false);
      }, 200);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btnDesistir', async function () {
    try {
      const data = tabelaItensMesa.row($(this).parents('tr')).data();
      const dataDesistencia = tabelaDesistenciaItem.rows().data().toArray();
      $('#txtItemDesistencia').html(data.CODIGO);
      if (pedido.desistencias.length > 0) {
        pedido.desistencias.forEach((desistencia) => {
          if (desistencia.CODIGO == data.CODIGO) {
            if (dataDesistencia.filter((tabelaDesistencia) => desistencia.CODMEN == desistencia.CODMEN).length == 0) {
              adicionaLinhaTabela(desistencia, '#tabelaDesistenciaItem');
            }
          }
        });
      }
      $('#modalDesistir').modal('show');
    } catch (error) {
      console.error(error);
    }
  });

  $('#tabelaCorAdicionarItem tbody').on('click', 'td>div>div>div .btnOpcoesCorSelecionada', async function () {
    try {
      const data = $('#tabelaCorAdicionarItem').DataTable().row($(this).parents('tr')).data();


      $('#modalOpcoesCorSelecionada').modal('show');
    } catch (error) {
      console.error(error);
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btn-imprimir-estoque', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/estoque?';
        const data_old = tabelaItensMesa.row($(this).parents('tr')).data();
        const layout = data_old.TIPO_ITEM == 'M' ? 'RelEstoqueMat' : 'RelEstoque';
        const bImprimeAutomatico = await verificaImprimirAutomatico(layout);
        const arquivo = await GeraRelatorio(`${url}CODIGO=${data_old.CODIGO}&TIPOITEM=${data_old.TIPO_ITEM}&MODULOB2B=true`, 'GET', 1000000, false, layout);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btn-imprimir-ft', async () => {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/estoque?';
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueMat');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelEstoqueMat');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnAdicionarDesistencia').on('click', async () => {
    const desistencia = {
      CODIGO: $('#txtItemDesistencia').html(),
      CODMEN: pegaChave('#txtDesistencia'),
      DESCRICAO: pegaDescricao('#txtDesistencia'),
    };
    adicionaLinhaTabela(desistencia, '#tabelaDesistenciaItem');

    limpaValor('#txtDesistencia');
  });

  $('#btnGravarDesistenciaItem').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const data = tabelaItensMesa.row('.selected').data();
      tabelaItensMesa.row('.selected').data({ ...data, SITUACAO: '<div class="situacaoIcon"><i class="fas fa-frown "></i></div>', SITUACAO_CODIGO: 'D' });

      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
      atualizaTotaisPedido();
      $('#modalDesistir').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnCancelarDesistenciaItem').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      $("#tabelaDesistenciaItem").DataTable().rows().remove().draw(false);
      limpaValor('#txtDesistencia');
      $('#modalDesistir').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnCancelarPedido').on('click', () => {
    msgAlerta(
      'Ao clicar em Confirmar você irá perder os dados que não foram salvos. Deseja realmente cancelar ? ',
      async () => {
        const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
        if ((numeroAtendimentoPedido != 'create') && (numeroAtendimentoPedido != 'create#')) {
          await deletaRegistro('LOJA', getCookie('usuario'), numeroAtendimentoPedido);
        }
        await deletaDadosNaoSalvos(`${hostname}.txt`);
        window.location.href = `${BASE_URI}/pedidosb2b/create`;
      },
    );
  });

  $('#abreAjuda').on('click', () => {
    $('.subatalho').trigger('click');
    criaTelaAjuda();
  });

  $('#abrePreco').on('click', async () => {
    $('.subatalho').trigger('click');
    $('#modalPrecos').modal('show');
  });

  RotinaCliqueInfo();
  await carregaDadosPedido();
});