$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#tabelaProduto',
            popover: {
                title: 'Produto',
                description: 'Aqui você tem uma lista de produtos conforme os filtros selecionados no passo anterior.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

function GoOutFullscreen() {
    if (document.exitFullscreen)
        document.exitFullscreen();
    else if (document.mozCancelFullScreen)
        document.mozCancelFullScreen();
    else if (document.webkitExitFullscreen)
        document.webkitExitFullscreen();
    else if (document.msExitFullscreen)
        document.msExitFullscreen();
}

document.addEventListener('keydown', (event) => {
    const keyName = event.key;

    if (keyName === 'F2') {
        event.preventDefault();
        GoOutFullscreen();
        $('#modalItens').removeClass('modal-fullscreen');
        $('#modalItens').modal('hide');
    }
});

$(document).ready(async function () {
    var parametrosSistema = await BuscaParametrosSistema('S');
    const parametrosVenda = await BuscaParametrosVenda();
    let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
    const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
    const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

    const tipoItem = parametrosVenda[17] == '0' ? 'P' : 'M';
    const bApenasBarraLog = parametrosVenda[46] == 3;

    const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
    let controleColunas = 'consultaPreco'

    let tipo;
    let controleBarra = false;

    const depositoParam = await CopiaParametro('VENDA', 1);
    $('#txtDeposito').val(depositoParam);
    const tabelaParam = await CopiaParametro('VENDA', 2);
    $('#txtTabPreco').val(tabelaParam);
    const vendeMaterial = await CopiaParametro('VENDA', 17) == '1';
    if (vendeMaterial) {
        $('#radioMaterial').prop('checked', true);
        setTimeout(() => { $('#radioMaterial').trigger('change'); }, 300);
    }

    let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

    let listaOrdenacao = [];

    if (colunas == null || colunas.consultaPreco == undefined) {
        localStorage.setItem(
            "colunasInvisiveisRelatorios",
            JSON.stringify({ ...colunas, consultaPreco: [] })
        );
        colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
    }

    if (colunas == null || colunas.consultaPrecoEstoque == undefined) {
        localStorage.setItem(
            "colunasInvisiveisRelatorios",
            JSON.stringify({ ...colunas, consultaPrecoEstoque: [] })
        );
        colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
    }

    $("#btnConfirmarColunas").on("click", async function () {
        try {
            $.LoadingOverlay("show");

            const novasColunas = retornaNovasColunasInvisiveis();
            if (controleColunas === 'consultaPreco') {
                localStorage.setItem(
                    "colunasInvisiveisRelatorios",
                    JSON.stringify({ ...colunas, consultaPreco: novasColunas })
                );

                $("#tabelaProduto").DataTable().columns().visible(true);

                $("#tabelaProduto")
                    .DataTable()
                    .columns()
                    .every(function () {
                        if (novasColunas.indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                    );
            } else if (controleColunas === 'consultaPrecoEstoque') {
                localStorage.setItem(
                    "colunasInvisiveisRelatorios",
                    JSON.stringify({ ...colunas, consultaPrecoEstoque: novasColunas })
                );

                $("#tabelaProdutosConsultaEstoque").DataTable().columns().visible(true);

                $("#tabelaProdutosConsultaEstoque")
                    .DataTable()
                    .columns()
                    .every(function () {
                        if (novasColunas.indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                    );
            }
        } finally {
            $.LoadingOverlay("hide");
            $("#modal-ColunasVisiveis").modal("hide");
        }
    });

    $('#modal-filtros').modal('hide');
    $('#modalItens').modal('hide');
    $('#txtBarraRapida').focus();

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"CLI_PROD", "camposSelect":["CLI_PROD.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"], "where": ["ENTIDADE.ATIVO = 'S'"], "innerJoin": [{"tabela": "ENTIDADE", "condicao": "CLI_PROD.CODCLI = ENTIDADE.CODCLI"}], "groupBy": ["CLI_PROD.CODCLI", "ENTIDADE.NOME"] }`);
    $("#txtCor").pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
    $("#txtTamanho").pesquisa_variosServerside(1, '{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}', 'TAM', 'FAIXA');

    $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['ENTIDADE.CODCLI'], ['ENTIDADE.NOME'], `{"tabela":"CLI_PROD", "camposSelect":["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "ENTIDADE.CNPJ"], "where": ["ENTIDADE.ATIVO = 'S'"], "innerJoin": [{"tabela": "ENTIDADE", "condicao": "CLI_PROD.CODCLI = ENTIDADE.CODCLI"}], "groupBy": ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "ENTIDADE.CNPJ"] }`, 'Pesquisa Cliente');
    $("#btnCor").pesquisa_serversideSel('#txtCor', `{ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor');
    $("#btnTamanho").pesquisa_serversideSel('#txtTamanho', `{ "tabela":"TABTAM", "camposSelect":["TAM", "FAIXA"], "where": null}`, 'Pesquisa de Tamanho');

    $("#btnLimpaCliente").on("click", function () {
        $("#txtCliente").val("");
    })

    $("#btnLimpaCor").on("click", function () {
        $("#txtCor").empty().trigger("change");
    })

    $("#btnLimpaTamanho").on("click", function () {
        $("#txtTamanho").empty().trigger("change");
    })

    $('#txtBarra').on('blur', function () {
        $('#btnConsultar').focus();
    });

    $('#btnConsultar').on('keypress', function () {
        $('#btnConsultar').trigger('click');
    });

    try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"material",
          "camposSelect":["CODIGO"],
          "where": ["1=1"], "limit": 10}`, null);
        let jsonStr = await response.json();

        if (jsonStr.RESULT[0].length < 1) {
            $('.escondeRadio').addClass('d-none');
        }
    } catch (error) {
        console.error(error);
    }

    $('#radioProduto, #radioMaterial').on('change', async function () {

        // $('#tabelaProduto').empty();
        $('#btn-produto-filtro').unbind();
        $('#txtProduto').val('');

        if ($('#radioMaterial').is(':checked')) {
            $("#txtProduto").attr("placeholder", "Material");
            $("#lblProduto").text("Material");
            $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
            $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
            $("#divCor").addClass("d-none");
            $("#divTamanho").addClass("d-none");
            $("#divCliente").addClass("d-none");
            $("#divItem").removeClass("col-6");
            $("#divBarra").removeClass("col-4");
            $("#divItem").addClass("col-12");
            $("#divBarra").addClass("col-12");
        } else {
            $("#txtProduto").attr("placeholder", "Produto");
            $("#lblProduto").text("Produto");
            $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'],
                ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
                '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
                'Pesquisa Produto');
            $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);
            $("#divCor").removeClass("d-none");
            $("#divTamanho").removeClass("d-none");
            $("#divCliente").removeClass("d-none");
            $("#divItem").removeClass("col-12");
            $("#divBarra").removeClass("col-12");
            $("#divItem").addClass("col-6");
            $("#divBarra").addClass("col-4");
        }
    });

    $('#txtBarraConsultaEstoque').on('change', async function () {
        $('#btnConsultarEstoque').trigger('click');
    });

    $('#txtBarraRapida').on('keypress', function (event) {
        let regex = new RegExp("^[a-zA-Z0-9 .#]+$")
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault(); return false;
        }
    });

    $('#txtBarraRapida').on('change', async function () {
        controleBarra = true;

        let tabela = $('#txtTabPreco').val().substring(1, $('#txtTabPreco').val().indexOf('] - '));
        let deposito = $('#txtDeposito').val().substring(1, $('#txtDeposito').val().indexOf('] - '));
        let barra = $('#txtBarraRapida').val().indexOf('#') > 0 ? $('#txtBarraRapida').val().substring(0, 6) : $('#txtBarraRapida').val();
        let tipoProdRapida = '';
        let codigo = '';

        const ebarralog = await retornaBarraLogLida($('#txtBarraRapida').val()) == "barra_log";

        if (!ebarralog && bApenasBarraLog) {
            msgAlerta('Barra log não encontrada, impossível continuar!');
            return;
        }

        if (ebarralog) {
            barra = await extraiBarra28($('#txtBarraRapida').val());
        }


        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        let produto = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
            "tabela":"PA_ITEN",
            "camposSelect":[ "CODIGO"],
            "where": ["(CODIGO   = '${encodeURIComponent(barra)}' 
                  OR BARRA    = '${encodeURIComponent(barra)}'
                  OR BARRACLI = '${encodeURIComponent(barra)}'
                  OR BARRA28  = '${encodeURIComponent(barra)}'
                  OR BARRA28  = '${encodeURIComponent(barra).substring(0, 6)}')
                "]}`, null);

        if (!produto) {
            $.LoadingOverlay("hide");
            return;
        }

        let jsonStrTipo = await produto.json();
        if (produto.status != 200) {
            $.LoadingOverlay("hide");
            msgAlerta(jsonStrTipo.RESULT[0].mensagem);
            return;
        }

        if (jsonStrTipo.RESULT[0].length > 0) {
            codigo = jsonStrTipo.RESULT[0][0].CODIGO;
            tipoProdRapida = 'P';
        } else {
            tipoProdRapida = 'M';
            let material = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                "tabela":"MAT_ITEN",
                "camposSelect":[ "CODIGO"],
                "where": ["(LOTE = '${barra}' OR BARRA = '${barra}')
                "]}`, null);

            if (!material) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStrTipoM = await material.json();
            if (material.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStrTipoM.RESULT[0].mensagem);
                return;
            }

            if (jsonStrTipoM.RESULT[0].length > 0) {
                codigo = jsonStrTipoM.RESULT[0][0].CODIGO;
            } else {
                msgAlerta('Código de barras não encontrado!');
                return;
            }
        }
        await buscaFoto(codigo);
        if (ebarralog) {
            barra = $('#txtBarraRapida').val().indexOf('#') > 0 ? $('#txtBarraRapida').val().substring(0, 6) : $('#txtBarraRapida').val();
        }
        barra = (barra == codigo) ? '' : barra;
        await BuscaPreco(codigo, barra, tipoProdRapida);

        $('#txtBarraRapida').val('');
        $('#txtBarraRapida').focus();
    });

    $('#txtBarraRapida').keydown(function (e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#txtBarraRapida').trigger('blur');
            $('#txtBarraRapida').focus();
        }
    });

    $('#btn-filtros').trigger('click');


    $('#btnConsultar').click(async function () {
        controleBarra = false;
        if ($.fn.DataTable.isDataTable("#tabelaProduto")) {
            $('#tabelaProduto').DataTable().destroy().draw(false);
            $('#tabelaProduto').html('<thead></thead><tbody></tbody>');
        }
        if ($.fn.DataTable.isDataTable("#tabelaItens")) {
            $('#tabelaItens').DataTable().clear().draw(false);
            $('#tabelaItens').empty();
        }
        $('#modalItens').removeClass('modal-fullscreen');
        if ($('#radioProduto').is(':checked')) {
            tipo = 'P';
        } else {
            tipo = 'M';
        }
        BuscaProduto();
        $('#modal-filtros').modal('hide');
    });

    $('#btn-tabpreco-filtro').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}', 'Pesquisa Tabela', 'REGIAO');
    $('#btn-limpa-tabela').on('click', function () {
        $('#txtTabPreco').val('');
    });

    $('#txtTabPreco').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-tabpreco-filtro').click();
        }
    });

    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao"], "where": ${filtroDeposito}}`);

    $('#txtDeposito').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-deposito-filtro').click();
        }
    });

    $('#txtGrupoConsultaEstoque').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-GrupoConsultaEstoque').click();
        }
    })

    $('#txtProdutoConsultaEstoque').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-ProdutoConsultaEstoque').click();
        }
    })

    $('#btn-filtros').on('click', function () {
        $('#modal-filtros').modal('show');
        $('#modalItens').modal('hide');
        $('#txtBarra').focus();
    });

    $('#btnConsultarPrecoFS').on('click', function (e) {
        $('#modalItens').addClass('modal-fullscreen');
        openFullscreen();
        $('#modalItens').modal('show');
        $('#txtBarraRapida').focus();
    });

    async function FecharModalFullScreen() {
        $('#btnFecharModal').on('click', function (e) {
            $('#modalItens').removeClass('modal-fullscreen');
            GoOutFullscreen();
            $('#modalItens').modal('hide');
        })
    };

    $('#btnFecharModal').on('click')
    FecharModalFullScreen();

    $('#btn-deposito-filtro').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${filtroDeposito}}`, 'Pesquisa Tabela', 'CODIGO');
    $('#btn-limpa-deposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#txtProduto').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-produto-filtro').click();
        }
    });


    function openFullscreen() {
        const elem = document.querySelector('body');
        if (elem.requestFullscreen) {
            elem.requestFullscreen();
        } else if (elem.mozRequestFullScreen) {
            elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
            elem.webkitRequestFullscreen();
        } else if (elem.msRequestFullscreen) {
            elem.msRequestFullscreen();
        }
    }

    function GoOutFullscreen() {
        try {
            if (document.exitFullscreen)
                document.exitFullscreen();
            else if (document.mozCancelFullScreen)
                document.mozCancelFullScreen();
            else if (document.webkitExitFullscreen)
                document.webkitExitFullscreen();
            else if (document.msExitFullscreen)
                document.msExitFullscreen();
        } catch (error) {

        }
    }

    $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'],
        ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
        '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
        'Pesquisa Produto');

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);


    $('#btn-limpa-produto').on('click', function () {
        $('#txtProduto').val('');
    });

    $('#btn-limpa-barra').on('click', function () {
        $('#txtBarra').val('');
    });

    $('#modalItens').on('hidden.bs.modal', function () {
        $('#txtBarraRapida').val('');
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr;
            $("#infoprodimagem").attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    async function retornaDadosBarra(barra) {
        try {
            $.LoadingOverlay("show");
            try {
                const sTabela = pegaChave("#txtTabPreco");
                const sDeposito = pegaChave("#txtDeposito");
                const iLancamento = 0;
                const sQualidade = 1;
                const url = `/Sisplan/Estoque/v1/barra?`;
                const tipoItem = 'P';

                const params = `lancamento=${iLancamento}&barra=${encodeURIComponent(barra)}&tabpreco=${sTabela}&qualidade=${sQualidade}&tipo=${tipoItem}&deposito=${sDeposito}`;

                const response = await requisicao('GET', url, params, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (jsonStr.codigo == 400) {
                    msgAlerta(jsonStr.mensagem);
                }

                return jsonStr;
            } catch (error) {
                msgErro('Erro ao buscar dados da barra!');
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function mostra2Casas(nr) {
        const og = Math.pow(10, 2);
        return Math.floor(nr * og) / og;
    }

    async function criaTabelaProdutosFilhosRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosRelacionados")) {
            $('#tabelaProdutosRelacionados').DataTable().destroy();
            $('#tabelaProdutosRelacionados').empty();
        }

        let objetoTabela = {
            paging: false,
            filter: true,
            info: false,
            order: true,
            autoWidth: true,
            destroy: true,
        }
        const dataSetCols = []
        if ((data) && (data.length > 0)) {
            let keys = Object.keys(data[0]);
            for (let k in keys) {
                dataSetCols.push({
                    title: keys[k],
                    data: keys[k],
                });
            }
            objetoTabela = {
                ...objetoTabela,
                data: data,
                columns: dataSetCols,
            }
        }

        $('#tabelaProdutosRelacionados').DataTable(objetoTabela)

        $('#tabelaProdutosRelacionados tbody').on('click', 'tr', async function () {
            $('#tabelaProdutosRelacionados').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');

            let data = $('#tabelaProdutosRelacionados').DataTable().row($(this)).data();
            if (parseFloat(data.PRECO_PROMO) > 0) {
                $('#txtPrecoProduto').text(quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(data.PRECO_PROMO, quantidadeCasasDecimaisCampo))
                    : mostra2Casas(data.PRECO_PROMO));
            } else {
                $('#txtPrecoProduto').text(data.PRECO == null ? '0.00' :
                    (quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(data.PRECO, quantidadeCasasDecimaisCampo))
                        : TruncaDecimaisNova(2, data.PRECO));
            }
            $('#txtQtdeProduto').text(data.QTDE);
            $('#txtDescProduto').text(`${data.DESCRICAO} - ${data.DESC_COR ? data.DESC_COR : ''} - ${data.TAM}`);
            $("#tabelaProdutosRelacionados").DataTable().columns.adjust().draw(false);

            await buscaFoto(data.CODIGO);
        })
    }

    async function retornaSeProdutosSaoRelacionados(data, filho) {
        try {
            $.LoadingOverlay('show')
            const id_pai = await verificaExisteTabelaProdFilhoRelac(data.CODIGO, data.COR, data.TAM);
            const existeFilho = await validaExisteProdutoRelacionado(data.CODIGO);

            if ((existeFilho) || (id_pai)) {
                $('#divProdutosRelacionados').removeClass('d-none');
            } else {
                $('#divProdutosRelacionados').addClass('d-none');
                return;
            }

            if (((!id_pai) && (existeFilho)) || ((filho) && (existeFilho))) {
                $('#checkboxProdutoPai').prop('checked', false);
                const url = '/sisplan/produto/v1/retorna_precos_produtos?';
                const response = await requisicao('GET', url, `CODIGO=${data.CODIGO}&ID_PAI=${0}&COR=${data.COR}&TAM=${data.TAM}&TABPRECO=${data.COD_TABELA}&DEPOSITO=${data.DEPOSITO}`, '', 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    await criaTabelaProdutosFilhosRelacionados();
                    return;
                }

                const jsonStr = await response.json();
                if ((!jsonStr) || (jsonStr.length == 0)) {
                    if (id_pai) {
                        $('#checkboxProdutoPai').trigger('click')
                    }
                    await criaTabelaProdutosFilhosRelacionados();
                    return;
                }

                await criaTabelaProdutosFilhosRelacionados(jsonStr);



                $('#checkboxProdutoFilho').prop('checked', true)
            } else {
                if (id_pai) {
                    $('#checkboxProdutoFilho').prop('checked', false);
                    const url = '/sisplan/produto/v1/retorna_precos_produtos?';
                    const response = await requisicao('GET', url, `CODIGO=${data.CODIGO}&ID_PAI=${id_pai}&COR=${data.COR}&TAM=${data.TAM}&TABPRECO=${data.COD_TABELA}&DEPOSITO=${data.DEPOSITO}`, '', 30000);

                    if (!response) {
                        return;
                    };

                    if (response.status != 200) {
                        await criaTabelaProdutosFilhosRelacionados();
                        return;
                    }

                    const jsonStr = await response.json();
                    if ((!jsonStr) || (jsonStr.length == 0)) {
                        if (existeFilho) {
                            $('#checkboxProdutoFilho').trigger('click')
                        }
                        await criasFilhosRelacionados();
                        return;
                    }

                    await criaTabelaProdutosFilhosRelacionados(jsonStr);


                    $('#checkboxProdutoPai').prop('checked', true)
                }
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function validaExisteProdutoRelacionado(sCodigo) {
        const url = '/sisplan/produto/v1/verifica_produtos_relacionados?';
        const response = await requisicao('GET', url, `CODIGO=${sCodigo}`, '', 30000);

        if (!response) {
            return;
        };

        if (response.status != 200) {
            return false;
        }
        const jsonStr = await response.json();

        return jsonStr;
    }

    async function verificaExisteTabelaProdFilhoRelac(codigo, cor, tamanho) {
        const pesquisa = {
            camposSelect: ['PRODFILHO_RELAC.ID_PAI'],
            tabela: 'PRODFILHO_RELAC',
            leftJoin: [
                { "tabela": "PRODUTO", "condicao": "PRODUTO.ID = PRODFILHO_RELAC.ID_PROD " },
                { "tabela": "CADCOR", "condicao": "CADCOR.ID = PRODFILHO_RELAC.ID_COR " },
                { "tabela": "TABTAM", "condicao": "TABTAM.ID = PRODFILHO_RELAC.ID_TAM " }
            ],
            where: [`PRODUTO.CODIGO = '${codigo}' AND CADCOR.COR = '${cor}' AND TABTAM.TAM = '${tamanho}' `]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        console.log(jsonStr)

        if (jsonStr.length > 0) {
            return jsonStr[0].ID_PAI
        }
        return false
    }

    async function BuscaPreco(pCodigo, sBarra = '', sTipo = '') {
        let prodEncontrado;
        if (sBarra != '') {
            const dadosBarra = await retornaDadosBarra(sBarra);
            prodEncontrado = dadosBarra ? dadosBarra.map((dados => ({
                CODIGO: dados.CODIGO,
                COR: dados.COR,
                TAM: dados.TAM
            })))[0] : undefined;
        }
        const tabela = pegaChave($('#txtTabPreco').val());
        const deposito = pegaChave($('#txtDeposito').val());
        const prazo = '00';
        let ebarralog = await retornaBarraLogLida($('#txtBarraRapida').val()) == "barra_log";
        ebarralog = ebarralog ? ebarralog : await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";
        const barra = sBarra == '' ? ebarralog ? await extraiBarra28($('#txtBarra').val()) : $('#txtBarra').val() : ebarralog ? await extraiBarra28($('#txtBarraRapida').val()) : controleBarra ? sBarra : '';
        const tipoBusca = sTipo != '' ? sTipo : tipo;

        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        try {
            $.LoadingOverlay("show");
            let dataSetCols = [];

            let response = await requisicao('GET', '/sisplan/vendas/v1/precos?', `tabpreco=${tabela}&PRODUTO=${"'" + pCodigo + "'"}&DEPOSITO=${"'" + deposito + "'"}&BARRA=${encodeURIComponent(barra)}&TIPO=${tipoBusca}&PRAZO=${prazo}&AGRUPA_ITENS=${true}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.mensagem);
                return;
            }

            let keys = Object.keys(jsonStr[0]);

            let arrayGrade = jsonStr;

            for (let i = 0; i < arrayGrade.length; i++) {
                if (arrayGrade[i].PRECO === 'null' || arrayGrade[i].PRECO === null) {
                    jsonStr[i].PRECO = 0;
                }
                // if (sBarra != '') {
                //     jsonStr[i].BARRA = sBarra;
                // }

            }

            const indicePreco = [];
            const indiceQtde = [];
            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k],
                    // 'width': '20%'
                });
                if ((keys[k] == 'PRECO') || (keys[k] == 'PRECO_PROMO')) {
                    indicePreco.push(+k);
                } else if (keys[k] == 'QTDE') {
                    indiceQtde.push(+k);
                }
            }

            $('#tabelaItens').DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: true,
                paging: false,

                "autoWidth": true,
                "data": jsonStr,
                "columns": dataSetCols,
                columnDefs: [
                    {
                        "visible": false,
                        "targets": [8]
                    },
                    {
                        "render": function (data) {
                            return parseFloat(data).toLocaleString("pt-BR", {
                                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                                minimumFractionDigits: quantidadeCasasDecimaisCampo
                            })
                        },
                        "targets": indicePreco,
                        "className": 'pr-4 text-right'
                    },
                    {
                        "targets": indiceQtde,
                        "className": 'pr-4 text-right'
                    }
                ],
            });

            $("#tabelaItens").DataTable().columns.adjust().draw(false);

            $.LoadingOverlay("hide");

            $('#tabelaItens tbody').on('click', 'tr', async function () {
                $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');

                let data = $('#tabelaItens').DataTable().row($(this)).data();
                if (parseFloat(data.PRECO_PROMO) > 0) {
                    $('#txtPrecoProduto').text(quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(data.PRECO_PROMO, quantidadeCasasDecimaisCampo))
                        : mostra2Casas(data.PRECO_PROMO));
                } else {
                    $('#txtPrecoProduto').text(data.PRECO == null ? '0.00' :
                        (quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(data.PRECO, quantidadeCasasDecimaisCampo))
                            : TruncaDecimaisNova(2, data.PRECO));
                }
                $('#txtQtdeProduto').text(data.QTDE);
                $('#txtDescProduto').text(`${data.DESCRICAO} - ${data.DESC_COR ? data.DESC_COR : ''} - ${data.TAM}`);
                $("#tabelaItens").DataTable().columns.adjust().draw(false);

                await retornaSeProdutosSaoRelacionados(data, true);

            });

            if (prodEncontrado) {
                const dados = $("#tabelaItens")
                    .DataTable()
                    .rows()
                    .data()
                    .toArray();

                const indiceEncontrado = dados.findIndex((item) => (item.CODIGO == prodEncontrado.CODIGO &&
                    item.COR == prodEncontrado.COR &&
                    item.TAM == prodEncontrado.TAM));
                $($("#tabelaItens tbody tr")[indiceEncontrado]).click();
                $(".dataTables_scrollBody").scrollTo($("#tabelaItens tbody tr").eq(indiceEncontrado), 200);
            } else {
                $("#tabelaItens tbody tr td")[0].click();
            }

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    async function retornaIdPaiProdutosRelacionados(codigo, cor, tamanho) {
        const pesquisa = {
            camposSelect: ['PROD_RELAC.ID'],
            tabela: 'PROD_RELAC',
            leftJoin: [
                { "tabela": "PRODUTO", "condicao": "PRODUTO.ID = PROD_RELAC.ID_PROD " },
                { "tabela": "CADCOR", "condicao": "CADCOR.ID = PROD_RELAC.ID_COR " },
                { "tabela": "TABTAM", "condicao": "TABTAM.ID = PROD_RELAC.ID_TAM " }
            ],
            where: [`PRODUTO.CODIGO = '${codigo}' AND CADCOR.COR = '${cor}' AND TABTAM.TAM = '${tamanho}' `]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length > 0) {
            return jsonStr[0].ID
        }
        return false
    }

    async function BuscaProduto() {
        const produto = pegaChave(('#txtProduto'));
        const deposito = pegaChave(('#txtDeposito'));
        const ebarralog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";
        const barra = ebarralog ? await extraiBarra28($('#txtBarra').val()) : $('#txtBarra').val().indexOf('#') > 0 ? $('#txtBarra').val().substring(0, 6) : $('#txtBarra').val();
        const cor = await formataListas($("#txtCor").val().toString());
        const tamanho = await formataListas($("#txtTamanho").val().toString());
        const cliente = pegaChave("#txtCliente");
        const bPesquisaProduto = $('#radioProduto').is(':checked');
        const tabelaPreco = pegaChave("#txtTabPreco");
        const precoCorTam = parametrosVenda[5] == "1";

        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        try {
            $.LoadingOverlay("show");
            let response;

            const tabela = bPesquisaProduto ? "PRODUTO" : "MATERIAL";
            const camposSelect = retornaCamposSelect(bPesquisaProduto, cliente != "", precoCorTam);
            const innerJoin = retornaInnerJoin(bPesquisaProduto, cliente != "");
            const leftJoin = retornaLeftJoin(bPesquisaProduto, precoCorTam, tabelaPreco);
            const where = retornaWhere(bPesquisaProduto, produto, deposito, barra, cor, tamanho, cliente);
            const groupBy = retornaGroupBy(bPesquisaProduto, cliente != '', precoCorTam)

            const pesquisa = {
                tabela: tabela,
                camposSelect: camposSelect,
                innerJoin: innerJoin,
                leftJoin: leftJoin,
                where: where,
                groupBy
            }

            response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }

            let dataSetCols = [];
            if (bPesquisaProduto && cliente != "") {
                dataSetCols = [{ title: "Código", data: "CODIGO" },
                { title: "Descrição", data: "DESCRICAO" },
                { title: "Cor", data: "COR" },
                { title: "Desc. Cor", data: "DESC_COR" },
                { title: "Tamanho", data: "TAM" },
                { title: "Estoque", data: "QTDE" },
                { title: "Preço", data: "PRECO" },
                { title: "Preço Promo", data: "PRECO_PROMO" },
                { title: "CodCli", data: "CODCLI" },
                { title: "Nome", data: "NOME" },
                { title: "Fantasia", data: "FANTASIA" },
                ];
            } else if (bPesquisaProduto) {
                dataSetCols = [{ title: "Código", data: "CODIGO" },
                { title: "Descrição", data: "DESCRICAO" },
                { title: "Cor", data: "COR" },
                { title: "Desc. Cor", data: "DESC_COR" },
                { title: "Tamanho", data: "TAM" },
                { title: "Estoque", data: "QTDE" },
                { title: "Preço", data: "PRECO" },
                { title: "Preço Promo", data: "PRECO_PROMO" }];
            }
            else {
                dataSetCols = [{ title: "Código", data: "CODIGO" },
                { title: "Descrição", data: "DESCRICAO" },
                { title: "Cor", data: "COR" },
                { title: "Desc. Cor", data: "DESC_COR" },
                { title: "Estoque", data: "QTDE" },
                { title: "Preço", data: "PRECO" },
                { title: "Preço Promo", data: "PRECO_PROMO" }];
            }

            $('#tabelaProduto').DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: true,
                lengthChange: true,
                scrollCollapse: true,
                colReorder: true,
                paging: true,
                "pagingType": "numbers",

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": dataSetCols,
                "columnDefs": [
                    {
                        render(data) {
                            const valor = parseFloat(data);

                            if (!isNaN(valor)) {
                                return valor.toLocaleString("pt-br", {
                                    maximumFractionDigits: quantidadeCasasDecimaisCampo,
                                    minimumFractionDigits: quantidadeCasasDecimaisCampo
                                });
                            } else {
                                return "0,00"
                            }
                        },
                        targets: [bPesquisaProduto ? 6 : 5, bPesquisaProduto ? 7 : 6]
                    }]
            });

            $('#tabelaProduto tbody').on('click', 'tr', async function () {
                $('#tabelaProduto').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');

                let data = $('#tabelaProduto').DataTable().row($(this)).data();
                if (data != undefined) {
                    await BuscaPreco(data.CODIGO);
                    await buscaFoto(data.CODIGO);
                }
                $('#modalItens').modal('show');
                // $("#tabelaItens tbody tr td")[0].click();
                $("#txtBarraRapida").focus();
            });

            const colunasInvisiveis = JSON.parse(
                localStorage.getItem("colunasInvisiveisRelatorios")
            );

            $("#tabelaProduto_length").prepend(
                '<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
            );
            $("#tabelaProduto_length").prepend(
                '<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>'
            );

            $("#buttonColVis").on("click", async function () {
                $.LoadingOverlay("show");
                $("#modal-ColunasVisiveis").modal("show");
                $.LoadingOverlay("hide");
            });

            $("#buttonExcel").on("click", async function () {
                const produto = pegaChave(('#txtProduto'));
                const deposito = pegaChave(('#txtDeposito'));
                const barra = $('#txtBarra').val().indexOf('#') > 0 ? $('#txtBarra').val().substring(0, 6) : $('#txtBarra').val();
                const cor = await formataListas($("#txtCor").val().toString());
                const tamanho = await formataListas($("#txtTamanho").val().toString());
                const cliente = pegaChave("#txtCliente");
                const bPesquisaProduto = $('#radioProduto').is(':checked');
                const tabelaPreco = pegaChave("#txtTabPreco");
                const precoCorTam = parametrosVenda[5] == "1";

                if (deposito == '') {
                    msgAlerta('Informe um depósito');
                    return;
                }

                const tabela = bPesquisaProduto ? "PRODUTO" : "MATERIAL";
                const camposSelect = retornaCamposSelect(bPesquisaProduto, cliente != "", precoCorTam);
                const innerJoin = retornaInnerJoin(bPesquisaProduto, cliente != "");
                const leftJoin = retornaLeftJoin(bPesquisaProduto, precoCorTam, tabelaPreco);
                const where = retornaWhere(bPesquisaProduto, produto, deposito, barra, cor, tamanho, cliente);
                const groupBy = retornaGroupBy(bPesquisaProduto, cliente != '', precoCorTam)

                const pesquisa = {
                    tabela: tabela,
                    camposSelect: camposSelect,
                    innerJoin: innerJoin,
                    leftJoin: leftJoin,
                    where: where,
                    groupBy
                }

                const url = '/sisplan/funcoes/v1/pesquisa?'

                await exportaCSV(
                    url,
                    `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`,
                    true,
                    null,
                    "Relatório de Preços",
                    "#tabelaProduto"
                );
            });

            $("#tabelaProduto")
                .DataTable()
                .columns()
                .every(function () {
                    if (
                        colunasInvisiveis.consultaPreco.indexOf(this.dataSrc()) != -1
                    ) {
                        this.visible(false);
                    }
                }
                );

            if (jsonStr.RESULT[0].length == 1) {
                $("#tabelaProduto tbody tr td")[0].click();
            }

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgAlerta(`Não foi possível buscar os dados do cliente: ${error}`);

        }
    }

    $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(
            localStorage.getItem("colunasInvisiveisRelatorios")
        );

        if (controleColunas === 'consultaPreco') {
            $("#tabelaProduto")
                .DataTable()
                .columns()
                .every(function () {
                    cols.push({
                        title: $(this.header()).text(),
                        data: this.dataSrc(),
                    });
                });

            adicionaColunas(cols, colunasInvisiveis.consultaPreco ?? []);
        } else if (controleColunas === 'consultaPrecoEstoque') {
            $("#tabelaProdutosConsultaEstoque")
                .DataTable()
                .columns()
                .every(function () {
                    cols.push({
                        title: $(this.header()).text(),
                        data: this.dataSrc(),
                    });
                });

            adicionaColunas(cols, colunasInvisiveis.consultaPrecoEstoque ?? []);
        }
    });

    criaDataTablePadrao('#tabelaProdutosConsultaEstoque', false, false, false, false, true, true, '200px');

    $('#modalConsultaEstoque').on('show.bs.modal', function () {
        controleColunas = 'consultaPrecoEstoque'
    })

    $('#modalConsultaEstoque').on('hidden.bs.modal', function () {
        // $('#tabelaProdutosConsultaEstoque').empty();
        limpaTabela();
        $('#txtDepositoConsultaEstoque').val('');
        $('#txtProdutoConsultaEstoque').val('');
        $('#txtGrupoConsultaEstoque').val('');
        controleColunas = 'consultaPreco'
    });

    $('#checkboxProdutoFilho').on('click', async function () {
        await retornaSeProdutosSaoRelacionados($('#tabelaItens').DataTable().row($('tr.selected')).data(), true)
    });

    $('#checkboxProdutoPai').on('click', async function () {
        await retornaSeProdutosSaoRelacionados($('#tabelaItens').DataTable().row($('tr.selected')).data(), false)
    })

    $('#btnAbrirConsultaEstoque').on('click', function () {
        $('#modalConsultaEstoque').modal('show');
        // $("#tabelaProdutosConsultaEstoque").DataTable().columns.adjust().draw(false);
    });

    $('#txtDepositoConsultaEstoque').pesquisa_variosServerside(1, `{"tabela":"deposito", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where" :${filtroDeposito}}`, 'CODIGO', 'DESCRICAO');
    $('#btn-DepositoConsultaEstoque').pesquisa_serversideSel('#txtDepositoConsultaEstoque', `{ "tabela":"deposito", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${filtroDeposito}}`, 'Pesquisa Depósito');
    $('#btn-limpa-DepositoConsultaEstoque').on('click', function () {
        $('#txtDepositoConsultaEstoque').empty().trigger('change');
    });

    $('#txtProdutoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#btn-ProdutoConsultaEstoque').pesquisa_serversideSel('#txtProdutoConsultaEstoque', `{ "tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}`, 'Pesquisa Produto');
    $('#btn-limpa-ProdutoConsultaEstoque').on('click', function () {
        $('#txtProdutoConsultaEstoque').empty().trigger('change');
    });

    $('#txtGrupoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#btn-GrupoConsultaEstoque').pesquisa_serversideSel('#txtGrupoConsultaEstoque', `{ "tabela":"grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Grupo');
    $('#btn-limpa-GrupoConsultaEstoque').on('click', function () {
        $('#txtGrupoConsultaEstoque').empty().trigger('change');
    });

    $('#radioProdutoC, #radioMaterialC').on('change', async function () {

        $('#btn-ProdutoConsultaEstoque').unbind();
        $('#txtProdutoConsultaEstoque').val('');

        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if (tipoConsulta == 'M') {
            $("#txtProdutoConsultaEstoque").attr("placeholder", "Material");
            $("#labelProduto").text("Material");

            $('#txtProdutoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
            $('#btn-ProdutoConsultaEstoque').pesquisa_serversideSel('#txtProdutoConsultaEstoque', `{ "tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Material');
            $('#btn-limpa-ProdutoConsultaEstoque').on('click', function () {
                $('#txtProdutoConsultaEstoque').empty().trigger('change');
            });

            $('#txtGrupoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"grupo_ma", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
            $('#btn-GrupoConsultaEstoque').pesquisa_serversideSel('#txtGrupoConsultaEstoque', `{ "tabela":"grupo_ma", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Grupo');
            $('#btn-limpa-GrupoConsultaEstoque').on('click', function () {
                $('#txtGrupoConsultaEstoque').empty().trigger('change');
            });
        } else {

            $("#txtProdutoConsultaEstoque").attr("placeholder", "Produto");
            $("#labelProduto").text("Produto");

            $('#txtProdutoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}', 'CODIGO', 'DESCRICAO');
            $('#btn-ProdutoConsultaEstoque').pesquisa_serversideSel('#txtProdutoConsultaEstoque', `{ "tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}`, 'Pesquisa Produto');
            $('#btn-limpa-ProdutoConsultaEstoque').on('click', function () {
                $('#txtProdutoConsultaEstoque').empty().trigger('change');
            });

            $('#txtGrupoConsultaEstoque').pesquisa_variosServerside(1, '{ "tabela":"grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
            $('#btn-GrupoConsultaEstoque').pesquisa_serversideSel('#txtGrupoConsultaEstoque', `{ "tabela":"grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Grupo');
            $('#btn-limpa-GrupoConsultaEstoque').on('click', function () {
                $('#txtGrupoConsultaEstoque').empty().trigger('change');
            });
        }
    });

    async function buscaEstoque(sTipo) {
        try {
            if ($.fn.DataTable.isDataTable("#tabelaProdutosConsultaEstoque")) {
                $('#tabelaProdutosConsultaEstoque').DataTable().destroy();
                $('#tabelaProdutosConsultaEstoque').empty();
            }

            let barra = $('#txtBarraConsultaEstoque').val().indexOf('#') > 0 ? $('#txtBarraConsultaEstoque').val().substring(0, 6) : $('#txtBarraConsultaEstoque').val();

            const ebarralog = await retornaBarraLogLida($('#txtBarraConsultaEstoque').val()) == "barra_log";

            if (!ebarralog && bApenasBarraLog) {
                msgAlerta('Barra log não encontrada, impossível continuar!');
                return;
            }

            if (ebarralog) {
                barra = await extraiBarra28($('#txtBarraConsultaEstoque').val());
            }

            const where = await montaWherePesquisa(barra);
            const campos = await montaCamposSelect(sTipo);
            const tabela = await montaTabela(sTipo);
            const indiceDireita = [];

            let dataSetCols = [];

            $.LoadingOverlay("show");

            for (let i = 0; i < campos.colunas.length; i++) {
                dataSetCols.push({
                    'title': campos.colunas[i],
                    'data': campos.colunas[i]
                });
                if ((campos.colunas[i] == 'QUANTIDADE') || (campos.colunas[i] == 'QTDE')) {
                    indiceDireita.push(i);
                }
            }

            const pesquisa = {
                tabela: tabela,
                camposSelect: campos.camposSelect,
                leftJoin: [
                    { tabela: "CADCOR", condicao: sTipo == 'P' ? 'CADCOR.COR = PA_ITEN.COR' : 'CADCOR.COR = MAT_ITEN.COR' },
                    { tabela: sTipo == 'P' ? 'PRODUTO' : 'MATERIAL', condicao: sTipo == 'P' ? 'PA_ITEN.CODIGO = PRODUTO.CODIGO' : 'MAT_ITEN.CODIGO = MATERIAL.CODIGO' },
                ],
                where: [`1=1 ${where}`]
            }

            if (sTipo == 'P') {
                pesquisa.leftJoin.push(
                    { tabela: "FAIXA_ITEN", condicao: 'FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND PA_ITEN.TAM = FAIXA_ITEN.TAMANHO' }
                )

                pesquisa.orderby = ['PA_ITEN.QUANTIDADE DESC', 'PA_ITEN.CODIGO', 'PA_ITEN.COR', 'FAIXA_ITEN.POSICAO']
            }

            $('#tabelaProdutosConsultaEstoque').DataTable({
                paging: true,
                lengthChange: true,
                filter: false,
                info: true,
                colReorder: true,
                lengthMenu: [8],
                order: true,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "POST",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: {
                        EMPRESA: getCookie('empresa'),
                        JSON: JSON.stringify(pesquisa),
                        CLIENTE: 'N'
                    },
                    dataSrc: function (data) {
                        const cols = campos.colunas;
                        const array = data.data;
                        return array.map(row => {
                            return row.reduce((obj, value, index) => {
                                obj[cols[index]] = value;
                                return obj;
                            }, {});
                        });
                    }
                },
                columns: dataSetCols,
                "columnDefs": [
                    {
                        "targets": indiceDireita,
                        "className": 'pr-4 text-right'
                    }
                ]
            });

            const colunasInvisiveis = JSON.parse(
                localStorage.getItem("colunasInvisiveisRelatorios")
            );

            $("#tabelaProdutosConsultaEstoque_length").prepend(
                '<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
            );
            $("#tabelaProdutosConsultaEstoque_length").prepend(
                '<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>'
            );

            $("#buttonColVis").on("click", async function () {
                $.LoadingOverlay("show");
                $("#modal-ColunasVisiveis").modal("show");
                $.LoadingOverlay("hide");
            });

            $("#buttonExcel").on("click", async function () {
                $.LoadingOverlay("show");
                try {
                    const where = await montaWherePesquisa(barra);
                    const campos = await montaCamposSelect(sTipo);
                    const tabela = await montaTabela(sTipo);

                    const pesquisa = {
                        tabela: tabela,
                        camposSelect: campos.camposSelect,
                        leftJoin: [
                            { tabela: "CADCOR", condicao: sTipo == 'P' ? 'CADCOR.COR = PA_ITEN.COR' : 'CADCOR.COR = MAT_ITEN.COR' },
                            { tabela: sTipo == 'P' ? 'PRODUTO' : 'MATERIAL', condicao: sTipo == 'P' ? 'PA_ITEN.CODIGO = PRODUTO.CODIGO' : 'MAT_ITEN.CODIGO = MATERIAL.CODIGO' },
                        ],
                        where: [`1=1 ${where}`]
                    }

                    if (sTipo == 'P') {
                        pesquisa.leftJoin.push(
                            { tabela: "FAIXA_ITEN", condicao: 'FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND PA_ITEN.TAM = FAIXA_ITEN.TAMANHO' }
                        )

                        pesquisa.orderby = ['PA_ITEN.QUANTIDADE DESC', 'PA_ITEN.CODIGO', 'PA_ITEN.COR', 'FAIXA_ITEN.POSICAO']
                    }

                    const url = '/sisplan/funcoes/v1/pesquisa?'

                    await exportaCSV(
                        url,
                        `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`,
                        true,
                        null,
                        "Relatório de Preços - Estoque",
                        "#tabelaProdutosConsultaEstoque"
                    );
                } finally {
                    $.LoadingOverlay("hide");
                }
            });

            $("#tabelaProdutosConsultaEstoque")
                .DataTable()
                .columns()
                .every(function () {
                    if (
                        colunasInvisiveis.consultaPreco.indexOf(this.dataSrc()) != -1
                    ) {
                        this.visible(false);
                    }
                }
                );
        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnConsultarEstoque').on('click', async function () {
        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if ($('#tabelaProdutosConsultaEstoque')[0].rows.length > 0) {
            await limpaTabela();
        }
        await buscaEstoque(tipoConsulta);

    });

    $("#btnImprimirConsultaPrecos").on("click", async function () {
        try {
            $.LoadingOverlay("show");
            const filtros = await retornaFiltrosImpressao();
            const url = `/sisplan/impressao/v1/imprimirrelprecosloja?${filtros}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsultaPrecosLoja');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RelConsultaPrecosLoja');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function retornaFiltrosImpressao() {
        const tabelaImpressao = pegaChave('#txtTabPreco');
        const depositoImpressao = pegaChave('#txtDeposito');
        const produtoImpressao = pegaChave('#txtProduto');
        const clienteImpressao = pegaChave('#txtCliente');
        const corImpressao = await formataListas($('#txtCor').val().toString());
        const tamImpressao = await formataListas($('#txtTamanho').val().toString());
        const barraImpressao = $('#txtBarra').val();

        filtros =
            `TIPO=${tipoItem}` +
            `&PESQUISACLIENTE=${clienteImpressao != ''}` +
            `&PRECO_COR_TAM=${parametrosVenda[5] == "1" ? 'S' : 'N'}` +
            `&TABELA_PRECO=${tabelaImpressao}` +
            `&DEPOSITO=${depositoImpressao}` +
            `&CODIGO=${produtoImpressao}` +
            `&COR=${corImpressao}` +
            `&TAM=${tamImpressao}` +
            `&CLI_PROD=${clienteImpressao}` +
            `&BARRA=${barraImpressao}` +
            `&BARRA28SUBSTRING=${barraImpressao.substring(0, 6)}`

        return filtros;
    }

    async function montaWherePesquisa(barra) {
        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        let deposito = await formataListas($('#txtDepositoConsultaEstoque').val().toString()) != '' ? ` AND ${tipoConsulta == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.DEPOSITO IN (${await formataListas($('#txtDepositoConsultaEstoque').val().toString())})` : '';
        if ((deposito == '') && (filtroDeposito != 'null')) {
            deposito = ` AND ${tipoConsulta == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.DEPOSITO IN (${filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '')})`;
        }
        let where = '';
        where += deposito;
        where += await formataListas($('#txtProdutoConsultaEstoque').val().toString()) != '' ? ` AND ${tipoConsulta == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.CODIGO IN (${await formataListas($('#txtProdutoConsultaEstoque').val().toString())})` : '';
        where += await formataListas($('#txtGrupoConsultaEstoque').val().toString()) != '' ? ` AND ${tipoConsulta == 'P' ? 'PRODUTO' : 'MATERIAL'}.GRUPO IN (${await formataListas($('#txtGrupoConsultaEstoque').val().toString())})` : '';
        if (barra != "") {
            if ((tipoConsulta == 'P')) {
                where += ` AND UDF_LEN(${tipoConsulta == 'P' && "PRODUTO"}.CODIGO) > 0`;
                where += tipoConsulta == 'P' && ` AND (PA_ITEN.BARRA = '${barra}' OR
                                                 PA_ITEN.BARRACLI = '${barra}' OR 
                                                 PA_ITEN.BARRA28 = '${barra}' OR 
                                                 PA_ITEN.BARRA28 = '${barra.substring(0, 6)}')`;

            } else {
                where += ` AND (MAT_ITEN.BARRA = '${barra}' OR MAT_ITEN.LOTE = '${barra}')`
            }
        }

        return where;
    }

    async function montaTabela(tipo) {
        let tabela = '';

        if (tipo == 'M') {
            tabela = `MAT_ITEN`
        } else {
            tabela = `PA_ITEN`
        }

        return tabela;
    }

    async function montaCamposSelect(tipo) {
        let camposSelect = [];
        let colunas = [];

        if (tipo == 'M') {

            camposSelect = ["MAT_ITEN.CODIGO", "MAT_ITEN.BARRA", "MAT_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "MAT_ITEN.DEPOSITO", "MAT_ITEN.QTDE"];

            colunas = ["CODIGO", "BARRA", "COR", "DESC_COR", "DEPOSITO", "QTDE"];

        } else {

            camposSelect = ["PA_ITEN.CODIGO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.DEPOSITO", "PA_ITEN.QUANTIDADE"];

            colunas = ["CODIGO", "COR", "DESC_COR", "TAM", "BARRA", "BARRA28", "BARRACLI", "DEPOSITO", "QUANTIDADE"];

        }

        return objeto = {
            camposSelect: camposSelect,
            colunas: colunas
        };

    }

    // async function atualizaQtde(tipo) {
    //     if (tipo == 'M') {
    //         qtde_estoque = 0;
    //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(3, {}).data().sum();
    //         $('#txtQuantidadeItem').val(qtde_estoque);

    //     } else {
    //         qtde_estoque = 0;
    //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(6, {}).data().sum();
    //         $('#txtQuantidadeItem').val(qtde_estoque);
    //     }
    // }

    async function limpaTabela() {
        $('#tabelaProdutosConsultaEstoque').DataTable().destroy();
        $('#tabelaProdutosConsultaEstoque').empty();
    };

    $('#btnImprimir').on('click', function () {
        imprimirConsultaPrecosEstoque();
    });

    async function imprimirConsultaPrecosEstoque() {
        const tipo_item = $('#radioProdutoC').prop('checked') ? 'P' : 'M';
        const deposito = await formataListas($('#txtDepositoConsultaEstoque').val().toString());
        const codigo = await formataListas($('#txtProdutoConsultaEstoque').val().toString());
        const grupo = await formataListas($('#txtGrupoConsultaEstoque').val().toString());
        const barra = $('#txtBarraConsultaEstoque').val();

        try {
            $.LoadingOverlay('show');

            const url = `/sisplan/impressao/v1/imprimir_consulta_precos_estoque?`;

            const bImprimeAutomatico = await verificaImprimirAutomatico('ConsultaPrecosEstoque');
            const arquivo = await GeraRelatorio(`${url}TIPO_ITEM=${tipo_item}&DEPOSITO=${deposito}&CODIGO=${codigo}&GRUPO=${grupo}&BARRA=${barra}`, 'GET', 1000000, false, 'ConsultaPrecosEstoque');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnCameraPreco').on('click', function () {
        if (getCookie('protocolo') == 'http') {
            msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
            return;
        }
        $('#modalCamera').modal('show');
        iniciaCamera();
    });

    if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
        console.log("enumerateDevices() not supported.");
        return;
    }

    var backCamID;

    navigator.mediaDevices.enumerateDevices()
        .then(function (devices) {
            devices.forEach(function (device) {
                if (device.kind == "videoinput" && device.label.match(/back/) != null) {
                    backCamID = device.deviceId;
                }
            });
        })
        .catch(function (err) {
            console.log(err.name + ": " + err.message);
        });

    if (typeof (backCamID) == "undefined") {
        console.log("back camera not found.");
    }

    function iniciaCamera() {
        Quagga.init({
            locate: false,
            numOfWorkers: 2,
            inputStream: {
                name: "Live",
                type: "LiveStream",
                target: document.querySelector('#cam'),
                constraints: {
                    //  width: '100%',
                    //  height: '100%',
                    //  facingMode: "environment"
                    deviceId: backCamID
                },
                area: {
                    // update area if its small mobile
                    top: "32%",
                    right: "10%",
                    left: "10%",
                    bottom: "32%"
                }
            },
            decoder: {
                readers: ["code_128_reader"]
            },
        }, function (err) {
            if (err) {
                msgAlertaSemConfirmacao('Nenhum dispositivo com câmera encontrado para realizar a bipagem, verifique!', 'modalCamera');
                return;
            } else {

                fixiOSVideo();

                if (typeof resolve === "function") {
                    resolve.call(this);
                }
            }
            console.log("Initialization finished. Ready to start");
            Quagga.start();
        });

    }

    Quagga.onDetected(({ codeResult }) => {
        const regexBarra = /[^/\\a-zA-Z0-9]/;
        if (regexBarra.test(codeResult.code)) {
            return;
        }

        if (isValidCode(codeResult)) {
            Quagga.stop();
            $('#txtBarra').val(codeResult.code).trigger('blur');
            $('#modalCamera').modal('hide');
        }

        Quagga.lastScannedCode = codeResult.code;

    });

    Quagga.onProcessed((result) => {
        const drawingCtx = Quagga.canvas.ctx.overlay;

        clearDrow();

        if (result) {
            if (result.boxes) {
                if (!Quagga.drowBox) {
                    Quagga.drowBox = result.boxes[0];
                }

                Quagga.ImageDebug.drawPath(Quagga.drowBox, {
                    x: 0,
                    y: 1
                }, drawingCtx, {
                    color: "green",
                    lineWidth: 3
                });
            }

            const currentTime = Date.now();

            if (!Quagga.lastDetectingTime) {
                Quagga.lastDetectingTime = currentTime;
            }

            if (result.codeResult) {
                Quagga.lastDetectingTime = currentTime;
            } else if ((currentTime - Quagga.lastDetectingTime) / 1000 >= 2) {
                Quagga.lastDetectingTime = currentTime;
            }

            if (result.codeResult && result.codeResult.code) {
                Quagga.ImageDebug.drawPath(
                    result.line, {
                    x: "x",
                    y: "y"
                },
                    drawingCtx, {
                    color: "red",
                    lineWidth: 3
                }
                );
            }
        }
    });

    function clearDrow() {
        const drawingCtx = Quagga.canvas.ctx.overlay;
        const drawingCanvas = Quagga.canvas.dom.overlay;

        drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.width), parseInt(drawingCanvas.height));
    }

    function fixiOSVideo() {
        const videoElement = Quagga.canvas.dom.overlay.parentElement.querySelector("video");

        setTimeout(() => { videoElement.play(); }, 10);
    }

    function isValidCode({ decodedCodes }) {
        const errors = decodedCodes.filter((x) => x.error !== undefined).map((y) => y.error); // TODO: use reduce
        const median = getMedian(errors);

        return median < 0.8;
    }

    function getMedian(arr) {
        const sorted = [...arr].sort((a, b) => a - b);
        const half = Math.floor(sorted.length / 2);

        if (arr.length % 2 === 1) {
            return arr[half];
        }

        return (arr[half - 1] + arr[half]) / 2;
    }

    $('#modalCamera').on('hidden.bs.modal', function () {
        Quagga.stop();
    });

    function retornaCamposSelect(bPesquisaProduto, bPesquisaCliente, bPrecoCorTam) {
        const precoPromo = bPrecoCorTam ? `CASE WHEN ((PRECO_COR_TAM.DT_PROMOINI <= '${retornaDataAtual()}' AND (PRECO_COR_TAM.DT_PROMOFIM >= '${retornaDataAtual()}'))) THEN PRECO_COR_TAM.PRECO_PROMO ELSE 0 END PRECO_PROMO` : `CASE WHEN ((TABPRECO.DT_PROMOINI <= '${retornaDataAtual()}' ) AND (TABPRECO.DT_PROMOFIM >= '${retornaDataAtual()}')) THEN TABPRECO.PRECO_PROMO ELSE 0 END PRECO_PROMO`
        const camposSelect = bPesquisaProduto && bPesquisaCliente ? ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "SUM(PA_ITEN.QUANTIDADE) QTDE", bPrecoCorTam ? "PRECO_COR_TAM.PRECO AS PRECO" : "TABPRECO.PRECO_00 AS PRECO", "CLI_PROD.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", precoPromo]
            : bPesquisaProduto
                ? ["DISTINCT PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "SUM(PA_ITEN.QUANTIDADE) QTDE", bPrecoCorTam ? "PRECO_COR_TAM.PRECO AS PRECO" : "TABPRECO.PRECO_00 AS PRECO", precoPromo]
                : ["DISTINCT MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MAT_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "SUM(MAT_ITEN.QTDE) QTDE", bPrecoCorTam ? "PRECO_COR_TAM.PRECO AS PRECO" : "TABPRECO.PRECO_00 AS PRECO", precoPromo];
        return camposSelect;
    }

    function retornaGroupBy(bPesquisaProduto, bPesquisaCliente, bPrecoCorTam) {
        const camposSelect = bPesquisaProduto && bPesquisaCliente ? ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PA_ITEN.TAM", bPrecoCorTam ? "PRECO_COR_TAM.PRECO" : "TABPRECO.PRECO_00", "CLI_PROD.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", bPrecoCorTam ? "PRECO_COR_TAM.PRECO_PROMO" : "TABPRECO.PRECO_PROMO", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOINI" : "TABPRECO.DT_PROMOINI", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOFIM" : "TABPRECO.DT_PROMOFIM"]
            : bPesquisaProduto
                ? ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PA_ITEN.TAM", bPrecoCorTam ? "PRECO_COR_TAM.PRECO" : "TABPRECO.PRECO_00", bPrecoCorTam ? "PRECO_COR_TAM.PRECO_PROMO" : "TABPRECO.PRECO_PROMO", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOINI" : "TABPRECO.DT_PROMOINI", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOFIM" : "TABPRECO.DT_PROMOFIM"]
                : ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MAT_ITEN.COR", "CADCOR.DESCRICAO", bPrecoCorTam ? "PRECO_COR_TAM.PRECO" : "TABPRECO.PRECO_00", bPrecoCorTam ? "PRECO_COR_TAM.PRECO_PROMO" : "TABPRECO.PRECO_PROMO", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOINI" : "TABPRECO.DT_PROMOINI", bPrecoCorTam ? "PRECO_COR_TAM.DT_PROMOFIM" : "TABPRECO.DT_PROMOFIM"];
        return camposSelect;
    }

    function retornaInnerJoin(bPesquisaProduto, bPesquisaCliente) {
        const ligacoes = bPesquisaProduto && bPesquisaCliente ? [{ tabela: "PA_ITEN", condicao: "PRODUTO.CODIGO = PA_ITEN.CODIGO" },
        { tabela: "CLI_PROD", condicao: "PRODUTO.CODIGO = CLI_PROD.CODIGO" },
        { tabela: "ENTIDADE", condicao: "CLI_PROD.CODCLI = ENTIDADE.CODCLI" },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' }]
            : bPesquisaProduto ? [{ tabela: "PA_ITEN", condicao: "PRODUTO.CODIGO = PA_ITEN.CODIGO" },
            { tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' }]
                : [{ tabela: "MAT_ITEN", condicao: "MATERIAL.CODIGO = MAT_ITEN.CODIGO" },
                { tabela: 'CADCOR', condicao: 'CADCOR.COR = MAT_ITEN.COR' }]
        return ligacoes;
    }

    function retornaWhere(bPesquisaProduto, codigoItem, deposito, barra, cor, tamanho, cliente) {
        const listaWhere = [];

        if (codigoItem != "") {
            listaWhere.push(`${bPesquisaProduto ? "PRODUTO" : "MATERIAL"}.CODIGO = '${codigoItem}'`);
        }

        if (deposito != "") {
            listaWhere.push(`${bPesquisaProduto ? "PA_ITEN" : "MAT_ITEN"}.DEPOSITO = '${deposito}'`);
        }

        if (barra != "") {
            listaWhere.push(`UDF_LEN(${bPesquisaProduto ? "PRODUTO" : "MATERIAL"}.CODIGO) > 0`);
            listaWhere.push(bPesquisaProduto ? `(PA_ITEN.BARRA = '${barra}' OR
                                                 PA_ITEN.BARRACLI = '${barra}' OR 
                                                 PA_ITEN.BARRA28 = '${barra}' OR 
                                                 PA_ITEN.BARRA28 = '${barra.substring(0, 6)}')`
                : `MAT_ITEN.LOTE = '${barra}'`);

        }

        if (bPesquisaProduto) {
            if (cor != "") {
                listaWhere.push(`PA_ITEN.COR IN (${cor})`);
            }

            if (tamanho != "") {
                listaWhere.push(`PA_ITEN.TAM IN (${tamanho})`);
            }

            if (cliente != "") {
                listaWhere.push(`CLI_PROD.CODCLI = '${cliente}'`)
            }
        }

        return listaWhere;
    }

    function retornaLeftJoin(bPesquisaProduto, bPrecoCorTam, tabelaPreco) {
        const ligacoes = bPesquisaProduto ? bPrecoCorTam
            ? [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.CODIGO = PA_ITEN.CODIGO ${tabelaPreco != "" ? `AND REGIAO = '${tabelaPreco}'` : ""} AND PA_ITEN.COR = PRECO_COR_TAM.COR AND PA_ITEN.TAM = PRECO_COR_TAM.TAM ` }]
            : [{ tabela: "TABPRECO", condicao: `TABPRECO.CODIGO = PA_ITEN.CODIGO ${tabelaPreco != "" ? `AND REGIAO = '${tabelaPreco}'` : ""}` }]
            : bPrecoCorTam
                ? [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.CODIGO = MAT_ITEN.CODIGO ${tabelaPreco != "" ? `AND REGIAO = '${tabelaPreco}'` : ""} AND MAT_ITEN.COR = PRECO_COR_TAM.COR` }]
                : [{ tabela: "TABPRECO", condicao: `TABPRECO.CODIGO = MAT_ITEN.CODIGO ${tabelaPreco != "" ? `AND REGIAO = '${tabelaPreco}'` : ""}` }]
        return ligacoes;
    }

    async function retornaBarraLogLida(sBarra) {
        try {
            const url = `/sisplan/barralog/v1/validarbarra?`;
            const params = `barra=${encodeURIComponent(sBarra)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
                return jsonStr.mensagem;
            }

            return jsonStr.mensagem;
        } catch (error) {
            console.error(error);
        }
    }

});
