$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta das UFs.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaUF',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma UF.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaUF',
                popover: {
                    title: 'Tabela UFs',
                    description: 'Aqui estão todos as UFs cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("UF");

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
          '</div>';
        return retorno;
      };

    ConsultaCep();

    $('#txtCidade').autocompleta(1, `JSON={ "tabela":"cidade", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $('#txtPais').autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $('#txtUf').autocompleta(1, `JSON={ "tabela":"tabuf", "camposSelect":[ "coduf chave", "descricao descricao"], "where": null}`);

    $('#btnCidade').pesquisa('#txtCidade', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cidade", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Cidade', 'cidade');
    $('#btnPais').pesquisa('#txtPais', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa País', 'cadpais');
    $('#btnUf').pesquisa('#txtUf', 'CODUF', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODUF", "DESCRICAO"]}`, 'Pesquisa UF', 'tabuf');

    $('#btnAUf').on('click', function () {
        $('#txtUf').val('');
    });
    $('#btnAPais').on('click', function () {
        $('#txtPais').val('');
    });
    $('#btnACidade').on('click', function () {
        $('#txtCidade').val('');
    });

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        await ConsultaCep(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtPais').val('');
        $('#txtUf').val('');
        $('#txtCidade').val('');
    });

    async function ConsultaCep(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;

            let pais = pegaChave('#txtPais');
            let uf = pegaChave('#txtUf');
            let params = '';

            if (uf != '') {
                params = `AND CODUF = '${uf}'`;
                pais = '';
            }
            if (pais != '') {
                params = `AND PAIS = '${pais}'`;
            }

            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ 
                        "tabela":"tabuf", 
                        "camposSelect":["codigo", "descricao", "coduf"],  
                        "where": ["1=1 ${params}"]}`, null);

            } else {
                response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"tabuf", 
                        "camposSelect":["codigo", "descricao", "coduf"], 
                        "where": ["1=1"], "limit": 10000}`, null);
            }
            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaUF').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                {
                    "data": "CODUF"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                      }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
        }
    }

    $('#btnNovaUF').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "uf/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaUF').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaUF').DataTable().row($(this).parents('tr')).data();
            // var clienteLiberado = true //await liberarRegistro('CODIGO', data.CODIGO);
            // if (clienteLiberado) {
            window.location.href = `uf/${data.CODIGO}`;
            // }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaUF').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaUF').DataTable().row($(this)).data();
            // var clienteLiberado = await liberarRegistro('CODIGO', data.CODIGO);
            // if (clienteLiberado) {
            window.location.href = `uf/${data.CODIGO}`;
            // }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaUF').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaUF").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/uf?", `CODIGOUF=${valorLinha.CODIGO}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

});